/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import java.rmi.RemoteException;
import ucar.unidata.idv.DisplayControl;
import ucar.unidata.idv.ViewManager;
import ucar.visad.display.DisplayMaster;
import ucar.visad.display.Displayable;
import visad.VisADException;

public class DisplayInfo {
    private DisplayControl displayControl;
    private ViewManager viewManager;
    private Displayable displayable;
    private boolean ultimateVisible = true;
    private boolean isDisplayableAdded = false;

    public DisplayInfo(DisplayControl displayControl, ViewManager viewManager, Displayable displayable) {
        this.displayControl = displayControl;
        this.viewManager = viewManager;
        this.displayable = displayable;
    }

    public boolean getUltimateVisible() {
        return this.ultimateVisible;
    }

    public void setUltimateVisible(boolean v) {
        this.ultimateVisible = v;
    }

    public DisplayControl getDisplayControl() {
        return this.displayControl;
    }

    public ViewManager getViewManager() {
        return this.viewManager;
    }

    public void setViewManager(ViewManager viewManager) {
        this.viewManager = viewManager;
    }

    public DisplayMaster getDisplayMaster() {
        return this.viewManager.getMaster();
    }

    public Displayable getDisplayable() {
        return this.displayable;
    }

    public void addDisplayable() throws RemoteException, VisADException {
        if (this.viewManager != null && !this.isDisplayableAdded) {
            this.isDisplayableAdded = this.viewManager.addDisplayInfo(this);
        }
    }

    public boolean getDisplayableAdded() {
        return this.isDisplayableAdded;
    }

    public void setDisplayableAdded(boolean v) {
        this.isDisplayableAdded = v;
    }

    public void moveTo(ViewManager newViewManager) throws RemoteException, VisADException {
        this.removeDisplayable();
        this.setViewManager(newViewManager);
        this.addDisplayable();
    }

    public void activateDisplay() throws RemoteException, VisADException {
        if (this.viewManager != null) {
            this.viewManager.setMasterActive();
        }
    }

    public void deactivateDisplay() throws RemoteException, VisADException {
        if (this.viewManager != null) {
            this.viewManager.setMasterInactive();
        }
    }

    public void removeDisplayable() throws RemoteException, VisADException {
        if (this.viewManager != null && this.isDisplayableAdded) {
            this.viewManager.removeDisplayInfo(this);
            this.isDisplayableAdded = false;
        }
    }

    public String toString() {
        return super.toString() + "---" + this.displayControl;
    }
}

