/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.idv.DisplayControl;
import ucar.unidata.idv.IdvManager;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.ui.ParamDefaultsEditor;
import ucar.unidata.util.ColorTable;
import ucar.unidata.util.ContourInfo;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Range;
import ucar.unidata.util.TwoFacedObject;
import ucar.visad.ProjectionCoordinateSystem;
import ucar.visad.Util;
import visad.Real;
import visad.RealType;
import visad.Unit;
import visad.VisADException;
import visad.data.mcidas.AREACoordinateSystem;
import visad.georef.EarthLocation;
import visad.georef.LatLonPoint;
import visad.georef.MapProjection;

public class DisplayConventions
extends IdvManager {
    private static DisplayConventions displayConventions;
    private static String DEFAULT_FORMAT;
    private DecimalFormat latLonFormat = new DecimalFormat(DEFAULT_FORMAT);
    private DecimalFormat distanceFormat = new DecimalFormat("####0.0#");
    private DecimalFormat angleFormat = new DecimalFormat(DEFAULT_FORMAT);
    private static int nextColor;
    private static Color[] colors;
    private Font windowLabelFont;
    public static final String PREF_UNITLIST = "Control.UnitList";
    private List unitList;
    private Object UNIT_MUTEX = new Object();
    private static final int LATITUDE = 1;
    private static final int LONGITUDE = 0;

    public DisplayConventions(IntegratedDataViewer idv) {
        super(idv);
        displayConventions = this;
    }

    public static DisplayConventions getDisplayConventions() {
        return displayConventions;
    }

    public String formatLatLonPoint(LatLonPoint llp) {
        return this.formatLatLonPoint(llp, true);
    }

    public String formatLatLonPoint(LatLonPoint llp, boolean includeLabel) {
        StringBuffer buf = new StringBuffer();
        if (includeLabel) {
            buf.append("Lat: ");
        }
        try {
            buf.append(this.formatLatLon(Math.min(Math.max(llp.getLatitude().getValue(), -90.0), 90.0)));
        }
        catch (Exception e) {
            buf.append(" ");
        }
        if (includeLabel) {
            buf.append(" Lon: ");
        } else {
            buf.append("/");
        }
        try {
            buf.append(this.formatLatLon(Misc.normalizeLongitude(llp.getLongitude().getValue())));
        }
        catch (Exception e) {
            buf.append(" ");
        }
        return buf.toString();
    }

    public String formatEarthLocation(EarthLocation el, boolean includeAlt) {
        return this.formatEarthLocation(el, includeAlt, true);
    }

    public String formatEarthLocation(EarthLocation el, boolean includeAlt, boolean includeLabel) {
        StringBuffer buf = new StringBuffer();
        try {
            buf.append(this.formatLatLonPoint(el.getLatLonPoint(), includeLabel));
        }
        catch (Exception e) {
            return "";
        }
        if (includeAlt) {
            if (includeLabel) {
                buf.append(" Alt: ");
            } else {
                buf.append(" ");
            }
            try {
                buf.append(this.formatDistance(el.getAltitude().getValue()));
            }
            catch (Exception e) {
                buf.append(" ");
            }
        }
        return buf.toString();
    }

    public String formatLatLonShort(LatLonPoint llp) {
        StringBuffer buf = new StringBuffer();
        try {
            buf.append(this.formatLatLon(llp.getLatitude().getValue()));
            buf.append("/");
            buf.append(this.formatLatLon(llp.getLongitude().getValue()));
        }
        catch (Exception e) {
            return "";
        }
        return buf.toString();
    }

    public String formatEarthLocationShort(EarthLocation el) {
        StringBuffer buf = new StringBuffer();
        try {
            LatLonPoint llp = el.getLatLonPoint();
            buf.append(this.formatLatLonShort(llp));
            buf.append(" ");
            buf.append(this.formatDistance(el.getAltitude().getValue()));
        }
        catch (Exception e) {
            return "";
        }
        return buf.toString();
    }

    public DecimalFormat getLatLonFormat() {
        DecimalFormat fmt = new DecimalFormat(DEFAULT_FORMAT);
        fmt.applyPattern(this.getStore().get("Data.LatLonFormat", DEFAULT_FORMAT));
        return fmt;
    }

    public String formatLatLon(double d) {
        if (Double.isNaN(d)) {
            return "missing";
        }
        this.latLonFormat.applyPattern(this.getStore().get("Data.LatLonFormat", DEFAULT_FORMAT));
        return this.latLonFormat.format(d);
    }

    public String formatLatLon(Real latorlon) {
        return this.formatLatLon(latorlon.getValue());
    }

    public String formatLatLonCardinal(double value, int type) {
        String retString;
        if (type == 1) {
            retString = Misc.format(Math.abs(value));
            retString = value < 0.0 ? retString + "S" : (value == 0.0 ? "EQ" : retString + "N");
        } else {
            if (value > 180.0) {
                value -= 360.0;
            }
            retString = Misc.format(Math.abs(value));
            retString = value < 0.0 ? retString + "W" : (value == 0.0 ? "0" : retString + "E");
        }
        return retString;
    }

    public String formatLatLonCardinal(Real latorlon, int type) {
        return this.formatLatLonCardinal(latorlon.getValue(), type);
    }

    public String formatAltitude(Real alt) {
        return this.formatDistance(alt.getValue());
    }

    public String formatDistance(double d) {
        if (d > 1000.0) {
            return "" + (int)d;
        }
        return this.distanceFormat.format(d);
    }

    public String formatAngle(double d) {
        return this.angleFormat.format(d);
    }

    public String formatLatOrLon(double ll) {
        return this.formatLatLon(ll);
    }

    public String format(double v) {
        return Misc.format(v);
    }

    public ContourInfo findDefaultContourInfo(String paramName) {
        return this.findDefaultContourInfo(paramName, null);
    }

    public ContourInfo findDefaultContourInfo(String paramName, ContourInfo contourInfo) {
        ContourInfo dflt = this.getParamDefaultsEditor().getParamContourInfo(paramName);
        if (dflt != null && dflt.isDefined()) {
            if (contourInfo == null) {
                return new ContourInfo(dflt);
            }
            contourInfo.setIfDefined(dflt);
            return contourInfo;
        }
        return null;
    }

    public ContourInfo findContourInfo(String paramName, RealType rangeType, Unit displayUnit, Range range) {
        return this.findContourInfo(paramName, rangeType, displayUnit, range, null);
    }

    public ContourInfo findContourInfo(String paramName, RealType rangeType, Unit displayUnit, Range range, ContourInfo contourInfo) {
        ContourInfo dflt;
        if (contourInfo == null) {
            contourInfo = new ContourInfo(Double.NaN, Double.NaN, Double.NaN, Double.NaN);
        }
        if ((dflt = this.getParamDefaultsEditor().getParamContourInfo(paramName)) != null) {
            contourInfo.setIfDefined(dflt);
        }
        if (contourInfo.isDefined()) {
            return contourInfo;
        }
        float min = 0.0f;
        float max = 1100.0f;
        float clBase = Float.NaN;
        float clInterval = Float.NaN;
        float clMin = Float.NaN;
        float clMax = Float.NaN;
        try {
            double cscale;
            double crange;
            int nrange;
            double rint;
            if (Unit.canConvert(rangeType.getDefaultUnit(), displayUnit)) {
                Real dispVal = new Real(rangeType, range.min);
                min = (float)dispVal.getValue(displayUnit);
                dispVal = new Real(rangeType, range.max);
                max = (float)dispVal.getValue(displayUnit);
            } else {
                min = (float)range.min;
                max = (float)range.max;
            }
            double span = Math.abs(max - min);
            int scale = (int)(Math.log(span) / Math.log(10.0));
            if (span < 1.0) {
                --scale;
            }
            if (Double.isInfinite(rint = (double)((nrange = (int)(crange = span / (cscale = Math.pow(10.0, scale)))) + 1) * 0.1 * cscale)) {
                rint = span;
            }
            if (span <= 300.0 && span > 5.0) {
                clInterval = (float)rint;
                clMin = clBase = clInterval * (float)((int)(min / clInterval));
                clMax = clInterval * (float)(1 + (int)(max / clInterval));
            } else if (span <= 5.0) {
                clInterval = (float)rint;
                clMin = clBase = min;
                clMax = max;
            } else {
                clInterval = (int)rint;
                clMin = clBase = (float)((int)min);
                clMax = (int)max;
            }
            clMax += clInterval;
            clMin -= clInterval;
        }
        catch (Exception exp) {
            DisplayConventions.logException("Set contour levels for " + paramName, exp);
        }
        if (clInterval == 0.0f) {
            clInterval = 20.0f;
        }
        if (!contourInfo.getIntervalDefined() && contourInfo.getLevelsString() == null) {
            contourInfo.setInterval(clInterval);
        }
        if (!contourInfo.getBaseDefined()) {
            contourInfo.setBase(clBase);
        }
        if (!contourInfo.getMinDefined()) {
            contourInfo.setMin(clMin);
        }
        if (!contourInfo.getMaxDefined()) {
            contourInfo.setMax(clMax);
        }
        return contourInfo;
    }

    public ColorTable getParamColorTable(String paramName) {
        return this.getParamDefaultsEditor().getParamColorTable(paramName);
    }

    public Range getParamRange(String paramName, Unit unit) throws VisADException, RemoteException {
        if (paramName == null) {
            if (unit != null) {
                return this.getParamDefaultsEditor().getParamRange("unit:" + unit);
            }
            return null;
        }
        Range r = this.getParamDefaultsEditor().getParamRange(paramName);
        if (r == null) {
            paramName = paramName.toLowerCase();
            r = this.getParamDefaultsEditor().getParamRange(paramName);
        }
        return r;
    }

    public ParamDefaultsEditor getParamDefaultsEditor() {
        return this.getIdv().getParamDefaultsEditor();
    }

    public Unit selectDisplayUnit(String paramName, Unit unit) {
        return this.getDisplayUnit(paramName, unit);
    }

    public Unit getDisplayUnit(String paramName, Unit unit) {
        if (paramName == null) {
            return null;
        }
        Unit displayUnit = this.getParamDefaultsEditor().getParamDisplayUnit(paramName);
        if (displayUnit == null) {
            displayUnit = unit;
        }
        if (unit == null) {
            return displayUnit;
        }
        return Unit.canConvert(unit, displayUnit) ? displayUnit : unit;
    }

    public Vector getColorNameList() {
        return new Vector(Misc.toList(GuiUtils.COLORNAMES));
    }

    public JComboBox makeColorSelector(Color dflt) {
        return GuiUtils.makeColorNameComboBox(dflt);
    }

    public Color getColor(String name) {
        return GuiUtils.decodeColor(name, Color.blue);
    }

    public String getColorName(Color color) {
        return GuiUtils.getColorName(color);
    }

    public static Color getColor() {
        if (nextColor >= colors.length) {
            nextColor = 0;
        }
        return colors[nextColor++];
    }

    public Font getWindowLabelFont() {
        if (this.windowLabelFont == null) {
            this.windowLabelFont = new Font("Monospaced", 1, 10);
        }
        return this.windowLabelFont;
    }

    public JComboBox makeUnitBox(Unit unit, Unit defaultUnit) {
        TwoFacedObject current = null;
        if (unit != null) {
            current = new TwoFacedObject((Object)unit.toString(), unit);
        }
        String unitName = unit == null ? null : unit.toString();
        ArrayList unitList = this.getDefaultUnitList();
        if (unit != null) {
            String unitString = unit.toString();
            ArrayList tmpList = unitList;
            unitList = new ArrayList();
            for (int i = 0; i < tmpList.size(); ++i) {
                Object o = tmpList.get(i);
                if (o.toString().equals(unitString)) continue;
                Unit theUnit = null;
                if (o instanceof TwoFacedObject) {
                    theUnit = (Unit)((TwoFacedObject)o).getId();
                } else {
                    if (!(o instanceof Unit)) continue;
                    theUnit = (Unit)o;
                }
                if (theUnit == null || !Unit.canConvert(unit, theUnit)) continue;
                if (unit.equals(theUnit)) {
                    // empty if block
                }
                unitList.add(o);
            }
        }
        return GuiUtils.getEditableBox(unitList, current);
    }

    public Unit selectUnit(Unit unit, Unit defaultUnit) {
        JComboBox ufld = this.makeUnitBox(unit, defaultUnit);
        JPanel panel = GuiUtils.label(" New unit:  ", ufld);
        if (!GuiUtils.showOkCancelDialog(null, "Change unit", GuiUtils.inset((Component)panel, 5), null, Misc.newList(ufld))) {
            return null;
        }
        Object selected = ufld.getSelectedItem();
        String unitName = TwoFacedObject.getIdString(selected);
        if (unitName == null) {
            return defaultUnit;
        }
        try {
            Unit newUnit = Util.parseUnit(unitName);
            if (!(selected instanceof TwoFacedObject)) {
                selected = new TwoFacedObject((Object)selected.toString(), newUnit);
            }
            this.addToUnitList(selected);
            return newUnit;
        }
        catch (Exception exc) {
            LogUtil.userMessage("Error parsing unit:" + unitName + "\n" + exc);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToUnitList(Object selected) {
        Object object = this.UNIT_MUTEX;
        synchronized (object) {
            if (this.unitList == null) {
                this.getDefaultUnitList();
            }
            if (!Misc.containsString(selected.toString(), this.unitList, true) && !this.unitList.contains(selected)) {
                this.unitList.add(selected);
                this.getStore().put(PREF_UNITLIST, (Object)this.unitList);
                this.getStore().save();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getDefaultUnitList() {
        Object object = this.UNIT_MUTEX;
        synchronized (object) {
            if (this.unitList != null) {
                return this.unitList;
            }
            this.unitList = (List)this.getStore().get(PREF_UNITLIST);
            if (this.unitList == null) {
                this.unitList = new ArrayList();
                this.unitList.add(new TwoFacedObject((Object)"Default", null));
            }
            HashSet<String> seenName = new HashSet<String>();
            ArrayList tmp = new ArrayList();
            for (Object o : this.unitList) {
                String s = o.toString().toLowerCase();
                if (seenName.contains(s) || tmp.contains(o)) continue;
                tmp.add(o);
                seenName.add(s);
            }
            this.unitList = tmp;
            String[] names = new String[]{"Celsius", "Fahrenheit", "Kelvin", "millibar", "hectoPascal", "m", "km", "miles", "feet", "inches", "cm", "mm", "m/s", "mi/hr", "knot", "km/hr"};
            for (int i = 0; i < names.length; ++i) {
                try {
                    TwoFacedObject tfo = new TwoFacedObject((Object)names[i], Util.parseUnit(names[i]));
                    if (this.unitList.contains(tfo) || seenName.contains(tfo.toString().toLowerCase())) continue;
                    this.unitList.add(tfo);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.unitList;
        }
    }

    public String getMapProjectionName(MapProjection projection) {
        Serializable op = projection;
        if (projection instanceof ProjectionCoordinateSystem) {
            ProjectionImpl pi = ((ProjectionCoordinateSystem)projection).getProjection();
            String name = pi.getName();
            if (name != null && name.length() > 0) {
                return name;
            }
            op = pi;
        } else if (projection instanceof AREACoordinateSystem) {
            return projection.toString();
        }
        return Misc.getClassName(op.getClass());
    }

    public String getMapProjectionLabel(MapProjection mp, DisplayControl display) {
        return this.getMapProjectionName(mp) + " from: " + display.getLabel();
    }

    static {
        DEFAULT_FORMAT = "##0.0";
        nextColor = 0;
        colors = new Color[]{Color.red, Color.cyan, Color.magenta, Color.green, Color.orange, Color.yellow};
    }
}

