/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatLightLaf;
import java.lang.reflect.Constructor;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.List;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import visad.VisADException;

public class DefaultIdv
extends IntegratedDataViewer {
    private String appearanceMode;

    public DefaultIdv() throws VisADException, RemoteException {
    }

    public DefaultIdv(String[] args) throws VisADException, RemoteException {
        super(args);
        this.appearanceMode = this.getStore().get("AppearanceMode", "idv");
        try {
            if (this.appearanceMode.equals("dark")) {
                UIManager.setLookAndFeel((LookAndFeel)new FlatDarkLaf());
            } else if (this.appearanceMode.equals("light")) {
                UIManager.setLookAndFeel((LookAndFeel)new FlatLightLaf());
            }
        }
        catch (Exception ex) {
            System.err.println("Failed to initialize LaF");
        }
        this.init();
    }

    @Override
    public void initPropertyFiles(List files) {
        super.initPropertyFiles(files);
        files.add("/ucar/unidata/idv/resources/haiku.properties");
    }

    @Override
    public boolean handleAction(String action, Hashtable properties, boolean checkForAlias) {
        if (this.getIdvUIManager().checkHaiku(action)) {
            return true;
        }
        return super.handleAction(action, properties, checkForAlias);
    }

    public static void main(String[] args) throws Exception {
        LogUtil.configure();
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-mainclass")) continue;
            Class mainClass = Misc.findClass(args[i + 1]);
            Constructor ctor = Misc.findConstructor(mainClass, new Class[]{args.getClass()});
            if (ctor == null) {
                throw new IllegalArgumentException("Could not find class:" + args[i + 1]);
            }
            ctor.newInstance(new Object[]{args});
            return;
        }
        DefaultIdv idv = new DefaultIdv(args);
    }
}

