/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import ucar.unidata.data.DataSourceResults;
import ucar.unidata.idv.History;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.util.Misc;

public class DataSourceHistory
extends History {
    private String dataSourceXml;
    private String dataSourceIdentifier;

    public DataSourceHistory() {
    }

    public DataSourceHistory(String name, String dataSourceXml, String identifier) {
        super(name);
        this.dataSourceXml = dataSourceXml;
        this.dataSourceIdentifier = identifier;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Misc.hashcode(this.dataSourceXml) ^ Misc.hashcode(this.dataSourceIdentifier);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DataSourceHistory)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DataSourceHistory that = (DataSourceHistory)o;
        return Misc.equals(this.dataSourceIdentifier, that.dataSourceIdentifier);
    }

    @Override
    public boolean process(IntegratedDataViewer idv) {
        boolean ok;
        DataSourceResults results = idv.makeDataSourceFromXml(this.dataSourceXml);
        idv.moveHistoryToFront(this);
        boolean bl = ok = !results.anyFailed();
        if (ok) {
            idv.getIdvUIManager().dataSelectorToFront();
        }
        return ok;
    }

    public void setDataSourceXml(String value) {
        this.dataSourceXml = value;
    }

    public String getDataSourceXml() {
        return this.dataSourceXml;
    }

    public void setDataSourceIdentifier(String value) {
        this.dataSourceIdentifier = value;
    }

    public String getDataSourceIdentifier() {
        return this.dataSourceIdentifier;
    }
}

