/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import ucar.unidata.idv.VerticalXSDisplay;
import ucar.unidata.idv.ViewContext;
import ucar.unidata.idv.ViewDescriptor;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.util.BooleanProperty;
import ucar.unidata.util.GuiUtils;
import ucar.visad.display.AnimationInfo;
import ucar.visad.display.DisplayMaster;
import ucar.visad.display.XSDisplay;
import visad.VisADException;

public class CrossSectionViewManager
extends ViewManager {
    public static final String PREF_PREFIX = "View.XS";
    public static final String PREF_CLIP = "View.XS.clip";
    private boolean clipOn = true;
    private TitledBorder csBorderTitle;
    private boolean propsComponentInstantiated = false;

    public CrossSectionViewManager() {
    }

    public CrossSectionViewManager(ViewContext viewContext, ViewDescriptor desc, String properties) throws VisADException, RemoteException {
        this(viewContext, desc, properties, null);
    }

    public CrossSectionViewManager(ViewContext viewContext, ViewDescriptor desc, String properties, AnimationInfo animationInfo) throws VisADException, RemoteException {
        super(viewContext, desc, properties, animationInfo);
    }

    @Override
    public void initializeViewMenu(JMenu viewMenu) {
        this.showControlMenu = false;
        super.initializeViewMenu(viewMenu);
        viewMenu.add(this.makeColorMenu());
        viewMenu.addSeparator();
        viewMenu.add(GuiUtils.makeMenuItem("Properties", this, "showPropertiesDialog"));
    }

    @Override
    protected DisplayMaster doMakeDisplayMaster() throws VisADException, RemoteException {
        Dimension dimension = this.getIdv().getStateManager().getViewSize();
        if (dimension == null) {
            if (this.getFullScreenWidth() > 0 && this.getFullScreenHeight() > 0) {
                dimension = new Dimension(this.getFullScreenWidth(), this.getFullScreenHeight());
            } else if (this.displayBounds != null) {
                dimension = new Dimension(this.displayBounds.width, this.displayBounds.height);
            }
        }
        if (dimension == null || dimension.width == 0 || dimension.height == 0) {
            dimension = null;
        }
        return new VerticalXSDisplay(this.getIdv().getArgsManager().getIsOffScreen(), dimension);
    }

    @Override
    protected void init() throws VisADException, RemoteException {
        if (this.getHaveInitialized()) {
            return;
        }
        super.init();
        VerticalXSDisplay csDisplay = (VerticalXSDisplay)this.getMaster();
        csDisplay.setAspect(1.0, 0.4);
    }

    public boolean isPropsComponentInstantiated() {
        return this.propsComponentInstantiated;
    }

    @Override
    public JComponent getPropertiesComponent() {
        JComponent jc = super.getPropertiesComponent();
        this.propsComponentInstantiated = true;
        return jc;
    }

    @Override
    protected Color getDefaultForeground() {
        return Color.black;
    }

    @Override
    protected Color getDefaultBackground() {
        return Color.white;
    }

    @Override
    public void applyPreferences() {
        super.applyPreferences();
        ((VerticalXSDisplay)this.getXSDisplay()).setXDisplayUnit(this.getIdv().getPreferenceManager().getDefaultDistanceUnit());
    }

    public XSDisplay getXSDisplay() {
        return (XSDisplay)this.getMaster();
    }

    public void setClipping(boolean value) {
        this.setBp(PREF_CLIP, value);
    }

    public boolean getClipping() {
        return this.getBp(PREF_CLIP);
    }

    @Override
    protected Container doMakeContents() {
        JPanel contents = new JPanel(new BorderLayout());
        this.csBorderTitle = new TitledBorder(new EtchedBorder(1), this.getXSDisplay().getName(), 1, 2);
        contents.setBorder(this.csBorderTitle);
        contents.setPreferredSize(new Dimension(450, 250));
        JComponent csComponent = (JComponent)this.getXSDisplay().getComponent();
        csComponent.setPreferredSize(contents.getSize());
        contents.add("Center", csComponent);
        return contents;
    }

    public void setDisplayTitle(String titlePart) {
        if (this.csBorderTitle != null) {
            this.csBorderTitle.setTitle(this.getXSDisplay().getName() + " " + titlePart);
            this.getContents().repaint();
        }
    }

    public void setNewDisplayTitle(String newTitle) {
        if (this.csBorderTitle != null) {
            this.csBorderTitle.setTitle(newTitle);
            this.getContents().repaint();
        }
    }

    @Override
    public boolean getShowSideLegend() {
        return false;
    }

    @Override
    public String getTypeName() {
        return "Cross Section";
    }

    @Override
    protected void handleBooleanPropertyChange(String id, boolean value) throws Exception {
        if (id.equals(PREF_CLIP)) {
            if (this.getXSDisplay() != null) {
                this.getXSDisplay().enableClipping(value);
            }
        } else if (id.equals("View.ShowScales")) {
            if (this.getXSDisplay() != null) {
                this.getXSDisplay().showAxisScales(value);
            }
        } else {
            super.handleBooleanPropertyChange(id, value);
        }
    }

    @Override
    protected void getInitialBooleanProperties(List props) {
        super.getInitialBooleanProperties(props);
        props.add(new BooleanProperty(PREF_CLIP, "Clip View At Box", "", false));
        props.add(new BooleanProperty("View.ShowScales", "Show Axis Scales", "", true));
    }

    @Override
    protected JMenu makeShowMenu() {
        JMenu showMenu = super.makeShowMenu();
        this.createCBMI(showMenu, PREF_CLIP);
        this.createCBMI(showMenu, "View.ShowScales");
        return showMenu;
    }
}

