/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.python.core.PyException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.data.DataCancelException;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.DerivedDataChoice;
import ucar.unidata.idv.ControlContext;
import ucar.unidata.idv.DisplayControl;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.Trace;
import ucar.unidata.xml.XmlResourceCollection;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.Util;
import visad.VisADException;

public class ControlDescriptor {
    public static final String ID_DISPLAYTEMPLATE = "displaytemplate";
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(ControlDescriptor.class.getName());
    public static final String DISPLAYID_MAP = "mapdisplay";
    public static final String TAG_CONTROLS = "controls";
    public static final String TAG_CONTROL = "control";
    public static final String ATTR_CATEGORIES = "categories";
    public static final String ATTR_DOESLEVELS = "doeslevels";
    public static final String ATTR_DISPLAYCATEGORY = "displaycategory";
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_DESCRIPTION = "description";
    public static final String ATTR_CODE = "code";
    public static final String ATTR_ICON = "icon";
    public static final String ATTR_ID = "id";
    public static final String ATTR_LABEL = "label";
    public static final String ATTR_LEVELS = "levels";
    public static final String TAG_PROPERTY = "property";
    public static final String ATTR_PROPERTIES = "properties";
    public static final String ATTR_CANSTANDALONE = "canstandalone";
    public static final String ATTR_VIEWMANAGERS = "viewmanagers";
    public static final String TAG_DISPLAY = "display";
    public static final String TAG_DATACHOICE = "datachoice";
    public static final String TAG_DATASOURCE = "datasource";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_SOURCE = "source";
    public static final String ATTR_TYPE = "type";
    public static final String PROP_DISPLAYNAME = "displayName";
    IntegratedDataViewer idv;
    Class controlClass;
    Hashtable properties = new Hashtable();
    String controlId;
    String label;
    String description;
    String code;
    String icon;
    List dataCategories;
    String displayCategory;
    public String className;
    public boolean canStandAlone = false;
    public boolean doesLevels = false;
    private String displayTemplateFile;
    private DisplayControl displayTemplatePrototype;
    Element node;
    private List levels;
    private DisplayControl prototype;

    public ControlDescriptor() {
    }

    public ControlDescriptor(IntegratedDataViewer idv, String displayTemplateFile, DisplayControl prototype) {
        this.idv = idv;
        this.displayTemplateFile = displayTemplateFile;
        this.label = IOUtil.stripExtension(IOUtil.getFileTail(displayTemplateFile));
        this.displayCategory = "Display Templates";
        this.controlId = ID_DISPLAYTEMPLATE;
        this.displayTemplatePrototype = prototype;
        this.dataCategories = prototype.getCategories();
    }

    public ControlDescriptor(IntegratedDataViewer idv, Element node) throws ClassNotFoundException {
        this.idv = idv;
        this.node = node;
        this.controlId = XmlUtil.getAttribute(node, ATTR_ID);
        this.controlClass = Misc.findClass(XmlUtil.getAttribute(node, ATTR_CLASS));
        this.label = XmlUtil.getAttribute((Node)node, ATTR_LABEL, "");
        this.description = XmlUtil.getAttribute((Node)node, ATTR_DESCRIPTION, this.label);
        if (this.label.length() == 0) {
            this.label = this.description;
        }
        this.code = XmlUtil.getAttribute((Node)node, ATTR_CODE, (String)null);
        this.icon = XmlUtil.getAttribute((Node)node, ATTR_ICON, (String)null);
        this.displayCategory = XmlUtil.getAttribute((Node)node, ATTR_DISPLAYCATEGORY, "");
        this.canStandAlone = XmlUtil.getAttribute((Node)node, ATTR_CANSTANDALONE, false);
        this.doesLevels = XmlUtil.getAttribute((Node)node, ATTR_DOESLEVELS, false);
        if (XmlUtil.hasAttribute(node, ATTR_LEVELS)) {
            List<String> toks = StringUtil.split(XmlUtil.getAttribute(node, ATTR_LEVELS), ",", true, true);
            this.levels = new ArrayList();
            try {
                for (String tok : toks) {
                    this.levels.add(Util.toReal(tok));
                }
            }
            catch (Throwable exc) {
                ControlDescriptor.logException("Processing levels", exc);
            }
        }
        this.properties = new Hashtable();
        this.properties.put(PROP_DISPLAYNAME, this.label);
        this.properties.putAll(StringUtil.parsePropertiesString(XmlUtil.getAttribute((Node)node, ATTR_PROPERTIES, "")));
        if (this.properties.get(PROP_DISPLAYNAME) == null) {
            this.properties.put(PROP_DISPLAYNAME, this.label);
        }
        List nodes = XmlUtil.findChildren(node, TAG_PROPERTY);
        for (int i = 0; i < nodes.size(); ++i) {
            Element propertyNode = (Element)nodes.get(i);
            String name = XmlUtil.getAttribute(propertyNode, ATTR_NAME);
            String value = null;
            value = XmlUtil.hasAttribute(propertyNode, ATTR_VALUE) ? XmlUtil.getAttribute(propertyNode, ATTR_VALUE) : XmlUtil.getChildText(propertyNode);
            this.properties.put(name, value);
        }
        this.dataCategories = DataCategory.parseCategories(XmlUtil.getAttribute((Node)node, ATTR_CATEGORIES, ""));
        this.dataCategories.add(new DataCategory("display:" + this.controlId, false));
    }

    protected void getDescriptorXml(StringBuffer sb) {
        if (this.node != null) {
            sb.append(XmlUtil.toString((Node)this.node, true));
        }
    }

    protected static void load(IntegratedDataViewer idv, XmlResourceCollection resources) {
        for (int i = 0; i < resources.size(); ++i) {
            Element root = resources.getRoot(i);
            if (root == null) continue;
            ControlDescriptor.createControlDescriptors(idv, root);
        }
    }

    public static void createControlDescriptors(IntegratedDataViewer idv, Element root) {
        try {
            if (root.getTagName().equals(TAG_CONTROL)) {
                ControlDescriptor.createControlDescriptor(idv, root);
            } else {
                List controlNodes = XmlUtil.findChildren(root, TAG_CONTROL);
                for (int i = 0; i < controlNodes.size(); ++i) {
                    Element node = (Element)controlNodes.get(i);
                    ControlDescriptor.createControlDescriptor(idv, node);
                }
            }
        }
        catch (Throwable exc) {
            ControlDescriptor.logException("Creating control descriptors", exc);
            return;
        }
    }

    public static void processDisplayXml(IntegratedDataViewer idv, String xml) {
        String displayFile = "display xml file";
        try {
            Element root = XmlUtil.getRoot(xml);
            if (root == null) {
                return;
            }
            List displayNodes = XmlUtil.findChildren(root, TAG_DISPLAY);
            for (int displayIdx = 0; displayIdx < displayNodes.size(); ++displayIdx) {
                Element displayNode = (Element)displayNodes.get(displayIdx);
                String displayType = XmlUtil.getAttribute(displayNode, ATTR_TYPE);
                ControlDescriptor cd = idv.getControlDescriptor(displayType);
                if (cd == null) {
                    throw new IllegalStateException("Could not find control descriptor:" + displayType);
                }
                ArrayList<DataChoice> dataChoices = new ArrayList<DataChoice>();
                List dataChoiceNodes = XmlUtil.findChildren(displayNode, TAG_DATACHOICE);
                for (int dcIdx = 0; dcIdx < dataChoiceNodes.size(); ++dcIdx) {
                    Element dataChoiceNode = (Element)dataChoiceNodes.get(dcIdx);
                    String dcName = XmlUtil.getAttribute(dataChoiceNode, ATTR_NAME);
                    Element dataSourceNode = XmlUtil.findChild(dataChoiceNode, TAG_DATASOURCE);
                    if (dataSourceNode == null) {
                        throw new IllegalStateException("Could not find data source node");
                    }
                    String dataSourceType = XmlUtil.getAttribute((Node)dataSourceNode, ATTR_TYPE, (String)null);
                    String dataSourceSource = XmlUtil.getAttribute(dataSourceNode, ATTR_SOURCE);
                    DataSource dataSource = idv.makeOneDataSource(dataSourceSource, dataSourceType, null);
                    if (dataSource == null) continue;
                    DataChoice dataChoice = dataSource.findDataChoice(dcName);
                    if (dataChoice == null) {
                        throw new IllegalStateException("Could not find data choice : " + dcName + " from:" + dataSource);
                    }
                    dataChoices.add(dataChoice);
                }
                cd.doMakeDisplay(dataChoices, idv, "", null, true);
            }
        }
        catch (Throwable exc) {
            ControlDescriptor.logException("Processing display file:" + displayFile, exc);
            return;
        }
    }

    public static void createControlDescriptor(IntegratedDataViewer idv, Element node) {
        try {
            idv.addControlDescriptor(new ControlDescriptor(idv, node));
        }
        catch (Throwable exc) {
            ControlDescriptor.logException("Creating control descriptor", exc);
            return;
        }
    }

    public static List getApplicableControlDescriptors(List categories, List descriptors) {
        return ControlDescriptor.getApplicableControlDescriptors(categories, descriptors, false, true);
    }

    public static List getApplicableControlDescriptors(List categories, List descriptors, boolean includeStandAlone, boolean includeIfEmpty) {
        boolean haveCategories;
        ArrayList<ControlDescriptor> l = new ArrayList<ControlDescriptor>();
        boolean bl = haveCategories = categories.size() > 0;
        if (categories.contains(DataCategory.NONE_CATEGORY)) {
            return l;
        }
        for (int i = 0; i < descriptors.size(); ++i) {
            ControlDescriptor dd = (ControlDescriptor)descriptors.get(i);
            if (includeStandAlone && dd.canStandAlone()) {
                l.add(dd);
                continue;
            }
            if (!includeIfEmpty && !haveCategories || !dd.applicableTo(categories)) continue;
            l.add(dd);
        }
        return l;
    }

    public void showHelp() {
        try {
            if (this.prototype == null) {
                this.prototype = this.controlClass == null ? this.displayTemplatePrototype : (DisplayControl)this.controlClass.newInstance();
                this.prototype.initBasic(this.controlId, this.dataCategories, this.properties);
            }
            this.prototype.showHelp();
        }
        catch (Throwable exc) {
            LogUtil.printException(log_, "Showing help", exc);
        }
    }

    private void initxxx(String controlId, Class controlClass, String label, String description, String icon, String categories, String properties) {
        this.dataCategories = DataCategory.parseCategories(categories);
        this.controlId = controlId;
        this.controlClass = controlClass;
        this.label = label;
        this.description = description;
        this.icon = icon;
    }

    public boolean canStandAlone() {
        return this.canStandAlone;
    }

    public List getLevels() {
        return this.levels;
    }

    public boolean doesLevels() {
        return this.doesLevels;
    }

    public Hashtable getProperties() {
        return this.properties;
    }

    public String getIcon() {
        return this.icon;
    }

    public List getCategories() {
        return this.dataCategories;
    }

    public void setCategories(List categoryList) {
        this.dataCategories = categoryList;
    }

    public boolean applicableTo(DataChoice dataChoice) {
        return this.applicableTo(dataChoice.getCategories());
    }

    public boolean applicableTo(DataCategory category) {
        return this.applicableTo(Misc.newList(category));
    }

    public boolean applicableTo(List categories) {
        return DataCategory.applicableTo(this.dataCategories, categories);
    }

    public DisplayControl doMakeDisplay(DataChoice dataChoice, IntegratedDataViewer viewer, String argProperties, DataSelection dataSelection) throws InstantiationException, VisADException, RemoteException, IllegalAccessException, InvocationTargetException {
        return this.doMakeDisplay(Misc.newList(dataChoice), viewer, argProperties, dataSelection, true);
    }

    private List processList(List choices) {
        if (this.code != null) {
            ArrayList<DerivedDataChoice> newList = new ArrayList<DerivedDataChoice>();
            for (int i = 0; i < choices.size(); ++i) {
                DataChoice dataChoice = (DataChoice)choices.get(i);
                DerivedDataChoice ddc = new DerivedDataChoice(this.idv, Misc.newList(dataChoice), dataChoice.getId().toString(), dataChoice.getDescription(), "", null, null, this.code);
                newList.add(ddc);
            }
            return newList;
        }
        return choices;
    }

    public DisplayControl doMakeDisplay(List dataChoices, IntegratedDataViewer viewer, String argPropertiesString, DataSelection dataSelection, boolean initDisplayInThread) throws InstantiationException, VisADException, RemoteException, IllegalAccessException, InvocationTargetException {
        Hashtable argProperties = null;
        if (argPropertiesString != null) {
            argProperties = StringUtil.parsePropertiesString(argPropertiesString);
        }
        return this.doMakeDisplay(dataChoices, viewer, argProperties, dataSelection, initDisplayInThread);
    }

    public DisplayControl doMakeDisplay(List dataChoices, final IntegratedDataViewer viewer, Hashtable argProperties, final DataSelection dataSelection, boolean initDisplayInThread) throws InstantiationException, VisADException, RemoteException, IllegalAccessException, InvocationTargetException {
        boolean showWindow;
        dataChoices = this.processList(dataChoices);
        final List newDataChoices = DataChoice.cloneDataChoices(dataChoices);
        if (argProperties == null) {
            argProperties = new Hashtable<String, String>();
        }
        DisplayControl control = null;
        if (this.displayTemplateFile != null) {
            control = this.idv.getPersistenceManager().instantiateFromTemplate(this.displayTemplateFile);
            control.initAsTemplate();
        } else {
            control = (DisplayControl)this.idv.getPersistenceManager().getPrototype(this.controlClass);
            if (control == null) {
                control = (DisplayControl)this.controlClass.newInstance();
            }
        }
        if (this.properties != null) {
            argProperties.putAll(this.properties);
        }
        if (this.idv != null && (showWindow = ((Boolean)this.idv.getStateManager().getPreference("Display.showControlWindow", Boolean.TRUE)).booleanValue())) {
            argProperties.put("windowVisible", "true");
        }
        argProperties.put("version", "1.3");
        final Hashtable<String, String> newProperties = argProperties;
        final DisplayControl theNewControl = control;
        if (initDisplayInThread) {
            Misc.run(new Runnable(){

                @Override
                public void run() {
                    ControlDescriptor.this.initControl(theNewControl, newDataChoices, viewer, newProperties, dataSelection);
                }
            });
        } else {
            this.initControl(theNewControl, newDataChoices, viewer, newProperties, dataSelection);
        }
        return control;
    }

    public void initControl(DisplayControl control, List newDataChoices, IntegratedDataViewer idv, String properties, DataSelection dataSelection) {
        this.initControl(control, newDataChoices, idv, properties == null ? null : StringUtil.parsePropertiesString(properties), dataSelection);
    }

    public void initControl(DisplayControl control, List newDataChoices, IntegratedDataViewer idv, Hashtable newProperties, DataSelection dataSelection) {
        if (newProperties == null) {
            newProperties = new Hashtable<String, String>();
        }
        if (newProperties.get("displayCategory") == null) {
            if (this.displayTemplatePrototype != null) {
                newProperties.put("displayCategory", this.displayTemplatePrototype.getDisplayCategory());
            } else if (this.displayCategory.length() > 0) {
                newProperties.put("displayCategory", this.displayCategory);
            }
        }
        idv.showWaitCursor();
        try {
            Trace.call1("ControlDescriptor control.init");
            control.init(this.controlId, this.dataCategories, newDataChoices, (ControlContext)idv, newProperties, dataSelection);
            Trace.call2("ControlDescriptor control.init");
            idv.controlHasBeenInitialized(control);
        }
        catch (DataCancelException dataCancelException) {
        }
        catch (PyException pye) {
            List<String> lines = StringUtil.split(pye.toString(), "\n", true, true);
            String message = lines.get(lines.size() - 1);
            message = message.replace("visad.VisADException:", "");
            message = message.replace("java.lang.Exception:", "");
            message = message.trim();
            LogUtil.printException(log_, "Creating display: " + this.label + "\n" + message, pye);
        }
        catch (Throwable exc) {
            LogUtil.printException(log_, "Creating display: " + this.label, exc);
        }
        idv.showNormalCursor();
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getControlId() {
        return this.controlId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getToolTipText() {
        if (this.description == null) {
            return this.label;
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        return this.label;
    }

    public static void logException(String msg, Throwable exc) {
        LogUtil.printException(log_, msg, exc);
    }

    public String getDisplayCategory() {
        return this.displayCategory;
    }

    public void setDisplayCategory(String c) {
        this.displayCategory = c;
    }

    public void setDisplayTemplateFile(String value) {
        this.displayTemplateFile = value;
    }

    public String getDisplayTemplateFile() {
        return this.displayTemplateFile;
    }
}

