/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv;

import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.collab.Server;
import ucar.unidata.idv.ControlDescriptor;
import ucar.unidata.idv.IdvManager;
import ucar.unidata.idv.IdvResourceManager;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Msg;
import ucar.unidata.util.PatternFileFilter;
import ucar.unidata.util.ResourceCollection;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.Trace;
import ucar.unidata.view.geoloc.MapProjectionDisplay;
import ucar.unidata.xml.XmlUtil;
import visad.VisADException;

public class ArgsManager
extends IdvManager {
    public static final String USAGE_MESSAGE = "Usage: IntegratedDataViewer  <args> <bundle/script files, e.g., .xidv, .zidv, .isl>";
    public static final int RUNNABLE_MAX_TRIES = 30;
    String[] originalArgs;
    String fixedTimeString;
    int imageServerPort = -1;
    String imageServerPropertyFile;
    int oneInstancePort = -1;
    boolean noOneInstance = false;
    String[] commandLineArgs;
    private boolean isOffScreen = false;
    protected boolean listResources = false;
    private boolean islInteractive = false;
    boolean pluginsOk = true;
    List initRunnables = new ArrayList();
    private boolean doDefaultBundle = true;
    boolean doClearAllBundles = false;
    String defaultBundle;
    boolean doPreferences = true;
    protected List persistentCommandLineArgs = new ArrayList();
    String defaultUserDirectory = null;
    boolean showChooserOnInit = false;
    public boolean testMode = false;
    public boolean testEval = false;
    boolean traceMode = false;
    public String testArchive;
    public String testDir;
    protected boolean noGui = false;
    protected String jythonCode = null;
    List initDataFiles = new ArrayList();
    public List argXidvFiles = new ArrayList();
    List argDisplayXmlFiles = new ArrayList();
    public List argDisplayB64Xml = new ArrayList();
    public List b64Bundles = new ArrayList();
    public List plugins = new ArrayList();
    public List installPlugins = new ArrayList();
    List jnlpFiles = new ArrayList();
    protected boolean printJnlpBundles = false;
    public List scriptingFiles = new ArrayList();
    List captureFiles = new ArrayList();
    List initCatalogs = new ArrayList();
    List propertyFiles = new ArrayList();
    String sitePathFromArgs = null;
    protected List initParams = new ArrayList();
    protected List initDisplays = new ArrayList();
    List displayTemplates = new ArrayList();
    List argPropertyNames = new ArrayList();
    List argPropertyValues = new ArrayList();
    List argRbiFiles = new ArrayList();
    String collabHostName = null;
    int collabPort = Server.DEFAULT_PORT;
    boolean doCollabServer = false;
    protected List fileMappingIds = new ArrayList();
    protected List fileMappingFiles = new ArrayList();

    public ArgsManager(IntegratedDataViewer idv, String[] args) {
        super(idv);
        String[] tmpargs = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            tmpargs[i] = args[i].trim();
        }
        this.originalArgs = tmpargs;
        this.commandLineArgs = this.preprocessArgs(this.originalArgs);
    }

    public String[] getOriginalArgs() {
        return this.originalArgs;
    }

    public List getInitCatalogs() {
        return this.initCatalogs;
    }

    protected void initDone() {
        if (this.scriptingFiles.size() == 0) {
            this.islInteractive = true;
        } else if (!this.islInteractive) {
            this.doDefaultBundle = false;
            this.getStateManager().setRunningIsl(true);
            this.initRunnables.add(new Runnable(){

                @Override
                public void run() {
                    ArgsManager.this.getImageGenerator().processScriptFiles(ArgsManager.this.scriptingFiles);
                }
            });
        } else {
            Misc.run(new Runnable(){

                @Override
                public void run() {
                    Misc.sleep(100L);
                    ArgsManager.this.getImageGenerator().processScriptFiles(ArgsManager.this.scriptingFiles);
                }
            });
        }
        if (this.showChooserOnInit || this.initCatalogs.size() > 0) {
            this.getIdvChooserManager().show();
        }
        if (this.initRunnables.size() > 0) {
            LogUtil.setTestMode(true);
            Runnable runnablesRunnable = new Runnable(){

                @Override
                public void run() {
                    ArgsManager.this.runInitRunnables();
                }
            };
            Misc.runInABit(100L, runnablesRunnable);
        }
        for (int i = 0; i < this.captureFiles.size(); ++i) {
            this.getCollabManager().runCaptureFile(this.captureFiles.get(i).toString());
        }
    }

    private void runInitRunnables() {
        for (int i = 0; i < this.initRunnables.size(); ++i) {
            Runnable runnable = (Runnable)this.initRunnables.get(i);
            runnable.run();
        }
        this.getIdv().exit(0);
    }

    public static boolean isDisplayXmlFile(String name) {
        return name.toLowerCase().endsWith(".dxml");
    }

    public List<PatternFileFilter> getBundleFileFilters() {
        return Misc.newList(this.getXidvFileFilter(), FILTER_JNLP, FILTER_ISL, this.getZidvFileFilter());
    }

    public PatternFileFilter getXidvFileFilter() {
        return FILTER_XIDV;
    }

    public PatternFileFilter getZidvFileFilter() {
        return FILTER_ZIDV;
    }

    public PatternFileFilter getXidvZidvFileFilter() {
        return FILTER_XIDVZIDV;
    }

    public boolean isXidvFile(String name) {
        return IOUtil.hasSuffix(name, this.getXidvFileFilter().getPreferredSuffix()) || IOUtil.hasSuffix(name, ".xidv");
    }

    public boolean isBundleFile(String name) {
        return this.isXidvFile(name) || this.isZidvFile(name);
    }

    public boolean isIslFile(String name) {
        return IOUtil.hasSuffix(name, ".isl");
    }

    public boolean isZidvFile(String name) {
        return IOUtil.hasSuffix(name, this.getZidvFileFilter().getPreferredSuffix()) || IOUtil.hasSuffix(name, ".zidv");
    }

    public boolean isRbiFile(String name) {
        return IOUtil.hasSuffix(name, ".rbi");
    }

    public boolean isJnlpFile(String name) {
        return IOUtil.hasSuffix(name, ".jnlp");
    }

    public boolean getNoGui() {
        return this.noGui;
    }

    public void usage(String err) {
        String msg = USAGE_MESSAGE;
        msg = msg + "\n" + this.getUsageMessage();
        LogUtil.userErrorMessage(err + "\n" + msg);
        this.getIdv().exit(0);
    }

    protected String msg(String arg, String desc) {
        return "\t" + arg + "  " + desc + "\n";
    }

    public boolean getIslInteractive() {
        return this.islInteractive;
    }

    protected String getUsageMessage() {
        return this.msg("-help", "(this message)") + this.msg("-properties", "<property file>") + this.msg("-Dpropertyname=value", "(Define the property value)") + this.msg("-installplugin", "<plugin jar file or url to install>") + this.msg("-plugin", "<plugin jar file, directory, url for this run>") + this.msg("-noplugins", "Don't load plugins") + this.msg("-cleardefault", "(Clear the default bundle)") + this.msg("-nodefault", "(Don't read in the default bundle file)") + this.msg("-default", "<.xidv file>") + this.msg("-bundle", "<bundle file or url>") + this.msg("-b64bundle", "<base 64 encoded inline bundle>") + this.msg("-setfiles", "<datasource pattern> <semi-colon delimited list of files> (Use the list of files for the bundled datasource)") + this.msg("-oneinstanceport", "<port number> (Check if another version of the IDV is running. If so pass command line arguments to it and shutdown)") + this.msg("-nooneinstance", "(Don't do the one instance port)") + this.msg("-nopref", "(Don't read in the user preferences)") + this.msg("-userpath", "<user directory to use>") + this.msg("-sitepath", "<url path to find site resources>") + this.msg("-nogui", "(Don't show the main window gui)") + this.msg("-data", "<data source> (Load the data source)") + this.msg("-display", "<parameter> <display>") + this.msg("<scriptfile.isl>", "(Run the IDV script in batch mode)") + this.msg("-script", "<jython script file to evaluate>") + this.msg("-b64isl", "<base64 encoded inline isl> This will run the isl in interactive mode") + this.msg("-islinteractive", "run any isl files in interactive mode") + this.msg("-image", "<image file name> (create a jpeg image and then exit)") + this.msg("-movie", "<movie file name> (create a quicktime movie and then exit)") + this.msg("-imageserver", "<port number or .properties file> (run the IDV in image generation server mode. Support http requests on the given port)") + this.msg("-catalog", "<url to a chooser catalog>") + this.msg("-connect", "<collaboration hostname to connect to>") + this.msg("-server", "(Should the IDV run in collaboration server mode)") + this.msg("-port", "<Port number collaboration server should listen on>") + this.msg("-chooser", "(show the data chooser on start up) ") + this.msg("-printjnlp", "(Print out any embedded bundles from jnlp files)") + this.msg("-currenttime", "<dttm> (Override current time for ISL processing)") + this.msg("-listresources", "<list out the resource types") + this.msg("-debug", "(Turn on debug print)") + this.msg("-debugmessages", "(Turn on language pack debug)") + this.msg("-recordmessages", "<Language pack file to write missing entries to>") + this.msg("-trace", "(Print out trace messages)") + this.msg("-noerrorsingui", "(Don't show errors in gui)") + this.msg("-traceonly", "<trace pattern> (Print out trace messages that match the pattern)");
    }

    protected String[] preprocessArgs(String[] args) {
        ArrayList<String> argList = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (this.isJnlpFile(arg)) {
                try {
                    Element root = XmlUtil.getRoot(arg, this.getClass());
                    List arguments = XmlUtil.findDescendants(root, "argument");
                    for (int jnlpArgIdx = 0; jnlpArgIdx < arguments.size(); ++jnlpArgIdx) {
                        String value = XmlUtil.getChildText((Node)arguments.get(jnlpArgIdx));
                        if (value == null) continue;
                        argList.add(value);
                    }
                    continue;
                }
                catch (Exception exc) {
                    this.getIdv().logException("Processing command line jnlp file", exc);
                    continue;
                }
            }
            argList.add(arg);
        }
        return StringUtil.listToStringArray(argList);
    }

    public void parseArgs() throws Exception {
        this.parseArgs(this.commandLineArgs);
    }

    protected void parseArgs(String[] args) throws Exception {
        int idx = 0;
        while (idx < args.length) {
            String arg = args[idx];
            ++idx;
            idx = this.parseArg(arg, args, idx);
        }
        if (this.isOffScreen) {
            LogUtil.setTestMode(true);
        }
    }

    protected boolean checkArg(String arg, String lookingFor, String[] args, int idx, int howManyMore) {
        if (!arg.equals(lookingFor)) {
            return false;
        }
        if (idx + (howManyMore - 1) >= args.length) {
            this.usage("No value given for " + lookingFor + "  argument");
        }
        return true;
    }

    protected int parseArg(String arg, String[] args, int idx) throws Exception {
        if (this.checkArg(arg, "-data", args, idx, 1)) {
            this.initDataFiles.add(args[idx++]);
        } else if (arg.startsWith("-D")) {
            this.persistentCommandLineArgs.add(arg);
            List<String> l = StringUtil.split(arg.substring(2), "=");
            if (l.size() != 2) {
                this.usage("Invalid property:" + arg);
            }
            this.argPropertyNames.add(l.get(0));
            this.argPropertyValues.add(l.get(1));
        } else if (arg.equals("-mainclass")) {
            ++idx;
        } else if (arg.equals("-server")) {
            this.doCollabServer = true;
        } else if (arg.equals("-printjnlp")) {
            this.printJnlpBundles = true;
        } else if (this.checkArg(arg, "-setfiles", args, idx, 2)) {
            this.fileMappingIds.add(args[idx++]);
            this.fileMappingFiles.add(StringUtil.split(args[idx++], ";"));
        } else if (this.checkArg(arg, "-currenttime", args, idx, 1)) {
            String dttm;
            Date date;
            if ((date = StringUtil.parseDate(dttm = args[idx++])) == null) {
                this.usage("Bad date format:" + dttm);
            }
            Misc.setCurrentTime(date);
        } else if (this.checkArg(arg, "-connect", args, idx, 1)) {
            this.collabHostName = args[idx++];
        } else if (this.checkArg(arg, "-port", args, idx, 1)) {
            this.collabPort = new Integer(args[idx++]);
        } else if (this.checkArg(arg, "-catalog", args, idx, 1)) {
            this.initCatalogs.add(args[idx++]);
        } else if (arg.equals("-noplugins")) {
            this.pluginsOk = false;
        } else if (this.checkArg(arg, "-installplugin", args, idx, 1)) {
            this.installPlugins.add(args[idx++]);
        } else if (this.checkArg(arg, "-plugin", args, idx, 1)) {
            this.plugins.add(args[idx++]);
        } else if (this.checkArg(arg, "-bundle", args, idx, 1)) {
            this.argXidvFiles.add(args[idx++]);
        } else if (this.checkArg(arg, "-b64bundle", args, idx, 1)) {
            this.b64Bundles.add(args[idx++]);
        } else if (this.checkArg(arg, "-properties", args, idx, 1)) {
            String argValue = args[idx++];
            this.persistentCommandLineArgs.add("-properties");
            this.persistentCommandLineArgs.add(argValue);
            this.propertyFiles.add(argValue);
        } else if (this.checkArg(arg, "-sitepath", args, idx, 1)) {
            this.sitePathFromArgs = args[idx++];
            this.persistentCommandLineArgs.add("-sitepath");
            this.persistentCommandLineArgs.add(this.sitePathFromArgs);
        } else if (arg.equals("-chooser")) {
            this.persistentCommandLineArgs.add("-chooser");
            this.showChooserOnInit = true;
        } else if (this.checkArg(arg, "-imageserver", args, idx, 1)) {
            String tmp;
            if ((tmp = args[idx++]).endsWith(".properties")) {
                this.imageServerPropertyFile = tmp;
            } else {
                this.imageServerPort = new Integer(tmp);
            }
            this.setIsOffScreen(true);
        } else if (arg.equals("-nooneinstance")) {
            this.noOneInstance = true;
        } else if (this.checkArg(arg, "-oneinstanceport", args, idx, 1)) {
            this.oneInstancePort = new Integer(args[idx++]);
            this.persistentCommandLineArgs.add(arg);
            this.persistentCommandLineArgs.add("" + this.oneInstancePort);
        } else if (this.checkArg(arg, "-image", args, idx, 1)) {
            this.setIsOffScreen(true);
            final String imageName = args[idx++];
            this.initRunnables.add(new Runnable(){

                @Override
                public void run() {
                    ArgsManager.this.getImageGenerator().captureImage(imageName);
                }
            });
        } else if (this.checkArg(arg, "-movie", args, idx, 1)) {
            this.setIsOffScreen(true);
            final String imageName = args[idx++];
            this.initRunnables.add(new Runnable(){

                @Override
                public void run() {
                    ArgsManager.this.getImageGenerator().captureMovie(imageName);
                }
            });
        } else if (this.checkArg(arg, "-userpath", args, idx, 1)) {
            String argValue;
            File f;
            if (!(f = new File(argValue = args[idx++])).exists()) {
                if (!GuiUtils.askYesNo("User directory", "Given -userpath directory does not exist. Do you want to create it?")) {
                    return idx;
                }
            } else if (!f.isDirectory()) {
                this.usage("Given -userpath argument must be a directory");
            }
            this.persistentCommandLineArgs.add("-userpath");
            this.persistentCommandLineArgs.add(argValue);
            this.defaultUserDirectory = argValue;
        } else if (arg.startsWith("-nopref")) {
            this.persistentCommandLineArgs.add(arg);
            this.doPreferences = false;
        } else if (this.checkArg(arg, "-default", args, idx, 1)) {
            this.defaultBundle = args[idx++];
        } else if (this.checkArg(arg, "-fixedtime", args, idx, 1)) {
            this.fixedTimeString = args[idx++];
        } else if (arg.equals("-debug")) {
            LogUtil.setDebugMode(true);
        } else if (arg.equals("-cleardefault")) {
            this.doClearAllBundles = true;
        } else if (arg.equals("-2d")) {
            MapProjectionDisplay.force2D = true;
        } else if (arg.equals("-nodefault")) {
            this.persistentCommandLineArgs.add(arg);
            this.doDefaultBundle = false;
        } else if (arg.equals("-nogui")) {
            this.persistentCommandLineArgs.add(arg);
            this.noGui = true;
        } else if (this.checkArg(arg, "-code", args, idx, 1)) {
            this.jythonCode = args[idx++];
        } else if (this.checkArg(arg, "-script", args, idx, 1)) {
            this.jythonCode = IOUtil.readContents(args[idx++]);
        } else if (this.isJnlpFile(arg)) {
            this.jnlpFiles.add(arg);
        } else if (arg.toLowerCase().endsWith(".cpt")) {
            this.captureFiles.add(arg);
        } else if (this.checkArg(arg, "-islfile", args, idx, 1)) {
            this.scriptingFiles.add(args[idx++]);
            if (!this.islInteractive) {
                this.setIsOffScreen(true);
            }
        } else if (arg.equals("-listresources")) {
            this.listResources = true;
        } else if (this.checkArg(arg, "-b64isl", args, idx, 1)) {
            this.scriptingFiles.add("b64:" + args[idx++]);
            this.islInteractive = true;
            this.setIsOffScreen(false);
        } else if (arg.equals("-islinteractive")) {
            this.islInteractive = true;
            this.setIsOffScreen(false);
        } else if (this.isIslFile(arg)) {
            this.scriptingFiles.add(arg);
            if (!this.islInteractive) {
                this.setIsOffScreen(true);
            }
        } else if (this.isXidvFile(arg)) {
            this.argXidvFiles.add(arg);
        } else if (this.isZidvFile(arg)) {
            this.argXidvFiles.add(arg);
        } else if (this.isRbiFile(arg)) {
            this.argRbiFiles.add(arg);
        } else if (this.checkArg(arg, "-dxml", args, idx, 1)) {
            this.argDisplayB64Xml.add(args[idx++]);
        } else if (ArgsManager.isDisplayXmlFile(arg)) {
            this.argDisplayXmlFiles.add(arg);
        } else if (this.checkArg(arg, "-template", args, idx, 3)) {
            this.displayTemplates.add(args[idx++]);
            this.displayTemplates.add(args[idx++]);
            this.displayTemplates.add(args[idx++]);
        } else if (this.checkArg(arg, "-display", args, idx, 2)) {
            this.initParams.add(args[idx++]);
            this.initDisplays.add(args[idx++]);
        } else if (arg.equals("-help")) {
            System.err.println(USAGE_MESSAGE);
            System.err.println(this.getUsageMessage());
            this.getIdv().exit(0);
        } else if (arg.equals("-noerrorsingui")) {
            LogUtil.setShowErrorsInGui(false);
        } else if (arg.equals("-testeval")) {
            this.testEval = true;
            this.testMode = true;
        } else if (this.checkArg(arg, "-test", args, idx, 2)) {
            this.testMode = true;
            this.testArchive = args[idx++];
            this.testDir = args[idx++];
        } else if (arg.equals("-debugmessages")) {
            Msg.setShowDebug(true);
        } else if (this.checkArg(arg, "-recordmessages", args, idx, 1)) {
            Msg.recordMessages(new File(args[idx++]));
        } else if (arg.equals("-trace")) {
            this.traceMode = true;
        } else if (this.checkArg(arg, "-traceonly", args, idx, 1)) {
            Trace.addOnly(args[idx++]);
            this.traceMode = true;
        } else {
            this.usage("Unknown argument:" + arg);
        }
        return idx;
    }

    protected void processInitialBundles() throws VisADException, RemoteException {
        String xml;
        int i;
        block4: {
            block6: {
                block5: {
                    if (this.doClearAllBundles) {
                        this.getResourceManager().clearDefaultBundles();
                        this.doDefaultBundle = false;
                    }
                    if (this.getIsOffScreen() || !this.doDefaultBundle) break block4;
                    this.showWaitCursor();
                    this.getIdvUIManager().splashMsg("Loading Defaults");
                    LogUtil.message("Loading  defaults");
                    if (this.defaultBundle == null) break block5;
                    String defaultXml = IOUtil.readContents(this.defaultBundle, (String)null);
                    if (defaultXml == null) break block6;
                    this.getPersistenceManager().decodeXml(defaultXml, false, "Default bundle", false);
                    break block6;
                }
                ResourceCollection rc = this.getResourceManager().getResources(IdvResourceManager.RSC_BUNDLES);
                for (int i2 = 0; i2 < rc.size(); ++i2) {
                    String bundleXml = rc.read(i2);
                    if (bundleXml == null) continue;
                    this.getPersistenceManager().decodeXml(bundleXml, false, "Default bundle", false);
                    break;
                }
            }
            LogUtil.clearMessage("Loading  defaults");
            this.showNormalCursor();
        }
        this.showWaitCursor();
        this.processXidvFiles(this.argXidvFiles);
        this.processBase64Bundles(this.b64Bundles);
        this.processJnlpFiles(this.jnlpFiles);
        for (i = 0; i < this.argDisplayXmlFiles.size(); ++i) {
            String displayFile = (String)this.argDisplayXmlFiles.get(i);
            xml = IOUtil.readContents(displayFile, this.getIdvClass(), null);
            if (xml == null) continue;
            ControlDescriptor.processDisplayXml(this.getIdv(), xml);
        }
        for (i = 0; i < this.argDisplayB64Xml.size(); ++i) {
            String b64Xml = (String)this.argDisplayB64Xml.get(i);
            xml = new String(XmlUtil.decodeBase64(b64Xml));
            ControlDescriptor.processDisplayXml(this.getIdv(), xml);
        }
        this.showNormalCursor();
    }

    private void processBase64Bundles(List bundles) {
        for (int i = 0; i < bundles.size(); ++i) {
            this.getPersistenceManager().loadB64Bundle((String)bundles.get(i));
        }
    }

    private void processJnlpFiles(List jnlpFiles) {
        for (int i = 0; i < jnlpFiles.size(); ++i) {
            LogUtil.message("Loading bundle");
            this.showWaitCursor();
            this.getPersistenceManager().decodeJnlpFile((String)jnlpFiles.get(i));
            this.showNormalCursor();
            LogUtil.clearMessage("Loading bundle");
        }
    }

    private void processXidvFiles(List files) {
        String lastFileName = null;
        for (int i = 0; i < files.size(); ++i) {
            lastFileName = (String)files.get(i);
            LogUtil.message("Loading  bundle:" + lastFileName);
            this.getPersistenceManager().decodeXmlFile(lastFileName, false);
            LogUtil.clearMessage("Loading  bundle:" + lastFileName);
        }
        this.getPersistenceManager().setCurrentFileName(lastFileName);
    }

    public void processInstanceArgs(String[] args) {
        ArrayList<String> jnlpFiles = new ArrayList<String>();
        ArrayList<String> xidvFiles = new ArrayList<String>();
        ArrayList<String> base64Bundles = new ArrayList<String>();
        ArrayList<String> dataSources = new ArrayList<String>();
        ArrayList<String> islFiles = new ArrayList<String>();
        boolean gotOne = false;
        for (int idx = 0; idx < args.length; ++idx) {
            String arg = args[idx];
            int nextIdx = idx + 1;
            if (this.isJnlpFile(arg)) {
                jnlpFiles.add(arg);
                gotOne = true;
                continue;
            }
            if (this.isIslFile(arg)) {
                islFiles.add(arg);
                continue;
            }
            if (this.isXidvFile(arg)) {
                xidvFiles.add(arg);
                gotOne = true;
                continue;
            }
            if (this.checkArg(arg, "-bundle", args, nextIdx, 1)) {
                this.argXidvFiles.add(args[++idx]);
                gotOne = true;
                continue;
            }
            if (this.checkArg(arg, "-b64bundle", args, nextIdx, 1)) {
                base64Bundles.add(args[++idx]);
                gotOne = true;
                continue;
            }
            if (this.checkArg(arg, "-islfile", args, nextIdx, 1)) {
                this.scriptingFiles.add(args[++idx]);
                continue;
            }
            if (!arg.equals("-data")) continue;
            dataSources.add(args[++idx]);
        }
        if (gotOne) {
            boolean[] ok = this.getPreferenceManager().getDoRemoveBeforeOpening(null);
            if (!ok[0]) {
                return;
            }
            if (ok[1]) {
                this.getIdv().removeAllDataSources();
                this.getIdv().removeAllDisplays();
            }
        }
        this.processXidvFiles(xidvFiles);
        this.processJnlpFiles(jnlpFiles);
        this.processBase64Bundles(base64Bundles);
        if (islFiles.size() > 0) {
            this.islInteractive = true;
            Misc.run(this.getImageGenerator(), "processScriptFiles", islFiles);
        }
        if (dataSources.size() > 0) {
            this.getIdv().loadDataFiles(dataSources);
        }
    }

    public String getCollabHostName() {
        return this.collabHostName;
    }

    public boolean getDoCollabServer() {
        return this.doCollabServer;
    }

    public int getCollabPort() {
        return this.collabPort;
    }

    public String getFixedTimeString() {
        return this.fixedTimeString;
    }

    public boolean getIsOffScreen() {
        return this.isOffScreen;
    }

    public void setIsOffScreen(boolean v) {
        this.isOffScreen = v;
    }

    public boolean isScriptingMode() {
        return !this.islInteractive && this.scriptingFiles.size() > 0;
    }
}

