/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.gis.shapefile;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ogc.WKTParser;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.unidata.util.IOUtil;
import ucar.visad.ProjectionCoordinateSystem;
import ucar.visad.Util;
import visad.Unit;
import visad.VisADException;

public class ProjFile {
    private ProjectionImpl projection;
    private ProjectionCoordinateSystem projCS;
    private Unit projUnit;

    public ProjFile(URL url) throws Exception {
        URLConnection connection = url.openConnection();
        this.init(connection.getInputStream());
    }

    public ProjFile(String spec) throws Exception {
        this.init(IOUtil.getInputStream(spec));
    }

    public ProjFile(File file) throws Exception {
        this(file.getPath());
    }

    public ProjFile(InputStream s) throws Exception {
        this.init(s);
    }

    public void init(InputStream s) {
        block9: {
            WKTParser parser = null;
            try {
                String projSpec = new String(IOUtil.readBytes(s, null, false));
                parser = new WKTParser(projSpec);
                if (parser.isPlanarProjection()) {
                    this.projection = WKTParser.convertWKTToProjection(parser);
                }
            }
            catch (Exception e) {
                this.projection = null;
            }
            if (this.projection != null && !(this.projection instanceof LatLonProjection)) {
                try {
                    this.projCS = new ProjectionCoordinateSystem(this.projection);
                    if (parser.getProjUnitName().equals(null)) break block9;
                    String unitString = parser.getProjUnitValue() + " " + parser.getProjUnitName();
                    Unit u = null;
                    try {
                        u = Util.parseUnit(unitString);
                    }
                    catch (VisADException ve) {
                        u = null;
                    }
                    if (u != null) {
                        this.projUnit = u;
                    }
                }
                catch (VisADException ve) {
                    System.err.println("can't make projection cs");
                }
            }
        }
    }

    public String toString() {
        return "projection:" + this.projection.getClass().getName();
    }

    public ProjectionImpl getProjection() {
        return this.projection;
    }

    public double[][] convertToLonLat(double[][] xy) {
        if (this.projCS == null) {
            return xy;
        }
        double[][] latlon = xy;
        try {
            latlon = this.projCS.toReference(xy, new Unit[]{this.projUnit, this.projUnit});
        }
        catch (Exception e) {
            return xy;
        }
        return new double[][]{latlon[1], latlon[0]};
    }
}

