/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.gis.shapefile;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.unidata.gis.GisFeatureRendererMulti;
import ucar.unidata.gis.shapefile.EsriShapefile;

public class EsriShapefileRenderer
extends GisFeatureRendererMulti {
    private static Map sfileHash = new HashMap();
    private static double defaultCoarseness = 0.0;
    private EsriShapefile esri = null;
    private ProjectionImpl dataProject = new LatLonProjection("Cylindrical Equidistant");

    public static EsriShapefileRenderer factory(String filename) {
        if (sfileHash.containsKey(filename)) {
            return (EsriShapefileRenderer)sfileHash.get(filename);
        }
        try {
            EsriShapefileRenderer sfile = new EsriShapefileRenderer(filename);
            sfileHash.put(filename, sfile);
            return sfile;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static EsriShapefileRenderer factory(InputStream stream) {
        if (sfileHash.containsKey(stream)) {
            return (EsriShapefileRenderer)sfileHash.get(stream);
        }
        try {
            EsriShapefileRenderer sfile = new EsriShapefileRenderer(stream);
            sfileHash.put(stream, sfile);
            return sfile;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private EsriShapefileRenderer(InputStream stream) throws IOException {
        this.esri = new EsriShapefile(stream, null, defaultCoarseness);
        double avgD = this.getStats(this.esri.getFeatures().iterator());
        this.createFeatureSet(avgD);
        this.createFeatureSet(2.0 * avgD);
        this.createFeatureSet(3.0 * avgD);
        this.createFeatureSet(5.0 * avgD);
        this.createFeatureSet(8.0 * avgD);
    }

    private EsriShapefileRenderer(String filename) throws IOException {
        this(filename, defaultCoarseness);
    }

    private EsriShapefileRenderer(String filename, double coarseness) throws IOException {
        this.esri = new EsriShapefile(filename, coarseness);
        double avgD = this.getStats(this.esri.getFeatures().iterator());
        this.createFeatureSet(2.0 * avgD);
        this.createFeatureSet(4.0 * avgD);
        this.createFeatureSet(8.0 * avgD);
        this.createFeatureSet(16.0 * avgD);
    }

    @Override
    public LatLonRect getPreferredArea() {
        Rectangle2D bb = this.esri.getBoundingBox();
        return new LatLonRect(new LatLonPointImpl(bb.getMinY(), bb.getMinX()), bb.getHeight(), bb.getWidth());
    }

    @Override
    protected List getFeatures() {
        return this.esri.getFeatures();
    }

    @Override
    protected ProjectionImpl getDataProjection() {
        return this.dataProject;
    }
}

