/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.gis.shapefile;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ucar.unidata.gis.shapefile.DbaseFieldDesc;
import ucar.unidata.io.Swap;

public class DbaseData {
    DbaseFieldDesc desc;
    int nrec;
    public static final int TYPE_CHAR = 0;
    public static final int TYPE_NUMERIC = 1;
    public static final int TYPE_BOOLEAN = 2;
    String[] character;
    double[] numeric;
    boolean[] logical;
    byte[] field;
    int type;
    static int cnt = 0;
    List listData;

    DbaseData(DbaseFieldDesc desc, int nrec) {
        this.desc = desc;
        this.nrec = nrec;
        this.field = new byte[desc.FieldLength];
        char switchValue = (char)desc.Type;
        switch (switchValue) {
            case 'C': 
            case 'D': {
                this.character = new String[nrec];
                this.type = 0;
                break;
            }
            case 'F': 
            case 'N': {
                this.numeric = new double[nrec];
                this.type = 1;
                break;
            }
            case 'L': {
                this.logical = new boolean[nrec];
                this.type = 2;
            }
        }
    }

    public int getType() {
        return this.type;
    }

    int readRowN(DataInputStream ds, int n) {
        if (n > this.nrec) {
            return -1;
        }
        try {
            ds.readFully(this.field, 0, this.desc.FieldLength);
        }
        catch (IOException e) {
            return -1;
        }
        char switchValue = (char)this.desc.Type;
        switch (switchValue) {
            case 'C': 
            case 'D': {
                this.character[n] = new String(this.field);
                break;
            }
            case 'N': {
                String sv = new String(this.field);
                this.numeric[n] = 0.0;
                if (sv.trim().length() == 0 || sv.startsWith("*")) break;
                try {
                    this.numeric[n] = Double.valueOf(sv);
                }
                catch (NumberFormatException nfe) {
                    System.err.println("Bad number format:" + sv);
                }
                break;
            }
            case 'F': {
                if (this.desc.FieldLength == 4) {
                    this.numeric[n] = Swap.swapFloat(this.field, 0);
                    break;
                }
                String sf = new String(this.field);
                this.numeric[n] = Double.valueOf(sf);
                break;
            }
            case 'L': {
                switch ((char)this.field[0]) {
                    case 'T': 
                    case 'Y': 
                    case 't': 
                    case 'y': {
                        this.logical[n] = true;
                        break;
                    }
                    default: {
                        this.logical[n] = false;
                    }
                }
            }
            default: {
                return -1;
            }
        }
        return 0;
    }

    public double[] getDoubles() {
        return this.numeric;
    }

    public double getDouble(int i) {
        return this.numeric[i];
    }

    public boolean[] getBooleans() {
        return this.logical;
    }

    public boolean getBoolean(int i) {
        return this.logical[i];
    }

    public String[] getStrings() {
        return this.character;
    }

    public String getString(int i) {
        return this.character[i];
    }

    public List asList() {
        if (this.listData != null) {
            return this.listData;
        }
        switch (this.type) {
            case 0: {
                this.listData = new ArrayList<String>(Arrays.asList(this.character));
                return this.listData;
            }
            case 1: {
                this.listData = new ArrayList();
                for (int i = 0; i < this.numeric.length; ++i) {
                    this.listData.add(new Double(this.numeric[i]));
                }
                return this.listData;
            }
        }
        this.listData = new ArrayList();
        for (int i = 0; i < this.logical.length; ++i) {
            this.listData.add(new Boolean(this.logical[i]));
        }
        return this.listData;
    }

    public Object getData(int i) {
        switch (this.type) {
            case 0: {
                return this.character[i];
            }
            case 1: {
                return new Double(this.numeric[i]);
            }
            case 2: {
                return new Boolean(this.logical[i]);
            }
        }
        return null;
    }

    public int getNumRec() {
        return this.nrec;
    }
}

