/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.gis.mcidasmap;

import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.unidata.gis.AbstractGisFeature;
import ucar.unidata.gis.GisFeatureRenderer;
import ucar.unidata.gis.GisPart;
import ucar.unidata.util.Resource;

public class McidasMap
extends GisFeatureRenderer {
    private ArrayList gisList;
    private ArrayList partList = null;
    private int total_pts = 0;
    private McidasMapFeature mcidasMapFeature = null;
    private String mapName;
    private boolean debug = false;
    private boolean debugTime = false;
    private LatLonRect defaultLLBB = null;
    private ProjectionImpl dataProject = new LatLonProjection("Cylindrical Equidistant");
    private int MAX_SEGMENTS = 100000;

    public McidasMap(String mapName) {
        this.mapName = mapName;
        this.readMcidasMap();
    }

    private boolean readMcidasMap() {
        int numSegments;
        InputStream is = null;
        long secs = System.currentTimeMillis();
        is = Resource.getFileResource(null, this.mapName);
        if (is == null) {
            System.err.println("McidasMap read failed on resource " + this.mapName);
            return false;
        }
        DataInputStream dis = new DataInputStream(new BufferedInputStream(is));
        this.mcidasMapFeature = new McidasMapFeature();
        this.gisList = new ArrayList();
        this.gisList.add(this.mcidasMapFeature);
        this.partList = new ArrayList();
        try {
            numSegments = dis.readInt();
        }
        catch (IOException e) {
            return false;
        }
        if (numSegments <= 0 || numSegments > this.MAX_SEGMENTS) {
            return false;
        }
        int position = 4;
        for (int j = 0; j < numSegments; ++j) {
            try {
                float miny = (float)dis.readInt() / 10000.0f;
                float maxy = (float)dis.readInt() / 10000.0f;
                float minx = (float)dis.readInt() / 10000.0f;
                float maxx = (float)dis.readInt() / 10000.0f;
                int start = dis.readInt();
                int npts = dis.readInt();
                position += 24;
                if (start < 0 || npts < 0 || npts % 2 != 0) continue;
                McidasMapPart run = new McidasMapPart(npts /= 2, minx, maxx, miny, maxy, start);
                this.partList.add(run);
                this.total_pts += npts;
                continue;
            }
            catch (EOFException ex) {
                break;
            }
            catch (Exception ex) {
                System.err.println("McidasMap exception " + ex);
                break;
            }
        }
        for (int i = 0; i < this.partList.size(); ++i) {
            McidasMapPart part = (McidasMapPart)this.partList.get(i);
            int start = part.getStartingWord();
            int numPairs = part.getNumPoints();
            int skipByte = start * 4 - position;
            try {
                dis.skipBytes(skipByte);
                position += skipByte;
            }
            catch (Exception e) {
                break;
            }
            try {
                for (int l = 0; l < numPairs; ++l) {
                    part.wy[l] = (double)dis.readInt() / 10000.0;
                    position += 4;
                    part.wx[l] = -((double)dis.readInt()) / 10000.0;
                    position += 4;
                }
                continue;
            }
            catch (IOException e) {
                return false;
            }
        }
        try {
            is.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.debugTime) {
            secs = System.currentTimeMillis() - secs;
            System.out.println("McidasMap read file: " + (double)secs * 0.001 + " seconds");
        }
        return true;
    }

    @Override
    public LatLonRect getPreferredArea() {
        return this.defaultLLBB;
    }

    @Override
    protected List getFeatures() {
        return this.gisList;
    }

    @Override
    protected ProjectionImpl getDataProjection() {
        return this.dataProject;
    }

    public AbstractGisFeature getMcidasMap() {
        return this.mcidasMapFeature;
    }

    private class McidasMapPart
    implements GisPart {
        int npts;
        int start;
        double[] wx;
        double[] wy;
        private double minx;
        private double miny;
        private double maxx;
        private double maxy;

        McidasMapPart(int npts, double minx, double maxx, double miny, double maxy, int start) {
            this.npts = npts;
            this.minx = minx;
            this.maxx = maxx;
            this.miny = miny;
            this.maxy = maxy;
            this.start = start;
            this.wx = new double[npts];
            this.wy = new double[npts];
        }

        public int getStartingWord() {
            return this.start;
        }

        @Override
        public int getNumPoints() {
            return this.npts;
        }

        @Override
        public double[] getX() {
            return this.wx;
        }

        @Override
        public double[] getY() {
            return this.wy;
        }
    }

    private class McidasMapFeature
    extends AbstractGisFeature {
        private McidasMapFeature() {
        }

        @Override
        public Rectangle2D getBounds2D() {
            return null;
        }

        @Override
        public int getNumPoints() {
            return McidasMap.this.total_pts;
        }

        @Override
        public int getNumParts() {
            return McidasMap.this.partList.size();
        }

        @Override
        public Iterator getGisParts() {
            return McidasMap.this.partList.iterator();
        }
    }
}

