/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.gis.maps;

import java.awt.Color;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.gis.maps.LatLonData;
import ucar.unidata.gis.maps.LatLonLabelData;
import ucar.unidata.gis.maps.MapData;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Trace;
import ucar.unidata.xml.XmlResourceCollection;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.MapFamily;
import visad.SampledSet;
import visad.VisADException;

public class MapInfo {
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(MapInfo.class.getName());
    public static final String TAG_LATITUDE = "latitude";
    public static final String TAG_LONGITUDE = "longitude";
    public static final String TAG_LATITUDELABEL = "latitudelabel";
    public static final String TAG_LONGITUDELABEL = "longitudelabel";
    public static final String TAG_MAPS = "maps";
    public static final String TAG_MAP = "map";
    public static final String ATTR_COLOR = "color";
    public static final String ATTR_FONT = "font";
    public static final String ATTR_CATEGORY = "category";
    public static final String ATTR_DESCRIPTION = "description";
    public static final String ATTR_FASTRENDER = "fastrender";
    public static final String ATTR_LINEWIDTH = "linewidth";
    public static final String ATTR_LINESTYLE = "linestyle";
    public static final String ATTR_MINVALUE = "minvalue";
    public static final String ATTR_MAXVALUE = "maxvalue";
    public static final String ATTR_POSITION = "position";
    public static final String ATTR_SOURCE = "source";
    public static final String ATTR_SPACING = "spacing";
    public static final String ATTR_BASE = "base";
    public static final String ATTR_LABELLINES = "labellines";
    public static final String ATTR_SPHERE = "sphere";
    public static final String ATTR_ALIGNMENT = "alignment";
    public static final String ATTR_LABELFORMAT = "labelformat";
    public static final String ATTR_USE360 = "use360";
    public static final String ATTR_VALID = "valid";
    public static final String ATTR_VISIBLE = "visible";
    private static Hashtable<String, SampledSet> mapCache = new Hashtable();
    private Hashtable seenNodes = new Hashtable();
    private List<LatLonData> latLonData = new ArrayList<LatLonData>();
    private List<LatLonLabelData> latLonLabelData = new ArrayList<LatLonLabelData>();
    private List mapDataList = new ArrayList();
    private double mapPosition = Double.NaN;
    private static MapFamily mapFamily = new MapFamily("IDV maps");
    private boolean justLoadedLocalMaps = false;

    public MapInfo() {
    }

    public MapInfo(List mapDataList) {
        this(mapDataList, null, null, Float.NaN);
    }

    public MapInfo(List mapDataList, LatLonData latData, LatLonData lonData, float mapPosition) {
        this(mapDataList, latData, lonData, null, null, mapPosition);
    }

    public MapInfo(List mapDataList, LatLonData latData, LatLonData lonData, LatLonLabelData latLabelData, LatLonLabelData lonLabelData, float mapPosition) {
        this.mapDataList = mapDataList;
        if (latData != null) {
            this.latLonData.add(latData);
        }
        if (lonData != null) {
            this.latLonData.add(lonData);
        }
        if (latLabelData != null) {
            this.latLonLabelData.add(latLabelData);
        }
        if (lonLabelData != null) {
            this.latLonLabelData.add(lonLabelData);
        }
        this.mapPosition = mapPosition;
    }

    public MapInfo(Element root) {
        if (root != null) {
            this.processMapsNode(root, "");
        }
        if (Double.isNaN(this.mapPosition)) {
            this.mapPosition = -0.99;
        }
    }

    public MapInfo(XmlResourceCollection mapResources, boolean stopAfterFirst) {
        this(mapResources, stopAfterFirst, false);
    }

    public MapInfo(XmlResourceCollection mapResources, boolean stopAfterFirst, boolean stopAfterEditable) {
        try {
            for (int i = 0; i < mapResources.size(); ++i) {
                Element root = mapResources.getRoot(i);
                this.processMapsNode(root, mapResources.get(i).toString());
                if (!stopAfterEditable || !mapResources.isWritable(i)) {
                    if (!stopAfterFirst || i != 0 || root == null) continue;
                    this.justLoadedLocalMaps = true;
                }
                break;
            }
        }
        catch (Exception exc) {
            LogUtil.printException(log_, "Creating xml", exc);
            return;
        }
    }

    private void processMapsNode(Element root, String resourcePath) {
        if (root == null) {
            return;
        }
        try {
            String resourceDir = IOUtil.getFileRoot(resourcePath);
            List nodes = XmlUtil.findChildren(root, TAG_MAP);
            for (int i = 0; i < nodes.size(); ++i) {
                Element mapNode = (Element)nodes.get(i);
                if (!XmlUtil.getAttribute((Node)mapNode, ATTR_VALID, true)) continue;
                String source = XmlUtil.getAttribute(mapNode, ATTR_SOURCE);
                if (IOUtil.isRelativePath(source)) {
                    source = resourceDir + "/" + source;
                }
                if (this.seenNodes.get(source) != null) continue;
                this.mapDataList.add(new MapData(mapNode, source));
                this.seenNodes.put(source, mapNode);
            }
            Element latitudeNode = XmlUtil.findChild(root, TAG_LATITUDE);
            if (latitudeNode == null) {
                // empty if block
            }
            this.latLonData.add(this.createLatLonData(latitudeNode, true, -90.0f, 90.0f, 15.0f));
            Element longitudeNode = XmlUtil.findChild(root, TAG_LONGITUDE);
            if (longitudeNode == null) {
                // empty if block
            }
            this.latLonData.add(this.createLatLonData(longitudeNode, false, -180.0f, 180.0f, 15.0f));
            Element latitudeLabelNode = XmlUtil.findChild(root, TAG_LATITUDELABEL);
            if (latitudeLabelNode == null) {
                // empty if block
            }
            this.latLonLabelData.add(this.createLatLonLabelData(latitudeLabelNode, true, 15.0f));
            Element longitudeLabelNode = XmlUtil.findChild(root, TAG_LONGITUDELABEL);
            if (longitudeLabelNode == null) {
                // empty if block
            }
            this.latLonLabelData.add(this.createLatLonLabelData(longitudeLabelNode, false, 15.0f));
            if (Double.isNaN(this.mapPosition)) {
                this.mapPosition = XmlUtil.getAttribute((Node)root, ATTR_POSITION, Double.NaN);
            }
        }
        catch (Exception e) {
            LogUtil.printException(log_, "Couldn't create map state", e);
        }
    }

    public String getXml() {
        return this.getXml(true);
    }

    public String getXml(boolean useFullSourcePath) {
        Document document = XmlUtil.makeDocument();
        Element currentState = document.createElement(TAG_MAPS);
        if (this.mapPosition == this.mapPosition) {
            currentState.setAttribute(ATTR_POSITION, "" + this.mapPosition);
        }
        try {
            Element newElement;
            for (int i = 0; i < this.latLonData.size(); ++i) {
                LatLonData lld = this.latLonData.get(i);
                newElement = document.createElement(lld.getIsLatitude() ? TAG_LATITUDE : TAG_LONGITUDE);
                currentState.appendChild(newElement);
                XmlUtil.setAttributes(newElement, new String[]{ATTR_SPACING, "" + lld.getSpacing(), ATTR_BASE, "" + lld.getBase(), ATTR_COLOR, "" + lld.getColor().getRGB(), ATTR_LINESTYLE, "" + lld.getLineStyle(), ATTR_LINEWIDTH, "" + lld.getLineWidth(), ATTR_VISIBLE, "" + lld.getVisible(), ATTR_FASTRENDER, "" + lld.getFastRendering()});
            }
            for (LatLonLabelData llld : this.latLonLabelData) {
                newElement = document.createElement(llld.getIsLatitude() ? TAG_LATITUDELABEL : TAG_LONGITUDELABEL);
                currentState.appendChild(newElement);
                XmlUtil.setAttributes(newElement, new String[]{ATTR_SPACING, "" + llld.getInterval(), ATTR_BASE, "" + llld.getBaseValue(), ATTR_LABELLINES, "" + LatLonLabelData.formatLabelLines(llld.getLabelLines()), ATTR_COLOR, "" + llld.getColor().getRGB(), ATTR_VISIBLE, "" + llld.getVisible(), ATTR_SPHERE, "" + llld.getSphere(), ATTR_ALIGNMENT, "" + llld.getAlignment(), ATTR_LABELFORMAT, "" + llld.getLabelFormat(), ATTR_USE360, "" + llld.getUse360()});
            }
            for (int i = 0; i < this.mapDataList.size(); ++i) {
                MapData mapData = (MapData)this.mapDataList.get(i);
                newElement = document.createElement(TAG_MAP);
                currentState.appendChild(newElement);
                String source = mapData.getSource();
                if (!useFullSourcePath) {
                    source = "/" + IOUtil.getFileTail(source);
                }
                XmlUtil.setAttributes(newElement, new String[]{ATTR_SOURCE, source, ATTR_CATEGORY, mapData.getCategory(), ATTR_COLOR, "" + mapData.getColor().getRGB(), ATTR_LINEWIDTH, "" + mapData.getLineWidth(), ATTR_LINESTYLE, "" + mapData.getLineStyle(), ATTR_VISIBLE, "" + mapData.getVisible(), ATTR_DESCRIPTION, "" + mapData.getDescription(), ATTR_FASTRENDER, "" + mapData.getFastRendering()});
            }
        }
        catch (Exception e) {
            LogUtil.printException(log_, "Couldn't create map state", e);
        }
        return XmlUtil.toStringWithHeader(currentState);
    }

    public double getMapPosition() {
        return this.mapPosition;
    }

    public void setMapPosition(double position) {
        this.mapPosition = position;
    }

    public static SampledSet createMapData(String source) {
        SampledSet mapSet = mapCache.get(source);
        if (mapSet != null) {
            return (SampledSet)mapSet.clone();
        }
        Trace.call1("create map", source);
        try {
            URL url = IOUtil.getURL(source, MapInfo.class);
            mapSet = url == null ? (SampledSet)mapFamily.open(source) : (SampledSet)mapFamily.open(url);
        }
        catch (Exception exc) {
            LogUtil.logException("Could not create map from url: " + source, exc);
            return null;
        }
        if (mapSet == null) {
            LogUtil.userMessage("Could not create map: " + source);
        } else {
            mapCache.put(source, mapSet);
        }
        Trace.call2("create map");
        return (SampledSet)mapSet.clone();
    }

    private LatLonData createLatLonData(Element node, boolean latitude, float min, float max, float spacing) throws VisADException, RemoteException {
        LatLonData lld;
        LatLonData latLonData = lld = node != null ? new LatLonData(latitude, XmlUtil.getAttribute((Node)node, ATTR_COLOR, Color.gray), XmlUtil.getAttribute((Node)node, ATTR_SPACING, spacing), XmlUtil.getAttribute((Node)node, ATTR_BASE, 0.0f), XmlUtil.getAttribute((Node)node, ATTR_LINEWIDTH, 1.0f), XmlUtil.getAttribute((Node)node, ATTR_LINESTYLE, 1), XmlUtil.getAttribute((Node)node, ATTR_FASTRENDER, false)) : new LatLonData(latitude, Color.gray, spacing, 0.0f, 1.0f, 1, false);
        if (node != null) {
            lld.setVisible(XmlUtil.getAttribute((Node)node, ATTR_VISIBLE, false));
        } else {
            lld.setVisible(false);
        }
        lld.setMinValue(min);
        lld.setMaxValue(max);
        return lld;
    }

    private LatLonLabelData createLatLonLabelData(Element node, boolean latitude, float spacing) throws VisADException, RemoteException {
        LatLonLabelData llld;
        LatLonLabelData latLonLabelData = llld = node != null ? new LatLonLabelData(latitude, XmlUtil.getAttribute((Node)node, ATTR_SPACING, spacing)) : new LatLonLabelData(latitude, spacing);
        if (node != null) {
            llld.setBaseValue(XmlUtil.getAttribute((Node)node, ATTR_BASE, 0.0f));
            llld.setColor(XmlUtil.getAttribute((Node)node, ATTR_COLOR, Color.white));
            llld.setVisible(XmlUtil.getAttribute((Node)node, ATTR_VISIBLE, false));
            llld.setLabelsLineString(XmlUtil.getAttribute((Node)node, ATTR_LABELLINES, "0"));
            llld.setAlignment(XmlUtil.getAttribute((Node)node, ATTR_ALIGNMENT, "MM"));
            llld.setLabelFormat(XmlUtil.getAttribute((Node)node, ATTR_LABELFORMAT, "DD"));
            llld.setSphere(XmlUtil.getAttribute((Node)node, ATTR_SPHERE, false));
            llld.setUse360(XmlUtil.getAttribute((Node)node, ATTR_USE360, false));
        } else {
            llld.setBaseValue(0.0f);
            llld.setColor(Color.white);
            llld.setVisible(false);
            llld.setLabelsLineString("0");
            llld.setAlignment("MM");
            llld.setLabelFormat("DD");
            llld.setSphere(false);
        }
        return llld;
    }

    public void setLatLonData(List value) {
        this.latLonData = value;
    }

    public List getLatLonData() {
        return this.latLonData;
    }

    public void setLatLonLabelData(List<LatLonLabelData> value) {
        this.latLonLabelData = value;
    }

    public List<LatLonLabelData> getLatLonLabelData() {
        return this.latLonLabelData;
    }

    public void setMapDataList(List value) {
        this.mapDataList = value;
    }

    public List<MapData> getMapDataList() {
        return this.mapDataList;
    }

    public LatLonData getLatData() {
        for (int i = 0; i < this.latLonData.size(); ++i) {
            LatLonData lld = this.latLonData.get(i);
            if (!lld.getIsLatitude()) continue;
            return lld;
        }
        return null;
    }

    public LatLonData getLonData() {
        for (int i = 0; i < this.latLonData.size(); ++i) {
            LatLonData lld = this.latLonData.get(i);
            if (lld.getIsLatitude()) continue;
            return lld;
        }
        return null;
    }

    public LatLonLabelData getLatLabelData() {
        for (int i = 0; i < this.latLonLabelData.size(); ++i) {
            LatLonLabelData lld = this.latLonLabelData.get(i);
            if (!lld.getIsLatitude()) continue;
            return lld;
        }
        return null;
    }

    public LatLonLabelData getLonLabelData() {
        for (int i = 0; i < this.latLonLabelData.size(); ++i) {
            LatLonLabelData lld = this.latLonLabelData.get(i);
            if (lld.getIsLatitude()) continue;
            return lld;
        }
        return null;
    }

    public boolean getJustLoadedLocalMaps() {
        return this.justLoadedLocalMaps;
    }

    public void setJustLoadedLocalMaps(boolean v) {
        this.justLoadedLocalMaps = v;
    }
}

