/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.gis.maps;

import java.awt.Color;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.display.MapLines;

public class MapData {
    public static final String ATTR_COLOR = "color";
    public static final String ATTR_LINEWIDTH = "linewidth";
    public static final String ATTR_LINESTYLE = "linestyle";
    public static final String ATTR_FASTRENDERING = "fastrendering";
    public static final String ATTR_VISIBLE = "visible";
    protected String source;
    protected String category = "Maps";
    protected String description;
    protected Color mapColor;
    protected boolean visible;
    protected float lineWidth = 1.0f;
    protected int lineStyle = 0;
    protected float spacing = 0.0f;
    protected MapLines myMap;
    protected boolean fastRendering = false;

    public MapData() {
    }

    public MapData(Element mapNode, String source) {
        this.source = source;
        this.category = XmlUtil.getAttribute((Node)mapNode, "category", "Maps");
        this.description = XmlUtil.getAttribute((Node)mapNode, "description", source);
        this.mapColor = XmlUtil.getAttribute((Node)mapNode, ATTR_COLOR, Color.white);
        this.visible = XmlUtil.getAttribute((Node)mapNode, ATTR_VISIBLE, true);
        this.lineWidth = XmlUtil.getAttribute((Node)mapNode, ATTR_LINEWIDTH, 1.0f);
        this.lineStyle = XmlUtil.getAttribute((Node)mapNode, ATTR_LINESTYLE, 0);
        this.fastRendering = XmlUtil.getAttribute((Node)mapNode, "fastrender", false);
    }

    public MapData(MapData that) {
        this.source = that.source;
        this.description = that.description;
        this.mapColor = that.mapColor;
        this.visible = that.visible;
        this.lineWidth = that.lineWidth;
        this.lineStyle = that.lineStyle;
        this.spacing = that.spacing;
        this.fastRendering = that.fastRendering;
    }

    public MapData(String mapPath, String description, Color mapColor, float lineWidth, int lineStyle) {
        this(mapPath, null);
        this.description = description;
        this.mapColor = mapColor;
        this.lineWidth = lineWidth;
        this.lineStyle = lineStyle;
        this.visible = true;
    }

    public MapData(String source, MapLines map) {
        this.source = source;
        this.myMap = map;
        if (map != null) {
            this.description = map.getName();
            this.visible = map.getVisible();
            this.mapColor = map.getColor();
            this.lineWidth = map.getLineWidth();
            this.lineStyle = map.getLineStyle();
            this.fastRendering = map.getUseFastRendering();
        }
    }

    protected void stateChanged() {
    }

    public MapLines getMap() {
        return this.myMap;
    }

    public Color getColor() {
        return this.mapColor;
    }

    public void setColor(Color v) {
        this.mapColor = v;
        this.stateChanged();
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean v) {
        this.visible = v;
        this.stateChanged();
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String v) {
        this.source = v;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String v) {
        this.description = v;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float v) {
        this.lineWidth = v;
        this.stateChanged();
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(int v) {
        this.lineStyle = v;
        this.stateChanged();
    }

    public float getSpacing() {
        return this.spacing;
    }

    public void setSpacing(float v) {
        this.spacing = v;
        this.stateChanged();
    }

    public int hashCode() {
        return this.source.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof MapData)) {
            return false;
        }
        return this.source.equals(((MapData)o).source);
    }

    public String toString() {
        return this.source + " " + this.visible;
    }

    public void setFastRendering(boolean value) {
        this.fastRendering = value;
        this.stateChanged();
    }

    public boolean getFastRendering() {
        return this.fastRendering;
    }

    public void setCategory(String value) {
        this.category = value;
    }

    public String getCategory() {
        return this.category;
    }
}

