/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.gis.maps;

import java.awt.Color;
import java.awt.Font;
import java.rmi.RemoteException;
import ucar.unidata.util.Misc;
import ucar.visad.display.LatLonLabels;
import visad.TextControl;
import visad.TextType;
import visad.VisADException;

public class LatLonLabelData {
    protected LatLonLabels myLatLonLabels;
    private boolean visible = true;
    private Color color = Color.white;
    private String alignment = "MM";
    private Object labelFont;
    private boolean isLatitude = true;
    private float interval;
    private float minValue;
    private float maxValue;
    private float baseValue;
    private float[] labelLines;
    protected boolean fastRendering = false;
    private boolean useSphere;
    private String labelFormat = "DD";
    private boolean use360 = false;

    public LatLonLabelData() {
    }

    public LatLonLabelData(boolean isLatitude, float interval) {
        this(isLatitude, interval, isLatitude ? -90 : -180, isLatitude ? 90 : 180, 0.0f, new float[]{0.0f}, "MM", null, Color.white, true);
    }

    public LatLonLabelData(boolean isLatitude, float interval, float min, float max, float base) {
        this(isLatitude, interval, min, max, base, new float[]{0.0f}, "MM", null, Color.white, true);
    }

    public LatLonLabelData(boolean isLatitude, float interval, float minValue, float maxValue, float baseValue, float[] labelLines, String alignment, Object labelFont, Color color, boolean fastRendering) {
        this.isLatitude = isLatitude;
        this.interval = interval;
        this.maxValue = maxValue;
        this.minValue = minValue;
        this.labelLines = labelLines;
        this.alignment = alignment;
        this.labelFont = labelFont;
        this.color = color;
        this.fastRendering = fastRendering;
    }

    protected LatLonLabelData(LatLonLabelData that) {
        this.initWith(that);
    }

    public void initWith(LatLonLabelData that) {
        if (that == null) {
            return;
        }
        this.isLatitude = that.isLatitude;
        this.interval = that.interval;
        this.baseValue = that.baseValue;
        this.maxValue = that.maxValue;
        this.minValue = that.minValue;
        this.labelLines = that.labelLines;
        this.alignment = that.alignment;
        this.labelFont = that.labelFont;
        this.color = that.color;
        this.fastRendering = that.fastRendering;
        this.visible = that.visible;
        this.useSphere = that.useSphere;
        this.labelFormat = that.labelFormat;
        this.use360 = that.use360;
    }

    protected void stateChanged() {
    }

    public LatLonLabels getLatLonLabels() throws VisADException, RemoteException {
        if (this.myLatLonLabels == null) {
            this.myLatLonLabels = new LatLonLabels("LatLonLabels", TextType.getTextType(this.isLatitude ? "LatLabels" : "LonLabels"), this.isLatitude, this.interval, this.minValue, this.maxValue, this.baseValue, this.labelLines);
        }
        if (this.color != null) {
            this.myLatLonLabels.setColor(this.color);
        }
        this.myLatLonLabels.setVisible(this.getRealVisibility());
        this.myLatLonLabels.setInterval(this.interval);
        this.myLatLonLabels.setMin(this.minValue);
        this.myLatLonLabels.setMax(this.maxValue);
        this.myLatLonLabels.setBase(this.baseValue);
        this.myLatLonLabels.setLabelLines(this.labelLines);
        this.setFont(this.myLatLonLabels, this.labelFont);
        this.setAlignment(this.myLatLonLabels, this.alignment);
        this.myLatLonLabels.setUseFastRendering(this.fastRendering);
        this.myLatLonLabels.setSphere(this.useSphere);
        this.myLatLonLabels.setLabelFormat(this.labelFormat);
        this.myLatLonLabels.setUse360(this.use360);
        return this.myLatLonLabels;
    }

    private void setFont(LatLonLabels lll, Object labelFont) throws VisADException, RemoteException {
        int size;
        Font f = (Font)labelFont;
        int n = size = f == null ? 12 : f.getSize();
        if (f != null && f.getName().equals("Default")) {
            f = null;
        }
        lll.setFont(f);
        lll.setTextSize((float)size / 12.0f);
    }

    private void setAlignment(LatLonLabels lll, String rectpoint) throws VisADException, RemoteException {
        if (rectpoint.equals("UL")) {
            lll.setJustification(TextControl.Justification.RIGHT);
            lll.setVerticalJustification(TextControl.Justification.BOTTOM);
        } else if (rectpoint.equals("UM")) {
            lll.setJustification(TextControl.Justification.CENTER);
            lll.setVerticalJustification(TextControl.Justification.BOTTOM);
        } else if (rectpoint.equals("UR")) {
            lll.setJustification(TextControl.Justification.LEFT);
            lll.setVerticalJustification(TextControl.Justification.BOTTOM);
        } else if (rectpoint.equals("ML")) {
            lll.setJustification(TextControl.Justification.RIGHT);
            lll.setVerticalJustification(TextControl.Justification.CENTER);
        } else if (rectpoint.equals("MM")) {
            lll.setJustification(TextControl.Justification.CENTER);
            lll.setVerticalJustification(TextControl.Justification.CENTER);
        } else if (rectpoint.equals("MR")) {
            lll.setJustification(TextControl.Justification.LEFT);
            lll.setVerticalJustification(TextControl.Justification.CENTER);
        } else if (rectpoint.equals("LL")) {
            lll.setJustification(TextControl.Justification.RIGHT);
            lll.setVerticalJustification(TextControl.Justification.TOP);
        } else if (rectpoint.equals("LM")) {
            lll.setJustification(TextControl.Justification.CENTER);
            lll.setVerticalJustification(TextControl.Justification.TOP);
        } else if (rectpoint.equals("LR")) {
            lll.setJustification(TextControl.Justification.LEFT);
            lll.setVerticalJustification(TextControl.Justification.TOP);
        }
    }

    protected boolean getRealVisibility() {
        return this.visible;
    }

    public void setColor(Color value) {
        this.color = value;
        this.stateChanged();
    }

    public Color getColor() {
        return this.color;
    }

    public void setInterval(float value) {
        this.interval = value;
        this.stateChanged();
    }

    public float getInterval() {
        return this.interval;
    }

    public void setBaseValue(float value) {
        this.baseValue = value;
        this.stateChanged();
    }

    public float getBaseValue() {
        return this.baseValue;
    }

    public void setIsLatitude(boolean value) {
        this.isLatitude = value;
    }

    public boolean getIsLatitude() {
        return this.isLatitude;
    }

    public void setMinValue(float value) {
        this.minValue = value;
        this.stateChanged();
    }

    public float getMinValue() {
        return this.minValue;
    }

    public void setMaxValue(float value) {
        this.maxValue = value;
        this.stateChanged();
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public void setLabelLines(float[] value) {
        this.labelLines = value;
        this.stateChanged();
    }

    public void setLabelsLineString(String value) {
        this.labelLines = LatLonLabelData.parseLabelLineString(value);
        this.stateChanged();
    }

    public static float[] parseLabelLineString(String llString) {
        if (llString.indexOf(";") > 0) {
            return Misc.parseFloats(llString, ";");
        }
        return Misc.parseFloats(llString, ",");
    }

    public static String formatLabelLines(float[] vals) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < vals.length; ++i) {
            buf.append(vals[i]);
            if (i >= vals.length - 1) continue;
            buf.append(";");
        }
        return buf.toString();
    }

    public float[] getLabelLines() {
        return this.labelLines;
    }

    public void setVisible(boolean value) {
        this.visible = value;
        this.stateChanged();
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setFastRendering(boolean value) {
        this.fastRendering = value;
        this.stateChanged();
    }

    public boolean getFastRendering() {
        return this.fastRendering;
    }

    public void setFont(Object value) {
        this.labelFont = value;
        this.stateChanged();
    }

    public Object getFont() {
        return this.labelFont;
    }

    public void setAlignment(String value) {
        this.alignment = value;
        this.stateChanged();
    }

    public String getAlignment() {
        return this.alignment;
    }

    public void setSphere(boolean sphere) {
        this.useSphere = sphere;
        this.stateChanged();
    }

    public boolean getSphere() {
        return this.useSphere;
    }

    public void setLabelFormat(String format) {
        this.labelFormat = format;
        this.stateChanged();
    }

    public String getLabelFormat() {
        return this.labelFormat;
    }

    public void setUse360(boolean value) {
        this.use360 = value;
        this.stateChanged();
    }

    public boolean getUse360() {
        return this.use360;
    }
}

