/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.gis.maps;

import java.awt.Color;
import java.rmi.RemoteException;
import ucar.visad.display.LatLonLines;
import visad.RealType;
import visad.VisADException;

public class LatLonData {
    protected LatLonLines myLatLon;
    private boolean visible = true;
    private Color color = Color.gray;
    private float spacing;
    private float base;
    private float lineWidth;
    private int lineStyle;
    private boolean isLatitude = true;
    private float minValue;
    private float maxValue;
    protected boolean fastRendering = false;

    public LatLonData() {
    }

    public LatLonData(boolean isLatitude, Color color, float defaultSpacing, float lineWidth, int lineStyle) {
        this(isLatitude, color, defaultSpacing, lineWidth, lineStyle, false);
    }

    public LatLonData(boolean isLatitude, Color color, float defaultSpacing, float lineWidth, int lineStyle, boolean fastRendering) {
        this(isLatitude, color, defaultSpacing, 0.0f, lineWidth, lineStyle, fastRendering);
    }

    public LatLonData(boolean isLatitude, Color color, float defaultSpacing, float base, float lineWidth, int lineStyle, boolean fastRendering) {
        this.isLatitude = isLatitude;
        this.color = color;
        this.spacing = defaultSpacing;
        this.base = base;
        this.lineWidth = lineWidth;
        this.lineStyle = lineStyle;
        this.fastRendering = fastRendering;
    }

    protected LatLonData(LatLonData that) {
        this.initWith(that);
    }

    public void initWith(LatLonData that) {
        if (that == null) {
            return;
        }
        this.isLatitude = that.isLatitude;
        this.color = that.color;
        this.spacing = that.spacing;
        this.base = that.base;
        this.lineWidth = that.lineWidth;
        this.lineStyle = that.lineStyle;
        this.maxValue = that.maxValue;
        this.minValue = that.minValue;
        this.visible = that.visible;
        this.fastRendering = that.fastRendering;
    }

    protected void stateChanged() {
    }

    public LatLonLines getLatLonLines() throws VisADException, RemoteException {
        if (this.myLatLon == null) {
            this.myLatLon = new LatLonLines(this.isLatitude ? RealType.Latitude : RealType.Longitude, this.minValue, this.maxValue, this.spacing, this.base, this.getRealVisibility());
        }
        if (this.color != null) {
            this.myLatLon.setColor(this.color);
        }
        this.myLatLon.setVisible(this.getRealVisibility());
        this.myLatLon.setSpacing(this.spacing);
        this.myLatLon.setBase(this.base);
        this.myLatLon.setLineStyle(this.lineStyle);
        this.myLatLon.setLineWidth(this.lineWidth);
        this.myLatLon.setUseFastRendering(this.fastRendering);
        return this.myLatLon;
    }

    protected boolean getRealVisibility() {
        return this.visible;
    }

    public void setColor(Color value) {
        this.color = value;
        this.stateChanged();
    }

    public Color getColor() {
        return this.color;
    }

    public void setSpacing(float value) {
        this.spacing = value;
        this.stateChanged();
    }

    public float getSpacing() {
        return this.spacing;
    }

    public void setBase(float value) {
        this.base = value;
        this.stateChanged();
    }

    public float getBase() {
        return this.base;
    }

    public void setLineWidth(float value) {
        this.lineWidth = value;
        this.stateChanged();
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineStyle(int value) {
        this.lineStyle = value;
        this.stateChanged();
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public void setIsLatitude(boolean value) {
        this.isLatitude = value;
    }

    public boolean getIsLatitude() {
        return this.isLatitude;
    }

    public void setMinValue(float value) {
        this.minValue = value;
    }

    public float getMinValue() {
        return this.minValue;
    }

    public void setMaxValue(float value) {
        this.maxValue = value;
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public void setVisible(boolean value) {
        this.visible = value;
        this.stateChanged();
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setFastRendering(boolean value) {
        this.fastRendering = value;
        this.stateChanged();
    }

    public boolean getFastRendering() {
        return this.fastRendering;
    }
}

