/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.gis.geotiff;

public class GeneratedKeys {

    public static class ModelType {
        public static final int Projected = 1;
        public static final int Geographic = 2;
        public static final int Geocentric = 3;
        public static final int Undefined = 0;
        public static final int UserDefined = Short.MAX_VALUE;
        public static final int[] values = new int[]{1, 2, 3, 0, Short.MAX_VALUE};
        public static final String[] names = new String[]{"Projected", "Geographic", "Geocentric", "Undefined", "UserDefined"};

        public static String getName(int value) {
            for (int i = 0; i < values.length; ++i) {
                if (values[i] != value) continue;
                return names[i];
            }
            return null;
        }
    }

    public static class Geokey {
        public static final int GTModelTypeGeoKey = 1024;
        public static final int GTRasterTypeGeoKey = 1025;
        public static final int GTCitationGeoKey = 1026;
        public static final int GeographicTypeGeoKey = 2048;
        public static final int GeogCitationGeoKey = 2049;
        public static final int GeogGeodeticDatumGeoKey = 2050;
        public static final int GeogPrimeMeridianGeoKey = 2051;
        public static final int GeogLinearUnitsGeoKey = 2052;
        public static final int GeogLinearUnitSizeGeoKey = 2053;
        public static final int GeogAngularUnitsGeoKey = 2054;
        public static final int GeogAngularUnitSizeGeoKey = 2055;
        public static final int GeogEllipsoidGeoKey = 2056;
        public static final int GeogSemiMajorAxisGeoKey = 2057;
        public static final int GeogSemiMinorAxisGeoKey = 2058;
        public static final int GeogInvFlatteningGeoKey = 2059;
        public static final int GeogAzimuthUnitsGeoKey = 2060;
        public static final int GeogPrimeMeridianLongGeoKey = 2061;
        public static final int ProjectedCSTypeGeoKey = 3072;
        public static final int PCSCitationGeoKey = 3073;
        public static final int ProjectionGeoKey = 3074;
        public static final int ProjCoordTransGeoKey = 3075;
        public static final int ProjLinearUnitsGeoKey = 3076;
        public static final int ProjLinearUnitSizeGeoKey = 3077;
        public static final int ProjStdParallel1GeoKey = 3078;
        public static final int ProjStdParallelGeoKey = 3078;
        public static final int ProjStdParallel2GeoKey = 3079;
        public static final int ProjNatOriginLongGeoKey = 3080;
        public static final int ProjOriginLongGeoKey = 3080;
        public static final int ProjNatOriginLatGeoKey = 3081;
        public static final int ProjOriginLatGeoKey = 3081;
        public static final int ProjFalseEastingGeoKey = 3082;
        public static final int ProjFalseNorthingGeoKey = 3083;
        public static final int ProjFalseOriginLongGeoKey = 3084;
        public static final int ProjFalseOriginLatGeoKey = 3085;
        public static final int ProjFalseOriginEastingGeoKey = 3086;
        public static final int ProjFalseOriginNorthingGeoKey = 3087;
        public static final int ProjCenterLongGeoKey = 3088;
        public static final int ProjCenterLatGeoKey = 3089;
        public static final int ProjCenterEastingGeoKey = 3090;
        public static final int ProjCenterNorthingGeoKey = 3091;
        public static final int ProjScaleAtNatOriginGeoKey = 3092;
        public static final int ProjScaleAtOriginGeoKey = 3092;
        public static final int ProjScaleAtCenterGeoKey = 3093;
        public static final int ProjAzimuthAngleGeoKey = 3094;
        public static final int ProjStraightVertPoleLongGeoKey = 3095;
        public static final int VerticalCSTypeGeoKey = 4096;
        public static final int VerticalCitationGeoKey = 4097;
        public static final int VerticalDatumGeoKey = 4098;
        public static final int VerticalUnitsGeoKey = 4099;
        public static final int[] values = new int[]{1024, 1025, 1026, 2048, 2049, 2050, 2051, 2052, 2053, 2054, 2055, 2056, 2057, 2058, 2059, 2060, 2061, 3072, 3073, 3074, 3075, 3076, 3077, 3078, 3078, 3079, 3080, 3080, 3081, 3081, 3082, 3083, 3084, 3085, 3086, 3087, 3088, 3089, 3090, 3091, 3092, 3092, 3093, 3094, 3095, 4096, 4097, 4098, 4099};
        public static final String[] names = new String[]{"GTModelTypeGeoKey", "GTRasterTypeGeoKey", "GTCitationGeoKey", "GeographicTypeGeoKey", "GeogCitationGeoKey", "GeogGeodeticDatumGeoKey", "GeogPrimeMeridianGeoKey", "GeogLinearUnitsGeoKey", "GeogLinearUnitSizeGeoKey", "GeogAngularUnitsGeoKey", "GeogAngularUnitSizeGeoKey", "GeogEllipsoidGeoKey", "GeogSemiMajorAxisGeoKey", "GeogSemiMinorAxisGeoKey", "GeogInvFlatteningGeoKey", "GeogAzimuthUnitsGeoKey", "GeogPrimeMeridianLongGeoKey", "ProjectedCSTypeGeoKey", "PCSCitationGeoKey", "ProjectionGeoKey", "ProjCoordTransGeoKey", "ProjLinearUnitsGeoKey", "ProjLinearUnitSizeGeoKey", "ProjStdParallel1GeoKey", "ProjStdParallelGeoKey", "ProjStdParallel2GeoKey", "ProjNatOriginLongGeoKey", "ProjOriginLongGeoKey", "ProjNatOriginLatGeoKey", "ProjOriginLatGeoKey", "ProjFalseEastingGeoKey", "ProjFalseNorthingGeoKey", "ProjFalseOriginLongGeoKey", "ProjFalseOriginLatGeoKey", "ProjFalseOriginEastingGeoKey", "ProjFalseOriginNorthingGeoKey", "ProjCenterLongGeoKey", "ProjCenterLatGeoKey", "ProjCenterEastingGeoKey", "ProjCenterNorthingGeoKey", "ProjScaleAtNatOriginGeoKey", "ProjScaleAtOriginGeoKey", "ProjScaleAtCenterGeoKey", "ProjAzimuthAngleGeoKey", "ProjStraightVertPoleLongGeoKey", "VerticalCSTypeGeoKey", "VerticalCitationGeoKey", "VerticalDatumGeoKey", "VerticalUnitsGeoKey"};

        public static String getName(int value) {
            for (int i = 0; i < values.length; ++i) {
                if (values[i] != value) continue;
                return names[i];
            }
            return null;
        }
    }

    public static class GeoCtrans {
        public static final int TransverseMercator = 1;
        public static final int TransvMercator_Modified_Alaska = 2;
        public static final int ObliqueMercator = 3;
        public static final int ObliqueMercator_Laborde = 4;
        public static final int ObliqueMercator_Rosenmund = 5;
        public static final int ObliqueMercator_Spherical = 6;
        public static final int Mercator = 7;
        public static final int LambertConfConic_2SP = 8;
        public static final int LambertConfConic = 8;
        public static final int LambertConfConic_1SP = 9;
        public static final int LambertConfConic_Helmert = 9;
        public static final int LambertAzimEqualArea = 10;
        public static final int AlbersEqualArea = 11;
        public static final int AzimuthalEquidistant = 12;
        public static final int EquidistantConic = 13;
        public static final int Stereographic = 14;
        public static final int PolarStereographic = 15;
        public static final int ObliqueStereographic = 16;
        public static final int Equirectangular = 17;
        public static final int CassiniSoldner = 18;
        public static final int Gnomonic = 19;
        public static final int MillerCylindrical = 20;
        public static final int Orthographic = 21;
        public static final int Polyconic = 22;
        public static final int Robinson = 23;
        public static final int Sinusoidal = 24;
        public static final int VanDerGrinten = 25;
        public static final int NewZealandMapGrid = 26;
        public static final int TransvMercator_SouthOriented = 27;
        public static final int SouthOrientedGaussConformal = 27;
        public static final int AlaskaConformal = 2;
        public static final int TransvEquidistCylindrical = 18;
        public static final int ObliqueMercator_Hotine = 3;
        public static final int SwissObliqueCylindrical = 5;
        public static final int GaussBoaga = 1;
        public static final int GaussKruger = 1;
        public static final int[] values = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 8, 9, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 27, 2, 18, 3, 5, 1, 1};
        public static final String[] names = new String[]{"CT_TransverseMercator", "CT_TransvMercator_Modified_Alaska", "CT_ObliqueMercator", "CT_ObliqueMercator_Laborde", "CT_ObliqueMercator_Rosenmund", "CT_ObliqueMercator_Spherical", "CT_Mercator", "CT_LambertConfConic_2SP", "CT_LambertConfConic", "CT_LambertConfConic_1SP", "CT_LambertConfConic_Helmert", "CT_LambertAzimEqualArea", "CT_AlbersEqualArea", "CT_AzimuthalEquidistant", "CT_EquidistantConic", "CT_Stereographic", "CT_PolarStereographic", "CT_ObliqueStereographic", "CT_Equirectangular", "CT_CassiniSoldner", "CT_Gnomonic", "CT_MillerCylindrical", "CT_Orthographic", "CT_Polyconic", "CT_Robinson", "CT_Sinusoidal", "CT_VanDerGrinten", "CT_NewZealandMapGrid", "CT_TransvMercator_SouthOriented", "CT_SouthOrientedGaussConformal", "CT_AlaskaConformal", "CT_TransvEquidistCylindrical", "CT_ObliqueMercator_Hotine", "CT_SwissObliqueCylindrical", "CT_GaussBoaga", "CT_GaussKruger"};

        public static String getName(int value) {
            for (int i = 0; i < values.length; ++i) {
                if (values[i] != value) continue;
                return names[i];
            }
            return null;
        }
    }

    public static class EpsgVertcs {
        public static final int Airy_1830_ellipsoid = 5001;
        public static final int Airy_Modified_1849_ellipsoid = 5002;
        public static final int ANS_ellipsoid = 5003;
        public static final int Bessel_1841_ellipsoid = 5004;
        public static final int Bessel_Modified_ellipsoid = 5005;
        public static final int Bessel_Namibia_ellipsoid = 5006;
        public static final int Clarke_1858_ellipsoid = 5007;
        public static final int Clarke_1866_ellipsoid = 5008;
        public static final int Clarke_1880_Benoit_ellipsoid = 5010;
        public static final int Clarke_1880_IGN_ellipsoid = 5011;
        public static final int Clarke_1880_RGS_ellipsoid = 5012;
        public static final int Clarke_1880_Arc_ellipsoid = 5013;
        public static final int Clarke_1880_SGA_1922_ellipsoid = 5014;
        public static final int Everest_1830_1937_Adjustment_ellipsoid = 5015;
        public static final int Everest_1830_1967_Definition_ellipsoid = 5016;
        public static final int Everest_1830_1975_Definition_ellipsoid = 5017;
        public static final int Everest_1830_Modified_ellipsoid = 5018;
        public static final int GRS_1980_ellipsoid = 5019;
        public static final int Helmert_1906_ellipsoid = 5020;
        public static final int INS_ellipsoid = 5021;
        public static final int International_1924_ellipsoid = 5022;
        public static final int International_1967_ellipsoid = 5023;
        public static final int Krassowsky_1940_ellipsoid = 5024;
        public static final int NWL_9D_ellipsoid = 5025;
        public static final int NWL_10D_ellipsoid = 5026;
        public static final int Plessis_1817_ellipsoid = 5027;
        public static final int Struve_1860_ellipsoid = 5028;
        public static final int War_Office_ellipsoid = 5029;
        public static final int WGS_84_ellipsoid = 5030;
        public static final int GEM_10C_ellipsoid = 5031;
        public static final int OSU86F_ellipsoid = 5032;
        public static final int OSU91A_ellipsoid = 5033;
        public static final int Newlyn = 5101;
        public static final int North_American_Vertical_Datum_1929 = 5102;
        public static final int North_American_Vertical_Datum_1988 = 5103;
        public static final int Yellow_Sea_1956 = 5104;
        public static final int Baltic_Sea = 5105;
        public static final int Caspian_Sea = 5106;
        public static final int[] values = new int[]{5001, 5002, 5003, 5004, 5005, 5006, 5007, 5008, 5010, 5011, 5012, 5013, 5014, 5015, 5016, 5017, 5018, 5019, 5020, 5021, 5022, 5023, 5024, 5025, 5026, 5027, 5028, 5029, 5030, 5031, 5032, 5033, 5101, 5102, 5103, 5104, 5105, 5106};
        public static final String[] names = new String[]{"VertCS_Airy_1830_ellipsoid", "VertCS_Airy_Modified_1849_ellipsoid", "VertCS_ANS_ellipsoid", "VertCS_Bessel_1841_ellipsoid", "VertCS_Bessel_Modified_ellipsoid", "VertCS_Bessel_Namibia_ellipsoid", "VertCS_Clarke_1858_ellipsoid", "VertCS_Clarke_1866_ellipsoid", "VertCS_Clarke_1880_Benoit_ellipsoid", "VertCS_Clarke_1880_IGN_ellipsoid", "VertCS_Clarke_1880_RGS_ellipsoid", "VertCS_Clarke_1880_Arc_ellipsoid", "VertCS_Clarke_1880_SGA_1922_ellipsoid", "VertCS_Everest_1830_1937_Adjustment_ellipsoid", "VertCS_Everest_1830_1967_Definition_ellipsoid", "VertCS_Everest_1830_1975_Definition_ellipsoid", "VertCS_Everest_1830_Modified_ellipsoid", "VertCS_GRS_1980_ellipsoid", "VertCS_Helmert_1906_ellipsoid", "VertCS_INS_ellipsoid", "VertCS_International_1924_ellipsoid", "VertCS_International_1967_ellipsoid", "VertCS_Krassowsky_1940_ellipsoid", "VertCS_NWL_9D_ellipsoid", "VertCS_NWL_10D_ellipsoid", "VertCS_Plessis_1817_ellipsoid", "VertCS_Struve_1860_ellipsoid", "VertCS_War_Office_ellipsoid", "VertCS_WGS_84_ellipsoid", "VertCS_GEM_10C_ellipsoid", "VertCS_OSU86F_ellipsoid", "VertCS_OSU91A_ellipsoid", "VertCS_Newlyn", "VertCS_North_American_Vertical_Datum_1929", "VertCS_North_American_Vertical_Datum_1988", "VertCS_Yellow_Sea_1956", "VertCS_Baltic_Sea", "VertCS_Caspian_Sea"};

        public static String getName(int value) {
            for (int i = 0; i < values.length; ++i) {
                if (values[i] != value) continue;
                return names[i];
            }
            return null;
        }
    }

    public static class EpsgUnit {
        public static final int Meter = 9001;
        public static final int Foot = 9002;
        public static final int Foot_US_Survey = 9003;
        public static final int Foot_Modified_American = 9004;
        public static final int Foot_Clarke = 9005;
        public static final int Foot_Indian = 9006;
        public static final int Link = 9007;
        public static final int Link_Benoit = 9008;
        public static final int Link_Sears = 9009;
        public static final int Chain_Benoit = 9010;
        public static final int Chain_Sears = 9011;
        public static final int Yard_Sears = 9012;
        public static final int Yard_Indian = 9013;
        public static final int Fathom = 9014;
        public static final int Mile_International_Nautical = 9015;
        public static final int Radian = 9101;
        public static final int Degree = 9102;
        public static final int Arc_Minute = 9103;
        public static final int Arc_Second = 9104;
        public static final int Grad = 9105;
        public static final int Gon = 9106;
        public static final int DMS = 9107;
        public static final int DMS_Hemisphere = 9108;
        public static final int[] values = new int[]{9001, 9002, 9003, 9004, 9005, 9006, 9007, 9008, 9009, 9010, 9011, 9012, 9013, 9014, 9015, 9101, 9102, 9103, 9104, 9105, 9106, 9107, 9108};
        public static final String[] names = new String[]{"Linear_Meter", "Linear_Foot", "Linear_Foot_US_Survey", "Linear_Foot_Modified_American", "Linear_Foot_Clarke", "Linear_Foot_Indian", "Linear_Link", "Linear_Link_Benoit", "Linear_Link_Sears", "Linear_Chain_Benoit", "Linear_Chain_Sears", "Linear_Yard_Sears", "Linear_Yard_Indian", "Linear_Fathom", "Linear_Mile_International_Nautical", "Angular_Radian", "Angular_Degree", "Angular_Arc_Minute", "Angular_Arc_Second", "Angular_Grad", "Angular_Gon", "Angular_DMS", "Angular_DMS_Hemisphere"};

        public static String getName(int value) {
            for (int i = 0; i < values.length; ++i) {
                if (values[i] != value) continue;
                return names[i];
            }
            return null;
        }
    }

    public static class EpsgProj {
        public static final int Alabama_CS27_East = 10101;
        public static final int Alabama_CS27_West = 10102;
        public static final int Alabama_CS83_East = 10131;
        public static final int Alabama_CS83_West = 10132;
        public static final int Arizona_Coordinate_System_east = 10201;
        public static final int Arizona_Coordinate_System_Central = 10202;
        public static final int Arizona_Coordinate_System_west = 10203;
        public static final int Arizona_CS83_east = 10231;
        public static final int Arizona_CS83_Central = 10232;
        public static final int Arizona_CS83_west = 10233;
        public static final int Arkansas_CS27_North = 10301;
        public static final int Arkansas_CS27_South = 10302;
        public static final int Arkansas_CS83_North = 10331;
        public static final int Arkansas_CS83_South = 10332;
        public static final int California_CS27_I = 10401;
        public static final int California_CS27_II = 10402;
        public static final int California_CS27_III = 10403;
        public static final int California_CS27_IV = 10404;
        public static final int California_CS27_V = 10405;
        public static final int California_CS27_VI = 10406;
        public static final int California_CS27_VII = 10407;
        public static final int California_CS83_1 = 10431;
        public static final int California_CS83_2 = 10432;
        public static final int California_CS83_3 = 10433;
        public static final int California_CS83_4 = 10434;
        public static final int California_CS83_5 = 10435;
        public static final int California_CS83_6 = 10436;
        public static final int Colorado_CS27_North = 10501;
        public static final int Colorado_CS27_Central = 10502;
        public static final int Colorado_CS27_South = 10503;
        public static final int Colorado_CS83_North = 10531;
        public static final int Colorado_CS83_Central = 10532;
        public static final int Colorado_CS83_South = 10533;
        public static final int Connecticut_CS27 = 10600;
        public static final int Connecticut_CS83 = 10630;
        public static final int Delaware_CS27 = 10700;
        public static final int Delaware_CS83 = 10730;
        public static final int Florida_CS27_East = 10901;
        public static final int Florida_CS27_West = 10902;
        public static final int Florida_CS27_North = 10903;
        public static final int Florida_CS83_East = 10931;
        public static final int Florida_CS83_West = 10932;
        public static final int Florida_CS83_North = 10933;
        public static final int Georgia_CS27_East = 11001;
        public static final int Georgia_CS27_West = 11002;
        public static final int Georgia_CS83_East = 11031;
        public static final int Georgia_CS83_West = 11032;
        public static final int Idaho_CS27_East = 11101;
        public static final int Idaho_CS27_Central = 11102;
        public static final int Idaho_CS27_West = 11103;
        public static final int Idaho_CS83_East = 11131;
        public static final int Idaho_CS83_Central = 11132;
        public static final int Idaho_CS83_West = 11133;
        public static final int Illinois_CS27_East = 11201;
        public static final int Illinois_CS27_West = 11202;
        public static final int Illinois_CS83_East = 11231;
        public static final int Illinois_CS83_West = 11232;
        public static final int Indiana_CS27_East = 11301;
        public static final int Indiana_CS27_West = 11302;
        public static final int Indiana_CS83_East = 11331;
        public static final int Indiana_CS83_West = 11332;
        public static final int Iowa_CS27_North = 11401;
        public static final int Iowa_CS27_South = 11402;
        public static final int Iowa_CS83_North = 11431;
        public static final int Iowa_CS83_South = 11432;
        public static final int Kansas_CS27_North = 11501;
        public static final int Kansas_CS27_South = 11502;
        public static final int Kansas_CS83_North = 11531;
        public static final int Kansas_CS83_South = 11532;
        public static final int Kentucky_CS27_North = 11601;
        public static final int Kentucky_CS27_South = 11602;
        public static final int Kentucky_CS83_North = 11631;
        public static final int Kentucky_CS83_South = 11632;
        public static final int Louisiana_CS27_North = 11701;
        public static final int Louisiana_CS27_South = 11702;
        public static final int Louisiana_CS83_North = 11731;
        public static final int Louisiana_CS83_South = 11732;
        public static final int Maine_CS27_East = 11801;
        public static final int Maine_CS27_West = 11802;
        public static final int Maine_CS83_East = 11831;
        public static final int Maine_CS83_West = 11832;
        public static final int Maryland_CS27 = 11900;
        public static final int Maryland_CS83 = 11930;
        public static final int Massachusetts_CS27_Mainland = 12001;
        public static final int Massachusetts_CS27_Island = 12002;
        public static final int Massachusetts_CS83_Mainland = 12031;
        public static final int Massachusetts_CS83_Island = 12032;
        public static final int Michigan_State_Plane_East = 12101;
        public static final int Michigan_State_Plane_Old_Central = 12102;
        public static final int Michigan_State_Plane_West = 12103;
        public static final int Michigan_CS27_North = 12111;
        public static final int Michigan_CS27_Central = 12112;
        public static final int Michigan_CS27_South = 12113;
        public static final int Michigan_CS83_North = 12141;
        public static final int Michigan_CS83_Central = 12142;
        public static final int Michigan_CS83_South = 12143;
        public static final int Minnesota_CS27_North = 12201;
        public static final int Minnesota_CS27_Central = 12202;
        public static final int Minnesota_CS27_South = 12203;
        public static final int Minnesota_CS83_North = 12231;
        public static final int Minnesota_CS83_Central = 12232;
        public static final int Minnesota_CS83_South = 12233;
        public static final int Mississippi_CS27_East = 12301;
        public static final int Mississippi_CS27_West = 12302;
        public static final int Mississippi_CS83_East = 12331;
        public static final int Mississippi_CS83_West = 12332;
        public static final int Missouri_CS27_East = 12401;
        public static final int Missouri_CS27_Central = 12402;
        public static final int Missouri_CS27_West = 12403;
        public static final int Missouri_CS83_East = 12431;
        public static final int Missouri_CS83_Central = 12432;
        public static final int Missouri_CS83_West = 12433;
        public static final int Montana_CS27_North = 12501;
        public static final int Montana_CS27_Central = 12502;
        public static final int Montana_CS27_South = 12503;
        public static final int Montana_CS83 = 12530;
        public static final int Nebraska_CS27_North = 12601;
        public static final int Nebraska_CS27_South = 12602;
        public static final int Nebraska_CS83 = 12630;
        public static final int Nevada_CS27_East = 12701;
        public static final int Nevada_CS27_Central = 12702;
        public static final int Nevada_CS27_West = 12703;
        public static final int Nevada_CS83_East = 12731;
        public static final int Nevada_CS83_Central = 12732;
        public static final int Nevada_CS83_West = 12733;
        public static final int New_Hampshire_CS27 = 12800;
        public static final int New_Hampshire_CS83 = 12830;
        public static final int New_Jersey_CS27 = 12900;
        public static final int New_Jersey_CS83 = 12930;
        public static final int New_Mexico_CS27_East = 13001;
        public static final int New_Mexico_CS27_Central = 13002;
        public static final int New_Mexico_CS27_West = 13003;
        public static final int New_Mexico_CS83_East = 13031;
        public static final int New_Mexico_CS83_Central = 13032;
        public static final int New_Mexico_CS83_West = 13033;
        public static final int New_York_CS27_East = 13101;
        public static final int New_York_CS27_Central = 13102;
        public static final int New_York_CS27_West = 13103;
        public static final int New_York_CS27_Long_Island = 13104;
        public static final int New_York_CS83_East = 13131;
        public static final int New_York_CS83_Central = 13132;
        public static final int New_York_CS83_West = 13133;
        public static final int New_York_CS83_Long_Island = 13134;
        public static final int North_Carolina_CS27 = 13200;
        public static final int North_Carolina_CS83 = 13230;
        public static final int North_Dakota_CS27_North = 13301;
        public static final int North_Dakota_CS27_South = 13302;
        public static final int North_Dakota_CS83_North = 13331;
        public static final int North_Dakota_CS83_South = 13332;
        public static final int Ohio_CS27_North = 13401;
        public static final int Ohio_CS27_South = 13402;
        public static final int Ohio_CS83_North = 13431;
        public static final int Ohio_CS83_South = 13432;
        public static final int Oklahoma_CS27_North = 13501;
        public static final int Oklahoma_CS27_South = 13502;
        public static final int Oklahoma_CS83_North = 13531;
        public static final int Oklahoma_CS83_South = 13532;
        public static final int Oregon_CS27_North = 13601;
        public static final int Oregon_CS27_South = 13602;
        public static final int Oregon_CS83_North = 13631;
        public static final int Oregon_CS83_South = 13632;
        public static final int Pennsylvania_CS27_North = 13701;
        public static final int Pennsylvania_CS27_South = 13702;
        public static final int Pennsylvania_CS83_North = 13731;
        public static final int Pennsylvania_CS83_South = 13732;
        public static final int Rhode_Island_CS27 = 13800;
        public static final int Rhode_Island_CS83 = 13830;
        public static final int South_Carolina_CS27_North = 13901;
        public static final int South_Carolina_CS27_South = 13902;
        public static final int South_Carolina_CS83 = 13930;
        public static final int South_Dakota_CS27_North = 14001;
        public static final int South_Dakota_CS27_South = 14002;
        public static final int South_Dakota_CS83_North = 14031;
        public static final int South_Dakota_CS83_South = 14032;
        public static final int Tennessee_CS27 = 14100;
        public static final int Tennessee_CS83 = 14130;
        public static final int Texas_CS27_North = 14201;
        public static final int Texas_CS27_North_Central = 14202;
        public static final int Texas_CS27_Central = 14203;
        public static final int Texas_CS27_South_Central = 14204;
        public static final int Texas_CS27_South = 14205;
        public static final int Texas_CS83_North = 14231;
        public static final int Texas_CS83_North_Central = 14232;
        public static final int Texas_CS83_Central = 14233;
        public static final int Texas_CS83_South_Central = 14234;
        public static final int Texas_CS83_South = 14235;
        public static final int Utah_CS27_North = 14301;
        public static final int Utah_CS27_Central = 14302;
        public static final int Utah_CS27_South = 14303;
        public static final int Utah_CS83_North = 14331;
        public static final int Utah_CS83_Central = 14332;
        public static final int Utah_CS83_South = 14333;
        public static final int Vermont_CS27 = 14400;
        public static final int Vermont_CS83 = 14430;
        public static final int Virginia_CS27_North = 14501;
        public static final int Virginia_CS27_South = 14502;
        public static final int Virginia_CS83_North = 14531;
        public static final int Virginia_CS83_South = 14532;
        public static final int Washington_CS27_North = 14601;
        public static final int Washington_CS27_South = 14602;
        public static final int Washington_CS83_North = 14631;
        public static final int Washington_CS83_South = 14632;
        public static final int West_Virginia_CS27_North = 14701;
        public static final int West_Virginia_CS27_South = 14702;
        public static final int West_Virginia_CS83_North = 14731;
        public static final int West_Virginia_CS83_South = 14732;
        public static final int Wisconsin_CS27_North = 14801;
        public static final int Wisconsin_CS27_Central = 14802;
        public static final int Wisconsin_CS27_South = 14803;
        public static final int Wisconsin_CS83_North = 14831;
        public static final int Wisconsin_CS83_Central = 14832;
        public static final int Wisconsin_CS83_South = 14833;
        public static final int Wyoming_CS27_East = 14901;
        public static final int Wyoming_CS27_East_Central = 14902;
        public static final int Wyoming_CS27_West_Central = 14903;
        public static final int Wyoming_CS27_West = 14904;
        public static final int Wyoming_CS83_East = 14931;
        public static final int Wyoming_CS83_East_Central = 14932;
        public static final int Wyoming_CS83_West_Central = 14933;
        public static final int Wyoming_CS83_West = 14934;
        public static final int Alaska_CS27_1 = 15001;
        public static final int Alaska_CS27_2 = 15002;
        public static final int Alaska_CS27_3 = 15003;
        public static final int Alaska_CS27_4 = 15004;
        public static final int Alaska_CS27_5 = 15005;
        public static final int Alaska_CS27_6 = 15006;
        public static final int Alaska_CS27_7 = 15007;
        public static final int Alaska_CS27_8 = 15008;
        public static final int Alaska_CS27_9 = 15009;
        public static final int Alaska_CS27_10 = 15010;
        public static final int Alaska_CS83_1 = 15031;
        public static final int Alaska_CS83_2 = 15032;
        public static final int Alaska_CS83_3 = 15033;
        public static final int Alaska_CS83_4 = 15034;
        public static final int Alaska_CS83_5 = 15035;
        public static final int Alaska_CS83_6 = 15036;
        public static final int Alaska_CS83_7 = 15037;
        public static final int Alaska_CS83_8 = 15038;
        public static final int Alaska_CS83_9 = 15039;
        public static final int Alaska_CS83_10 = 15040;
        public static final int Hawaii_CS27_1 = 15101;
        public static final int Hawaii_CS27_2 = 15102;
        public static final int Hawaii_CS27_3 = 15103;
        public static final int Hawaii_CS27_4 = 15104;
        public static final int Hawaii_CS27_5 = 15105;
        public static final int Hawaii_CS83_1 = 15131;
        public static final int Hawaii_CS83_2 = 15132;
        public static final int Hawaii_CS83_3 = 15133;
        public static final int Hawaii_CS83_4 = 15134;
        public static final int Hawaii_CS83_5 = 15135;
        public static final int Puerto_Rico_CS27 = 15201;
        public static final int St_Croix = 15202;
        public static final int Puerto_Rico_Virgin_Is = 15230;
        public static final int BLM_14N_feet = 15914;
        public static final int BLM_15N_feet = 15915;
        public static final int BLM_16N_feet = 15916;
        public static final int BLM_17N_feet = 15917;
        public static final int Map_Grid_of_Australia_48 = 17348;
        public static final int Map_Grid_of_Australia_49 = 17349;
        public static final int Map_Grid_of_Australia_50 = 17350;
        public static final int Map_Grid_of_Australia_51 = 17351;
        public static final int Map_Grid_of_Australia_52 = 17352;
        public static final int Map_Grid_of_Australia_53 = 17353;
        public static final int Map_Grid_of_Australia_54 = 17354;
        public static final int Map_Grid_of_Australia_55 = 17355;
        public static final int Map_Grid_of_Australia_56 = 17356;
        public static final int Map_Grid_of_Australia_57 = 17357;
        public static final int Map_Grid_of_Australia_58 = 17358;
        public static final int Australian_Map_Grid_48 = 17448;
        public static final int Australian_Map_Grid_49 = 17449;
        public static final int Australian_Map_Grid_50 = 17450;
        public static final int Australian_Map_Grid_51 = 17451;
        public static final int Australian_Map_Grid_52 = 17452;
        public static final int Australian_Map_Grid_53 = 17453;
        public static final int Australian_Map_Grid_54 = 17454;
        public static final int Australian_Map_Grid_55 = 17455;
        public static final int Australian_Map_Grid_56 = 17456;
        public static final int Australian_Map_Grid_57 = 17457;
        public static final int Australian_Map_Grid_58 = 17458;
        public static final int Argentina_1 = 18031;
        public static final int Argentina_2 = 18032;
        public static final int Argentina_3 = 18033;
        public static final int Argentina_4 = 18034;
        public static final int Argentina_5 = 18035;
        public static final int Argentina_6 = 18036;
        public static final int Argentina_7 = 18037;
        public static final int Colombia_3W = 18051;
        public static final int Colombia_Bogota = 18052;
        public static final int Colombia_3E = 18053;
        public static final int Colombia_6E = 18054;
        public static final int Egypt_Red_Belt = 18072;
        public static final int Egypt_Purple_Belt = 18073;
        public static final int Extended_Purple_Belt = 18074;
        public static final int New_Zealand_North_Island_Nat_Grid = 18141;
        public static final int New_Zealand_South_Island_Nat_Grid = 18142;
        public static final int Bahrain_Grid = 19900;
        public static final int Netherlands_E_Indies_Equatorial = 19905;
        public static final int RSO_Borneo = 19912;
        public static final int[] values = new int[]{10101, 10102, 10131, 10132, 10201, 10202, 10203, 10231, 10232, 10233, 10301, 10302, 10331, 10332, 10401, 10402, 10403, 10404, 10405, 10406, 10407, 10431, 10432, 10433, 10434, 10435, 10436, 10501, 10502, 10503, 10531, 10532, 10533, 10600, 10630, 10700, 10730, 10901, 10902, 10903, 10931, 10932, 10933, 11001, 11002, 11031, 11032, 11101, 11102, 11103, 11131, 11132, 11133, 11201, 11202, 11231, 11232, 11301, 11302, 11331, 11332, 11401, 11402, 11431, 11432, 11501, 11502, 11531, 11532, 11601, 11602, 11631, 11632, 11701, 11702, 11731, 11732, 11801, 11802, 11831, 11832, 11900, 11930, 12001, 12002, 12031, 12032, 12101, 12102, 12103, 12111, 12112, 12113, 12141, 12142, 12143, 12201, 12202, 12203, 12231, 12232, 12233, 12301, 12302, 12331, 12332, 12401, 12402, 12403, 12431, 12432, 12433, 12501, 12502, 12503, 12530, 12601, 12602, 12630, 12701, 12702, 12703, 12731, 12732, 12733, 12800, 12830, 12900, 12930, 13001, 13002, 13003, 13031, 13032, 13033, 13101, 13102, 13103, 13104, 13131, 13132, 13133, 13134, 13200, 13230, 13301, 13302, 13331, 13332, 13401, 13402, 13431, 13432, 13501, 13502, 13531, 13532, 13601, 13602, 13631, 13632, 13701, 13702, 13731, 13732, 13800, 13830, 13901, 13902, 13930, 14001, 14002, 14031, 14032, 14100, 14130, 14201, 14202, 14203, 14204, 14205, 14231, 14232, 14233, 14234, 14235, 14301, 14302, 14303, 14331, 14332, 14333, 14400, 14430, 14501, 14502, 14531, 14532, 14601, 14602, 14631, 14632, 14701, 14702, 14731, 14732, 14801, 14802, 14803, 14831, 14832, 14833, 14901, 14902, 14903, 14904, 14931, 14932, 14933, 14934, 15001, 15002, 15003, 15004, 15005, 15006, 15007, 15008, 15009, 15010, 15031, 15032, 15033, 15034, 15035, 15036, 15037, 15038, 15039, 15040, 15101, 15102, 15103, 15104, 15105, 15131, 15132, 15133, 15134, 15135, 15201, 15202, 15230, 15914, 15915, 15916, 15917, 17348, 17349, 17350, 17351, 17352, 17353, 17354, 17355, 17356, 17357, 17358, 17448, 17449, 17450, 17451, 17452, 17453, 17454, 17455, 17456, 17457, 17458, 18031, 18032, 18033, 18034, 18035, 18036, 18037, 18051, 18052, 18053, 18054, 18072, 18073, 18074, 18141, 18142, 19900, 19905, 19912};
        public static final String[] names = new String[]{"Proj_Alabama_CS27_East", "Proj_Alabama_CS27_West", "Proj_Alabama_CS83_East", "Proj_Alabama_CS83_West", "Proj_Arizona_Coordinate_System_east", "Proj_Arizona_Coordinate_System_Central", "Proj_Arizona_Coordinate_System_west", "Proj_Arizona_CS83_east", "Proj_Arizona_CS83_Central", "Proj_Arizona_CS83_west", "Proj_Arkansas_CS27_North", "Proj_Arkansas_CS27_South", "Proj_Arkansas_CS83_North", "Proj_Arkansas_CS83_South", "Proj_California_CS27_I", "Proj_California_CS27_II", "Proj_California_CS27_III", "Proj_California_CS27_IV", "Proj_California_CS27_V", "Proj_California_CS27_VI", "Proj_California_CS27_VII", "Proj_California_CS83_1", "Proj_California_CS83_2", "Proj_California_CS83_3", "Proj_California_CS83_4", "Proj_California_CS83_5", "Proj_California_CS83_6", "Proj_Colorado_CS27_North", "Proj_Colorado_CS27_Central", "Proj_Colorado_CS27_South", "Proj_Colorado_CS83_North", "Proj_Colorado_CS83_Central", "Proj_Colorado_CS83_South", "Proj_Connecticut_CS27", "Proj_Connecticut_CS83", "Proj_Delaware_CS27", "Proj_Delaware_CS83", "Proj_Florida_CS27_East", "Proj_Florida_CS27_West", "Proj_Florida_CS27_North", "Proj_Florida_CS83_East", "Proj_Florida_CS83_West", "Proj_Florida_CS83_North", "Proj_Georgia_CS27_East", "Proj_Georgia_CS27_West", "Proj_Georgia_CS83_East", "Proj_Georgia_CS83_West", "Proj_Idaho_CS27_East", "Proj_Idaho_CS27_Central", "Proj_Idaho_CS27_West", "Proj_Idaho_CS83_East", "Proj_Idaho_CS83_Central", "Proj_Idaho_CS83_West", "Proj_Illinois_CS27_East", "Proj_Illinois_CS27_West", "Proj_Illinois_CS83_East", "Proj_Illinois_CS83_West", "Proj_Indiana_CS27_East", "Proj_Indiana_CS27_West", "Proj_Indiana_CS83_East", "Proj_Indiana_CS83_West", "Proj_Iowa_CS27_North", "Proj_Iowa_CS27_South", "Proj_Iowa_CS83_North", "Proj_Iowa_CS83_South", "Proj_Kansas_CS27_North", "Proj_Kansas_CS27_South", "Proj_Kansas_CS83_North", "Proj_Kansas_CS83_South", "Proj_Kentucky_CS27_North", "Proj_Kentucky_CS27_South", "Proj_Kentucky_CS83_North", "Proj_Kentucky_CS83_South", "Proj_Louisiana_CS27_North", "Proj_Louisiana_CS27_South", "Proj_Louisiana_CS83_North", "Proj_Louisiana_CS83_South", "Proj_Maine_CS27_East", "Proj_Maine_CS27_West", "Proj_Maine_CS83_East", "Proj_Maine_CS83_West", "Proj_Maryland_CS27", "Proj_Maryland_CS83", "Proj_Massachusetts_CS27_Mainland", "Proj_Massachusetts_CS27_Island", "Proj_Massachusetts_CS83_Mainland", "Proj_Massachusetts_CS83_Island", "Proj_Michigan_State_Plane_East", "Proj_Michigan_State_Plane_Old_Central", "Proj_Michigan_State_Plane_West", "Proj_Michigan_CS27_North", "Proj_Michigan_CS27_Central", "Proj_Michigan_CS27_South", "Proj_Michigan_CS83_North", "Proj_Michigan_CS83_Central", "Proj_Michigan_CS83_South", "Proj_Minnesota_CS27_North", "Proj_Minnesota_CS27_Central", "Proj_Minnesota_CS27_South", "Proj_Minnesota_CS83_North", "Proj_Minnesota_CS83_Central", "Proj_Minnesota_CS83_South", "Proj_Mississippi_CS27_East", "Proj_Mississippi_CS27_West", "Proj_Mississippi_CS83_East", "Proj_Mississippi_CS83_West", "Proj_Missouri_CS27_East", "Proj_Missouri_CS27_Central", "Proj_Missouri_CS27_West", "Proj_Missouri_CS83_East", "Proj_Missouri_CS83_Central", "Proj_Missouri_CS83_West", "Proj_Montana_CS27_North", "Proj_Montana_CS27_Central", "Proj_Montana_CS27_South", "Proj_Montana_CS83", "Proj_Nebraska_CS27_North", "Proj_Nebraska_CS27_South", "Proj_Nebraska_CS83", "Proj_Nevada_CS27_East", "Proj_Nevada_CS27_Central", "Proj_Nevada_CS27_West", "Proj_Nevada_CS83_East", "Proj_Nevada_CS83_Central", "Proj_Nevada_CS83_West", "Proj_New_Hampshire_CS27", "Proj_New_Hampshire_CS83", "Proj_New_Jersey_CS27", "Proj_New_Jersey_CS83", "Proj_New_Mexico_CS27_East", "Proj_New_Mexico_CS27_Central", "Proj_New_Mexico_CS27_West", "Proj_New_Mexico_CS83_East", "Proj_New_Mexico_CS83_Central", "Proj_New_Mexico_CS83_West", "Proj_New_York_CS27_East", "Proj_New_York_CS27_Central", "Proj_New_York_CS27_West", "Proj_New_York_CS27_Long_Island", "Proj_New_York_CS83_East", "Proj_New_York_CS83_Central", "Proj_New_York_CS83_West", "Proj_New_York_CS83_Long_Island", "Proj_North_Carolina_CS27", "Proj_North_Carolina_CS83", "Proj_North_Dakota_CS27_North", "Proj_North_Dakota_CS27_South", "Proj_North_Dakota_CS83_North", "Proj_North_Dakota_CS83_South", "Proj_Ohio_CS27_North", "Proj_Ohio_CS27_South", "Proj_Ohio_CS83_North", "Proj_Ohio_CS83_South", "Proj_Oklahoma_CS27_North", "Proj_Oklahoma_CS27_South", "Proj_Oklahoma_CS83_North", "Proj_Oklahoma_CS83_South", "Proj_Oregon_CS27_North", "Proj_Oregon_CS27_South", "Proj_Oregon_CS83_North", "Proj_Oregon_CS83_South", "Proj_Pennsylvania_CS27_North", "Proj_Pennsylvania_CS27_South", "Proj_Pennsylvania_CS83_North", "Proj_Pennsylvania_CS83_South", "Proj_Rhode_Island_CS27", "Proj_Rhode_Island_CS83", "Proj_South_Carolina_CS27_North", "Proj_South_Carolina_CS27_South", "Proj_South_Carolina_CS83", "Proj_South_Dakota_CS27_North", "Proj_South_Dakota_CS27_South", "Proj_South_Dakota_CS83_North", "Proj_South_Dakota_CS83_South", "Proj_Tennessee_CS27", "Proj_Tennessee_CS83", "Proj_Texas_CS27_North", "Proj_Texas_CS27_North_Central", "Proj_Texas_CS27_Central", "Proj_Texas_CS27_South_Central", "Proj_Texas_CS27_South", "Proj_Texas_CS83_North", "Proj_Texas_CS83_North_Central", "Proj_Texas_CS83_Central", "Proj_Texas_CS83_South_Central", "Proj_Texas_CS83_South", "Proj_Utah_CS27_North", "Proj_Utah_CS27_Central", "Proj_Utah_CS27_South", "Proj_Utah_CS83_North", "Proj_Utah_CS83_Central", "Proj_Utah_CS83_South", "Proj_Vermont_CS27", "Proj_Vermont_CS83", "Proj_Virginia_CS27_North", "Proj_Virginia_CS27_South", "Proj_Virginia_CS83_North", "Proj_Virginia_CS83_South", "Proj_Washington_CS27_North", "Proj_Washington_CS27_South", "Proj_Washington_CS83_North", "Proj_Washington_CS83_South", "Proj_West_Virginia_CS27_North", "Proj_West_Virginia_CS27_South", "Proj_West_Virginia_CS83_North", "Proj_West_Virginia_CS83_South", "Proj_Wisconsin_CS27_North", "Proj_Wisconsin_CS27_Central", "Proj_Wisconsin_CS27_South", "Proj_Wisconsin_CS83_North", "Proj_Wisconsin_CS83_Central", "Proj_Wisconsin_CS83_South", "Proj_Wyoming_CS27_East", "Proj_Wyoming_CS27_East_Central", "Proj_Wyoming_CS27_West_Central", "Proj_Wyoming_CS27_West", "Proj_Wyoming_CS83_East", "Proj_Wyoming_CS83_East_Central", "Proj_Wyoming_CS83_West_Central", "Proj_Wyoming_CS83_West", "Proj_Alaska_CS27_1", "Proj_Alaska_CS27_2", "Proj_Alaska_CS27_3", "Proj_Alaska_CS27_4", "Proj_Alaska_CS27_5", "Proj_Alaska_CS27_6", "Proj_Alaska_CS27_7", "Proj_Alaska_CS27_8", "Proj_Alaska_CS27_9", "Proj_Alaska_CS27_10", "Proj_Alaska_CS83_1", "Proj_Alaska_CS83_2", "Proj_Alaska_CS83_3", "Proj_Alaska_CS83_4", "Proj_Alaska_CS83_5", "Proj_Alaska_CS83_6", "Proj_Alaska_CS83_7", "Proj_Alaska_CS83_8", "Proj_Alaska_CS83_9", "Proj_Alaska_CS83_10", "Proj_Hawaii_CS27_1", "Proj_Hawaii_CS27_2", "Proj_Hawaii_CS27_3", "Proj_Hawaii_CS27_4", "Proj_Hawaii_CS27_5", "Proj_Hawaii_CS83_1", "Proj_Hawaii_CS83_2", "Proj_Hawaii_CS83_3", "Proj_Hawaii_CS83_4", "Proj_Hawaii_CS83_5", "Proj_Puerto_Rico_CS27", "Proj_St_Croix", "Proj_Puerto_Rico_Virgin_Is", "Proj_BLM_14N_feet", "Proj_BLM_15N_feet", "Proj_BLM_16N_feet", "Proj_BLM_17N_feet", "Proj_Map_Grid_of_Australia_48", "Proj_Map_Grid_of_Australia_49", "Proj_Map_Grid_of_Australia_50", "Proj_Map_Grid_of_Australia_51", "Proj_Map_Grid_of_Australia_52", "Proj_Map_Grid_of_Australia_53", "Proj_Map_Grid_of_Australia_54", "Proj_Map_Grid_of_Australia_55", "Proj_Map_Grid_of_Australia_56", "Proj_Map_Grid_of_Australia_57", "Proj_Map_Grid_of_Australia_58", "Proj_Australian_Map_Grid_48", "Proj_Australian_Map_Grid_49", "Proj_Australian_Map_Grid_50", "Proj_Australian_Map_Grid_51", "Proj_Australian_Map_Grid_52", "Proj_Australian_Map_Grid_53", "Proj_Australian_Map_Grid_54", "Proj_Australian_Map_Grid_55", "Proj_Australian_Map_Grid_56", "Proj_Australian_Map_Grid_57", "Proj_Australian_Map_Grid_58", "Proj_Argentina_1", "Proj_Argentina_2", "Proj_Argentina_3", "Proj_Argentina_4", "Proj_Argentina_5", "Proj_Argentina_6", "Proj_Argentina_7", "Proj_Colombia_3W", "Proj_Colombia_Bogota", "Proj_Colombia_3E", "Proj_Colombia_6E", "Proj_Egypt_Red_Belt", "Proj_Egypt_Purple_Belt", "Proj_Extended_Purple_Belt", "Proj_New_Zealand_North_Island_Nat_Grid", "Proj_New_Zealand_South_Island_Nat_Grid", "Proj_Bahrain_Grid", "Proj_Netherlands_E_Indies_Equatorial", "Proj_RSO_Borneo"};

        public static String getName(int value) {
            for (int i = 0; i < values.length; ++i) {
                if (values[i] != value) continue;
                return names[i];
            }
            return null;
        }
    }

    public static class EpsgPm {
        public static final int Greenwich = 8901;
        public static final int Lisbon = 8902;
        public static final int Paris = 8903;
        public static final int Bogota = 8904;
        public static final int Madrid = 8905;
        public static final int Rome = 8906;
        public static final int Bern = 8907;
        public static final int Jakarta = 8908;
        public static final int Ferro = 8909;
        public static final int Brussels = 8910;
        public static final int Stockholm = 8911;
        public static final int[] values = new int[]{8901, 8902, 8903, 8904, 8905, 8906, 8907, 8908, 8909, 8910, 8911};
        public static final String[] names = new String[]{"PM_Greenwich", "PM_Lisbon", "PM_Paris", "PM_Bogota", "PM_Madrid", "PM_Rome", "PM_Bern", "PM_Jakarta", "PM_Ferro", "PM_Brussels", "PM_Stockholm"};

        public static String getName(int value) {
            for (int i = 0; i < values.length; ++i) {
                if (values[i] != value) continue;
                return names[i];
            }
            return null;
        }
    }

    public static class EpsgPcs {
        public static final int Adindan_UTM_zone_37N = 20137;
        public static final int Adindan_UTM_zone_38N = 20138;
        public static final int AGD66_AMG_zone_48 = 20248;
        public static final int AGD66_AMG_zone_49 = 20249;
        public static final int AGD66_AMG_zone_50 = 20250;
        public static final int AGD66_AMG_zone_51 = 20251;
        public static final int AGD66_AMG_zone_52 = 20252;
        public static final int AGD66_AMG_zone_53 = 20253;
        public static final int AGD66_AMG_zone_54 = 20254;
        public static final int AGD66_AMG_zone_55 = 20255;
        public static final int AGD66_AMG_zone_56 = 20256;
        public static final int AGD66_AMG_zone_57 = 20257;
        public static final int AGD66_AMG_zone_58 = 20258;
        public static final int AGD84_AMG_zone_48 = 20348;
        public static final int AGD84_AMG_zone_49 = 20349;
        public static final int AGD84_AMG_zone_50 = 20350;
        public static final int AGD84_AMG_zone_51 = 20351;
        public static final int AGD84_AMG_zone_52 = 20352;
        public static final int AGD84_AMG_zone_53 = 20353;
        public static final int AGD84_AMG_zone_54 = 20354;
        public static final int AGD84_AMG_zone_55 = 20355;
        public static final int AGD84_AMG_zone_56 = 20356;
        public static final int AGD84_AMG_zone_57 = 20357;
        public static final int AGD84_AMG_zone_58 = 20358;
        public static final int Ain_el_Abd_UTM_zone_37N = 20437;
        public static final int Ain_el_Abd_UTM_zone_38N = 20438;
        public static final int Ain_el_Abd_UTM_zone_39N = 20439;
        public static final int Ain_el_Abd_Bahrain_Grid = 20499;
        public static final int Afgooye_UTM_zone_38N = 20538;
        public static final int Afgooye_UTM_zone_39N = 20539;
        public static final int Lisbon_Portugese_Grid = 20700;
        public static final int Aratu_UTM_zone_22S = 20822;
        public static final int Aratu_UTM_zone_23S = 20823;
        public static final int Aratu_UTM_zone_24S = 20824;
        public static final int Arc_1950_Lo13 = 20973;
        public static final int Arc_1950_Lo15 = 20975;
        public static final int Arc_1950_Lo17 = 20977;
        public static final int Arc_1950_Lo19 = 20979;
        public static final int Arc_1950_Lo21 = 20981;
        public static final int Arc_1950_Lo23 = 20983;
        public static final int Arc_1950_Lo25 = 20985;
        public static final int Arc_1950_Lo27 = 20987;
        public static final int Arc_1950_Lo29 = 20989;
        public static final int Arc_1950_Lo31 = 20991;
        public static final int Arc_1950_Lo33 = 20993;
        public static final int Arc_1950_Lo35 = 20995;
        public static final int Batavia_NEIEZ = 21100;
        public static final int Batavia_UTM_zone_48S = 21148;
        public static final int Batavia_UTM_zone_49S = 21149;
        public static final int Batavia_UTM_zone_50S = 21150;
        public static final int Beijing_Gauss_zone_13 = 21413;
        public static final int Beijing_Gauss_zone_14 = 21414;
        public static final int Beijing_Gauss_zone_15 = 21415;
        public static final int Beijing_Gauss_zone_16 = 21416;
        public static final int Beijing_Gauss_zone_17 = 21417;
        public static final int Beijing_Gauss_zone_18 = 21418;
        public static final int Beijing_Gauss_zone_19 = 21419;
        public static final int Beijing_Gauss_zone_20 = 21420;
        public static final int Beijing_Gauss_zone_21 = 21421;
        public static final int Beijing_Gauss_zone_22 = 21422;
        public static final int Beijing_Gauss_zone_23 = 21423;
        public static final int Beijing_Gauss_13N = 21473;
        public static final int Beijing_Gauss_14N = 21474;
        public static final int Beijing_Gauss_15N = 21475;
        public static final int Beijing_Gauss_16N = 21476;
        public static final int Beijing_Gauss_17N = 21477;
        public static final int Beijing_Gauss_18N = 21478;
        public static final int Beijing_Gauss_19N = 21479;
        public static final int Beijing_Gauss_20N = 21480;
        public static final int Beijing_Gauss_21N = 21481;
        public static final int Beijing_Gauss_22N = 21482;
        public static final int Beijing_Gauss_23N = 21483;
        public static final int Belge_Lambert_50 = 21500;
        public static final int Bern_1898_Swiss_Old = 21790;
        public static final int Bogota_UTM_zone_17N = 21817;
        public static final int Bogota_UTM_zone_18N = 21818;
        public static final int Bogota_Colombia_3W = 21891;
        public static final int Bogota_Colombia_Bogota = 21892;
        public static final int Bogota_Colombia_3E = 21893;
        public static final int Bogota_Colombia_6E = 21894;
        public static final int Camacupa_UTM_32S = 22032;
        public static final int Camacupa_UTM_33S = 22033;
        public static final int C_Inchauspe_Argentina_1 = 22191;
        public static final int C_Inchauspe_Argentina_2 = 22192;
        public static final int C_Inchauspe_Argentina_3 = 22193;
        public static final int C_Inchauspe_Argentina_4 = 22194;
        public static final int C_Inchauspe_Argentina_5 = 22195;
        public static final int C_Inchauspe_Argentina_6 = 22196;
        public static final int C_Inchauspe_Argentina_7 = 22197;
        public static final int Carthage_UTM_zone_32N = 22332;
        public static final int Carthage_Nord_Tunisie = 22391;
        public static final int Carthage_Sud_Tunisie = 22392;
        public static final int Corrego_Alegre_UTM_23S = 22523;
        public static final int Corrego_Alegre_UTM_24S = 22524;
        public static final int Douala_UTM_zone_32N = 22832;
        public static final int Egypt_1907_Red_Belt = 22992;
        public static final int Egypt_1907_Purple_Belt = 22993;
        public static final int Egypt_1907_Ext_Purple = 22994;
        public static final int ED50_UTM_zone_28N = 23028;
        public static final int ED50_UTM_zone_29N = 23029;
        public static final int ED50_UTM_zone_30N = 23030;
        public static final int ED50_UTM_zone_31N = 23031;
        public static final int ED50_UTM_zone_32N = 23032;
        public static final int ED50_UTM_zone_33N = 23033;
        public static final int ED50_UTM_zone_34N = 23034;
        public static final int ED50_UTM_zone_35N = 23035;
        public static final int ED50_UTM_zone_36N = 23036;
        public static final int ED50_UTM_zone_37N = 23037;
        public static final int ED50_UTM_zone_38N = 23038;
        public static final int Fahud_UTM_zone_39N = 23239;
        public static final int Fahud_UTM_zone_40N = 23240;
        public static final int Garoua_UTM_zone_33N = 23433;
        public static final int ID74_UTM_zone_46N = 23846;
        public static final int ID74_UTM_zone_47N = 23847;
        public static final int ID74_UTM_zone_48N = 23848;
        public static final int ID74_UTM_zone_49N = 23849;
        public static final int ID74_UTM_zone_50N = 23850;
        public static final int ID74_UTM_zone_51N = 23851;
        public static final int ID74_UTM_zone_52N = 23852;
        public static final int ID74_UTM_zone_53N = 23853;
        public static final int ID74_UTM_zone_46S = 23886;
        public static final int ID74_UTM_zone_47S = 23887;
        public static final int ID74_UTM_zone_48S = 23888;
        public static final int ID74_UTM_zone_49S = 23889;
        public static final int ID74_UTM_zone_50S = 23890;
        public static final int ID74_UTM_zone_51S = 23891;
        public static final int ID74_UTM_zone_52S = 23892;
        public static final int ID74_UTM_zone_53S = 23893;
        public static final int ID74_UTM_zone_54S = 23894;
        public static final int Indian_1954_UTM_47N = 23947;
        public static final int Indian_1954_UTM_48N = 23948;
        public static final int Indian_1975_UTM_47N = 24047;
        public static final int Indian_1975_UTM_48N = 24048;
        public static final int Jamaica_1875_Old_Grid = 24100;
        public static final int JAD69_Jamaica_Grid = 24200;
        public static final int Kalianpur_India_0 = 24370;
        public static final int Kalianpur_India_I = 24371;
        public static final int Kalianpur_India_IIa = 24372;
        public static final int Kalianpur_India_IIIa = 24373;
        public static final int Kalianpur_India_IVa = 24374;
        public static final int Kalianpur_India_IIb = 24382;
        public static final int Kalianpur_India_IIIb = 24383;
        public static final int Kalianpur_India_IVb = 24384;
        public static final int Kertau_Singapore_Grid = 24500;
        public static final int Kertau_UTM_zone_47N = 24547;
        public static final int Kertau_UTM_zone_48N = 24548;
        public static final int La_Canoa_UTM_zone_20N = 24720;
        public static final int La_Canoa_UTM_zone_21N = 24721;
        public static final int PSAD56_UTM_zone_18N = 24818;
        public static final int PSAD56_UTM_zone_19N = 24819;
        public static final int PSAD56_UTM_zone_20N = 24820;
        public static final int PSAD56_UTM_zone_21N = 24821;
        public static final int PSAD56_UTM_zone_17S = 24877;
        public static final int PSAD56_UTM_zone_18S = 24878;
        public static final int PSAD56_UTM_zone_19S = 24879;
        public static final int PSAD56_UTM_zone_20S = 24880;
        public static final int PSAD56_Peru_west_zone = 24891;
        public static final int PSAD56_Peru_central = 24892;
        public static final int PSAD56_Peru_east_zone = 24893;
        public static final int Leigon_Ghana_Grid = 25000;
        public static final int Lome_UTM_zone_31N = 25231;
        public static final int Luzon_Philippines_I = 25391;
        public static final int Luzon_Philippines_II = 25392;
        public static final int Luzon_Philippines_III = 25393;
        public static final int Luzon_Philippines_IV = 25394;
        public static final int Luzon_Philippines_V = 25395;
        public static final int Makassar_NEIEZ = 25700;
        public static final int Malongo_1987_UTM_32S = 25932;
        public static final int Merchich_Nord_Maroc = 26191;
        public static final int Merchich_Sud_Maroc = 26192;
        public static final int Merchich_Sahara = 26193;
        public static final int Massawa_UTM_zone_37N = 26237;
        public static final int Minna_UTM_zone_31N = 26331;
        public static final int Minna_UTM_zone_32N = 26332;
        public static final int Minna_Nigeria_West = 26391;
        public static final int Minna_Nigeria_Mid_Belt = 26392;
        public static final int Minna_Nigeria_East = 26393;
        public static final int Mhast_UTM_zone_32S = 26432;
        public static final int Monte_Mario_Italy_1 = 26591;
        public static final int Monte_Mario_Italy_2 = 26592;
        public static final int M_poraloko_UTM_32N = 26632;
        public static final int M_poraloko_UTM_32S = 26692;
        public static final int NAD27_UTM_zone_3N = 26703;
        public static final int NAD27_UTM_zone_4N = 26704;
        public static final int NAD27_UTM_zone_5N = 26705;
        public static final int NAD27_UTM_zone_6N = 26706;
        public static final int NAD27_UTM_zone_7N = 26707;
        public static final int NAD27_UTM_zone_8N = 26708;
        public static final int NAD27_UTM_zone_9N = 26709;
        public static final int NAD27_UTM_zone_10N = 26710;
        public static final int NAD27_UTM_zone_11N = 26711;
        public static final int NAD27_UTM_zone_12N = 26712;
        public static final int NAD27_UTM_zone_13N = 26713;
        public static final int NAD27_UTM_zone_14N = 26714;
        public static final int NAD27_UTM_zone_15N = 26715;
        public static final int NAD27_UTM_zone_16N = 26716;
        public static final int NAD27_UTM_zone_17N = 26717;
        public static final int NAD27_UTM_zone_18N = 26718;
        public static final int NAD27_UTM_zone_19N = 26719;
        public static final int NAD27_UTM_zone_20N = 26720;
        public static final int NAD27_UTM_zone_21N = 26721;
        public static final int NAD27_UTM_zone_22N = 26722;
        public static final int NAD27_Alabama_East = 26729;
        public static final int NAD27_Alabama_West = 26730;
        public static final int NAD27_Alaska_zone_1 = 26731;
        public static final int NAD27_Alaska_zone_2 = 26732;
        public static final int NAD27_Alaska_zone_3 = 26733;
        public static final int NAD27_Alaska_zone_4 = 26734;
        public static final int NAD27_Alaska_zone_5 = 26735;
        public static final int NAD27_Alaska_zone_6 = 26736;
        public static final int NAD27_Alaska_zone_7 = 26737;
        public static final int NAD27_Alaska_zone_8 = 26738;
        public static final int NAD27_Alaska_zone_9 = 26739;
        public static final int NAD27_Alaska_zone_10 = 26740;
        public static final int NAD27_California_I = 26741;
        public static final int NAD27_California_II = 26742;
        public static final int NAD27_California_III = 26743;
        public static final int NAD27_California_IV = 26744;
        public static final int NAD27_California_V = 26745;
        public static final int NAD27_California_VI = 26746;
        public static final int NAD27_California_VII = 26747;
        public static final int NAD27_Arizona_East = 26748;
        public static final int NAD27_Arizona_Central = 26749;
        public static final int NAD27_Arizona_West = 26750;
        public static final int NAD27_Arkansas_North = 26751;
        public static final int NAD27_Arkansas_South = 26752;
        public static final int NAD27_Colorado_North = 26753;
        public static final int NAD27_Colorado_Central = 26754;
        public static final int NAD27_Colorado_South = 26755;
        public static final int NAD27_Connecticut = 26756;
        public static final int NAD27_Delaware = 26757;
        public static final int NAD27_Florida_East = 26758;
        public static final int NAD27_Florida_West = 26759;
        public static final int NAD27_Florida_North = 26760;
        public static final int NAD27_Hawaii_zone_1 = 26761;
        public static final int NAD27_Hawaii_zone_2 = 26762;
        public static final int NAD27_Hawaii_zone_3 = 26763;
        public static final int NAD27_Hawaii_zone_4 = 26764;
        public static final int NAD27_Hawaii_zone_5 = 26765;
        public static final int NAD27_Georgia_East = 26766;
        public static final int NAD27_Georgia_West = 26767;
        public static final int NAD27_Idaho_East = 26768;
        public static final int NAD27_Idaho_Central = 26769;
        public static final int NAD27_Idaho_West = 26770;
        public static final int NAD27_Illinois_East = 26771;
        public static final int NAD27_Illinois_West = 26772;
        public static final int NAD27_Indiana_East = 26773;
        public static final int NAD27_BLM_14N_feet = 26774;
        public static final int NAD27_Indiana_West = 26774;
        public static final int NAD27_BLM_15N_feet = 26775;
        public static final int NAD27_Iowa_North = 26775;
        public static final int NAD27_BLM_16N_feet = 26776;
        public static final int NAD27_Iowa_South = 26776;
        public static final int NAD27_BLM_17N_feet = 26777;
        public static final int NAD27_Kansas_North = 26777;
        public static final int NAD27_Kansas_South = 26778;
        public static final int NAD27_Kentucky_North = 26779;
        public static final int NAD27_Kentucky_South = 26780;
        public static final int NAD27_Louisiana_North = 26781;
        public static final int NAD27_Louisiana_South = 26782;
        public static final int NAD27_Maine_East = 26783;
        public static final int NAD27_Maine_West = 26784;
        public static final int NAD27_Maryland = 26785;
        public static final int NAD27_Massachusetts = 26786;
        public static final int NAD27_Massachusetts_Is = 26787;
        public static final int NAD27_Michigan_North = 26788;
        public static final int NAD27_Michigan_Central = 26789;
        public static final int NAD27_Michigan_South = 26790;
        public static final int NAD27_Minnesota_North = 26791;
        public static final int NAD27_Minnesota_Cent = 26792;
        public static final int NAD27_Minnesota_South = 26793;
        public static final int NAD27_Mississippi_East = 26794;
        public static final int NAD27_Mississippi_West = 26795;
        public static final int NAD27_Missouri_East = 26796;
        public static final int NAD27_Missouri_Central = 26797;
        public static final int NAD27_Missouri_West = 26798;
        public static final int NAD_Michigan_Michigan_East = 26801;
        public static final int NAD_Michigan_Michigan_Old_Central = 26802;
        public static final int NAD_Michigan_Michigan_West = 26803;
        public static final int NAD83_UTM_zone_3N = 26903;
        public static final int NAD83_UTM_zone_4N = 26904;
        public static final int NAD83_UTM_zone_5N = 26905;
        public static final int NAD83_UTM_zone_6N = 26906;
        public static final int NAD83_UTM_zone_7N = 26907;
        public static final int NAD83_UTM_zone_8N = 26908;
        public static final int NAD83_UTM_zone_9N = 26909;
        public static final int NAD83_UTM_zone_10N = 26910;
        public static final int NAD83_UTM_zone_11N = 26911;
        public static final int NAD83_UTM_zone_12N = 26912;
        public static final int NAD83_UTM_zone_13N = 26913;
        public static final int NAD83_UTM_zone_14N = 26914;
        public static final int NAD83_UTM_zone_15N = 26915;
        public static final int NAD83_UTM_zone_16N = 26916;
        public static final int NAD83_UTM_zone_17N = 26917;
        public static final int NAD83_UTM_zone_18N = 26918;
        public static final int NAD83_UTM_zone_19N = 26919;
        public static final int NAD83_UTM_zone_20N = 26920;
        public static final int NAD83_UTM_zone_21N = 26921;
        public static final int NAD83_UTM_zone_22N = 26922;
        public static final int NAD83_UTM_zone_23N = 26923;
        public static final int NAD83_Alabama_East = 26929;
        public static final int NAD83_Alabama_West = 26930;
        public static final int NAD83_Alaska_zone_1 = 26931;
        public static final int NAD83_Alaska_zone_2 = 26932;
        public static final int NAD83_Alaska_zone_3 = 26933;
        public static final int NAD83_Alaska_zone_4 = 26934;
        public static final int NAD83_Alaska_zone_5 = 26935;
        public static final int NAD83_Alaska_zone_6 = 26936;
        public static final int NAD83_Alaska_zone_7 = 26937;
        public static final int NAD83_Alaska_zone_8 = 26938;
        public static final int NAD83_Alaska_zone_9 = 26939;
        public static final int NAD83_Alaska_zone_10 = 26940;
        public static final int NAD83_California_1 = 26941;
        public static final int NAD83_California_2 = 26942;
        public static final int NAD83_California_3 = 26943;
        public static final int NAD83_California_4 = 26944;
        public static final int NAD83_California_5 = 26945;
        public static final int NAD83_California_6 = 26946;
        public static final int NAD83_Arizona_East = 26948;
        public static final int NAD83_Arizona_Central = 26949;
        public static final int NAD83_Arizona_West = 26950;
        public static final int NAD83_Arkansas_North = 26951;
        public static final int NAD83_Arkansas_South = 26952;
        public static final int NAD83_Colorado_North = 26953;
        public static final int NAD83_Colorado_Central = 26954;
        public static final int NAD83_Colorado_South = 26955;
        public static final int NAD83_Connecticut = 26956;
        public static final int NAD83_Delaware = 26957;
        public static final int NAD83_Florida_East = 26958;
        public static final int NAD83_Florida_West = 26959;
        public static final int NAD83_Florida_North = 26960;
        public static final int NAD83_Hawaii_zone_1 = 26961;
        public static final int NAD83_Hawaii_zone_2 = 26962;
        public static final int NAD83_Hawaii_zone_3 = 26963;
        public static final int NAD83_Hawaii_zone_4 = 26964;
        public static final int NAD83_Hawaii_zone_5 = 26965;
        public static final int NAD83_Georgia_East = 26966;
        public static final int NAD83_Georgia_West = 26967;
        public static final int NAD83_Idaho_East = 26968;
        public static final int NAD83_Idaho_Central = 26969;
        public static final int NAD83_Idaho_West = 26970;
        public static final int NAD83_Illinois_East = 26971;
        public static final int NAD83_Illinois_West = 26972;
        public static final int NAD83_Indiana_East = 26973;
        public static final int NAD83_Indiana_West = 26974;
        public static final int NAD83_Iowa_North = 26975;
        public static final int NAD83_Iowa_South = 26976;
        public static final int NAD83_Kansas_North = 26977;
        public static final int NAD83_Kansas_South = 26978;
        public static final int NAD83_Kentucky_North = 26979;
        public static final int NAD83_Kentucky_South = 26980;
        public static final int NAD83_Louisiana_North = 26981;
        public static final int NAD83_Louisiana_South = 26982;
        public static final int NAD83_Maine_East = 26983;
        public static final int NAD83_Maine_West = 26984;
        public static final int NAD83_Maryland = 26985;
        public static final int NAD83_Massachusetts = 26986;
        public static final int NAD83_Massachusetts_Is = 26987;
        public static final int NAD83_Michigan_North = 26988;
        public static final int NAD83_Michigan_Central = 26989;
        public static final int NAD83_Michigan_South = 26990;
        public static final int NAD83_Minnesota_North = 26991;
        public static final int NAD83_Minnesota_Cent = 26992;
        public static final int NAD83_Minnesota_South = 26993;
        public static final int NAD83_Mississippi_East = 26994;
        public static final int NAD83_Mississippi_West = 26995;
        public static final int NAD83_Missouri_East = 26996;
        public static final int NAD83_Missouri_Central = 26997;
        public static final int NAD83_Missouri_West = 26998;
        public static final int Nahrwan_1967_UTM_38N = 27038;
        public static final int Nahrwan_1967_UTM_39N = 27039;
        public static final int Nahrwan_1967_UTM_40N = 27040;
        public static final int Naparima_UTM_20N = 27120;
        public static final int GD49_NZ_Map_Grid = 27200;
        public static final int GD49_North_Island_Grid = 27291;
        public static final int GD49_South_Island_Grid = 27292;
        public static final int Datum_73_UTM_zone_29N = 27429;
        public static final int ATF_Nord_de_Guerre = 27500;
        public static final int NTF_France_I = 27581;
        public static final int NTF_France_II = 27582;
        public static final int NTF_France_III = 27583;
        public static final int NTF_Nord_France = 27591;
        public static final int NTF_Centre_France = 27592;
        public static final int NTF_Sud_France = 27593;
        public static final int British_National_Grid = 27700;
        public static final int Point_Noire_UTM_32S = 28232;
        public static final int GDA94_MGA_zone_48 = 28348;
        public static final int GDA94_MGA_zone_49 = 28349;
        public static final int GDA94_MGA_zone_50 = 28350;
        public static final int GDA94_MGA_zone_51 = 28351;
        public static final int GDA94_MGA_zone_52 = 28352;
        public static final int GDA94_MGA_zone_53 = 28353;
        public static final int GDA94_MGA_zone_54 = 28354;
        public static final int GDA94_MGA_zone_55 = 28355;
        public static final int GDA94_MGA_zone_56 = 28356;
        public static final int GDA94_MGA_zone_57 = 28357;
        public static final int GDA94_MGA_zone_58 = 28358;
        public static final int Pulkovo_Gauss_zone_4 = 28404;
        public static final int Pulkovo_Gauss_zone_5 = 28405;
        public static final int Pulkovo_Gauss_zone_6 = 28406;
        public static final int Pulkovo_Gauss_zone_7 = 28407;
        public static final int Pulkovo_Gauss_zone_8 = 28408;
        public static final int Pulkovo_Gauss_zone_9 = 28409;
        public static final int Pulkovo_Gauss_zone_10 = 28410;
        public static final int Pulkovo_Gauss_zone_11 = 28411;
        public static final int Pulkovo_Gauss_zone_12 = 28412;
        public static final int Pulkovo_Gauss_zone_13 = 28413;
        public static final int Pulkovo_Gauss_zone_14 = 28414;
        public static final int Pulkovo_Gauss_zone_15 = 28415;
        public static final int Pulkovo_Gauss_zone_16 = 28416;
        public static final int Pulkovo_Gauss_zone_17 = 28417;
        public static final int Pulkovo_Gauss_zone_18 = 28418;
        public static final int Pulkovo_Gauss_zone_19 = 28419;
        public static final int Pulkovo_Gauss_zone_20 = 28420;
        public static final int Pulkovo_Gauss_zone_21 = 28421;
        public static final int Pulkovo_Gauss_zone_22 = 28422;
        public static final int Pulkovo_Gauss_zone_23 = 28423;
        public static final int Pulkovo_Gauss_zone_24 = 28424;
        public static final int Pulkovo_Gauss_zone_25 = 28425;
        public static final int Pulkovo_Gauss_zone_26 = 28426;
        public static final int Pulkovo_Gauss_zone_27 = 28427;
        public static final int Pulkovo_Gauss_zone_28 = 28428;
        public static final int Pulkovo_Gauss_zone_29 = 28429;
        public static final int Pulkovo_Gauss_zone_30 = 28430;
        public static final int Pulkovo_Gauss_zone_31 = 28431;
        public static final int Pulkovo_Gauss_zone_32 = 28432;
        public static final int Pulkovo_Gauss_4N = 28464;
        public static final int Pulkovo_Gauss_5N = 28465;
        public static final int Pulkovo_Gauss_6N = 28466;
        public static final int Pulkovo_Gauss_7N = 28467;
        public static final int Pulkovo_Gauss_8N = 28468;
        public static final int Pulkovo_Gauss_9N = 28469;
        public static final int Pulkovo_Gauss_10N = 28470;
        public static final int Pulkovo_Gauss_11N = 28471;
        public static final int Pulkovo_Gauss_12N = 28472;
        public static final int Pulkovo_Gauss_13N = 28473;
        public static final int Pulkovo_Gauss_14N = 28474;
        public static final int Pulkovo_Gauss_15N = 28475;
        public static final int Pulkovo_Gauss_16N = 28476;
        public static final int Pulkovo_Gauss_17N = 28477;
        public static final int Pulkovo_Gauss_18N = 28478;
        public static final int Pulkovo_Gauss_19N = 28479;
        public static final int Pulkovo_Gauss_20N = 28480;
        public static final int Pulkovo_Gauss_21N = 28481;
        public static final int Pulkovo_Gauss_22N = 28482;
        public static final int Pulkovo_Gauss_23N = 28483;
        public static final int Pulkovo_Gauss_24N = 28484;
        public static final int Pulkovo_Gauss_25N = 28485;
        public static final int Pulkovo_Gauss_26N = 28486;
        public static final int Pulkovo_Gauss_27N = 28487;
        public static final int Pulkovo_Gauss_28N = 28488;
        public static final int Pulkovo_Gauss_29N = 28489;
        public static final int Pulkovo_Gauss_30N = 28490;
        public static final int Pulkovo_Gauss_31N = 28491;
        public static final int Pulkovo_Gauss_32N = 28492;
        public static final int Qatar_National_Grid = 28600;
        public static final int RD_Netherlands_Old = 28991;
        public static final int RD_Netherlands_New = 28992;
        public static final int SAD69_UTM_zone_18N = 29118;
        public static final int SAD69_UTM_zone_19N = 29119;
        public static final int SAD69_UTM_zone_20N = 29120;
        public static final int SAD69_UTM_zone_21N = 29121;
        public static final int SAD69_UTM_zone_22N = 29122;
        public static final int SAD69_UTM_zone_17S = 29177;
        public static final int SAD69_UTM_zone_18S = 29178;
        public static final int SAD69_UTM_zone_19S = 29179;
        public static final int SAD69_UTM_zone_20S = 29180;
        public static final int SAD69_UTM_zone_21S = 29181;
        public static final int SAD69_UTM_zone_22S = 29182;
        public static final int SAD69_UTM_zone_23S = 29183;
        public static final int SAD69_UTM_zone_24S = 29184;
        public static final int SAD69_UTM_zone_25S = 29185;
        public static final int Sapper_Hill_UTM_20S = 29220;
        public static final int Sapper_Hill_UTM_21S = 29221;
        public static final int Schwarzeck_UTM_33S = 29333;
        public static final int Sudan_UTM_zone_35N = 29635;
        public static final int Sudan_UTM_zone_36N = 29636;
        public static final int Tananarive_Laborde = 29700;
        public static final int Tananarive_UTM_38S = 29738;
        public static final int Tananarive_UTM_39S = 29739;
        public static final int Timbalai_1948_Borneo = 29800;
        public static final int Timbalai_1948_UTM_49N = 29849;
        public static final int Timbalai_1948_UTM_50N = 29850;
        public static final int TM65_Irish_Nat_Grid = 29900;
        public static final int Trinidad_1903_Trinidad = 30200;
        public static final int TC_1948_UTM_zone_39N = 30339;
        public static final int TC_1948_UTM_zone_40N = 30340;
        public static final int Voirol_N_Algerie_ancien = 30491;
        public static final int Voirol_S_Algerie_ancien = 30492;
        public static final int Voirol_Unifie_N_Algerie = 30591;
        public static final int Voirol_Unifie_S_Algerie = 30592;
        public static final int Bern_1938_Swiss_New = 30600;
        public static final int Nord_Sahara_UTM_29N = 30729;
        public static final int Nord_Sahara_UTM_30N = 30730;
        public static final int Nord_Sahara_UTM_31N = 30731;
        public static final int Nord_Sahara_UTM_32N = 30732;
        public static final int Yoff_UTM_zone_28N = 31028;
        public static final int Zanderij_UTM_zone_21N = 31121;
        public static final int MGI_Austria_West = 31291;
        public static final int MGI_Austria_Central = 31292;
        public static final int MGI_Austria_East = 31293;
        public static final int Belge_Lambert_72 = 31300;
        public static final int DHDN_Germany_zone_1 = 31491;
        public static final int DHDN_Germany_zone_2 = 31492;
        public static final int DHDN_Germany_zone_3 = 31493;
        public static final int DHDN_Germany_zone_4 = 31494;
        public static final int DHDN_Germany_zone_5 = 31495;
        public static final int NAD27_Montana_North = 32001;
        public static final int NAD27_Montana_Central = 32002;
        public static final int NAD27_Montana_South = 32003;
        public static final int NAD27_Nebraska_North = 32005;
        public static final int NAD27_Nebraska_South = 32006;
        public static final int NAD27_Nevada_East = 32007;
        public static final int NAD27_Nevada_Central = 32008;
        public static final int NAD27_Nevada_West = 32009;
        public static final int NAD27_New_Hampshire = 32010;
        public static final int NAD27_New_Jersey = 32011;
        public static final int NAD27_New_Mexico_East = 32012;
        public static final int NAD27_New_Mexico_Cent = 32013;
        public static final int NAD27_New_Mexico_West = 32014;
        public static final int NAD27_New_York_East = 32015;
        public static final int NAD27_New_York_Central = 32016;
        public static final int NAD27_New_York_West = 32017;
        public static final int NAD27_New_York_Long_Is = 32018;
        public static final int NAD27_North_Carolina = 32019;
        public static final int NAD27_North_Dakota_N = 32020;
        public static final int NAD27_North_Dakota_S = 32021;
        public static final int NAD27_Ohio_North = 32022;
        public static final int NAD27_Ohio_South = 32023;
        public static final int NAD27_Oklahoma_North = 32024;
        public static final int NAD27_Oklahoma_South = 32025;
        public static final int NAD27_Oregon_North = 32026;
        public static final int NAD27_Oregon_South = 32027;
        public static final int NAD27_Pennsylvania_N = 32028;
        public static final int NAD27_Pennsylvania_S = 32029;
        public static final int NAD27_Rhode_Island = 32030;
        public static final int NAD27_South_Carolina_N = 32031;
        public static final int NAD27_South_Carolina_S = 32033;
        public static final int NAD27_South_Dakota_N = 32034;
        public static final int NAD27_South_Dakota_S = 32035;
        public static final int NAD27_Tennessee = 32036;
        public static final int NAD27_Texas_North = 32037;
        public static final int NAD27_Texas_North_Cen = 32038;
        public static final int NAD27_Texas_Central = 32039;
        public static final int NAD27_Texas_South_Cen = 32040;
        public static final int NAD27_Texas_South = 32041;
        public static final int NAD27_Utah_North = 32042;
        public static final int NAD27_Utah_Central = 32043;
        public static final int NAD27_Utah_South = 32044;
        public static final int NAD27_Vermont = 32045;
        public static final int NAD27_Virginia_North = 32046;
        public static final int NAD27_Virginia_South = 32047;
        public static final int NAD27_Washington_North = 32048;
        public static final int NAD27_Washington_South = 32049;
        public static final int NAD27_West_Virginia_N = 32050;
        public static final int NAD27_West_Virginia_S = 32051;
        public static final int NAD27_Wisconsin_North = 32052;
        public static final int NAD27_Wisconsin_Cen = 32053;
        public static final int NAD27_Wisconsin_South = 32054;
        public static final int NAD27_Wyoming_East = 32055;
        public static final int NAD27_Wyoming_E_Cen = 32056;
        public static final int NAD27_Wyoming_W_Cen = 32057;
        public static final int NAD27_Wyoming_West = 32058;
        public static final int NAD27_Puerto_Rico = 32059;
        public static final int NAD27_St_Croix = 32060;
        public static final int NAD83_Montana = 32100;
        public static final int NAD83_Nebraska = 32104;
        public static final int NAD83_Nevada_East = 32107;
        public static final int NAD83_Nevada_Central = 32108;
        public static final int NAD83_Nevada_West = 32109;
        public static final int NAD83_New_Hampshire = 32110;
        public static final int NAD83_New_Jersey = 32111;
        public static final int NAD83_New_Mexico_East = 32112;
        public static final int NAD83_New_Mexico_Cent = 32113;
        public static final int NAD83_New_Mexico_West = 32114;
        public static final int NAD83_New_York_East = 32115;
        public static final int NAD83_New_York_Central = 32116;
        public static final int NAD83_New_York_West = 32117;
        public static final int NAD83_New_York_Long_Is = 32118;
        public static final int NAD83_North_Carolina = 32119;
        public static final int NAD83_North_Dakota_N = 32120;
        public static final int NAD83_North_Dakota_S = 32121;
        public static final int NAD83_Ohio_North = 32122;
        public static final int NAD83_Ohio_South = 32123;
        public static final int NAD83_Oklahoma_North = 32124;
        public static final int NAD83_Oklahoma_South = 32125;
        public static final int NAD83_Oregon_North = 32126;
        public static final int NAD83_Oregon_South = 32127;
        public static final int NAD83_Pennsylvania_N = 32128;
        public static final int NAD83_Pennsylvania_S = 32129;
        public static final int NAD83_Rhode_Island = 32130;
        public static final int NAD83_South_Carolina = 32133;
        public static final int NAD83_South_Dakota_N = 32134;
        public static final int NAD83_South_Dakota_S = 32135;
        public static final int NAD83_Tennessee = 32136;
        public static final int NAD83_Texas_North = 32137;
        public static final int NAD83_Texas_North_Cen = 32138;
        public static final int NAD83_Texas_Central = 32139;
        public static final int NAD83_Texas_South_Cen = 32140;
        public static final int NAD83_Texas_South = 32141;
        public static final int NAD83_Utah_North = 32142;
        public static final int NAD83_Utah_Central = 32143;
        public static final int NAD83_Utah_South = 32144;
        public static final int NAD83_Vermont = 32145;
        public static final int NAD83_Virginia_North = 32146;
        public static final int NAD83_Virginia_South = 32147;
        public static final int NAD83_Washington_North = 32148;
        public static final int NAD83_Washington_South = 32149;
        public static final int NAD83_West_Virginia_N = 32150;
        public static final int NAD83_West_Virginia_S = 32151;
        public static final int NAD83_Wisconsin_North = 32152;
        public static final int NAD83_Wisconsin_Cen = 32153;
        public static final int NAD83_Wisconsin_South = 32154;
        public static final int NAD83_Wyoming_East = 32155;
        public static final int NAD83_Wyoming_E_Cen = 32156;
        public static final int NAD83_Wyoming_W_Cen = 32157;
        public static final int NAD83_Wyoming_West = 32158;
        public static final int NAD83_Puerto_Rico_Virgin_Is = 32161;
        public static final int WGS72_UTM_zone_1N = 32201;
        public static final int WGS72_UTM_zone_2N = 32202;
        public static final int WGS72_UTM_zone_3N = 32203;
        public static final int WGS72_UTM_zone_4N = 32204;
        public static final int WGS72_UTM_zone_5N = 32205;
        public static final int WGS72_UTM_zone_6N = 32206;
        public static final int WGS72_UTM_zone_7N = 32207;
        public static final int WGS72_UTM_zone_8N = 32208;
        public static final int WGS72_UTM_zone_9N = 32209;
        public static final int WGS72_UTM_zone_10N = 32210;
        public static final int WGS72_UTM_zone_11N = 32211;
        public static final int WGS72_UTM_zone_12N = 32212;
        public static final int WGS72_UTM_zone_13N = 32213;
        public static final int WGS72_UTM_zone_14N = 32214;
        public static final int WGS72_UTM_zone_15N = 32215;
        public static final int WGS72_UTM_zone_16N = 32216;
        public static final int WGS72_UTM_zone_17N = 32217;
        public static final int WGS72_UTM_zone_18N = 32218;
        public static final int WGS72_UTM_zone_19N = 32219;
        public static final int WGS72_UTM_zone_20N = 32220;
        public static final int WGS72_UTM_zone_21N = 32221;
        public static final int WGS72_UTM_zone_22N = 32222;
        public static final int WGS72_UTM_zone_23N = 32223;
        public static final int WGS72_UTM_zone_24N = 32224;
        public static final int WGS72_UTM_zone_25N = 32225;
        public static final int WGS72_UTM_zone_26N = 32226;
        public static final int WGS72_UTM_zone_27N = 32227;
        public static final int WGS72_UTM_zone_28N = 32228;
        public static final int WGS72_UTM_zone_29N = 32229;
        public static final int WGS72_UTM_zone_30N = 32230;
        public static final int WGS72_UTM_zone_31N = 32231;
        public static final int WGS72_UTM_zone_32N = 32232;
        public static final int WGS72_UTM_zone_33N = 32233;
        public static final int WGS72_UTM_zone_34N = 32234;
        public static final int WGS72_UTM_zone_35N = 32235;
        public static final int WGS72_UTM_zone_36N = 32236;
        public static final int WGS72_UTM_zone_37N = 32237;
        public static final int WGS72_UTM_zone_38N = 32238;
        public static final int WGS72_UTM_zone_39N = 32239;
        public static final int WGS72_UTM_zone_40N = 32240;
        public static final int WGS72_UTM_zone_41N = 32241;
        public static final int WGS72_UTM_zone_42N = 32242;
        public static final int WGS72_UTM_zone_43N = 32243;
        public static final int WGS72_UTM_zone_44N = 32244;
        public static final int WGS72_UTM_zone_45N = 32245;
        public static final int WGS72_UTM_zone_46N = 32246;
        public static final int WGS72_UTM_zone_47N = 32247;
        public static final int WGS72_UTM_zone_48N = 32248;
        public static final int WGS72_UTM_zone_49N = 32249;
        public static final int WGS72_UTM_zone_50N = 32250;
        public static final int WGS72_UTM_zone_51N = 32251;
        public static final int WGS72_UTM_zone_52N = 32252;
        public static final int WGS72_UTM_zone_53N = 32253;
        public static final int WGS72_UTM_zone_54N = 32254;
        public static final int WGS72_UTM_zone_55N = 32255;
        public static final int WGS72_UTM_zone_56N = 32256;
        public static final int WGS72_UTM_zone_57N = 32257;
        public static final int WGS72_UTM_zone_58N = 32258;
        public static final int WGS72_UTM_zone_59N = 32259;
        public static final int WGS72_UTM_zone_60N = 32260;
        public static final int WGS72_UTM_zone_1S = 32301;
        public static final int WGS72_UTM_zone_2S = 32302;
        public static final int WGS72_UTM_zone_3S = 32303;
        public static final int WGS72_UTM_zone_4S = 32304;
        public static final int WGS72_UTM_zone_5S = 32305;
        public static final int WGS72_UTM_zone_6S = 32306;
        public static final int WGS72_UTM_zone_7S = 32307;
        public static final int WGS72_UTM_zone_8S = 32308;
        public static final int WGS72_UTM_zone_9S = 32309;
        public static final int WGS72_UTM_zone_10S = 32310;
        public static final int WGS72_UTM_zone_11S = 32311;
        public static final int WGS72_UTM_zone_12S = 32312;
        public static final int WGS72_UTM_zone_13S = 32313;
        public static final int WGS72_UTM_zone_14S = 32314;
        public static final int WGS72_UTM_zone_15S = 32315;
        public static final int WGS72_UTM_zone_16S = 32316;
        public static final int WGS72_UTM_zone_17S = 32317;
        public static final int WGS72_UTM_zone_18S = 32318;
        public static final int WGS72_UTM_zone_19S = 32319;
        public static final int WGS72_UTM_zone_20S = 32320;
        public static final int WGS72_UTM_zone_21S = 32321;
        public static final int WGS72_UTM_zone_22S = 32322;
        public static final int WGS72_UTM_zone_23S = 32323;
        public static final int WGS72_UTM_zone_24S = 32324;
        public static final int WGS72_UTM_zone_25S = 32325;
        public static final int WGS72_UTM_zone_26S = 32326;
        public static final int WGS72_UTM_zone_27S = 32327;
        public static final int WGS72_UTM_zone_28S = 32328;
        public static final int WGS72_UTM_zone_29S = 32329;
        public static final int WGS72_UTM_zone_30S = 32330;
        public static final int WGS72_UTM_zone_31S = 32331;
        public static final int WGS72_UTM_zone_32S = 32332;
        public static final int WGS72_UTM_zone_33S = 32333;
        public static final int WGS72_UTM_zone_34S = 32334;
        public static final int WGS72_UTM_zone_35S = 32335;
        public static final int WGS72_UTM_zone_36S = 32336;
        public static final int WGS72_UTM_zone_37S = 32337;
        public static final int WGS72_UTM_zone_38S = 32338;
        public static final int WGS72_UTM_zone_39S = 32339;
        public static final int WGS72_UTM_zone_40S = 32340;
        public static final int WGS72_UTM_zone_41S = 32341;
        public static final int WGS72_UTM_zone_42S = 32342;
        public static final int WGS72_UTM_zone_43S = 32343;
        public static final int WGS72_UTM_zone_44S = 32344;
        public static final int WGS72_UTM_zone_45S = 32345;
        public static final int WGS72_UTM_zone_46S = 32346;
        public static final int WGS72_UTM_zone_47S = 32347;
        public static final int WGS72_UTM_zone_48S = 32348;
        public static final int WGS72_UTM_zone_49S = 32349;
        public static final int WGS72_UTM_zone_50S = 32350;
        public static final int WGS72_UTM_zone_51S = 32351;
        public static final int WGS72_UTM_zone_52S = 32352;
        public static final int WGS72_UTM_zone_53S = 32353;
        public static final int WGS72_UTM_zone_54S = 32354;
        public static final int WGS72_UTM_zone_55S = 32355;
        public static final int WGS72_UTM_zone_56S = 32356;
        public static final int WGS72_UTM_zone_57S = 32357;
        public static final int WGS72_UTM_zone_58S = 32358;
        public static final int WGS72_UTM_zone_59S = 32359;
        public static final int WGS72_UTM_zone_60S = 32360;
        public static final int WGS72BE_UTM_zone_1N = 32401;
        public static final int WGS72BE_UTM_zone_2N = 32402;
        public static final int WGS72BE_UTM_zone_3N = 32403;
        public static final int WGS72BE_UTM_zone_4N = 32404;
        public static final int WGS72BE_UTM_zone_5N = 32405;
        public static final int WGS72BE_UTM_zone_6N = 32406;
        public static final int WGS72BE_UTM_zone_7N = 32407;
        public static final int WGS72BE_UTM_zone_8N = 32408;
        public static final int WGS72BE_UTM_zone_9N = 32409;
        public static final int WGS72BE_UTM_zone_10N = 32410;
        public static final int WGS72BE_UTM_zone_11N = 32411;
        public static final int WGS72BE_UTM_zone_12N = 32412;
        public static final int WGS72BE_UTM_zone_13N = 32413;
        public static final int WGS72BE_UTM_zone_14N = 32414;
        public static final int WGS72BE_UTM_zone_15N = 32415;
        public static final int WGS72BE_UTM_zone_16N = 32416;
        public static final int WGS72BE_UTM_zone_17N = 32417;
        public static final int WGS72BE_UTM_zone_18N = 32418;
        public static final int WGS72BE_UTM_zone_19N = 32419;
        public static final int WGS72BE_UTM_zone_20N = 32420;
        public static final int WGS72BE_UTM_zone_21N = 32421;
        public static final int WGS72BE_UTM_zone_22N = 32422;
        public static final int WGS72BE_UTM_zone_23N = 32423;
        public static final int WGS72BE_UTM_zone_24N = 32424;
        public static final int WGS72BE_UTM_zone_25N = 32425;
        public static final int WGS72BE_UTM_zone_26N = 32426;
        public static final int WGS72BE_UTM_zone_27N = 32427;
        public static final int WGS72BE_UTM_zone_28N = 32428;
        public static final int WGS72BE_UTM_zone_29N = 32429;
        public static final int WGS72BE_UTM_zone_30N = 32430;
        public static final int WGS72BE_UTM_zone_31N = 32431;
        public static final int WGS72BE_UTM_zone_32N = 32432;
        public static final int WGS72BE_UTM_zone_33N = 32433;
        public static final int WGS72BE_UTM_zone_34N = 32434;
        public static final int WGS72BE_UTM_zone_35N = 32435;
        public static final int WGS72BE_UTM_zone_36N = 32436;
        public static final int WGS72BE_UTM_zone_37N = 32437;
        public static final int WGS72BE_UTM_zone_38N = 32438;
        public static final int WGS72BE_UTM_zone_39N = 32439;
        public static final int WGS72BE_UTM_zone_40N = 32440;
        public static final int WGS72BE_UTM_zone_41N = 32441;
        public static final int WGS72BE_UTM_zone_42N = 32442;
        public static final int WGS72BE_UTM_zone_43N = 32443;
        public static final int WGS72BE_UTM_zone_44N = 32444;
        public static final int WGS72BE_UTM_zone_45N = 32445;
        public static final int WGS72BE_UTM_zone_46N = 32446;
        public static final int WGS72BE_UTM_zone_47N = 32447;
        public static final int WGS72BE_UTM_zone_48N = 32448;
        public static final int WGS72BE_UTM_zone_49N = 32449;
        public static final int WGS72BE_UTM_zone_50N = 32450;
        public static final int WGS72BE_UTM_zone_51N = 32451;
        public static final int WGS72BE_UTM_zone_52N = 32452;
        public static final int WGS72BE_UTM_zone_53N = 32453;
        public static final int WGS72BE_UTM_zone_54N = 32454;
        public static final int WGS72BE_UTM_zone_55N = 32455;
        public static final int WGS72BE_UTM_zone_56N = 32456;
        public static final int WGS72BE_UTM_zone_57N = 32457;
        public static final int WGS72BE_UTM_zone_58N = 32458;
        public static final int WGS72BE_UTM_zone_59N = 32459;
        public static final int WGS72BE_UTM_zone_60N = 32460;
        public static final int WGS72BE_UTM_zone_1S = 32501;
        public static final int WGS72BE_UTM_zone_2S = 32502;
        public static final int WGS72BE_UTM_zone_3S = 32503;
        public static final int WGS72BE_UTM_zone_4S = 32504;
        public static final int WGS72BE_UTM_zone_5S = 32505;
        public static final int WGS72BE_UTM_zone_6S = 32506;
        public static final int WGS72BE_UTM_zone_7S = 32507;
        public static final int WGS72BE_UTM_zone_8S = 32508;
        public static final int WGS72BE_UTM_zone_9S = 32509;
        public static final int WGS72BE_UTM_zone_10S = 32510;
        public static final int WGS72BE_UTM_zone_11S = 32511;
        public static final int WGS72BE_UTM_zone_12S = 32512;
        public static final int WGS72BE_UTM_zone_13S = 32513;
        public static final int WGS72BE_UTM_zone_14S = 32514;
        public static final int WGS72BE_UTM_zone_15S = 32515;
        public static final int WGS72BE_UTM_zone_16S = 32516;
        public static final int WGS72BE_UTM_zone_17S = 32517;
        public static final int WGS72BE_UTM_zone_18S = 32518;
        public static final int WGS72BE_UTM_zone_19S = 32519;
        public static final int WGS72BE_UTM_zone_20S = 32520;
        public static final int WGS72BE_UTM_zone_21S = 32521;
        public static final int WGS72BE_UTM_zone_22S = 32522;
        public static final int WGS72BE_UTM_zone_23S = 32523;
        public static final int WGS72BE_UTM_zone_24S = 32524;
        public static final int WGS72BE_UTM_zone_25S = 32525;
        public static final int WGS72BE_UTM_zone_26S = 32526;
        public static final int WGS72BE_UTM_zone_27S = 32527;
        public static final int WGS72BE_UTM_zone_28S = 32528;
        public static final int WGS72BE_UTM_zone_29S = 32529;
        public static final int WGS72BE_UTM_zone_30S = 32530;
        public static final int WGS72BE_UTM_zone_31S = 32531;
        public static final int WGS72BE_UTM_zone_32S = 32532;
        public static final int WGS72BE_UTM_zone_33S = 32533;
        public static final int WGS72BE_UTM_zone_34S = 32534;
        public static final int WGS72BE_UTM_zone_35S = 32535;
        public static final int WGS72BE_UTM_zone_36S = 32536;
        public static final int WGS72BE_UTM_zone_37S = 32537;
        public static final int WGS72BE_UTM_zone_38S = 32538;
        public static final int WGS72BE_UTM_zone_39S = 32539;
        public static final int WGS72BE_UTM_zone_40S = 32540;
        public static final int WGS72BE_UTM_zone_41S = 32541;
        public static final int WGS72BE_UTM_zone_42S = 32542;
        public static final int WGS72BE_UTM_zone_43S = 32543;
        public static final int WGS72BE_UTM_zone_44S = 32544;
        public static final int WGS72BE_UTM_zone_45S = 32545;
        public static final int WGS72BE_UTM_zone_46S = 32546;
        public static final int WGS72BE_UTM_zone_47S = 32547;
        public static final int WGS72BE_UTM_zone_48S = 32548;
        public static final int WGS72BE_UTM_zone_49S = 32549;
        public static final int WGS72BE_UTM_zone_50S = 32550;
        public static final int WGS72BE_UTM_zone_51S = 32551;
        public static final int WGS72BE_UTM_zone_52S = 32552;
        public static final int WGS72BE_UTM_zone_53S = 32553;
        public static final int WGS72BE_UTM_zone_54S = 32554;
        public static final int WGS72BE_UTM_zone_55S = 32555;
        public static final int WGS72BE_UTM_zone_56S = 32556;
        public static final int WGS72BE_UTM_zone_57S = 32557;
        public static final int WGS72BE_UTM_zone_58S = 32558;
        public static final int WGS72BE_UTM_zone_59S = 32559;
        public static final int WGS72BE_UTM_zone_60S = 32560;
        public static final int WGS84_UTM_zone_1N = 32601;
        public static final int WGS84_UTM_zone_2N = 32602;
        public static final int WGS84_UTM_zone_3N = 32603;
        public static final int WGS84_UTM_zone_4N = 32604;
        public static final int WGS84_UTM_zone_5N = 32605;
        public static final int WGS84_UTM_zone_6N = 32606;
        public static final int WGS84_UTM_zone_7N = 32607;
        public static final int WGS84_UTM_zone_8N = 32608;
        public static final int WGS84_UTM_zone_9N = 32609;
        public static final int WGS84_UTM_zone_10N = 32610;
        public static final int WGS84_UTM_zone_11N = 32611;
        public static final int WGS84_UTM_zone_12N = 32612;
        public static final int WGS84_UTM_zone_13N = 32613;
        public static final int WGS84_UTM_zone_14N = 32614;
        public static final int WGS84_UTM_zone_15N = 32615;
        public static final int WGS84_UTM_zone_16N = 32616;
        public static final int WGS84_UTM_zone_17N = 32617;
        public static final int WGS84_UTM_zone_18N = 32618;
        public static final int WGS84_UTM_zone_19N = 32619;
        public static final int WGS84_UTM_zone_20N = 32620;
        public static final int WGS84_UTM_zone_21N = 32621;
        public static final int WGS84_UTM_zone_22N = 32622;
        public static final int WGS84_UTM_zone_23N = 32623;
        public static final int WGS84_UTM_zone_24N = 32624;
        public static final int WGS84_UTM_zone_25N = 32625;
        public static final int WGS84_UTM_zone_26N = 32626;
        public static final int WGS84_UTM_zone_27N = 32627;
        public static final int WGS84_UTM_zone_28N = 32628;
        public static final int WGS84_UTM_zone_29N = 32629;
        public static final int WGS84_UTM_zone_30N = 32630;
        public static final int WGS84_UTM_zone_31N = 32631;
        public static final int WGS84_UTM_zone_32N = 32632;
        public static final int WGS84_UTM_zone_33N = 32633;
        public static final int WGS84_UTM_zone_34N = 32634;
        public static final int WGS84_UTM_zone_35N = 32635;
        public static final int WGS84_UTM_zone_36N = 32636;
        public static final int WGS84_UTM_zone_37N = 32637;
        public static final int WGS84_UTM_zone_38N = 32638;
        public static final int WGS84_UTM_zone_39N = 32639;
        public static final int WGS84_UTM_zone_40N = 32640;
        public static final int WGS84_UTM_zone_41N = 32641;
        public static final int WGS84_UTM_zone_42N = 32642;
        public static final int WGS84_UTM_zone_43N = 32643;
        public static final int WGS84_UTM_zone_44N = 32644;
        public static final int WGS84_UTM_zone_45N = 32645;
        public static final int WGS84_UTM_zone_46N = 32646;
        public static final int WGS84_UTM_zone_47N = 32647;
        public static final int WGS84_UTM_zone_48N = 32648;
        public static final int WGS84_UTM_zone_49N = 32649;
        public static final int WGS84_UTM_zone_50N = 32650;
        public static final int WGS84_UTM_zone_51N = 32651;
        public static final int WGS84_UTM_zone_52N = 32652;
        public static final int WGS84_UTM_zone_53N = 32653;
        public static final int WGS84_UTM_zone_54N = 32654;
        public static final int WGS84_UTM_zone_55N = 32655;
        public static final int WGS84_UTM_zone_56N = 32656;
        public static final int WGS84_UTM_zone_57N = 32657;
        public static final int WGS84_UTM_zone_58N = 32658;
        public static final int WGS84_UTM_zone_59N = 32659;
        public static final int WGS84_UTM_zone_60N = 32660;
        public static final int WGS84_UTM_zone_1S = 32701;
        public static final int WGS84_UTM_zone_2S = 32702;
        public static final int WGS84_UTM_zone_3S = 32703;
        public static final int WGS84_UTM_zone_4S = 32704;
        public static final int WGS84_UTM_zone_5S = 32705;
        public static final int WGS84_UTM_zone_6S = 32706;
        public static final int WGS84_UTM_zone_7S = 32707;
        public static final int WGS84_UTM_zone_8S = 32708;
        public static final int WGS84_UTM_zone_9S = 32709;
        public static final int WGS84_UTM_zone_10S = 32710;
        public static final int WGS84_UTM_zone_11S = 32711;
        public static final int WGS84_UTM_zone_12S = 32712;
        public static final int WGS84_UTM_zone_13S = 32713;
        public static final int WGS84_UTM_zone_14S = 32714;
        public static final int WGS84_UTM_zone_15S = 32715;
        public static final int WGS84_UTM_zone_16S = 32716;
        public static final int WGS84_UTM_zone_17S = 32717;
        public static final int WGS84_UTM_zone_18S = 32718;
        public static final int WGS84_UTM_zone_19S = 32719;
        public static final int WGS84_UTM_zone_20S = 32720;
        public static final int WGS84_UTM_zone_21S = 32721;
        public static final int WGS84_UTM_zone_22S = 32722;
        public static final int WGS84_UTM_zone_23S = 32723;
        public static final int WGS84_UTM_zone_24S = 32724;
        public static final int WGS84_UTM_zone_25S = 32725;
        public static final int WGS84_UTM_zone_26S = 32726;
        public static final int WGS84_UTM_zone_27S = 32727;
        public static final int WGS84_UTM_zone_28S = 32728;
        public static final int WGS84_UTM_zone_29S = 32729;
        public static final int WGS84_UTM_zone_30S = 32730;
        public static final int WGS84_UTM_zone_31S = 32731;
        public static final int WGS84_UTM_zone_32S = 32732;
        public static final int WGS84_UTM_zone_33S = 32733;
        public static final int WGS84_UTM_zone_34S = 32734;
        public static final int WGS84_UTM_zone_35S = 32735;
        public static final int WGS84_UTM_zone_36S = 32736;
        public static final int WGS84_UTM_zone_37S = 32737;
        public static final int WGS84_UTM_zone_38S = 32738;
        public static final int WGS84_UTM_zone_39S = 32739;
        public static final int WGS84_UTM_zone_40S = 32740;
        public static final int WGS84_UTM_zone_41S = 32741;
        public static final int WGS84_UTM_zone_42S = 32742;
        public static final int WGS84_UTM_zone_43S = 32743;
        public static final int WGS84_UTM_zone_44S = 32744;
        public static final int WGS84_UTM_zone_45S = 32745;
        public static final int WGS84_UTM_zone_46S = 32746;
        public static final int WGS84_UTM_zone_47S = 32747;
        public static final int WGS84_UTM_zone_48S = 32748;
        public static final int WGS84_UTM_zone_49S = 32749;
        public static final int WGS84_UTM_zone_50S = 32750;
        public static final int WGS84_UTM_zone_51S = 32751;
        public static final int WGS84_UTM_zone_52S = 32752;
        public static final int WGS84_UTM_zone_53S = 32753;
        public static final int WGS84_UTM_zone_54S = 32754;
        public static final int WGS84_UTM_zone_55S = 32755;
        public static final int WGS84_UTM_zone_56S = 32756;
        public static final int WGS84_UTM_zone_57S = 32757;
        public static final int WGS84_UTM_zone_58S = 32758;
        public static final int WGS84_UTM_zone_59S = 32759;
        public static final int WGS84_UTM_zone_60S = 32760;
        public static final int[] values = new int[]{20137, 20138, 20248, 20249, 20250, 20251, 20252, 20253, 20254, 20255, 20256, 20257, 20258, 20348, 20349, 20350, 20351, 20352, 20353, 20354, 20355, 20356, 20357, 20358, 20437, 20438, 20439, 20499, 20538, 20539, 20700, 20822, 20823, 20824, 20973, 20975, 20977, 20979, 20981, 20983, 20985, 20987, 20989, 20991, 20993, 20995, 21100, 21148, 21149, 21150, 21413, 21414, 21415, 21416, 21417, 21418, 21419, 21420, 21421, 21422, 21423, 21473, 21474, 21475, 21476, 21477, 21478, 21479, 21480, 21481, 21482, 21483, 21500, 21790, 21817, 21818, 21891, 21892, 21893, 21894, 22032, 22033, 22191, 22192, 22193, 22194, 22195, 22196, 22197, 22332, 22391, 22392, 22523, 22524, 22832, 22992, 22993, 22994, 23028, 23029, 23030, 23031, 23032, 23033, 23034, 23035, 23036, 23037, 23038, 23239, 23240, 23433, 23846, 23847, 23848, 23849, 23850, 23851, 23852, 23853, 23886, 23887, 23888, 23889, 23890, 23891, 23892, 23893, 23894, 23947, 23948, 24047, 24048, 24100, 24200, 24370, 24371, 24372, 24373, 24374, 24382, 24383, 24384, 24500, 24547, 24548, 24720, 24721, 24818, 24819, 24820, 24821, 24877, 24878, 24879, 24880, 24891, 24892, 24893, 25000, 25231, 25391, 25392, 25393, 25394, 25395, 25700, 25932, 26191, 26192, 26193, 26237, 26331, 26332, 26391, 26392, 26393, 26432, 26591, 26592, 26632, 26692, 26703, 26704, 26705, 26706, 26707, 26708, 26709, 26710, 26711, 26712, 26713, 26714, 26715, 26716, 26717, 26718, 26719, 26720, 26721, 26722, 26729, 26730, 26731, 26732, 26733, 26734, 26735, 26736, 26737, 26738, 26739, 26740, 26741, 26742, 26743, 26744, 26745, 26746, 26747, 26748, 26749, 26750, 26751, 26752, 26753, 26754, 26755, 26756, 26757, 26758, 26759, 26760, 26761, 26762, 26763, 26764, 26765, 26766, 26767, 26768, 26769, 26770, 26771, 26772, 26773, 26774, 26774, 26775, 26775, 26776, 26776, 26777, 26777, 26778, 26779, 26780, 26781, 26782, 26783, 26784, 26785, 26786, 26787, 26788, 26789, 26790, 26791, 26792, 26793, 26794, 26795, 26796, 26797, 26798, 26801, 26802, 26803, 26903, 26904, 26905, 26906, 26907, 26908, 26909, 26910, 26911, 26912, 26913, 26914, 26915, 26916, 26917, 26918, 26919, 26920, 26921, 26922, 26923, 26929, 26930, 26931, 26932, 26933, 26934, 26935, 26936, 26937, 26938, 26939, 26940, 26941, 26942, 26943, 26944, 26945, 26946, 26948, 26949, 26950, 26951, 26952, 26953, 26954, 26955, 26956, 26957, 26958, 26959, 26960, 26961, 26962, 26963, 26964, 26965, 26966, 26967, 26968, 26969, 26970, 26971, 26972, 26973, 26974, 26975, 26976, 26977, 26978, 26979, 26980, 26981, 26982, 26983, 26984, 26985, 26986, 26987, 26988, 26989, 26990, 26991, 26992, 26993, 26994, 26995, 26996, 26997, 26998, 27038, 27039, 27040, 27120, 27200, 27291, 27292, 27429, 27500, 27581, 27582, 27583, 27591, 27592, 27593, 27700, 28232, 28348, 28349, 28350, 28351, 28352, 28353, 28354, 28355, 28356, 28357, 28358, 28404, 28405, 28406, 28407, 28408, 28409, 28410, 28411, 28412, 28413, 28414, 28415, 28416, 28417, 28418, 28419, 28420, 28421, 28422, 28423, 28424, 28425, 28426, 28427, 28428, 28429, 28430, 28431, 28432, 28464, 28465, 28466, 28467, 28468, 28469, 28470, 28471, 28472, 28473, 28474, 28475, 28476, 28477, 28478, 28479, 28480, 28481, 28482, 28483, 28484, 28485, 28486, 28487, 28488, 28489, 28490, 28491, 28492, 28600, 28991, 28992, 29118, 29119, 29120, 29121, 29122, 29177, 29178, 29179, 29180, 29181, 29182, 29183, 29184, 29185, 29220, 29221, 29333, 29635, 29636, 29700, 29738, 29739, 29800, 29849, 29850, 29900, 30200, 30339, 30340, 30491, 30492, 30591, 30592, 30600, 30729, 30730, 30731, 30732, 31028, 31121, 31291, 31292, 31293, 31300, 31491, 31492, 31493, 31494, 31495, 32001, 32002, 32003, 32005, 32006, 32007, 32008, 32009, 32010, 32011, 32012, 32013, 32014, 32015, 32016, 32017, 32018, 32019, 32020, 32021, 32022, 32023, 32024, 32025, 32026, 32027, 32028, 32029, 32030, 32031, 32033, 32034, 32035, 32036, 32037, 32038, 32039, 32040, 32041, 32042, 32043, 32044, 32045, 32046, 32047, 32048, 32049, 32050, 32051, 32052, 32053, 32054, 32055, 32056, 32057, 32058, 32059, 32060, 32100, 32104, 32107, 32108, 32109, 32110, 32111, 32112, 32113, 32114, 32115, 32116, 32117, 32118, 32119, 32120, 32121, 32122, 32123, 32124, 32125, 32126, 32127, 32128, 32129, 32130, 32133, 32134, 32135, 32136, 32137, 32138, 32139, 32140, 32141, 32142, 32143, 32144, 32145, 32146, 32147, 32148, 32149, 32150, 32151, 32152, 32153, 32154, 32155, 32156, 32157, 32158, 32161, 32201, 32202, 32203, 32204, 32205, 32206, 32207, 32208, 32209, 32210, 32211, 32212, 32213, 32214, 32215, 32216, 32217, 32218, 32219, 32220, 32221, 32222, 32223, 32224, 32225, 32226, 32227, 32228, 32229, 32230, 32231, 32232, 32233, 32234, 32235, 32236, 32237, 32238, 32239, 32240, 32241, 32242, 32243, 32244, 32245, 32246, 32247, 32248, 32249, 32250, 32251, 32252, 32253, 32254, 32255, 32256, 32257, 32258, 32259, 32260, 32301, 32302, 32303, 32304, 32305, 32306, 32307, 32308, 32309, 32310, 32311, 32312, 32313, 32314, 32315, 32316, 32317, 32318, 32319, 32320, 32321, 32322, 32323, 32324, 32325, 32326, 32327, 32328, 32329, 32330, 32331, 32332, 32333, 32334, 32335, 32336, 32337, 32338, 32339, 32340, 32341, 32342, 32343, 32344, 32345, 32346, 32347, 32348, 32349, 32350, 32351, 32352, 32353, 32354, 32355, 32356, 32357, 32358, 32359, 32360, 32401, 32402, 32403, 32404, 32405, 32406, 32407, 32408, 32409, 32410, 32411, 32412, 32413, 32414, 32415, 32416, 32417, 32418, 32419, 32420, 32421, 32422, 32423, 32424, 32425, 32426, 32427, 32428, 32429, 32430, 32431, 32432, 32433, 32434, 32435, 32436, 32437, 32438, 32439, 32440, 32441, 32442, 32443, 32444, 32445, 32446, 32447, 32448, 32449, 32450, 32451, 32452, 32453, 32454, 32455, 32456, 32457, 32458, 32459, 32460, 32501, 32502, 32503, 32504, 32505, 32506, 32507, 32508, 32509, 32510, 32511, 32512, 32513, 32514, 32515, 32516, 32517, 32518, 32519, 32520, 32521, 32522, 32523, 32524, 32525, 32526, 32527, 32528, 32529, 32530, 32531, 32532, 32533, 32534, 32535, 32536, 32537, 32538, 32539, 32540, 32541, 32542, 32543, 32544, 32545, 32546, 32547, 32548, 32549, 32550, 32551, 32552, 32553, 32554, 32555, 32556, 32557, 32558, 32559, 32560, 32601, 32602, 32603, 32604, 32605, 32606, 32607, 32608, 32609, 32610, 32611, 32612, 32613, 32614, 32615, 32616, 32617, 32618, 32619, 32620, 32621, 32622, 32623, 32624, 32625, 32626, 32627, 32628, 32629, 32630, 32631, 32632, 32633, 32634, 32635, 32636, 32637, 32638, 32639, 32640, 32641, 32642, 32643, 32644, 32645, 32646, 32647, 32648, 32649, 32650, 32651, 32652, 32653, 32654, 32655, 32656, 32657, 32658, 32659, 32660, 32701, 32702, 32703, 32704, 32705, 32706, 32707, 32708, 32709, 32710, 32711, 32712, 32713, 32714, 32715, 32716, 32717, 32718, 32719, 32720, 32721, 32722, 32723, 32724, 32725, 32726, 32727, 32728, 32729, 32730, 32731, 32732, 32733, 32734, 32735, 32736, 32737, 32738, 32739, 32740, 32741, 32742, 32743, 32744, 32745, 32746, 32747, 32748, 32749, 32750, 32751, 32752, 32753, 32754, 32755, 32756, 32757, 32758, 32759, 32760};
        public static final String[] names = new String[]{"PCS_Adindan_UTM_zone_37N", "PCS_Adindan_UTM_zone_38N", "PCS_AGD66_AMG_zone_48", "PCS_AGD66_AMG_zone_49", "PCS_AGD66_AMG_zone_50", "PCS_AGD66_AMG_zone_51", "PCS_AGD66_AMG_zone_52", "PCS_AGD66_AMG_zone_53", "PCS_AGD66_AMG_zone_54", "PCS_AGD66_AMG_zone_55", "PCS_AGD66_AMG_zone_56", "PCS_AGD66_AMG_zone_57", "PCS_AGD66_AMG_zone_58", "PCS_AGD84_AMG_zone_48", "PCS_AGD84_AMG_zone_49", "PCS_AGD84_AMG_zone_50", "PCS_AGD84_AMG_zone_51", "PCS_AGD84_AMG_zone_52", "PCS_AGD84_AMG_zone_53", "PCS_AGD84_AMG_zone_54", "PCS_AGD84_AMG_zone_55", "PCS_AGD84_AMG_zone_56", "PCS_AGD84_AMG_zone_57", "PCS_AGD84_AMG_zone_58", "PCS_Ain_el_Abd_UTM_zone_37N", "PCS_Ain_el_Abd_UTM_zone_38N", "PCS_Ain_el_Abd_UTM_zone_39N", "PCS_Ain_el_Abd_Bahrain_Grid", "PCS_Afgooye_UTM_zone_38N", "PCS_Afgooye_UTM_zone_39N", "PCS_Lisbon_Portugese_Grid", "PCS_Aratu_UTM_zone_22S", "PCS_Aratu_UTM_zone_23S", "PCS_Aratu_UTM_zone_24S", "PCS_Arc_1950_Lo13", "PCS_Arc_1950_Lo15", "PCS_Arc_1950_Lo17", "PCS_Arc_1950_Lo19", "PCS_Arc_1950_Lo21", "PCS_Arc_1950_Lo23", "PCS_Arc_1950_Lo25", "PCS_Arc_1950_Lo27", "PCS_Arc_1950_Lo29", "PCS_Arc_1950_Lo31", "PCS_Arc_1950_Lo33", "PCS_Arc_1950_Lo35", "PCS_Batavia_NEIEZ", "PCS_Batavia_UTM_zone_48S", "PCS_Batavia_UTM_zone_49S", "PCS_Batavia_UTM_zone_50S", "PCS_Beijing_Gauss_zone_13", "PCS_Beijing_Gauss_zone_14", "PCS_Beijing_Gauss_zone_15", "PCS_Beijing_Gauss_zone_16", "PCS_Beijing_Gauss_zone_17", "PCS_Beijing_Gauss_zone_18", "PCS_Beijing_Gauss_zone_19", "PCS_Beijing_Gauss_zone_20", "PCS_Beijing_Gauss_zone_21", "PCS_Beijing_Gauss_zone_22", "PCS_Beijing_Gauss_zone_23", "PCS_Beijing_Gauss_13N", "PCS_Beijing_Gauss_14N", "PCS_Beijing_Gauss_15N", "PCS_Beijing_Gauss_16N", "PCS_Beijing_Gauss_17N", "PCS_Beijing_Gauss_18N", "PCS_Beijing_Gauss_19N", "PCS_Beijing_Gauss_20N", "PCS_Beijing_Gauss_21N", "PCS_Beijing_Gauss_22N", "PCS_Beijing_Gauss_23N", "PCS_Belge_Lambert_50", "PCS_Bern_1898_Swiss_Old", "PCS_Bogota_UTM_zone_17N", "PCS_Bogota_UTM_zone_18N", "PCS_Bogota_Colombia_3W", "PCS_Bogota_Colombia_Bogota", "PCS_Bogota_Colombia_3E", "PCS_Bogota_Colombia_6E", "PCS_Camacupa_UTM_32S", "PCS_Camacupa_UTM_33S", "PCS_C_Inchauspe_Argentina_1", "PCS_C_Inchauspe_Argentina_2", "PCS_C_Inchauspe_Argentina_3", "PCS_C_Inchauspe_Argentina_4", "PCS_C_Inchauspe_Argentina_5", "PCS_C_Inchauspe_Argentina_6", "PCS_C_Inchauspe_Argentina_7", "PCS_Carthage_UTM_zone_32N", "PCS_Carthage_Nord_Tunisie", "PCS_Carthage_Sud_Tunisie", "PCS_Corrego_Alegre_UTM_23S", "PCS_Corrego_Alegre_UTM_24S", "PCS_Douala_UTM_zone_32N", "PCS_Egypt_1907_Red_Belt", "PCS_Egypt_1907_Purple_Belt", "PCS_Egypt_1907_Ext_Purple", "PCS_ED50_UTM_zone_28N", "PCS_ED50_UTM_zone_29N", "PCS_ED50_UTM_zone_30N", "PCS_ED50_UTM_zone_31N", "PCS_ED50_UTM_zone_32N", "PCS_ED50_UTM_zone_33N", "PCS_ED50_UTM_zone_34N", "PCS_ED50_UTM_zone_35N", "PCS_ED50_UTM_zone_36N", "PCS_ED50_UTM_zone_37N", "PCS_ED50_UTM_zone_38N", "PCS_Fahud_UTM_zone_39N", "PCS_Fahud_UTM_zone_40N", "PCS_Garoua_UTM_zone_33N", "PCS_ID74_UTM_zone_46N", "PCS_ID74_UTM_zone_47N", "PCS_ID74_UTM_zone_48N", "PCS_ID74_UTM_zone_49N", "PCS_ID74_UTM_zone_50N", "PCS_ID74_UTM_zone_51N", "PCS_ID74_UTM_zone_52N", "PCS_ID74_UTM_zone_53N", "PCS_ID74_UTM_zone_46S", "PCS_ID74_UTM_zone_47S", "PCS_ID74_UTM_zone_48S", "PCS_ID74_UTM_zone_49S", "PCS_ID74_UTM_zone_50S", "PCS_ID74_UTM_zone_51S", "PCS_ID74_UTM_zone_52S", "PCS_ID74_UTM_zone_53S", "PCS_ID74_UTM_zone_54S", "PCS_Indian_1954_UTM_47N", "PCS_Indian_1954_UTM_48N", "PCS_Indian_1975_UTM_47N", "PCS_Indian_1975_UTM_48N", "PCS_Jamaica_1875_Old_Grid", "PCS_JAD69_Jamaica_Grid", "PCS_Kalianpur_India_0", "PCS_Kalianpur_India_I", "PCS_Kalianpur_India_IIa", "PCS_Kalianpur_India_IIIa", "PCS_Kalianpur_India_IVa", "PCS_Kalianpur_India_IIb", "PCS_Kalianpur_India_IIIb", "PCS_Kalianpur_India_IVb", "PCS_Kertau_Singapore_Grid", "PCS_Kertau_UTM_zone_47N", "PCS_Kertau_UTM_zone_48N", "PCS_La_Canoa_UTM_zone_20N", "PCS_La_Canoa_UTM_zone_21N", "PCS_PSAD56_UTM_zone_18N", "PCS_PSAD56_UTM_zone_19N", "PCS_PSAD56_UTM_zone_20N", "PCS_PSAD56_UTM_zone_21N", "PCS_PSAD56_UTM_zone_17S", "PCS_PSAD56_UTM_zone_18S", "PCS_PSAD56_UTM_zone_19S", "PCS_PSAD56_UTM_zone_20S", "PCS_PSAD56_Peru_west_zone", "PCS_PSAD56_Peru_central", "PCS_PSAD56_Peru_east_zone", "PCS_Leigon_Ghana_Grid", "PCS_Lome_UTM_zone_31N", "PCS_Luzon_Philippines_I", "PCS_Luzon_Philippines_II", "PCS_Luzon_Philippines_III", "PCS_Luzon_Philippines_IV", "PCS_Luzon_Philippines_V", "PCS_Makassar_NEIEZ", "PCS_Malongo_1987_UTM_32S", "PCS_Merchich_Nord_Maroc", "PCS_Merchich_Sud_Maroc", "PCS_Merchich_Sahara", "PCS_Massawa_UTM_zone_37N", "PCS_Minna_UTM_zone_31N", "PCS_Minna_UTM_zone_32N", "PCS_Minna_Nigeria_West", "PCS_Minna_Nigeria_Mid_Belt", "PCS_Minna_Nigeria_East", "PCS_Mhast_UTM_zone_32S", "PCS_Monte_Mario_Italy_1", "PCS_Monte_Mario_Italy_2", "PCS_M_poraloko_UTM_32N", "PCS_M_poraloko_UTM_32S", "PCS_NAD27_UTM_zone_3N", "PCS_NAD27_UTM_zone_4N", "PCS_NAD27_UTM_zone_5N", "PCS_NAD27_UTM_zone_6N", "PCS_NAD27_UTM_zone_7N", "PCS_NAD27_UTM_zone_8N", "PCS_NAD27_UTM_zone_9N", "PCS_NAD27_UTM_zone_10N", "PCS_NAD27_UTM_zone_11N", "PCS_NAD27_UTM_zone_12N", "PCS_NAD27_UTM_zone_13N", "PCS_NAD27_UTM_zone_14N", "PCS_NAD27_UTM_zone_15N", "PCS_NAD27_UTM_zone_16N", "PCS_NAD27_UTM_zone_17N", "PCS_NAD27_UTM_zone_18N", "PCS_NAD27_UTM_zone_19N", "PCS_NAD27_UTM_zone_20N", "PCS_NAD27_UTM_zone_21N", "PCS_NAD27_UTM_zone_22N", "PCS_NAD27_Alabama_East", "PCS_NAD27_Alabama_West", "PCS_NAD27_Alaska_zone_1", "PCS_NAD27_Alaska_zone_2", "PCS_NAD27_Alaska_zone_3", "PCS_NAD27_Alaska_zone_4", "PCS_NAD27_Alaska_zone_5", "PCS_NAD27_Alaska_zone_6", "PCS_NAD27_Alaska_zone_7", "PCS_NAD27_Alaska_zone_8", "PCS_NAD27_Alaska_zone_9", "PCS_NAD27_Alaska_zone_10", "PCS_NAD27_California_I", "PCS_NAD27_California_II", "PCS_NAD27_California_III", "PCS_NAD27_California_IV", "PCS_NAD27_California_V", "PCS_NAD27_California_VI", "PCS_NAD27_California_VII", "PCS_NAD27_Arizona_East", "PCS_NAD27_Arizona_Central", "PCS_NAD27_Arizona_West", "PCS_NAD27_Arkansas_North", "PCS_NAD27_Arkansas_South", "PCS_NAD27_Colorado_North", "PCS_NAD27_Colorado_Central", "PCS_NAD27_Colorado_South", "PCS_NAD27_Connecticut", "PCS_NAD27_Delaware", "PCS_NAD27_Florida_East", "PCS_NAD27_Florida_West", "PCS_NAD27_Florida_North", "PCS_NAD27_Hawaii_zone_1", "PCS_NAD27_Hawaii_zone_2", "PCS_NAD27_Hawaii_zone_3", "PCS_NAD27_Hawaii_zone_4", "PCS_NAD27_Hawaii_zone_5", "PCS_NAD27_Georgia_East", "PCS_NAD27_Georgia_West", "PCS_NAD27_Idaho_East", "PCS_NAD27_Idaho_Central", "PCS_NAD27_Idaho_West", "PCS_NAD27_Illinois_East", "PCS_NAD27_Illinois_West", "PCS_NAD27_Indiana_East", "PCS_NAD27_BLM_14N_feet", "PCS_NAD27_Indiana_West", "PCS_NAD27_BLM_15N_feet", "PCS_NAD27_Iowa_North", "PCS_NAD27_BLM_16N_feet", "PCS_NAD27_Iowa_South", "PCS_NAD27_BLM_17N_feet", "PCS_NAD27_Kansas_North", "PCS_NAD27_Kansas_South", "PCS_NAD27_Kentucky_North", "PCS_NAD27_Kentucky_South", "PCS_NAD27_Louisiana_North", "PCS_NAD27_Louisiana_South", "PCS_NAD27_Maine_East", "PCS_NAD27_Maine_West", "PCS_NAD27_Maryland", "PCS_NAD27_Massachusetts", "PCS_NAD27_Massachusetts_Is", "PCS_NAD27_Michigan_North", "PCS_NAD27_Michigan_Central", "PCS_NAD27_Michigan_South", "PCS_NAD27_Minnesota_North", "PCS_NAD27_Minnesota_Cent", "PCS_NAD27_Minnesota_South", "PCS_NAD27_Mississippi_East", "PCS_NAD27_Mississippi_West", "PCS_NAD27_Missouri_East", "PCS_NAD27_Missouri_Central", "PCS_NAD27_Missouri_West", "PCS_NAD_Michigan_Michigan_East", "PCS_NAD_Michigan_Michigan_Old_Central", "PCS_NAD_Michigan_Michigan_West", "PCS_NAD83_UTM_zone_3N", "PCS_NAD83_UTM_zone_4N", "PCS_NAD83_UTM_zone_5N", "PCS_NAD83_UTM_zone_6N", "PCS_NAD83_UTM_zone_7N", "PCS_NAD83_UTM_zone_8N", "PCS_NAD83_UTM_zone_9N", "PCS_NAD83_UTM_zone_10N", "PCS_NAD83_UTM_zone_11N", "PCS_NAD83_UTM_zone_12N", "PCS_NAD83_UTM_zone_13N", "PCS_NAD83_UTM_zone_14N", "PCS_NAD83_UTM_zone_15N", "PCS_NAD83_UTM_zone_16N", "PCS_NAD83_UTM_zone_17N", "PCS_NAD83_UTM_zone_18N", "PCS_NAD83_UTM_zone_19N", "PCS_NAD83_UTM_zone_20N", "PCS_NAD83_UTM_zone_21N", "PCS_NAD83_UTM_zone_22N", "PCS_NAD83_UTM_zone_23N", "PCS_NAD83_Alabama_East", "PCS_NAD83_Alabama_West", "PCS_NAD83_Alaska_zone_1", "PCS_NAD83_Alaska_zone_2", "PCS_NAD83_Alaska_zone_3", "PCS_NAD83_Alaska_zone_4", "PCS_NAD83_Alaska_zone_5", "PCS_NAD83_Alaska_zone_6", "PCS_NAD83_Alaska_zone_7", "PCS_NAD83_Alaska_zone_8", "PCS_NAD83_Alaska_zone_9", "PCS_NAD83_Alaska_zone_10", "PCS_NAD83_California_1", "PCS_NAD83_California_2", "PCS_NAD83_California_3", "PCS_NAD83_California_4", "PCS_NAD83_California_5", "PCS_NAD83_California_6", "PCS_NAD83_Arizona_East", "PCS_NAD83_Arizona_Central", "PCS_NAD83_Arizona_West", "PCS_NAD83_Arkansas_North", "PCS_NAD83_Arkansas_South", "PCS_NAD83_Colorado_North", "PCS_NAD83_Colorado_Central", "PCS_NAD83_Colorado_South", "PCS_NAD83_Connecticut", "PCS_NAD83_Delaware", "PCS_NAD83_Florida_East", "PCS_NAD83_Florida_West", "PCS_NAD83_Florida_North", "PCS_NAD83_Hawaii_zone_1", "PCS_NAD83_Hawaii_zone_2", "PCS_NAD83_Hawaii_zone_3", "PCS_NAD83_Hawaii_zone_4", "PCS_NAD83_Hawaii_zone_5", "PCS_NAD83_Georgia_East", "PCS_NAD83_Georgia_West", "PCS_NAD83_Idaho_East", "PCS_NAD83_Idaho_Central", "PCS_NAD83_Idaho_West", "PCS_NAD83_Illinois_East", "PCS_NAD83_Illinois_West", "PCS_NAD83_Indiana_East", "PCS_NAD83_Indiana_West", "PCS_NAD83_Iowa_North", "PCS_NAD83_Iowa_South", "PCS_NAD83_Kansas_North", "PCS_NAD83_Kansas_South", "PCS_NAD83_Kentucky_North", "PCS_NAD83_Kentucky_South", "PCS_NAD83_Louisiana_North", "PCS_NAD83_Louisiana_South", "PCS_NAD83_Maine_East", "PCS_NAD83_Maine_West", "PCS_NAD83_Maryland", "PCS_NAD83_Massachusetts", "PCS_NAD83_Massachusetts_Is", "PCS_NAD83_Michigan_North", "PCS_NAD83_Michigan_Central", "PCS_NAD83_Michigan_South", "PCS_NAD83_Minnesota_North", "PCS_NAD83_Minnesota_Cent", "PCS_NAD83_Minnesota_South", "PCS_NAD83_Mississippi_East", "PCS_NAD83_Mississippi_West", "PCS_NAD83_Missouri_East", "PCS_NAD83_Missouri_Central", "PCS_NAD83_Missouri_West", "PCS_Nahrwan_1967_UTM_38N", "PCS_Nahrwan_1967_UTM_39N", "PCS_Nahrwan_1967_UTM_40N", "PCS_Naparima_UTM_20N", "PCS_GD49_NZ_Map_Grid", "PCS_GD49_North_Island_Grid", "PCS_GD49_South_Island_Grid", "PCS_Datum_73_UTM_zone_29N", "PCS_ATF_Nord_de_Guerre", "PCS_NTF_France_I", "PCS_NTF_France_II", "PCS_NTF_France_III", "PCS_NTF_Nord_France", "PCS_NTF_Centre_France", "PCS_NTF_Sud_France", "PCS_British_National_Grid", "PCS_Point_Noire_UTM_32S", "PCS_GDA94_MGA_zone_48", "PCS_GDA94_MGA_zone_49", "PCS_GDA94_MGA_zone_50", "PCS_GDA94_MGA_zone_51", "PCS_GDA94_MGA_zone_52", "PCS_GDA94_MGA_zone_53", "PCS_GDA94_MGA_zone_54", "PCS_GDA94_MGA_zone_55", "PCS_GDA94_MGA_zone_56", "PCS_GDA94_MGA_zone_57", "PCS_GDA94_MGA_zone_58", "PCS_Pulkovo_Gauss_zone_4", "PCS_Pulkovo_Gauss_zone_5", "PCS_Pulkovo_Gauss_zone_6", "PCS_Pulkovo_Gauss_zone_7", "PCS_Pulkovo_Gauss_zone_8", "PCS_Pulkovo_Gauss_zone_9", "PCS_Pulkovo_Gauss_zone_10", "PCS_Pulkovo_Gauss_zone_11", "PCS_Pulkovo_Gauss_zone_12", "PCS_Pulkovo_Gauss_zone_13", "PCS_Pulkovo_Gauss_zone_14", "PCS_Pulkovo_Gauss_zone_15", "PCS_Pulkovo_Gauss_zone_16", "PCS_Pulkovo_Gauss_zone_17", "PCS_Pulkovo_Gauss_zone_18", "PCS_Pulkovo_Gauss_zone_19", "PCS_Pulkovo_Gauss_zone_20", "PCS_Pulkovo_Gauss_zone_21", "PCS_Pulkovo_Gauss_zone_22", "PCS_Pulkovo_Gauss_zone_23", "PCS_Pulkovo_Gauss_zone_24", "PCS_Pulkovo_Gauss_zone_25", "PCS_Pulkovo_Gauss_zone_26", "PCS_Pulkovo_Gauss_zone_27", "PCS_Pulkovo_Gauss_zone_28", "PCS_Pulkovo_Gauss_zone_29", "PCS_Pulkovo_Gauss_zone_30", "PCS_Pulkovo_Gauss_zone_31", "PCS_Pulkovo_Gauss_zone_32", "PCS_Pulkovo_Gauss_4N", "PCS_Pulkovo_Gauss_5N", "PCS_Pulkovo_Gauss_6N", "PCS_Pulkovo_Gauss_7N", "PCS_Pulkovo_Gauss_8N", "PCS_Pulkovo_Gauss_9N", "PCS_Pulkovo_Gauss_10N", "PCS_Pulkovo_Gauss_11N", "PCS_Pulkovo_Gauss_12N", "PCS_Pulkovo_Gauss_13N", "PCS_Pulkovo_Gauss_14N", "PCS_Pulkovo_Gauss_15N", "PCS_Pulkovo_Gauss_16N", "PCS_Pulkovo_Gauss_17N", "PCS_Pulkovo_Gauss_18N", "PCS_Pulkovo_Gauss_19N", "PCS_Pulkovo_Gauss_20N", "PCS_Pulkovo_Gauss_21N", "PCS_Pulkovo_Gauss_22N", "PCS_Pulkovo_Gauss_23N", "PCS_Pulkovo_Gauss_24N", "PCS_Pulkovo_Gauss_25N", "PCS_Pulkovo_Gauss_26N", "PCS_Pulkovo_Gauss_27N", "PCS_Pulkovo_Gauss_28N", "PCS_Pulkovo_Gauss_29N", "PCS_Pulkovo_Gauss_30N", "PCS_Pulkovo_Gauss_31N", "PCS_Pulkovo_Gauss_32N", "PCS_Qatar_National_Grid", "PCS_RD_Netherlands_Old", "PCS_RD_Netherlands_New", "PCS_SAD69_UTM_zone_18N", "PCS_SAD69_UTM_zone_19N", "PCS_SAD69_UTM_zone_20N", "PCS_SAD69_UTM_zone_21N", "PCS_SAD69_UTM_zone_22N", "PCS_SAD69_UTM_zone_17S", "PCS_SAD69_UTM_zone_18S", "PCS_SAD69_UTM_zone_19S", "PCS_SAD69_UTM_zone_20S", "PCS_SAD69_UTM_zone_21S", "PCS_SAD69_UTM_zone_22S", "PCS_SAD69_UTM_zone_23S", "PCS_SAD69_UTM_zone_24S", "PCS_SAD69_UTM_zone_25S", "PCS_Sapper_Hill_UTM_20S", "PCS_Sapper_Hill_UTM_21S", "PCS_Schwarzeck_UTM_33S", "PCS_Sudan_UTM_zone_35N", "PCS_Sudan_UTM_zone_36N", "PCS_Tananarive_Laborde", "PCS_Tananarive_UTM_38S", "PCS_Tananarive_UTM_39S", "PCS_Timbalai_1948_Borneo", "PCS_Timbalai_1948_UTM_49N", "PCS_Timbalai_1948_UTM_50N", "PCS_TM65_Irish_Nat_Grid", "PCS_Trinidad_1903_Trinidad", "PCS_TC_1948_UTM_zone_39N", "PCS_TC_1948_UTM_zone_40N", "PCS_Voirol_N_Algerie_ancien", "PCS_Voirol_S_Algerie_ancien", "PCS_Voirol_Unifie_N_Algerie", "PCS_Voirol_Unifie_S_Algerie", "PCS_Bern_1938_Swiss_New", "PCS_Nord_Sahara_UTM_29N", "PCS_Nord_Sahara_UTM_30N", "PCS_Nord_Sahara_UTM_31N", "PCS_Nord_Sahara_UTM_32N", "PCS_Yoff_UTM_zone_28N", "PCS_Zanderij_UTM_zone_21N", "PCS_MGI_Austria_West", "PCS_MGI_Austria_Central", "PCS_MGI_Austria_East", "PCS_Belge_Lambert_72", "PCS_DHDN_Germany_zone_1", "PCS_DHDN_Germany_zone_2", "PCS_DHDN_Germany_zone_3", "PCS_DHDN_Germany_zone_4", "PCS_DHDN_Germany_zone_5", "PCS_NAD27_Montana_North", "PCS_NAD27_Montana_Central", "PCS_NAD27_Montana_South", "PCS_NAD27_Nebraska_North", "PCS_NAD27_Nebraska_South", "PCS_NAD27_Nevada_East", "PCS_NAD27_Nevada_Central", "PCS_NAD27_Nevada_West", "PCS_NAD27_New_Hampshire", "PCS_NAD27_New_Jersey", "PCS_NAD27_New_Mexico_East", "PCS_NAD27_New_Mexico_Cent", "PCS_NAD27_New_Mexico_West", "PCS_NAD27_New_York_East", "PCS_NAD27_New_York_Central", "PCS_NAD27_New_York_West", "PCS_NAD27_New_York_Long_Is", "PCS_NAD27_North_Carolina", "PCS_NAD27_North_Dakota_N", "PCS_NAD27_North_Dakota_S", "PCS_NAD27_Ohio_North", "PCS_NAD27_Ohio_South", "PCS_NAD27_Oklahoma_North", "PCS_NAD27_Oklahoma_South", "PCS_NAD27_Oregon_North", "PCS_NAD27_Oregon_South", "PCS_NAD27_Pennsylvania_N", "PCS_NAD27_Pennsylvania_S", "PCS_NAD27_Rhode_Island", "PCS_NAD27_South_Carolina_N", "PCS_NAD27_South_Carolina_S", "PCS_NAD27_South_Dakota_N", "PCS_NAD27_South_Dakota_S", "PCS_NAD27_Tennessee", "PCS_NAD27_Texas_North", "PCS_NAD27_Texas_North_Cen", "PCS_NAD27_Texas_Central", "PCS_NAD27_Texas_South_Cen", "PCS_NAD27_Texas_South", "PCS_NAD27_Utah_North", "PCS_NAD27_Utah_Central", "PCS_NAD27_Utah_South", "PCS_NAD27_Vermont", "PCS_NAD27_Virginia_North", "PCS_NAD27_Virginia_South", "PCS_NAD27_Washington_North", "PCS_NAD27_Washington_South", "PCS_NAD27_West_Virginia_N", "PCS_NAD27_West_Virginia_S", "PCS_NAD27_Wisconsin_North", "PCS_NAD27_Wisconsin_Cen", "PCS_NAD27_Wisconsin_South", "PCS_NAD27_Wyoming_East", "PCS_NAD27_Wyoming_E_Cen", "PCS_NAD27_Wyoming_W_Cen", "PCS_NAD27_Wyoming_West", "PCS_NAD27_Puerto_Rico", "PCS_NAD27_St_Croix", "PCS_NAD83_Montana", "PCS_NAD83_Nebraska", "PCS_NAD83_Nevada_East", "PCS_NAD83_Nevada_Central", "PCS_NAD83_Nevada_West", "PCS_NAD83_New_Hampshire", "PCS_NAD83_New_Jersey", "PCS_NAD83_New_Mexico_East", "PCS_NAD83_New_Mexico_Cent", "PCS_NAD83_New_Mexico_West", "PCS_NAD83_New_York_East", "PCS_NAD83_New_York_Central", "PCS_NAD83_New_York_West", "PCS_NAD83_New_York_Long_Is", "PCS_NAD83_North_Carolina", "PCS_NAD83_North_Dakota_N", "PCS_NAD83_North_Dakota_S", "PCS_NAD83_Ohio_North", "PCS_NAD83_Ohio_South", "PCS_NAD83_Oklahoma_North", "PCS_NAD83_Oklahoma_South", "PCS_NAD83_Oregon_North", "PCS_NAD83_Oregon_South", "PCS_NAD83_Pennsylvania_N", "PCS_NAD83_Pennsylvania_S", "PCS_NAD83_Rhode_Island", "PCS_NAD83_South_Carolina", "PCS_NAD83_South_Dakota_N", "PCS_NAD83_South_Dakota_S", "PCS_NAD83_Tennessee", "PCS_NAD83_Texas_North", "PCS_NAD83_Texas_North_Cen", "PCS_NAD83_Texas_Central", "PCS_NAD83_Texas_South_Cen", "PCS_NAD83_Texas_South", "PCS_NAD83_Utah_North", "PCS_NAD83_Utah_Central", "PCS_NAD83_Utah_South", "PCS_NAD83_Vermont", "PCS_NAD83_Virginia_North", "PCS_NAD83_Virginia_South", "PCS_NAD83_Washington_North", "PCS_NAD83_Washington_South", "PCS_NAD83_West_Virginia_N", "PCS_NAD83_West_Virginia_S", "PCS_NAD83_Wisconsin_North", "PCS_NAD83_Wisconsin_Cen", "PCS_NAD83_Wisconsin_South", "PCS_NAD83_Wyoming_East", "PCS_NAD83_Wyoming_E_Cen", "PCS_NAD83_Wyoming_W_Cen", "PCS_NAD83_Wyoming_West", "PCS_NAD83_Puerto_Rico_Virgin_Is", "PCS_WGS72_UTM_zone_1N", "PCS_WGS72_UTM_zone_2N", "PCS_WGS72_UTM_zone_3N", "PCS_WGS72_UTM_zone_4N", "PCS_WGS72_UTM_zone_5N", "PCS_WGS72_UTM_zone_6N", "PCS_WGS72_UTM_zone_7N", "PCS_WGS72_UTM_zone_8N", "PCS_WGS72_UTM_zone_9N", "PCS_WGS72_UTM_zone_10N", "PCS_WGS72_UTM_zone_11N", "PCS_WGS72_UTM_zone_12N", "PCS_WGS72_UTM_zone_13N", "PCS_WGS72_UTM_zone_14N", "PCS_WGS72_UTM_zone_15N", "PCS_WGS72_UTM_zone_16N", "PCS_WGS72_UTM_zone_17N", "PCS_WGS72_UTM_zone_18N", "PCS_WGS72_UTM_zone_19N", "PCS_WGS72_UTM_zone_20N", "PCS_WGS72_UTM_zone_21N", "PCS_WGS72_UTM_zone_22N", "PCS_WGS72_UTM_zone_23N", "PCS_WGS72_UTM_zone_24N", "PCS_WGS72_UTM_zone_25N", "PCS_WGS72_UTM_zone_26N", "PCS_WGS72_UTM_zone_27N", "PCS_WGS72_UTM_zone_28N", "PCS_WGS72_UTM_zone_29N", "PCS_WGS72_UTM_zone_30N", "PCS_WGS72_UTM_zone_31N", "PCS_WGS72_UTM_zone_32N", "PCS_WGS72_UTM_zone_33N", "PCS_WGS72_UTM_zone_34N", "PCS_WGS72_UTM_zone_35N", "PCS_WGS72_UTM_zone_36N", "PCS_WGS72_UTM_zone_37N", "PCS_WGS72_UTM_zone_38N", "PCS_WGS72_UTM_zone_39N", "PCS_WGS72_UTM_zone_40N", "PCS_WGS72_UTM_zone_41N", "PCS_WGS72_UTM_zone_42N", "PCS_WGS72_UTM_zone_43N", "PCS_WGS72_UTM_zone_44N", "PCS_WGS72_UTM_zone_45N", "PCS_WGS72_UTM_zone_46N", "PCS_WGS72_UTM_zone_47N", "PCS_WGS72_UTM_zone_48N", "PCS_WGS72_UTM_zone_49N", "PCS_WGS72_UTM_zone_50N", "PCS_WGS72_UTM_zone_51N", "PCS_WGS72_UTM_zone_52N", "PCS_WGS72_UTM_zone_53N", "PCS_WGS72_UTM_zone_54N", "PCS_WGS72_UTM_zone_55N", "PCS_WGS72_UTM_zone_56N", "PCS_WGS72_UTM_zone_57N", "PCS_WGS72_UTM_zone_58N", "PCS_WGS72_UTM_zone_59N", "PCS_WGS72_UTM_zone_60N", "PCS_WGS72_UTM_zone_1S", "PCS_WGS72_UTM_zone_2S", "PCS_WGS72_UTM_zone_3S", "PCS_WGS72_UTM_zone_4S", "PCS_WGS72_UTM_zone_5S", "PCS_WGS72_UTM_zone_6S", "PCS_WGS72_UTM_zone_7S", "PCS_WGS72_UTM_zone_8S", "PCS_WGS72_UTM_zone_9S", "PCS_WGS72_UTM_zone_10S", "PCS_WGS72_UTM_zone_11S", "PCS_WGS72_UTM_zone_12S", "PCS_WGS72_UTM_zone_13S", "PCS_WGS72_UTM_zone_14S", "PCS_WGS72_UTM_zone_15S", "PCS_WGS72_UTM_zone_16S", "PCS_WGS72_UTM_zone_17S", "PCS_WGS72_UTM_zone_18S", "PCS_WGS72_UTM_zone_19S", "PCS_WGS72_UTM_zone_20S", "PCS_WGS72_UTM_zone_21S", "PCS_WGS72_UTM_zone_22S", "PCS_WGS72_UTM_zone_23S", "PCS_WGS72_UTM_zone_24S", "PCS_WGS72_UTM_zone_25S", "PCS_WGS72_UTM_zone_26S", "PCS_WGS72_UTM_zone_27S", "PCS_WGS72_UTM_zone_28S", "PCS_WGS72_UTM_zone_29S", "PCS_WGS72_UTM_zone_30S", "PCS_WGS72_UTM_zone_31S", "PCS_WGS72_UTM_zone_32S", "PCS_WGS72_UTM_zone_33S", "PCS_WGS72_UTM_zone_34S", "PCS_WGS72_UTM_zone_35S", "PCS_WGS72_UTM_zone_36S", "PCS_WGS72_UTM_zone_37S", "PCS_WGS72_UTM_zone_38S", "PCS_WGS72_UTM_zone_39S", "PCS_WGS72_UTM_zone_40S", "PCS_WGS72_UTM_zone_41S", "PCS_WGS72_UTM_zone_42S", "PCS_WGS72_UTM_zone_43S", "PCS_WGS72_UTM_zone_44S", "PCS_WGS72_UTM_zone_45S", "PCS_WGS72_UTM_zone_46S", "PCS_WGS72_UTM_zone_47S", "PCS_WGS72_UTM_zone_48S", "PCS_WGS72_UTM_zone_49S", "PCS_WGS72_UTM_zone_50S", "PCS_WGS72_UTM_zone_51S", "PCS_WGS72_UTM_zone_52S", "PCS_WGS72_UTM_zone_53S", "PCS_WGS72_UTM_zone_54S", "PCS_WGS72_UTM_zone_55S", "PCS_WGS72_UTM_zone_56S", "PCS_WGS72_UTM_zone_57S", "PCS_WGS72_UTM_zone_58S", "PCS_WGS72_UTM_zone_59S", "PCS_WGS72_UTM_zone_60S", "PCS_WGS72BE_UTM_zone_1N", "PCS_WGS72BE_UTM_zone_2N", "PCS_WGS72BE_UTM_zone_3N", "PCS_WGS72BE_UTM_zone_4N", "PCS_WGS72BE_UTM_zone_5N", "PCS_WGS72BE_UTM_zone_6N", "PCS_WGS72BE_UTM_zone_7N", "PCS_WGS72BE_UTM_zone_8N", "PCS_WGS72BE_UTM_zone_9N", "PCS_WGS72BE_UTM_zone_10N", "PCS_WGS72BE_UTM_zone_11N", "PCS_WGS72BE_UTM_zone_12N", "PCS_WGS72BE_UTM_zone_13N", "PCS_WGS72BE_UTM_zone_14N", "PCS_WGS72BE_UTM_zone_15N", "PCS_WGS72BE_UTM_zone_16N", "PCS_WGS72BE_UTM_zone_17N", "PCS_WGS72BE_UTM_zone_18N", "PCS_WGS72BE_UTM_zone_19N", "PCS_WGS72BE_UTM_zone_20N", "PCS_WGS72BE_UTM_zone_21N", "PCS_WGS72BE_UTM_zone_22N", "PCS_WGS72BE_UTM_zone_23N", "PCS_WGS72BE_UTM_zone_24N", "PCS_WGS72BE_UTM_zone_25N", "PCS_WGS72BE_UTM_zone_26N", "PCS_WGS72BE_UTM_zone_27N", "PCS_WGS72BE_UTM_zone_28N", "PCS_WGS72BE_UTM_zone_29N", "PCS_WGS72BE_UTM_zone_30N", "PCS_WGS72BE_UTM_zone_31N", "PCS_WGS72BE_UTM_zone_32N", "PCS_WGS72BE_UTM_zone_33N", "PCS_WGS72BE_UTM_zone_34N", "PCS_WGS72BE_UTM_zone_35N", "PCS_WGS72BE_UTM_zone_36N", "PCS_WGS72BE_UTM_zone_37N", "PCS_WGS72BE_UTM_zone_38N", "PCS_WGS72BE_UTM_zone_39N", "PCS_WGS72BE_UTM_zone_40N", "PCS_WGS72BE_UTM_zone_41N", "PCS_WGS72BE_UTM_zone_42N", "PCS_WGS72BE_UTM_zone_43N", "PCS_WGS72BE_UTM_zone_44N", "PCS_WGS72BE_UTM_zone_45N", "PCS_WGS72BE_UTM_zone_46N", "PCS_WGS72BE_UTM_zone_47N", "PCS_WGS72BE_UTM_zone_48N", "PCS_WGS72BE_UTM_zone_49N", "PCS_WGS72BE_UTM_zone_50N", "PCS_WGS72BE_UTM_zone_51N", "PCS_WGS72BE_UTM_zone_52N", "PCS_WGS72BE_UTM_zone_53N", "PCS_WGS72BE_UTM_zone_54N", "PCS_WGS72BE_UTM_zone_55N", "PCS_WGS72BE_UTM_zone_56N", "PCS_WGS72BE_UTM_zone_57N", "PCS_WGS72BE_UTM_zone_58N", "PCS_WGS72BE_UTM_zone_59N", "PCS_WGS72BE_UTM_zone_60N", "PCS_WGS72BE_UTM_zone_1S", "PCS_WGS72BE_UTM_zone_2S", "PCS_WGS72BE_UTM_zone_3S", "PCS_WGS72BE_UTM_zone_4S", "PCS_WGS72BE_UTM_zone_5S", "PCS_WGS72BE_UTM_zone_6S", "PCS_WGS72BE_UTM_zone_7S", "PCS_WGS72BE_UTM_zone_8S", "PCS_WGS72BE_UTM_zone_9S", "PCS_WGS72BE_UTM_zone_10S", "PCS_WGS72BE_UTM_zone_11S", "PCS_WGS72BE_UTM_zone_12S", "PCS_WGS72BE_UTM_zone_13S", "PCS_WGS72BE_UTM_zone_14S", "PCS_WGS72BE_UTM_zone_15S", "PCS_WGS72BE_UTM_zone_16S", "PCS_WGS72BE_UTM_zone_17S", "PCS_WGS72BE_UTM_zone_18S", "PCS_WGS72BE_UTM_zone_19S", "PCS_WGS72BE_UTM_zone_20S", "PCS_WGS72BE_UTM_zone_21S", "PCS_WGS72BE_UTM_zone_22S", "PCS_WGS72BE_UTM_zone_23S", "PCS_WGS72BE_UTM_zone_24S", "PCS_WGS72BE_UTM_zone_25S", "PCS_WGS72BE_UTM_zone_26S", "PCS_WGS72BE_UTM_zone_27S", "PCS_WGS72BE_UTM_zone_28S", "PCS_WGS72BE_UTM_zone_29S", "PCS_WGS72BE_UTM_zone_30S", "PCS_WGS72BE_UTM_zone_31S", "PCS_WGS72BE_UTM_zone_32S", "PCS_WGS72BE_UTM_zone_33S", "PCS_WGS72BE_UTM_zone_34S", "PCS_WGS72BE_UTM_zone_35S", "PCS_WGS72BE_UTM_zone_36S", "PCS_WGS72BE_UTM_zone_37S", "PCS_WGS72BE_UTM_zone_38S", "PCS_WGS72BE_UTM_zone_39S", "PCS_WGS72BE_UTM_zone_40S", "PCS_WGS72BE_UTM_zone_41S", "PCS_WGS72BE_UTM_zone_42S", "PCS_WGS72BE_UTM_zone_43S", "PCS_WGS72BE_UTM_zone_44S", "PCS_WGS72BE_UTM_zone_45S", "PCS_WGS72BE_UTM_zone_46S", "PCS_WGS72BE_UTM_zone_47S", "PCS_WGS72BE_UTM_zone_48S", "PCS_WGS72BE_UTM_zone_49S", "PCS_WGS72BE_UTM_zone_50S", "PCS_WGS72BE_UTM_zone_51S", "PCS_WGS72BE_UTM_zone_52S", "PCS_WGS72BE_UTM_zone_53S", "PCS_WGS72BE_UTM_zone_54S", "PCS_WGS72BE_UTM_zone_55S", "PCS_WGS72BE_UTM_zone_56S", "PCS_WGS72BE_UTM_zone_57S", "PCS_WGS72BE_UTM_zone_58S", "PCS_WGS72BE_UTM_zone_59S", "PCS_WGS72BE_UTM_zone_60S", "PCS_WGS84_UTM_zone_1N", "PCS_WGS84_UTM_zone_2N", "PCS_WGS84_UTM_zone_3N", "PCS_WGS84_UTM_zone_4N", "PCS_WGS84_UTM_zone_5N", "PCS_WGS84_UTM_zone_6N", "PCS_WGS84_UTM_zone_7N", "PCS_WGS84_UTM_zone_8N", "PCS_WGS84_UTM_zone_9N", "PCS_WGS84_UTM_zone_10N", "PCS_WGS84_UTM_zone_11N", "PCS_WGS84_UTM_zone_12N", "PCS_WGS84_UTM_zone_13N", "PCS_WGS84_UTM_zone_14N", "PCS_WGS84_UTM_zone_15N", "PCS_WGS84_UTM_zone_16N", "PCS_WGS84_UTM_zone_17N", "PCS_WGS84_UTM_zone_18N", "PCS_WGS84_UTM_zone_19N", "PCS_WGS84_UTM_zone_20N", "PCS_WGS84_UTM_zone_21N", "PCS_WGS84_UTM_zone_22N", "PCS_WGS84_UTM_zone_23N", "PCS_WGS84_UTM_zone_24N", "PCS_WGS84_UTM_zone_25N", "PCS_WGS84_UTM_zone_26N", "PCS_WGS84_UTM_zone_27N", "PCS_WGS84_UTM_zone_28N", "PCS_WGS84_UTM_zone_29N", "PCS_WGS84_UTM_zone_30N", "PCS_WGS84_UTM_zone_31N", "PCS_WGS84_UTM_zone_32N", "PCS_WGS84_UTM_zone_33N", "PCS_WGS84_UTM_zone_34N", "PCS_WGS84_UTM_zone_35N", "PCS_WGS84_UTM_zone_36N", "PCS_WGS84_UTM_zone_37N", "PCS_WGS84_UTM_zone_38N", "PCS_WGS84_UTM_zone_39N", "PCS_WGS84_UTM_zone_40N", "PCS_WGS84_UTM_zone_41N", "PCS_WGS84_UTM_zone_42N", "PCS_WGS84_UTM_zone_43N", "PCS_WGS84_UTM_zone_44N", "PCS_WGS84_UTM_zone_45N", "PCS_WGS84_UTM_zone_46N", "PCS_WGS84_UTM_zone_47N", "PCS_WGS84_UTM_zone_48N", "PCS_WGS84_UTM_zone_49N", "PCS_WGS84_UTM_zone_50N", "PCS_WGS84_UTM_zone_51N", "PCS_WGS84_UTM_zone_52N", "PCS_WGS84_UTM_zone_53N", "PCS_WGS84_UTM_zone_54N", "PCS_WGS84_UTM_zone_55N", "PCS_WGS84_UTM_zone_56N", "PCS_WGS84_UTM_zone_57N", "PCS_WGS84_UTM_zone_58N", "PCS_WGS84_UTM_zone_59N", "PCS_WGS84_UTM_zone_60N", "PCS_WGS84_UTM_zone_1S", "PCS_WGS84_UTM_zone_2S", "PCS_WGS84_UTM_zone_3S", "PCS_WGS84_UTM_zone_4S", "PCS_WGS84_UTM_zone_5S", "PCS_WGS84_UTM_zone_6S", "PCS_WGS84_UTM_zone_7S", "PCS_WGS84_UTM_zone_8S", "PCS_WGS84_UTM_zone_9S", "PCS_WGS84_UTM_zone_10S", "PCS_WGS84_UTM_zone_11S", "PCS_WGS84_UTM_zone_12S", "PCS_WGS84_UTM_zone_13S", "PCS_WGS84_UTM_zone_14S", "PCS_WGS84_UTM_zone_15S", "PCS_WGS84_UTM_zone_16S", "PCS_WGS84_UTM_zone_17S", "PCS_WGS84_UTM_zone_18S", "PCS_WGS84_UTM_zone_19S", "PCS_WGS84_UTM_zone_20S", "PCS_WGS84_UTM_zone_21S", "PCS_WGS84_UTM_zone_22S", "PCS_WGS84_UTM_zone_23S", "PCS_WGS84_UTM_zone_24S", "PCS_WGS84_UTM_zone_25S", "PCS_WGS84_UTM_zone_26S", "PCS_WGS84_UTM_zone_27S", "PCS_WGS84_UTM_zone_28S", "PCS_WGS84_UTM_zone_29S", "PCS_WGS84_UTM_zone_30S", "PCS_WGS84_UTM_zone_31S", "PCS_WGS84_UTM_zone_32S", "PCS_WGS84_UTM_zone_33S", "PCS_WGS84_UTM_zone_34S", "PCS_WGS84_UTM_zone_35S", "PCS_WGS84_UTM_zone_36S", "PCS_WGS84_UTM_zone_37S", "PCS_WGS84_UTM_zone_38S", "PCS_WGS84_UTM_zone_39S", "PCS_WGS84_UTM_zone_40S", "PCS_WGS84_UTM_zone_41S", "PCS_WGS84_UTM_zone_42S", "PCS_WGS84_UTM_zone_43S", "PCS_WGS84_UTM_zone_44S", "PCS_WGS84_UTM_zone_45S", "PCS_WGS84_UTM_zone_46S", "PCS_WGS84_UTM_zone_47S", "PCS_WGS84_UTM_zone_48S", "PCS_WGS84_UTM_zone_49S", "PCS_WGS84_UTM_zone_50S", "PCS_WGS84_UTM_zone_51S", "PCS_WGS84_UTM_zone_52S", "PCS_WGS84_UTM_zone_53S", "PCS_WGS84_UTM_zone_54S", "PCS_WGS84_UTM_zone_55S", "PCS_WGS84_UTM_zone_56S", "PCS_WGS84_UTM_zone_57S", "PCS_WGS84_UTM_zone_58S", "PCS_WGS84_UTM_zone_59S", "PCS_WGS84_UTM_zone_60S"};

        public static String getName(int value) {
            for (int i = 0; i < values.length; ++i) {
                if (values[i] != value) continue;
                return names[i];
            }
            return null;
        }
    }

    public static class EpsgGcs {
        public static final int Airy1830 = 4001;
        public static final int AiryModified1849 = 4002;
        public static final int AustralianNationalSpheroid = 4003;
        public static final int Bessel1841 = 4004;
        public static final int BesselModified = 4005;
        public static final int BesselNamibia = 4006;
        public static final int Clarke1858 = 4007;
        public static final int Clarke1866 = 4008;
        public static final int Clarke1866Michigan = 4009;
        public static final int Clarke1880_Benoit = 4010;
        public static final int Clarke1880_IGN = 4011;
        public static final int Clarke1880_RGS = 4012;
        public static final int Clarke1880_Arc = 4013;
        public static final int Clarke1880_SGA1922 = 4014;
        public static final int Everest1830_1937Adjustment = 4015;
        public static final int Everest1830_1967Definition = 4016;
        public static final int Everest1830_1975Definition = 4017;
        public static final int Everest1830Modified = 4018;
        public static final int GRS1980 = 4019;
        public static final int Helmert1906 = 4020;
        public static final int IndonesianNationalSpheroid = 4021;
        public static final int International1924 = 4022;
        public static final int International1967 = 4023;
        public static final int Krassowsky1940 = 4024;
        public static final int NWL9D = 4025;
        public static final int NWL10D = 4026;
        public static final int Plessis1817 = 4027;
        public static final int Struve1860 = 4028;
        public static final int WarOffice = 4029;
        public static final int WGS84 = 4030;
        public static final int GEM10C = 4031;
        public static final int OSU86F = 4032;
        public static final int OSU91A = 4033;
        public static final int Clarke1880 = 4034;
        public static final int Sphere = 4035;
        public static final int GCS_Adindan = 4201;
        public static final int GCS_AGD66 = 4202;
        public static final int GCS_AGD84 = 4203;
        public static final int GCS_Ain_el_Abd = 4204;
        public static final int GCS_Afgooye = 4205;
        public static final int GCS_Agadez = 4206;
        public static final int GCS_Lisbon = 4207;
        public static final int GCS_Aratu = 4208;
        public static final int GCS_Arc_1950 = 4209;
        public static final int GCS_Arc_1960 = 4210;
        public static final int GCS_Batavia = 4211;
        public static final int GCS_Barbados = 4212;
        public static final int GCS_Beduaram = 4213;
        public static final int GCS_Beijing_1954 = 4214;
        public static final int GCS_Belge_1950 = 4215;
        public static final int GCS_Bermuda_1957 = 4216;
        public static final int GCS_Bern_1898 = 4217;
        public static final int GCS_Bogota = 4218;
        public static final int GCS_Bukit_Rimpah = 4219;
        public static final int GCS_Camacupa = 4220;
        public static final int GCS_Campo_Inchauspe = 4221;
        public static final int GCS_Cape = 4222;
        public static final int GCS_Carthage = 4223;
        public static final int GCS_Chua = 4224;
        public static final int GCS_Corrego_Alegre = 4225;
        public static final int GCS_Cote_d_Ivoire = 4226;
        public static final int GCS_Deir_ez_Zor = 4227;
        public static final int GCS_Douala = 4228;
        public static final int GCS_Egypt_1907 = 4229;
        public static final int GCS_ED50 = 4230;
        public static final int GCS_ED87 = 4231;
        public static final int GCS_Fahud = 4232;
        public static final int GCS_Gandajika_1970 = 4233;
        public static final int GCS_Garoua = 4234;
        public static final int GCS_Guyane_Francaise = 4235;
        public static final int GCS_Hu_Tzu_Shan = 4236;
        public static final int GCS_HD72 = 4237;
        public static final int GCS_ID74 = 4238;
        public static final int GCS_Indian_1954 = 4239;
        public static final int GCS_Indian_1975 = 4240;
        public static final int GCS_Jamaica_1875 = 4241;
        public static final int GCS_JAD69 = 4242;
        public static final int GCS_Kalianpur = 4243;
        public static final int GCS_Kandawala = 4244;
        public static final int GCS_Kertau = 4245;
        public static final int GCS_KOC = 4246;
        public static final int GCS_La_Canoa = 4247;
        public static final int GCS_PSAD56 = 4248;
        public static final int GCS_Lake = 4249;
        public static final int GCS_Leigon = 4250;
        public static final int GCS_Liberia_1964 = 4251;
        public static final int GCS_Lome = 4252;
        public static final int GCS_Luzon_1911 = 4253;
        public static final int GCS_Hito_XVIII_1963 = 4254;
        public static final int GCS_Herat_North = 4255;
        public static final int GCS_Mahe_1971 = 4256;
        public static final int GCS_Makassar = 4257;
        public static final int GCS_EUREF89 = 4258;
        public static final int GCS_Malongo_1987 = 4259;
        public static final int GCS_Manoca = 4260;
        public static final int GCS_Merchich = 4261;
        public static final int GCS_Massawa = 4262;
        public static final int GCS_Minna = 4263;
        public static final int GCS_Mhast = 4264;
        public static final int GCS_Monte_Mario = 4265;
        public static final int GCS_M_poraloko = 4266;
        public static final int GCS_NAD27 = 4267;
        public static final int GCS_NAD_Michigan = 4268;
        public static final int GCS_NAD83 = 4269;
        public static final int GCS_Nahrwan_1967 = 4270;
        public static final int GCS_Naparima_1972 = 4271;
        public static final int GCS_GD49 = 4272;
        public static final int GCS_NGO_1948 = 4273;
        public static final int GCS_Datum_73 = 4274;
        public static final int GCS_NTF = 4275;
        public static final int GCS_NSWC_9Z_2 = 4276;
        public static final int GCS_OSGB_1936 = 4277;
        public static final int GCS_OSGB70 = 4278;
        public static final int GCS_OS_SN80 = 4279;
        public static final int GCS_Padang = 4280;
        public static final int GCS_Palestine_1923 = 4281;
        public static final int GCS_Pointe_Noire = 4282;
        public static final int GCS_GDA94 = 4283;
        public static final int GCS_Pulkovo_1942 = 4284;
        public static final int GCS_Qatar = 4285;
        public static final int GCS_Qatar_1948 = 4286;
        public static final int GCS_Qornoq = 4287;
        public static final int GCS_Loma_Quintana = 4288;
        public static final int GCS_Amersfoort = 4289;
        public static final int GCS_RT38 = 4290;
        public static final int GCS_SAD69 = 4291;
        public static final int GCS_Sapper_Hill_1943 = 4292;
        public static final int GCS_Schwarzeck = 4293;
        public static final int GCS_Segora = 4294;
        public static final int GCS_Serindung = 4295;
        public static final int GCS_Sudan = 4296;
        public static final int GCS_Tananarive = 4297;
        public static final int GCS_Timbalai_1948 = 4298;
        public static final int GCS_TM65 = 4299;
        public static final int GCS_TM75 = 4300;
        public static final int GCS_Tokyo = 4301;
        public static final int GCS_Trinidad_1903 = 4302;
        public static final int GCS_TC_1948 = 4303;
        public static final int GCS_Voirol_1875 = 4304;
        public static final int GCS_Voirol_Unifie = 4305;
        public static final int GCS_Bern_1938 = 4306;
        public static final int GCS_Nord_Sahara_1959 = 4307;
        public static final int GCS_Stockholm_1938 = 4308;
        public static final int GCS_Yacare = 4309;
        public static final int GCS_Yoff = 4310;
        public static final int GCS_Zanderij = 4311;
        public static final int GCS_MGI = 4312;
        public static final int GCS_Belge_1972 = 4313;
        public static final int GCS_DHDN = 4314;
        public static final int GCS_Conakry_1905 = 4315;
        public static final int GCS_WGS_72 = 4322;
        public static final int GCS_WGS_72BE = 4324;
        public static final int GCS_WGS_84 = 4326;
        public static final int GCS_Bern_1898_Bern = 4801;
        public static final int GCS_Bogota_Bogota = 4802;
        public static final int GCS_Lisbon_Lisbon = 4803;
        public static final int GCS_Makassar_Jakarta = 4804;
        public static final int GCS_MGI_Ferro = 4805;
        public static final int GCS_Monte_Mario_Rome = 4806;
        public static final int GCS_NTF_Paris = 4807;
        public static final int GCS_Padang_Jakarta = 4808;
        public static final int GCS_Belge_1950_Brussels = 4809;
        public static final int GCS_Tananarive_Paris = 4810;
        public static final int GCS_Voirol_1875_Paris = 4811;
        public static final int GCS_Voirol_Unifie_Paris = 4812;
        public static final int GCS_Batavia_Jakarta = 4813;
        public static final int GCS_ATF_Paris = 4901;
        public static final int GCS_NDG_Paris = 4902;
        public static final int[] values = new int[]{4001, 4002, 4003, 4004, 4005, 4006, 4007, 4008, 4009, 4010, 4011, 4012, 4013, 4014, 4015, 4016, 4017, 4018, 4019, 4020, 4021, 4022, 4023, 4024, 4025, 4026, 4027, 4028, 4029, 4030, 4031, 4032, 4033, 4034, 4035, 4201, 4202, 4203, 4204, 4205, 4206, 4207, 4208, 4209, 4210, 4211, 4212, 4213, 4214, 4215, 4216, 4217, 4218, 4219, 4220, 4221, 4222, 4223, 4224, 4225, 4226, 4227, 4228, 4229, 4230, 4231, 4232, 4233, 4234, 4235, 4236, 4237, 4238, 4239, 4240, 4241, 4242, 4243, 4244, 4245, 4246, 4247, 4248, 4249, 4250, 4251, 4252, 4253, 4254, 4255, 4256, 4257, 4258, 4259, 4260, 4261, 4262, 4263, 4264, 4265, 4266, 4267, 4268, 4269, 4270, 4271, 4272, 4273, 4274, 4275, 4276, 4277, 4278, 4279, 4280, 4281, 4282, 4283, 4284, 4285, 4286, 4287, 4288, 4289, 4290, 4291, 4292, 4293, 4294, 4295, 4296, 4297, 4298, 4299, 4300, 4301, 4302, 4303, 4304, 4305, 4306, 4307, 4308, 4309, 4310, 4311, 4312, 4313, 4314, 4315, 4322, 4324, 4326, 4801, 4802, 4803, 4804, 4805, 4806, 4807, 4808, 4809, 4810, 4811, 4812, 4813, 4901, 4902};
        public static final String[] names = new String[]{"GCSE_Airy1830", "GCSE_AiryModified1849", "GCSE_AustralianNationalSpheroid", "GCSE_Bessel1841", "GCSE_BesselModified", "GCSE_BesselNamibia", "GCSE_Clarke1858", "GCSE_Clarke1866", "GCSE_Clarke1866Michigan", "GCSE_Clarke1880_Benoit", "GCSE_Clarke1880_IGN", "GCSE_Clarke1880_RGS", "GCSE_Clarke1880_Arc", "GCSE_Clarke1880_SGA1922", "GCSE_Everest1830_1937Adjustment", "GCSE_Everest1830_1967Definition", "GCSE_Everest1830_1975Definition", "GCSE_Everest1830Modified", "GCSE_GRS1980", "GCSE_Helmert1906", "GCSE_IndonesianNationalSpheroid", "GCSE_International1924", "GCSE_International1967", "GCSE_Krassowsky1940", "GCSE_NWL9D", "GCSE_NWL10D", "GCSE_Plessis1817", "GCSE_Struve1860", "GCSE_WarOffice", "GCSE_WGS84", "GCSE_GEM10C", "GCSE_OSU86F", "GCSE_OSU91A", "GCSE_Clarke1880", "GCSE_Sphere", "GCS_Adindan", "GCS_AGD66", "GCS_AGD84", "GCS_Ain_el_Abd", "GCS_Afgooye", "GCS_Agadez", "GCS_Lisbon", "GCS_Aratu", "GCS_Arc_1950", "GCS_Arc_1960", "GCS_Batavia", "GCS_Barbados", "GCS_Beduaram", "GCS_Beijing_1954", "GCS_Belge_1950", "GCS_Bermuda_1957", "GCS_Bern_1898", "GCS_Bogota", "GCS_Bukit_Rimpah", "GCS_Camacupa", "GCS_Campo_Inchauspe", "GCS_Cape", "GCS_Carthage", "GCS_Chua", "GCS_Corrego_Alegre", "GCS_Cote_d_Ivoire", "GCS_Deir_ez_Zor", "GCS_Douala", "GCS_Egypt_1907", "GCS_ED50", "GCS_ED87", "GCS_Fahud", "GCS_Gandajika_1970", "GCS_Garoua", "GCS_Guyane_Francaise", "GCS_Hu_Tzu_Shan", "GCS_HD72", "GCS_ID74", "GCS_Indian_1954", "GCS_Indian_1975", "GCS_Jamaica_1875", "GCS_JAD69", "GCS_Kalianpur", "GCS_Kandawala", "GCS_Kertau", "GCS_KOC", "GCS_La_Canoa", "GCS_PSAD56", "GCS_Lake", "GCS_Leigon", "GCS_Liberia_1964", "GCS_Lome", "GCS_Luzon_1911", "GCS_Hito_XVIII_1963", "GCS_Herat_North", "GCS_Mahe_1971", "GCS_Makassar", "GCS_EUREF89", "GCS_Malongo_1987", "GCS_Manoca", "GCS_Merchich", "GCS_Massawa", "GCS_Minna", "GCS_Mhast", "GCS_Monte_Mario", "GCS_M_poraloko", "GCS_NAD27", "GCS_NAD_Michigan", "GCS_NAD83", "GCS_Nahrwan_1967", "GCS_Naparima_1972", "GCS_GD49", "GCS_NGO_1948", "GCS_Datum_73", "GCS_NTF", "GCS_NSWC_9Z_2", "GCS_OSGB_1936", "GCS_OSGB70", "GCS_OS_SN80", "GCS_Padang", "GCS_Palestine_1923", "GCS_Pointe_Noire", "GCS_GDA94", "GCS_Pulkovo_1942", "GCS_Qatar", "GCS_Qatar_1948", "GCS_Qornoq", "GCS_Loma_Quintana", "GCS_Amersfoort", "GCS_RT38", "GCS_SAD69", "GCS_Sapper_Hill_1943", "GCS_Schwarzeck", "GCS_Segora", "GCS_Serindung", "GCS_Sudan", "GCS_Tananarive", "GCS_Timbalai_1948", "GCS_TM65", "GCS_TM75", "GCS_Tokyo", "GCS_Trinidad_1903", "GCS_TC_1948", "GCS_Voirol_1875", "GCS_Voirol_Unifie", "GCS_Bern_1938", "GCS_Nord_Sahara_1959", "GCS_Stockholm_1938", "GCS_Yacare", "GCS_Yoff", "GCS_Zanderij", "GCS_MGI", "GCS_Belge_1972", "GCS_DHDN", "GCS_Conakry_1905", "GCS_WGS_72", "GCS_WGS_72BE", "GCS_WGS_84", "GCS_Bern_1898_Bern", "GCS_Bogota_Bogota", "GCS_Lisbon_Lisbon", "GCS_Makassar_Jakarta", "GCS_MGI_Ferro", "GCS_Monte_Mario_Rome", "GCS_NTF_Paris", "GCS_Padang_Jakarta", "GCS_Belge_1950_Brussels", "GCS_Tananarive_Paris", "GCS_Voirol_1875_Paris", "GCS_Voirol_Unifie_Paris", "GCS_Batavia_Jakarta", "GCS_ATF_Paris", "GCS_NDG_Paris"};

        public static String getName(int value) {
            for (int i = 0; i < values.length; ++i) {
                if (values[i] != value) continue;
                return names[i];
            }
            return null;
        }
    }

    public static class EpsgEllipse {
        public static final int Airy_1830 = 7001;
        public static final int Airy_Modified_1849 = 7002;
        public static final int Australian_National_Spheroid = 7003;
        public static final int Bessel_1841 = 7004;
        public static final int Bessel_Modified = 7005;
        public static final int Bessel_Namibia = 7006;
        public static final int Clarke_1858 = 7007;
        public static final int Clarke_1866 = 7008;
        public static final int Clarke_1866_Michigan = 7009;
        public static final int Clarke_1880_Benoit = 7010;
        public static final int Clarke_1880_IGN = 7011;
        public static final int Clarke_1880_RGS = 7012;
        public static final int Clarke_1880_Arc = 7013;
        public static final int Clarke_1880_SGA_1922 = 7014;
        public static final int Everest_1830_1937_Adjustment = 7015;
        public static final int Everest_1830_1967_Definition = 7016;
        public static final int Everest_1830_1975_Definition = 7017;
        public static final int Everest_1830_Modified = 7018;
        public static final int GRS_1980 = 7019;
        public static final int Helmert_1906 = 7020;
        public static final int Indonesian_National_Spheroid = 7021;
        public static final int International_1924 = 7022;
        public static final int International_1967 = 7023;
        public static final int Krassowsky_1940 = 7024;
        public static final int NWL_9D = 7025;
        public static final int NWL_10D = 7026;
        public static final int Plessis_1817 = 7027;
        public static final int Struve_1860 = 7028;
        public static final int War_Office = 7029;
        public static final int WGS_84 = 7030;
        public static final int GEM_10C = 7031;
        public static final int OSU86F = 7032;
        public static final int OSU91A = 7033;
        public static final int Clarke_1880 = 7034;
        public static final int Sphere = 7035;
        public static final int[] values = new int[]{7001, 7002, 7003, 7004, 7005, 7006, 7007, 7008, 7009, 7010, 7011, 7012, 7013, 7014, 7015, 7016, 7017, 7018, 7019, 7020, 7021, 7022, 7023, 7024, 7025, 7026, 7027, 7028, 7029, 7030, 7031, 7032, 7033, 7034, 7035};
        public static final String[] names = new String[]{"Ellipse_Airy_1830", "Ellipse_Airy_Modified_1849", "Ellipse_Australian_National_Spheroid", "Ellipse_Bessel_1841", "Ellipse_Bessel_Modified", "Ellipse_Bessel_Namibia", "Ellipse_Clarke_1858", "Ellipse_Clarke_1866", "Ellipse_Clarke_1866_Michigan", "Ellipse_Clarke_1880_Benoit", "Ellipse_Clarke_1880_IGN", "Ellipse_Clarke_1880_RGS", "Ellipse_Clarke_1880_Arc", "Ellipse_Clarke_1880_SGA_1922", "Ellipse_Everest_1830_1937_Adjustment", "Ellipse_Everest_1830_1967_Definition", "Ellipse_Everest_1830_1975_Definition", "Ellipse_Everest_1830_Modified", "Ellipse_GRS_1980", "Ellipse_Helmert_1906", "Ellipse_Indonesian_National_Spheroid", "Ellipse_International_1924", "Ellipse_International_1967", "Ellipse_Krassowsky_1940", "Ellipse_NWL_9D", "Ellipse_NWL_10D", "Ellipse_Plessis_1817", "Ellipse_Struve_1860", "Ellipse_War_Office", "Ellipse_WGS_84", "Ellipse_GEM_10C", "Ellipse_OSU86F", "Ellipse_OSU91A", "Ellipse_Clarke_1880", "Ellipse_Sphere"};

        public static String getName(int value) {
            for (int i = 0; i < values.length; ++i) {
                if (values[i] != value) continue;
                return names[i];
            }
            return null;
        }
    }

    public static class EpsgDatum {
        public static final int DatumE_Airy1830 = 6001;
        public static final int DatumE_AiryModified1849 = 6002;
        public static final int DatumE_AustralianNationalSpheroid = 6003;
        public static final int DatumE_Bessel1841 = 6004;
        public static final int DatumE_BesselModified = 6005;
        public static final int DatumE_BesselNamibia = 6006;
        public static final int DatumE_Clarke1858 = 6007;
        public static final int DatumE_Clarke1866 = 6008;
        public static final int DatumE_Clarke1866Michigan = 6009;
        public static final int DatumE_Clarke1880_Benoit = 6010;
        public static final int DatumE_Clarke1880_IGN = 6011;
        public static final int DatumE_Clarke1880_RGS = 6012;
        public static final int DatumE_Clarke1880_Arc = 6013;
        public static final int DatumE_Clarke1880_SGA1922 = 6014;
        public static final int DatumE_Everest1830_1937Adjustment = 6015;
        public static final int DatumE_Everest1830_1967Definition = 6016;
        public static final int DatumE_Everest1830_1975Definition = 6017;
        public static final int DatumE_Everest1830Modified = 6018;
        public static final int DatumE_GRS1980 = 6019;
        public static final int DatumE_Helmert1906 = 6020;
        public static final int DatumE_IndonesianNationalSpheroid = 6021;
        public static final int DatumE_International1924 = 6022;
        public static final int DatumE_International1967 = 6023;
        public static final int DatumE_Krassowsky1960 = 6024;
        public static final int DatumE_NWL9D = 6025;
        public static final int DatumE_NWL10D = 6026;
        public static final int DatumE_Plessis1817 = 6027;
        public static final int DatumE_Struve1860 = 6028;
        public static final int DatumE_WarOffice = 6029;
        public static final int DatumE_WGS84 = 6030;
        public static final int DatumE_GEM10C = 6031;
        public static final int DatumE_OSU86F = 6032;
        public static final int DatumE_OSU91A = 6033;
        public static final int DatumE_Clarke1880 = 6034;
        public static final int DatumE_Sphere = 6035;
        public static final int Datum_Adindan = 6201;
        public static final int Datum_Australian_Geodetic_Datum_1966 = 6202;
        public static final int Datum_Australian_Geodetic_Datum_1984 = 6203;
        public static final int Datum_Ain_el_Abd_1970 = 6204;
        public static final int Datum_Afgooye = 6205;
        public static final int Datum_Agadez = 6206;
        public static final int Datum_Lisbon = 6207;
        public static final int Datum_Aratu = 6208;
        public static final int Datum_Arc_1950 = 6209;
        public static final int Datum_Arc_1960 = 6210;
        public static final int Datum_Batavia = 6211;
        public static final int Datum_Barbados = 6212;
        public static final int Datum_Beduaram = 6213;
        public static final int Datum_Beijing_1954 = 6214;
        public static final int Datum_Reseau_National_Belge_1950 = 6215;
        public static final int Datum_Bermuda_1957 = 6216;
        public static final int Datum_Bern_1898 = 6217;
        public static final int Datum_Bogota = 6218;
        public static final int Datum_Bukit_Rimpah = 6219;
        public static final int Datum_Camacupa = 6220;
        public static final int Datum_Campo_Inchauspe = 6221;
        public static final int Datum_Cape = 6222;
        public static final int Datum_Carthage = 6223;
        public static final int Datum_Chua = 6224;
        public static final int Datum_Corrego_Alegre = 6225;
        public static final int Datum_Cote_d_Ivoire = 6226;
        public static final int Datum_Deir_ez_Zor = 6227;
        public static final int Datum_Douala = 6228;
        public static final int Datum_Egypt_1907 = 6229;
        public static final int Datum_European_Datum_1950 = 6230;
        public static final int Datum_European_Datum_1987 = 6231;
        public static final int Datum_Fahud = 6232;
        public static final int Datum_Gandajika_1970 = 6233;
        public static final int Datum_Garoua = 6234;
        public static final int Datum_Guyane_Francaise = 6235;
        public static final int Datum_Hu_Tzu_Shan = 6236;
        public static final int Datum_Hungarian_Datum_1972 = 6237;
        public static final int Datum_Indonesian_Datum_1974 = 6238;
        public static final int Datum_Indian_1954 = 6239;
        public static final int Datum_Indian_1975 = 6240;
        public static final int Datum_Jamaica_1875 = 6241;
        public static final int Datum_Jamaica_1969 = 6242;
        public static final int Datum_Kalianpur = 6243;
        public static final int Datum_Kandawala = 6244;
        public static final int Datum_Kertau = 6245;
        public static final int Datum_Kuwait_Oil_Company = 6246;
        public static final int Datum_La_Canoa = 6247;
        public static final int Datum_Provisional_S_American_Datum_1956 = 6248;
        public static final int Datum_Lake = 6249;
        public static final int Datum_Leigon = 6250;
        public static final int Datum_Liberia_1964 = 6251;
        public static final int Datum_Lome = 6252;
        public static final int Datum_Luzon_1911 = 6253;
        public static final int Datum_Hito_XVIII_1963 = 6254;
        public static final int Datum_Herat_North = 6255;
        public static final int Datum_Mahe_1971 = 6256;
        public static final int Datum_Makassar = 6257;
        public static final int Datum_European_Reference_System_1989 = 6258;
        public static final int Datum_Malongo_1987 = 6259;
        public static final int Datum_Manoca = 6260;
        public static final int Datum_Merchich = 6261;
        public static final int Datum_Massawa = 6262;
        public static final int Datum_Minna = 6263;
        public static final int Datum_Mhast = 6264;
        public static final int Datum_Monte_Mario = 6265;
        public static final int Datum_M_poraloko = 6266;
        public static final int Datum_North_American_Datum_1927 = 6267;
        public static final int Datum_NAD_Michigan = 6268;
        public static final int Datum_North_American_Datum_1983 = 6269;
        public static final int Datum_Nahrwan_1967 = 6270;
        public static final int Datum_Naparima_1972 = 6271;
        public static final int Datum_New_Zealand_Geodetic_Datum_1949 = 6272;
        public static final int Datum_NGO_1948 = 6273;
        public static final int Datum_Datum_73 = 6274;
        public static final int Datum_Nouvelle_Triangulation_Francaise = 6275;
        public static final int Datum_NSWC_9Z_2 = 6276;
        public static final int Datum_OSGB_1936 = 6277;
        public static final int Datum_OSGB_1970_SN = 6278;
        public static final int Datum_OS_SN_1980 = 6279;
        public static final int Datum_Padang_1884 = 6280;
        public static final int Datum_Palestine_1923 = 6281;
        public static final int Datum_Pointe_Noire = 6282;
        public static final int Datum_Geocentric_Datum_of_Australia_1994 = 6283;
        public static final int Datum_Pulkovo_1942 = 6284;
        public static final int Datum_Qatar = 6285;
        public static final int Datum_Qatar_1948 = 6286;
        public static final int Datum_Qornoq = 6287;
        public static final int Datum_Loma_Quintana = 6288;
        public static final int Datum_Amersfoort = 6289;
        public static final int Datum_RT38 = 6290;
        public static final int Datum_South_American_Datum_1969 = 6291;
        public static final int Datum_Sapper_Hill_1943 = 6292;
        public static final int Datum_Schwarzeck = 6293;
        public static final int Datum_Segora = 6294;
        public static final int Datum_Serindung = 6295;
        public static final int Datum_Sudan = 6296;
        public static final int Datum_Tananarive_1925 = 6297;
        public static final int Datum_Timbalai_1948 = 6298;
        public static final int Datum_TM65 = 6299;
        public static final int Datum_TM75 = 6300;
        public static final int Datum_Tokyo = 6301;
        public static final int Datum_Trinidad_1903 = 6302;
        public static final int Datum_Trucial_Coast_1948 = 6303;
        public static final int Datum_Voirol_1875 = 6304;
        public static final int Datum_Voirol_Unifie_1960 = 6305;
        public static final int Datum_Bern_1938 = 6306;
        public static final int Datum_Nord_Sahara_1959 = 6307;
        public static final int Datum_Stockholm_1938 = 6308;
        public static final int Datum_Yacare = 6309;
        public static final int Datum_Yoff = 6310;
        public static final int Datum_Zanderij = 6311;
        public static final int Datum_Militar_Geographische_Institut = 6312;
        public static final int Datum_Reseau_National_Belge_1972 = 6313;
        public static final int Datum_Deutsche_Hauptdreiecksnetz = 6314;
        public static final int Datum_Conakry_1905 = 6315;
        public static final int Datum_WGS72 = 6322;
        public static final int Datum_WGS72_Transit_Broadcast_Ephemeris = 6324;
        public static final int Datum_WGS84 = 6326;
        public static final int Datum_Ancienne_Triangulation_Francaise = 6901;
        public static final int Datum_Nord_de_Guerre = 6902;
        public static final int[] values = new int[]{6001, 6002, 6003, 6004, 6005, 6006, 6007, 6008, 6009, 6010, 6011, 6012, 6013, 6014, 6015, 6016, 6017, 6018, 6019, 6020, 6021, 6022, 6023, 6024, 6025, 6026, 6027, 6028, 6029, 6030, 6031, 6032, 6033, 6034, 6035, 6201, 6202, 6203, 6204, 6205, 6206, 6207, 6208, 6209, 6210, 6211, 6212, 6213, 6214, 6215, 6216, 6217, 6218, 6219, 6220, 6221, 6222, 6223, 6224, 6225, 6226, 6227, 6228, 6229, 6230, 6231, 6232, 6233, 6234, 6235, 6236, 6237, 6238, 6239, 6240, 6241, 6242, 6243, 6244, 6245, 6246, 6247, 6248, 6249, 6250, 6251, 6252, 6253, 6254, 6255, 6256, 6257, 6258, 6259, 6260, 6261, 6262, 6263, 6264, 6265, 6266, 6267, 6268, 6269, 6270, 6271, 6272, 6273, 6274, 6275, 6276, 6277, 6278, 6279, 6280, 6281, 6282, 6283, 6284, 6285, 6286, 6287, 6288, 6289, 6290, 6291, 6292, 6293, 6294, 6295, 6296, 6297, 6298, 6299, 6300, 6301, 6302, 6303, 6304, 6305, 6306, 6307, 6308, 6309, 6310, 6311, 6312, 6313, 6314, 6315, 6322, 6324, 6326, 6901, 6902};
        public static final String[] names = new String[]{"DatumE_Airy1830", "DatumE_AiryModified1849", "DatumE_AustralianNationalSpheroid", "DatumE_Bessel1841", "DatumE_BesselModified", "DatumE_BesselNamibia", "DatumE_Clarke1858", "DatumE_Clarke1866", "DatumE_Clarke1866Michigan", "DatumE_Clarke1880_Benoit", "DatumE_Clarke1880_IGN", "DatumE_Clarke1880_RGS", "DatumE_Clarke1880_Arc", "DatumE_Clarke1880_SGA1922", "DatumE_Everest1830_1937Adjustment", "DatumE_Everest1830_1967Definition", "DatumE_Everest1830_1975Definition", "DatumE_Everest1830Modified", "DatumE_GRS1980", "DatumE_Helmert1906", "DatumE_IndonesianNationalSpheroid", "DatumE_International1924", "DatumE_International1967", "DatumE_Krassowsky1960", "DatumE_NWL9D", "DatumE_NWL10D", "DatumE_Plessis1817", "DatumE_Struve1860", "DatumE_WarOffice", "DatumE_WGS84", "DatumE_GEM10C", "DatumE_OSU86F", "DatumE_OSU91A", "DatumE_Clarke1880", "DatumE_Sphere", "Datum_Adindan", "Datum_Australian_Geodetic_Datum_1966", "Datum_Australian_Geodetic_Datum_1984", "Datum_Ain_el_Abd_1970", "Datum_Afgooye", "Datum_Agadez", "Datum_Lisbon", "Datum_Aratu", "Datum_Arc_1950", "Datum_Arc_1960", "Datum_Batavia", "Datum_Barbados", "Datum_Beduaram", "Datum_Beijing_1954", "Datum_Reseau_National_Belge_1950", "Datum_Bermuda_1957", "Datum_Bern_1898", "Datum_Bogota", "Datum_Bukit_Rimpah", "Datum_Camacupa", "Datum_Campo_Inchauspe", "Datum_Cape", "Datum_Carthage", "Datum_Chua", "Datum_Corrego_Alegre", "Datum_Cote_d_Ivoire", "Datum_Deir_ez_Zor", "Datum_Douala", "Datum_Egypt_1907", "Datum_European_Datum_1950", "Datum_European_Datum_1987", "Datum_Fahud", "Datum_Gandajika_1970", "Datum_Garoua", "Datum_Guyane_Francaise", "Datum_Hu_Tzu_Shan", "Datum_Hungarian_Datum_1972", "Datum_Indonesian_Datum_1974", "Datum_Indian_1954", "Datum_Indian_1975", "Datum_Jamaica_1875", "Datum_Jamaica_1969", "Datum_Kalianpur", "Datum_Kandawala", "Datum_Kertau", "Datum_Kuwait_Oil_Company", "Datum_La_Canoa", "Datum_Provisional_S_American_Datum_1956", "Datum_Lake", "Datum_Leigon", "Datum_Liberia_1964", "Datum_Lome", "Datum_Luzon_1911", "Datum_Hito_XVIII_1963", "Datum_Herat_North", "Datum_Mahe_1971", "Datum_Makassar", "Datum_European_Reference_System_1989", "Datum_Malongo_1987", "Datum_Manoca", "Datum_Merchich", "Datum_Massawa", "Datum_Minna", "Datum_Mhast", "Datum_Monte_Mario", "Datum_M_poraloko", "Datum_North_American_Datum_1927", "Datum_NAD_Michigan", "Datum_North_American_Datum_1983", "Datum_Nahrwan_1967", "Datum_Naparima_1972", "Datum_New_Zealand_Geodetic_Datum_1949", "Datum_NGO_1948", "Datum_Datum_73", "Datum_Nouvelle_Triangulation_Francaise", "Datum_NSWC_9Z_2", "Datum_OSGB_1936", "Datum_OSGB_1970_SN", "Datum_OS_SN_1980", "Datum_Padang_1884", "Datum_Palestine_1923", "Datum_Pointe_Noire", "Datum_Geocentric_Datum_of_Australia_1994", "Datum_Pulkovo_1942", "Datum_Qatar", "Datum_Qatar_1948", "Datum_Qornoq", "Datum_Loma_Quintana", "Datum_Amersfoort", "Datum_RT38", "Datum_South_American_Datum_1969", "Datum_Sapper_Hill_1943", "Datum_Schwarzeck", "Datum_Segora", "Datum_Serindung", "Datum_Sudan", "Datum_Tananarive_1925", "Datum_Timbalai_1948", "Datum_TM65", "Datum_TM75", "Datum_Tokyo", "Datum_Trinidad_1903", "Datum_Trucial_Coast_1948", "Datum_Voirol_1875", "Datum_Voirol_Unifie_1960", "Datum_Bern_1938", "Datum_Nord_Sahara_1959", "Datum_Stockholm_1938", "Datum_Yacare", "Datum_Yoff", "Datum_Zanderij", "Datum_Militar_Geographische_Institut", "Datum_Reseau_National_Belge_1972", "Datum_Deutsche_Hauptdreiecksnetz", "Datum_Conakry_1905", "Datum_WGS72", "Datum_WGS72_Transit_Broadcast_Ephemeris", "Datum_WGS84", "Datum_Ancienne_Triangulation_Francaise", "Datum_Nord_de_Guerre"};

        public static String getName(int value) {
            for (int i = 0; i < values.length; ++i) {
                if (values[i] != value) continue;
                return names[i];
            }
            return null;
        }
    }
}

