/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.gis.epsg;

import java.util.ArrayList;
import java.util.List;
import ucar.unidata.util.CsvDb;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.StringUtil;

public class CoordinateOperationParameter
extends CsvDb {
    private static String csvFileName = "csv/coordinate_operation_parameter.csv";
    private static boolean haveInitialized = false;
    private static List members = new ArrayList();
    public static final int LATITUDE_OFFSET = 8601;
    public static final int LONGITUDE_OFFSET = 8602;
    public static final int VERTICAL_OFFSET = 8603;
    public static final int GEOID_UNDULATION = 8604;
    public static final int X_AXIS_TRANSLATION = 8605;
    public static final int Y_AXIS_TRANSLATION = 8606;
    public static final int Z_AXIS_TRANSLATION = 8607;
    public static final int X_AXIS_ROTATION = 8608;
    public static final int Y_AXIS_ROTATION = 8609;
    public static final int Z_AXIS_ROTATION = 8610;
    public static final int SCALE_DIFFERENCE = 8611;
    public static final int SCALE_FACTOR_FOR_SOURCE_COORDINATE_REFERENCE_SYSTEM_FIRST_AXIS = 8612;
    public static final int SCALE_FACTOR_FOR_SOURCE_COORDINATE_REFERENCE_SYSTEM_SECOND_AXIS = 8613;
    public static final int ROTATION_ANGLE_OF_SOURCE_COORDINATE_REFERENCE_SYSTEM_AXES = 8614;
    public static final int ROTATION_ANGLE_OF_SOURCE_COORDINATE_REFERENCE_SYSTEM_FIRST_AXIS = 8615;
    public static final int ROTATION_ANGLE_OF_SOURCE_COORDINATE_REFERENCE_SYSTEM_SECOND_AXIS = 8616;
    public static final int ORDINATE_1_OF_EVALUATION_POINT = 8617;
    public static final int ORDINATE_2_OF_EVALUATION_POINT = 8618;
    public static final int ORDINATE_1_OF_EVALUATION_POINT_IN_SOURCE_CRS = 8619;
    public static final int ORDINATE_2_OF_EVALUATION_POINT_IN_SOURCE_CRS = 8620;
    public static final int ORDINATE_1_OF_EVALUATION_POINT_IN_TARGET_CRS = 8621;
    public static final int ORDINATE_2_OF_EVALUATION_POINT_IN_TARGET_CRS = 8622;
    public static final int A0 = 8623;
    public static final int A1 = 8624;
    public static final int A2 = 8625;
    public static final int A3 = 8626;
    public static final int A4 = 8627;
    public static final int A5 = 8628;
    public static final int A6 = 8629;
    public static final int A7 = 8630;
    public static final int A8 = 8631;
    public static final int A9 = 8632;
    public static final int A10 = 8633;
    public static final int A11 = 8634;
    public static final int A12 = 8635;
    public static final int A13 = 8636;
    public static final int A14 = 8637;
    public static final int B00 = 8638;
    public static final int B0 = 8639;
    public static final int B1 = 8640;
    public static final int B2 = 8641;
    public static final int B3 = 8642;
    public static final int B4 = 8643;
    public static final int B5 = 8644;
    public static final int B6 = 8645;
    public static final int B7 = 8646;
    public static final int B8 = 8647;
    public static final int B9 = 8648;
    public static final int B10 = 8649;
    public static final int B11 = 8650;
    public static final int B12 = 8651;
    public static final int B13 = 8652;
    public static final int B14 = 8653;
    public static final int SEMI_MAJOR_AXIS_LENGTH_DIFFERENCE = 8654;
    public static final int FLATTENING_DIFFERENCE = 8655;
    public static final int LATITUDE_AND_LONGITUDE_DIFFERENCE_FILE = 8656;
    public static final int LATITUDE_DIFFERENCE_FILE = 8657;
    public static final int LONGITUDE_DIFFERENCE_FILE = 8658;
    public static final int GEOD_TFM_CODE_FOR_NORTHERN_BOUNDARY = 8659;
    public static final int GEOD_TFM_CODE_FOR_SOUTHERN_BOUNDARY = 8660;
    public static final int GEOD_TFM_NAME_FOR_NORTHERN_BOUNDARY = 8661;
    public static final int GEOD_TFM_NAME_FOR_SOUTHERN_BOUNDARY = 8662;
    public static final int POINT_SCALE_FACTOR = 8663;
    public static final int EASTING_AND_NORTHING_DIFFERENCE_FILE = 8664;
    public static final int MARITIME_PROVINCE_RESIDUAL_FILE = 8665;
    public static final int GEOID_MODEL_FILE = 8666;
    public static final int ORDINATE_3_OF_EVALUATION_POINT = 8667;
    public static final int LATITUDE_OF_NATURAL_ORIGIN = 8801;
    public static final int LONGITUDE_OF_NATURAL_ORIGIN = 8802;
    public static final int SCALE_FACTOR_AT_NATURAL_ORIGIN = 8805;
    public static final int FALSE_EASTING = 8806;
    public static final int FALSE_NORTHING = 8807;
    public static final int LATITUDE_OF_PROJECTION_CENTRE = 8811;
    public static final int LONGITUDE_OF_PROJECTION_CENTRE = 8812;
    public static final int AZIMUTH_OF_INITIAL_LINE = 8813;
    public static final int ANGLE_FROM_RECTIFIED_TO_SKEW_GRID = 8814;
    public static final int SCALE_FACTOR_ON_INITIAL_LINE = 8815;
    public static final int EASTING_AT_PROJECTION_CENTRE = 8816;
    public static final int NORTHING_AT_PROJECTION_CENTRE = 8817;
    public static final int LATITUDE_OF_PSEUDO_STANDARD_PARALLEL = 8818;
    public static final int SCALE_FACTOR_ON_PSEUDO_STANDARD_PARALLEL = 8819;
    public static final int LATITUDE_OF_FALSE_ORIGIN = 8821;
    public static final int LONGITUDE_OF_FALSE_ORIGIN = 8822;
    public static final int LATITUDE_OF_1ST_STANDARD_PARALLEL = 8823;
    public static final int LATITUDE_OF_2ND_STANDARD_PARALLEL = 8824;
    public static final int EASTING_AT_FALSE_ORIGIN = 8826;
    public static final int NORTHING_AT_FALSE_ORIGIN = 8827;
    public static final int SPHERICAL_LATITUDE_OF_ORIGIN = 8828;
    public static final int SPHERICAL_LONGITUDE_OF_ORIGIN = 8829;
    public static final int INITIAL_LONGITUDE = 8830;
    public static final int ZONE_WIDTH = 8831;
    private int parameterCode;
    private String parameterName;
    private String description;
    private String informationSource;
    private String dataSource;
    private String revisionDate;
    private String changeId;
    private String deprecated;

    public CoordinateOperationParameter(int arg_parameterCode, String arg_parameterName, String arg_description, String arg_informationSource, String arg_dataSource, String arg_revisionDate, String arg_changeId, String arg_deprecated) {
        this.parameterCode = arg_parameterCode;
        this.parameterName = arg_parameterName;
        this.description = arg_description;
        this.informationSource = arg_informationSource;
        this.dataSource = arg_dataSource;
        this.revisionDate = arg_revisionDate;
        this.changeId = arg_changeId;
        this.deprecated = arg_deprecated;
    }

    public CoordinateOperationParameter(List tuple) {
        this.parameterCode = CoordinateOperationParameter.getInt((String)tuple.get(0));
        this.parameterName = (String)tuple.get(1);
        this.description = (String)tuple.get(2);
        this.informationSource = (String)tuple.get(3);
        this.dataSource = (String)tuple.get(4);
        this.revisionDate = (String)tuple.get(5);
        this.changeId = (String)tuple.get(6);
        this.deprecated = (String)tuple.get(7);
        members.add(this);
    }

    private static void doInit() {
        String csv = IOUtil.readContents(csvFileName, CoordinateOperationParameter.class, null);
        if (csv == null) {
            System.err.println("Failed to read:" + csvFileName);
            return;
        }
        List lines = StringUtil.parseCsv(csv, true);
        for (int i = 0; i < lines.size(); ++i) {
            List line = (List)lines.get(i);
            if (line.size() < 8) {
                System.err.println("csv/coordinate_operation_parameter.csv: line #" + i + " " + line);
                continue;
            }
            try {
                new CoordinateOperationParameter(line);
                continue;
            }
            catch (Exception exc) {
                System.err.println("Error creating CoordinateOperationParameter " + exc);
                exc.printStackTrace();
                return;
            }
        }
    }

    public int getParameterCode() {
        return this.parameterCode;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getInformationSource() {
        return this.informationSource;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public String getRevisionDate() {
        return this.revisionDate;
    }

    public String getChangeId() {
        return this.changeId;
    }

    public String getDeprecated() {
        return this.deprecated;
    }

    public static CoordinateOperationParameter findParameterCode(int value) {
        for (int i = 0; i < members.size(); ++i) {
            CoordinateOperationParameter obj = (CoordinateOperationParameter)members.get(i);
            if (obj.parameterCode != value) continue;
            return obj;
        }
        return null;
    }

    public int findIntByName(String varname) {
        if (varname.equals("parameterCode")) {
            return this.parameterCode;
        }
        throw new IllegalArgumentException("Unknown name:" + varname);
    }

    public String findStringByName(String varname) {
        if (varname.equals("parameterName")) {
            return this.parameterName;
        }
        if (varname.equals("description")) {
            return this.description;
        }
        if (varname.equals("informationSource")) {
            return this.informationSource;
        }
        if (varname.equals("dataSource")) {
            return this.dataSource;
        }
        if (varname.equals("revisionDate")) {
            return this.revisionDate;
        }
        if (varname.equals("changeId")) {
            return this.changeId;
        }
        if (varname.equals("deprecated")) {
            return this.deprecated;
        }
        throw new IllegalArgumentException("Unknown name:" + varname);
    }

    public String toString() {
        return "   parameterCode=" + this.parameterCode + "\n" + "   parameterName=" + this.parameterName + "\n" + "   description=" + this.description + "\n" + "   informationSource=" + this.informationSource + "\n" + "   dataSource=" + this.dataSource + "\n" + "   revisionDate=" + this.revisionDate + "\n" + "   changeId=" + this.changeId + "\n" + "   deprecated=" + this.deprecated + "\n";
    }

    public static void main(String[] args) {
    }

    static {
        CoordinateOperationParameter.doInit();
    }
}

