/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.gis;

import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import ucar.unidata.io.BeLeDataInputStream;
import ucar.unidata.util.IOUtil;

public class WorldWindReader {
    byte[] stringBuff = new byte[10000];
    DataOutputStream dos = null;

    public List findWwps(List wwps, Rectangle2D.Double rect) {
        ArrayList<Object> names = new ArrayList<Object>();
        double height = Math.min(180.0, Math.abs(rect.getHeight()));
        for (int i = 0; i < wwps.size(); ++i) {
            Rectangle2D.Double wwpRect;
            Object[] a = (Object[])wwps.get(i);
            double[] range = (double[])a[1];
            if (height > range[1] || height < range[0] || !(wwpRect = (Rectangle2D.Double)a[2]).intersects(rect) && !rect.contains(wwpRect)) continue;
            names.add(a[0]);
        }
        return names;
    }

    public String readString(BeLeDataInputStream bdis) throws Exception {
        byte size = bdis.readByte();
        bdis.readFully(this.stringBuff, 0, size);
        return new String(this.stringBuff, 0, (int)size);
    }

    public byte[] readStringAsBytes(BeLeDataInputStream bdis) throws Exception {
        byte size = bdis.readByte();
        byte[] buff = new byte[size];
        bdis.readFully(buff, 0, size);
        return buff;
    }

    public List readWPL(String fileOrUrl, double minRange, double maxRange) throws Exception {
        String dirPath = IOUtil.getFileRoot(fileOrUrl);
        ArrayList<Object[]> entries = new ArrayList<Object[]>();
        byte[] bytes = IOUtil.readBytesAndCache(fileOrUrl, "WorldWind");
        BeLeDataInputStream bdis = new BeLeDataInputStream(new ByteArrayInputStream(bytes));
        int numEntries = bdis.readLEInt();
        for (int i = 0; i < numEntries; ++i) {
            String name = this.readString(bdis);
            float lon1 = (float)bdis.readLEDouble();
            float lat1 = (float)bdis.readLEDouble();
            float lon2 = (float)bdis.readLEDouble();
            float lat2 = (float)bdis.readLEDouble();
            name = dirPath + "/" + name;
            entries.add(new Object[]{name, new double[]{minRange, maxRange}, new Rectangle2D.Double(lon1, lat1, lon2 - lon1, lat2 - lat1)});
        }
        return entries;
    }

    public FeatureList readWWP(String file) throws Exception {
        return this.readWWP(file, false);
    }

    public FeatureList readWWP(String file, boolean convert) throws Exception {
        this.dos = null;
        boolean isBlf = false;
        if (file.startsWith("http:")) {
            file = IOUtil.stripExtension(file) + ".zip";
            isBlf = true;
        }
        byte[] fileBuffer = IOUtil.readBytesAndCache(file, "WorldWind", true);
        ByteArrayInputStream is = new ByteArrayInputStream(fileBuffer, 0, fileBuffer.length);
        return this.readWWP(is, isBlf);
    }

    public FeatureList readWWP(InputStream inputStream, boolean isBlf) throws Exception {
        int numFeatures;
        BeLeDataInputStream bdis = new BeLeDataInputStream(inputStream);
        int n = numFeatures = isBlf ? bdis.readInt() : bdis.readLEInt();
        if (isBlf) {
            bdis.readByte();
            bdis.readByte();
        }
        byte[][] names = new byte[numFeatures][];
        double[] lats = new double[numFeatures];
        double[] lons = new double[numFeatures];
        boolean skipMeta = true;
        if (this.dos != null) {
            this.dos.writeInt(numFeatures);
            this.dos.writeByte(0);
            this.dos.writeByte(0);
        }
        for (int i = 0; i < numFeatures; ++i) {
            float alt = 0.0f;
            names[i] = this.readStringAsBytes(bdis);
            if (isBlf) {
                lats[i] = bdis.readFloat();
                lons[i] = bdis.readFloat();
            } else {
                lats[i] = bdis.readLEDouble();
                lons[i] = bdis.readLEDouble();
            }
            int numEntries = bdis.readLEInt();
            for (int entryIdx = 0; entryIdx < numEntries; ++entryIdx) {
                if (skipMeta) {
                    bdis.skip(bdis.readByte());
                    bdis.skip(bdis.readByte());
                    continue;
                }
                String name = this.readString(bdis);
                String string = this.readString(bdis);
            }
            if (this.dos == null) continue;
            this.dos.writeByte(names[i].length);
            this.dos.write(names[i], 0, names[i].length);
            this.dos.writeFloat((float)lats[i]);
            this.dos.writeFloat((float)lons[i]);
            this.dos.writeFloat(alt);
        }
        if (this.dos != null) {
            this.dos.close();
        }
        bdis.close();
        return new FeatureList(names, lats, lons);
    }

    public static void main(String[] args) throws Exception {
        long t1 = System.currentTimeMillis();
        WorldWindReader reader = new WorldWindReader();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].endsWith(".wpl")) {
                List wwps = reader.readWPL(args[i], 0.0, 5.0);
                List names = reader.findWwps(wwps, new Rectangle2D.Double(-110.0, 35.0, 5.0, 5.0));
                for (int nameIdx = 0; nameIdx < names.size(); ++nameIdx) {
                    System.err.println("WWP:" + names.get(nameIdx));
                    reader.readWWP(names.get(nameIdx).toString());
                }
                continue;
            }
            reader.readWWP(args[i], false);
        }
        long t2 = System.currentTimeMillis();
        System.err.println(" time:" + (t2 - t1));
    }

    public class FeatureList {
        public double[] lats;
        public double[] lons;
        public byte[][] names;

        public FeatureList(byte[][] names, double[] lats, double[] lons) {
            this.lats = lats;
            this.lons = lons;
            this.names = names;
        }
    }
}

