/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.gis;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class SpatialGrid {
    private static final double MAX_DOUBLE = Double.MAX_VALUE;
    private GridCell[][] grid;
    private int nx;
    private int ny;
    private int countX;
    private int countY;
    private double gridWidth;
    private double gridHeight;
    private double offsetX;
    private double offsetY;
    private double scaleOverlap = 1.0;
    private Rectangle2D result = new Rectangle2D.Double();
    private boolean debug = false;
    private boolean debugMark = false;
    private boolean debugMark2 = false;
    private boolean debugClosest = false;

    public SpatialGrid(int nx, int ny) {
        this.nx = nx;
        this.ny = ny;
        this.grid = new GridCell[ny][];
        for (int y = 0; y < ny; ++y) {
            this.grid[y] = new GridCell[nx];
            for (int x = 0; x < nx; ++x) {
                this.grid[y][x] = new GridCell();
            }
        }
    }

    public void setGrid(Rectangle2D bbox, Rectangle2D cellSize) {
        this.offsetX = bbox.getX();
        this.offsetY = bbox.getY();
        this.countX = Math.min(this.nx, (int)(bbox.getWidth() / (this.scaleOverlap * cellSize.getWidth())));
        this.countY = Math.min(this.ny, (int)(bbox.getHeight() / (this.scaleOverlap * cellSize.getHeight())));
        this.gridWidth = bbox.getWidth() / (double)this.countX;
        this.gridHeight = bbox.getHeight() / (double)this.countY;
        if (this.debug) {
            System.out.println("SpatialGrid size " + this.gridWidth + " " + this.gridHeight + " = " + this.countX + " by " + this.countY + " scaleOverlap= " + this.scaleOverlap);
        }
    }

    public void setOverlap(int overlap) {
        double dover = Math.max(0.0, Math.min(0.01 * (double)overlap, 0.5));
        this.scaleOverlap = 1.0 - dover;
    }

    public void print() {
        for (int y = 0; y < this.countY; ++y) {
            for (int x = 0; x < this.countX; ++x) {
                if (this.grid[y][x].clear) {
                    System.out.print("0");
                    continue;
                }
                System.out.print("1");
            }
            System.out.println("");
        }
    }

    public void clear() {
        for (int y = 0; y < this.countY; ++y) {
            for (int x = 0; x < this.countX; ++x) {
                this.grid[y][x].clear = true;
            }
        }
    }

    public boolean markIfClear(Rectangle2D rect, Object o) {
        double centerX = rect.getX() + rect.getWidth() / 2.0;
        double centerY = rect.getY() + rect.getHeight() / 2.0;
        int indexX = (int)((centerX - this.offsetX) / this.gridWidth);
        int indexY = (int)((centerY - this.offsetY) / this.gridHeight);
        if (this.debugMark) {
            System.out.print("markIfClear " + rect.getX() + " " + rect.getY() + " " + rect.getWidth() + " " + rect.getHeight() + " " + indexX + " " + indexY);
        }
        if (indexX < 0 || indexX >= this.countX || indexY < 0 || indexY >= this.countY) {
            if (this.debugMark) {
                System.out.println("   NOT OK(0)");
            }
            return false;
        }
        GridCell gwant = this.grid[indexY][indexX];
        if (!gwant.clear) {
            if (this.debugMark) {
                System.out.println("   NOT OK(1)");
            }
            return false;
        }
        for (int y = Math.max(0, indexY - 1); y <= Math.min(this.countY - 1, indexY + 1); ++y) {
            for (int x = Math.max(0, indexX - 1); x <= Math.min(this.countX - 1, indexX + 1); ++x) {
                GridCell gtest = this.grid[y][x];
                if (this.debugMark2) {
                    // empty if block
                }
                if (gtest.clear) continue;
                if (this.intersectsOverlap(rect, gtest.rect)) {
                    if (this.debugMark) {
                        System.out.println("   NOT OK(2)");
                    }
                    return false;
                }
                if (!this.debugMark) continue;
                System.out.println("  not intersect " + gtest.rect);
            }
        }
        if (this.debugMark) {
            System.out.println("   OK");
        }
        gwant.clear = false;
        gwant.rect = rect;
        gwant.o = o;
        return true;
    }

    public Object findClosest(Point2D pt) {
        Object o = null;
        int indexX = (int)((pt.getX() - this.offsetX) / this.gridWidth);
        int indexY = (int)((pt.getY() - this.offsetY) / this.gridHeight);
        if (this.debugClosest) {
            System.out.println("findClosest " + pt + " " + indexX + " " + indexY);
        }
        if (indexX < 0 || indexX >= this.countX || indexY < 0 || indexY >= this.countY) {
            return null;
        }
        GridCell gwant = this.grid[indexY][indexX];
        if (!gwant.clear) {
            return gwant.o;
        }
        for (int p = 1; p < Math.max(this.countX - 1, this.countY - 1); ++p) {
            o = this.findClosestAlongPerimeter(pt, indexX, indexY, p);
            if (null == o) continue;
            return o;
        }
        return null;
    }

    private Object findClosestAlongPerimeter(Point2D pt, int centerX, int centerY, int perimeter) {
        double distance;
        int x;
        int y;
        Object closestO = null;
        double closestD = Double.MAX_VALUE;
        for (y = centerY - perimeter; y <= centerY + perimeter; y += 2 * perimeter) {
            for (x = centerX - perimeter; x <= centerX + perimeter; ++x) {
                distance = this.distanceSq(pt, x, y);
                if (!(distance < closestD)) continue;
                closestO = this.grid[y][x].o;
                closestD = distance;
                if (!this.debugClosest) continue;
                System.out.println("   closest " + this.grid[y][x]);
            }
        }
        for (y = centerY - perimeter + 1; y <= centerY + perimeter - 1; ++y) {
            for (x = centerX - perimeter; x <= centerX + perimeter; x += 2 * perimeter) {
                distance = this.distanceSq(pt, x, y);
                if (!(distance < closestD)) continue;
                closestO = this.grid[y][x].o;
                closestD = distance;
                if (!this.debugClosest) continue;
                System.out.println("   closest " + this.grid[y][x]);
            }
        }
        return closestO;
    }

    private double distanceSq(Point2D pt, int indexX, int indexY) {
        if (indexX < 0 || indexX >= this.countX || indexY < 0 || indexY >= this.countY) {
            return Double.MAX_VALUE;
        }
        GridCell gtest = this.grid[indexY][indexX];
        if (gtest.clear) {
            return Double.MAX_VALUE;
        }
        Rectangle2D rect = gtest.rect;
        double dx = rect.getX() + rect.getWidth() / 2.0 - pt.getX();
        double dy = rect.getY() + rect.getHeight() / 2.0 - pt.getY();
        return dx * dx + dy * dy;
    }

    private boolean intersectsOverlap(Rectangle2D r1, Rectangle2D r2) {
        if (this.scaleOverlap >= 1.0) {
            return r1.intersects(r2);
        }
        Rectangle2D.intersect(r1, r2, this.result);
        double area = this.result.getWidth() * this.result.getHeight();
        return area > 0.0 && area > (1.0 - this.scaleOverlap) * r1.getWidth() * r1.getHeight();
    }

    private static class GridCell {
        boolean clear = true;
        Rectangle2D rect = null;
        Object o = null;

        private GridCell() {
        }
    }
}

