/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.gis;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.gis.GisFeature;
import ucar.unidata.gis.GisPart;
import ucar.unidata.util.Debug;
import ucar.visad.data.MapSet;
import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded2DSet;
import visad.RealTupleType;
import visad.SampledSet;
import visad.UnionSet;
import visad.Unit;
import visad.VisADException;

public abstract class AbstractGisFeature
implements GisFeature {
    private int pointCnt = 0;

    @Override
    public abstract Rectangle2D getBounds2D();

    @Override
    public abstract int getNumPoints();

    @Override
    public abstract int getNumParts();

    @Override
    public abstract Iterator getGisParts();

    public Shape getShape() {
        int npts = this.getNumPoints();
        GeneralPath path = new GeneralPath(0, npts);
        Iterator pi = this.getGisParts();
        while (pi.hasNext()) {
            GisPart gp = (GisPart)pi.next();
            double[] xx = gp.getX();
            double[] yy = gp.getY();
            int np = gp.getNumPoints();
            if (np > 0) {
                path.moveTo((float)xx[0], (float)yy[0]);
            }
            for (int i = 1; i < np; ++i) {
                path.lineTo((float)xx[i], (float)yy[i]);
            }
        }
        return path;
    }

    public Shape getProjectedShape(ProjectionImpl displayProject) {
        LatLonPointImpl workL = new LatLonPointImpl();
        ProjectionPointImpl lastW = new ProjectionPointImpl();
        GeneralPath path = new GeneralPath(0, this.getNumPoints());
        boolean showPts = Debug.isSet("projection.showPoints");
        Iterator pi = this.getGisParts();
        while (pi.hasNext()) {
            GisPart gp = (GisPart)pi.next();
            double[] xx = gp.getX();
            double[] yy = gp.getY();
            for (int i = 0; i < gp.getNumPoints(); ++i) {
                workL.set(yy[i], xx[i]);
                ProjectionPoint pt = displayProject.latLonToProj(workL);
                if (showPts) {
                    System.out.println("getProjectedShape 1 " + xx[i] + " " + yy[i] + " === " + pt.getX() + " " + pt.getY());
                    if (displayProject.crossSeam(pt, lastW)) {
                        System.out.println("***cross seam");
                    }
                }
                if (pt.getX() == pt.getX()) {
                    if (i == 0 || displayProject.crossSeam(pt, lastW) || Double.isNaN(lastW.getX())) {
                        path.moveTo((float)pt.getX(), (float)pt.getY());
                    } else {
                        path.lineTo((float)pt.getX(), (float)pt.getY());
                    }
                }
                lastW.setLocation(pt);
            }
        }
        return path;
    }

    public Shape getProjectedShape(ProjectionImpl dataProject, ProjectionImpl displayProject) {
        ProjectionPointImpl pt1 = new ProjectionPointImpl();
        ProjectionPointImpl lastW = new ProjectionPointImpl();
        GeneralPath path = new GeneralPath(0, this.getNumPoints());
        boolean showPts = Debug.isSet("projection.showPoints");
        Iterator pi = this.getGisParts();
        while (pi.hasNext()) {
            GisPart gp = (GisPart)pi.next();
            double[] xx = gp.getX();
            double[] yy = gp.getY();
            for (int i = 0; i < gp.getNumPoints(); ++i) {
                pt1.setLocation(xx[i], yy[i]);
                LatLonPoint llpt = dataProject.projToLatLon(pt1);
                ProjectionPoint pt2 = displayProject.latLonToProj(llpt);
                if (showPts) {
                    System.out.println("getProjectedShape 2 " + xx[i] + " " + yy[i] + " === " + pt2.getX() + " " + pt2.getY());
                    if (displayProject.crossSeam(pt2, lastW)) {
                        System.out.println("***cross seam");
                    }
                }
                if (i == 0 || displayProject.crossSeam(pt2, lastW)) {
                    path.moveTo((float)pt2.getX(), (float)pt2.getY());
                } else {
                    path.lineTo((float)pt2.getX(), (float)pt2.getY());
                }
                lastW.setLocation(pt2);
            }
        }
        return path;
    }

    public int getPointCount() {
        return this.pointCnt;
    }

    public SampledSet getMapLines() {
        return this.getMapLines(null);
    }

    public SampledSet getMapLines(Rectangle2D bbox) {
        this.pointCnt = 0;
        if (this.getNumParts() == 0 || this.getNumPoints() == 0) {
            return null;
        }
        SampledSet maplines = null;
        ArrayList<MapSet> lines = new ArrayList<MapSet>();
        try {
            RealTupleType coordMathType = RealTupleType.SpatialEarth2DTuple;
            Iterator pi = this.getGisParts();
            while (pi.hasNext()) {
                int i;
                GisPart gp = (GisPart)pi.next();
                int np = gp.getNumPoints();
                double[] xx = gp.getX();
                double[] yy = gp.getY();
                if (bbox != null) {
                    boolean inBox = false;
                    for (i = 0; i < np; ++i) {
                        if (!bbox.contains(xx[i], yy[i])) continue;
                        inBox = true;
                        break;
                    }
                    if (!inBox) continue;
                }
                this.pointCnt += np;
                float[][] part = new float[2][np];
                for (i = 0; i < np; ++i) {
                    part[0][i] = (float)xx[i];
                    part[1][i] = (float)yy[i];
                }
                lines.add(new MapSet(coordMathType, part, np, (CoordinateSystem)null, (Unit[])null, (ErrorEstimate[])null, false));
            }
            if (lines.size() == 0) {
                return null;
            }
            SampledSet[] latLonLines = lines.toArray(new Gridded2DSet[lines.size()]);
            maplines = latLonLines.length > 1 ? new UnionSet(coordMathType, latLonLines, null, null, null, false) : latLonLines[0];
        }
        catch (VisADException e) {
            e.printStackTrace();
            System.out.println("numParts = " + this.getNumParts());
        }
        return maplines;
    }
}

