/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.text;

import java.util.Hashtable;
import java.util.List;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DirectDataChoice;
import ucar.unidata.data.FilesDataSource;
import ucar.unidata.data.text.Product;
import ucar.unidata.data.text.ProductGroup;
import ucar.unidata.data.text.ProductType;
import ucar.unidata.metdata.NamedStationImpl;
import ucar.unidata.metdata.NamedStationTable;
import ucar.unidata.util.DateSelection;

public abstract class TextProductDataSource
extends FilesDataSource {
    public TextProductDataSource() {
    }

    public TextProductDataSource(DataSourceDescriptor descriptor, String name, String description, Hashtable properties) {
        super(descriptor, name, description, properties);
    }

    public TextProductDataSource(DataSourceDescriptor descriptor, List newSources, String description, Hashtable properties) {
        super(descriptor, newSources, description, properties);
    }

    public TextProductDataSource(DataSourceDescriptor descriptor, List newSources, String name, String description, Hashtable properties) {
        super(descriptor, newSources, name, description, properties);
    }

    public abstract List<Product> readProducts(ProductType var1, List<NamedStationImpl> var2, DateSelection var3);

    public abstract NamedStationTable getStations(ProductType var1, DateSelection var2) throws Exception;

    protected static Hashtable<String, Integer> makeStationMap(List<NamedStationImpl> stations) {
        Hashtable<String, Integer> ids = new Hashtable<String, Integer>();
        if (stations != null && stations.size() > 0) {
            for (NamedStationImpl station : stations) {
                ids.put(station.getID(), new Integer(0));
            }
        }
        return ids;
    }

    public abstract List<ProductGroup> getProductGroups();

    @Override
    protected void doMakeDataChoices() {
        String category = "textproducts";
        String docName = this.getName();
        this.addDataChoice(new DirectDataChoice(this, (Object)docName, docName, docName, DataCategory.parseCategories(category, false)));
    }
}

