/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.text;

import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.List;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DirectDataChoice;
import ucar.unidata.data.FilesDataSource;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import visad.Data;
import visad.Text;
import visad.VisADException;

public class TextDataSource
extends FilesDataSource {
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(TextDataSource.class.getName());

    public TextDataSource() {
    }

    public TextDataSource(DataSourceDescriptor descriptor, String filename, Hashtable properties) {
        super(descriptor, filename, "Text data source", properties);
    }

    @Override
    public boolean canSaveDataToLocalDisk() {
        return !this.isFileBased();
    }

    @Override
    public void initAfterUnpersistence() {
        if (this.sources == null) {
            this.sources = Misc.newList(this.getName());
        }
        super.initAfterUnpersistence();
    }

    @Override
    protected void makeDerivedDataChoices(List dataChoices) {
    }

    @Override
    protected void doMakeDataChoices() {
        String category = this.getDescriptor().getProperty("categories");
        String docName = this.getSource();
        if (category == null) {
            category = IOUtil.isHtmlFile(docName) ? "html" : (IOUtil.isTextFile(docName) ? "text" : "unknown");
        }
        this.addDataChoice(new DirectDataChoice(this, (Object)docName, docName, docName, DataCategory.parseCategories(category, false)));
    }

    @Override
    protected Data getDataInner(DataChoice dataChoice, DataCategory category, DataSelection dataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        String filename = dataChoice.getStringId();
        try {
            return new Text(filename);
        }
        catch (Exception fnfe) {
            LogUtil.printException(log_, "getData", fnfe);
            return null;
        }
    }
}

