/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.text;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import ucar.unidata.data.BadDataException;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.text.Product;
import ucar.unidata.data.text.ProductGroup;
import ucar.unidata.data.text.ProductType;
import ucar.unidata.data.text.TextProductDataSource;
import ucar.unidata.metdata.NamedStationImpl;
import ucar.unidata.metdata.NamedStationTable;
import ucar.unidata.util.DateSelection;
import ucar.unidata.util.DateUtil;
import ucar.unidata.util.DatedObject;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.PatternFileFilter;
import ucar.unidata.util.StringUtil;

public class NwxTextProductDataSource
extends TextProductDataSource {
    private Hashtable<String, NamedStationTable> tableMap = new Hashtable();
    private String tablePath;
    private String textDataPath;
    private String gemDataPath;
    private Hashtable<String, String> paths = new Hashtable();
    private Properties nwxProperties;
    private static final String PROP_GEMTBL = "GEMTBL";
    private static final String PROP_TEXT_DATA = "TEXT_DATA";
    private static final String PROP_GEMDATA = "GEMDATA";
    private List<TableInfo> tables = new ArrayList<TableInfo>();
    private List<ProductGroup> productGroups;
    protected static String MASTER_TABLE = "master.tbl";
    protected static String GUI_TABLE = "guidata.tbl";
    private static SimpleDateFormat sdf;
    private boolean askForPaths = false;

    public NwxTextProductDataSource() {
    }

    public NwxTextProductDataSource(DataSourceDescriptor descriptor, String filename, Hashtable properties) {
        this(descriptor, Misc.newList(filename), properties);
    }

    public NwxTextProductDataSource(DataSourceDescriptor descriptor, List files, Hashtable properties) {
        this(descriptor, files, "NWX Text Products", "NWX Text Products", properties);
    }

    public NwxTextProductDataSource(DataSourceDescriptor descriptor, List newSources, String name, String description, Hashtable properties) {
        super(descriptor, newSources, name, description, properties);
    }

    public TableInfo getTableInfo(ProductType productType) {
        if (productType == null) {
            return null;
        }
        for (TableInfo tableInfo : this.tables) {
            if (!tableInfo.type.equals(productType.getId())) continue;
            return tableInfo;
        }
        return null;
    }

    @Override
    public NamedStationTable getStations(ProductType productType, DateSelection dateSelection) throws Exception {
        TableInfo tableInfo = this.getTableInfo(productType);
        if (tableInfo != null) {
            NamedStationTable stations = this.getStations(tableInfo);
            if (tableInfo.flag.equals("W")) {
                stations = this.getAvailableStations(stations, tableInfo, dateSelection);
            }
            return stations;
        }
        return null;
    }

    protected NamedStationTable getAvailableStations(NamedStationTable all, TableInfo tableInfo, DateSelection dateSelection) {
        if (all == null) {
            return all;
        }
        List<Product> products = this.readProducts(tableInfo, null, dateSelection);
        NamedStationTable subset = new NamedStationTable();
        HashSet<String> seen = new HashSet<String>();
        for (Product p : products) {
            String station = p.getStation();
            if (station == null || station.equals("") || seen.contains(station)) continue;
            seen.add(station);
            NamedStationImpl nstat = (NamedStationImpl)all.get(station);
            if (nstat == null) continue;
            subset.add(nstat, true);
        }
        return subset;
    }

    @Override
    public List<Product> readProducts(ProductType productType, List<NamedStationImpl> stations, DateSelection dateSelection) {
        TableInfo tableInfo = this.getTableInfo(productType);
        if (tableInfo != null && this.canHandleType(tableInfo)) {
            return this.readProducts(tableInfo, stations, dateSelection);
        }
        return new ArrayList<Product>();
    }

    private String readTableFile(String file) throws Exception {
        String contents = IOUtil.readContents(this.tablePath + "/nwx/" + file, this.getClass(), null);
        return contents;
    }

    private NamedStationTable getStations(TableInfo tableInfo) throws Exception {
        String contents = this.readTableFile(tableInfo.locationFile);
        if (contents == null) {
            return null;
        }
        try {
            NamedStationTable table = this.tableMap.get(tableInfo.locationFile);
            if (table == null) {
                table = new NamedStationTable("Stations for " + tableInfo.type);
                if (tableInfo.flag.equals("B") || tableInfo.flag.equals("S") || tableInfo.flag.equals("W")) {
                    table.createStationTableFromBulletin(contents);
                } else {
                    table.createStationTableFromGempak(contents);
                }
                this.tableMap.put(tableInfo.locationFile, table);
            }
            return table;
        }
        catch (Exception exc) {
            this.logException("Error reading table", exc);
            return null;
        }
    }

    @Override
    public List<ProductGroup> getProductGroups() {
        return this.productGroups;
    }

    protected String getPath(String prop, String title) {
        File dir;
        String path = this.paths.get(prop);
        if (path == null) {
            path = System.getenv(prop);
        }
        if (path == null && this.askForPaths && (dir = FileManager.getDirectory(null, title)) != null) {
            path = dir.toString();
            this.paths.put(prop, path);
        }
        return path;
    }

    protected String getTablePath() {
        return this.getPath(PROP_GEMTBL, "Where are the GEMPAK tables (GEMTBL) stored?");
    }

    protected boolean setAdditionalResources() {
        this.gemDataPath = this.getPath(PROP_GEMDATA, "Where is the GEMPAK data (GEMDATA) stored?");
        if (this.gemDataPath == null) {
            return false;
        }
        this.textDataPath = this.getPath(PROP_TEXT_DATA, "Where is the GEMPAK text data (TEXT_DATA) stored?");
        return this.textDataPath != null;
    }

    public String getAdditionalResourcesError() {
        return "You must have the GEMPAK environment variables GEMDATA and TEXT_DATA defined";
    }

    @Override
    protected void initAfter() {
        this.tablePath = this.getTablePath();
        if (this.tablePath == null) {
            this.askForPaths = GuiUtils.showYesNoDialog(null, "<html>You need to have access to GEMPAK tables and data.<p><br>Do you wish to continue?</html>", "Define GEMPAK Resources?");
            if (this.askForPaths) {
                this.tablePath = this.getTablePath();
            }
        }
        if (this.tablePath == null) {
            this.setInError(true, "Couldn't find path to text product tables");
            return;
        }
        if (!this.setAdditionalResources()) {
            this.setInError(true, this.getAdditionalResourcesError());
            return;
        }
        try {
            String masterTable = this.readTableFile(MASTER_TABLE);
            if (masterTable == null) {
                throw new BadDataException("Unable to read " + MASTER_TABLE);
            }
            List<String[]> tableInfo = StringUtil.parseLineWords(masterTable, new int[]{0, 13, 26, 28, 69}, new int[]{12, 12, 1, 40, 8}, "\n", "!", true);
            for (String[] tuple : tableInfo) {
                this.tables.add(new TableInfo(tuple[0], tuple[1], tuple[2], tuple[3], tuple[4]));
            }
            String gui = this.readTableFile(GUI_TABLE);
            if (gui == null) {
                throw new BadDataException("Unable to read " + GUI_TABLE);
            }
            this.productGroups = this.parseProductGroups(gui);
        }
        catch (Exception exc) {
            this.logException("Error initializing table based products", exc);
            this.setInError(true, "Error initializing table based products");
        }
    }

    private List<ProductGroup> parseProductGroups(String contents) throws Exception {
        contents = contents.replace("{", "\n{\n");
        contents = contents.replace("}", "\n}\n");
        List<String> lines = StringUtil.split(contents, "\n", true, true);
        ArrayList<ProductGroup> products = new ArrayList<ProductGroup>();
        ProductGroup productGroup = null;
        boolean inProduct = false;
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (productGroup != null) {
                String render;
                if (line.equals("}")) {
                    if (!productGroup.getProductTypes().isEmpty()) {
                        products.add(productGroup);
                    }
                    productGroup = null;
                    continue;
                }
                if (line.equals("{")) continue;
                String[] toks = StringUtil.split(line, "|", 2);
                if (toks == null || toks.length != 2) {
                    throw new IllegalArgumentException("Bad line:" + line);
                }
                if (toks[0].startsWith("(") || toks[0].startsWith("!")) continue;
                ProductType pt = new ProductType(toks[0].replace("_", " "), toks[1]);
                if (this.nwxProperties == null) {
                    this.nwxProperties = new Properties();
                    this.nwxProperties = Misc.readProperties("/ucar/unidata/data/text/nwx.properties", this.nwxProperties, this.getClass());
                }
                if ((render = (String)this.nwxProperties.get(pt.getId() + ".html")) == null) {
                    render = "false";
                }
                render = render.trim();
                pt.setRenderAsHtml(Misc.equals(render, "true"));
                TableInfo ti = this.getTableInfo(pt);
                if (ti == null || !this.canHandleType(ti)) continue;
                productGroup.addProduct(pt);
                continue;
            }
            productGroup = line.equals("{") ? null : new ProductGroup(line.replace("_", " "));
        }
        return products;
    }

    protected List<Product> readProducts(TableInfo tableInfo, List<NamedStationImpl> stations, DateSelection dateSelection) {
        int maxCount;
        List<Object> datedObjects = new ArrayList();
        datedObjects = this.getFiles(tableInfo, dateSelection);
        ArrayList<Product> products = new ArrayList<Product>();
        if (datedObjects == null || datedObjects.isEmpty()) {
            return products;
        }
        int n = maxCount = dateSelection == null ? Integer.MAX_VALUE : dateSelection.getCount();
        if (stations != null) {
            maxCount = Math.min(stations.size() * maxCount, Integer.MAX_VALUE);
        }
        int count = 0;
        boolean ok = true;
        for (DatedObject datedObject : datedObjects) {
            if (!ok) break;
            try {
                File f = (File)datedObject.getObject();
                List<Product> productsInFile = NwxTextProductDataSource.parseProduct(f.toString(), true, stations, maxCount);
                for (Product product : productsInFile) {
                    products.add(product);
                    if (++count < maxCount) continue;
                    ok = false;
                }
            }
            catch (Exception exception) {}
        }
        return products;
    }

    private List<DatedObject> getFiles(TableInfo tableInfo, DateSelection dateSelection) {
        String path = tableInfo.dataDir;
        path = path.replace("$TEXT_DATA", this.textDataPath);
        File dir = new File(path = path.replace("$GEMDATA", this.gemDataPath));
        File[] files = dir.listFiles(new PatternFileFilter(".*\\." + tableInfo.fileExtension));
        if (files == null || files.length == 0) {
            return null;
        }
        Date[] dateRange = dateSelection == null ? null : dateSelection.getRange();
        ArrayList<DatedObject> datedObjects = new ArrayList();
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            Date fileDate = NwxTextProductDataSource.getDateFromFileName(f.toString());
            if (fileDate == null) {
                fileDate = new Date(f.lastModified());
            }
            datedObjects.add(new DatedObject(fileDate, f));
        }
        datedObjects = DatedObject.sort(datedObjects, false);
        if (dateRange == null) {
            return datedObjects;
        }
        ArrayList<DatedObject> validFiles = new ArrayList<DatedObject>();
        for (DatedObject datedObject : datedObjects) {
            if (dateSelection.isLatest() || dateSelection.isAll()) {
                validFiles.add(datedObject);
                continue;
            }
            Date fileDate = datedObject.getDate();
            if (dateRange[0].getTime() > fileDate.getTime() || fileDate.getTime() > dateRange[1].getTime()) continue;
            validFiles.add(datedObject);
        }
        return validFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getDateFromFileName(String path) {
        if (sdf == null) {
            sdf = new SimpleDateFormat();
            sdf.setTimeZone(DateUtil.TIMEZONE_GMT);
        }
        String tmp = IOUtil.getFileTail(path);
        String pattern = "yyyyMMddhh";
        String regex = "(\\d{8,10})";
        String dateString = StringUtil.findPattern(tmp, regex);
        if (dateString != null) {
            if (dateString.length() == 8) {
                pattern = "yyMMddhh";
            }
            try {
                SimpleDateFormat simpleDateFormat = sdf;
                synchronized (simpleDateFormat) {
                    sdf.applyPattern(pattern);
                    return sdf.parse(dateString);
                }
            }
            catch (Exception exc) {
                System.err.println("no date in file name: " + path + ": " + exc);
            }
        }
        return null;
    }

    private static List<Product> parseProduct(String path, boolean recordType, List<NamedStationImpl> stations, int maxCount) throws Exception {
        int idx2;
        int idx1;
        ArrayList<Product> products = new ArrayList<Product>();
        String contents = IOUtil.readContents(path, NwxTextProductDataSource.class);
        String prefix = recordType ? "\u0001" : "\u0001";
        String suffix = recordType ? "\u0003" : "\u0003";
        int idx = 0;
        Hashtable<String, Integer> ids = NwxTextProductDataSource.makeStationMap(stations);
        Date fileDate = NwxTextProductDataSource.getDateFromFileName(path);
        while ((idx1 = contents.indexOf(prefix, idx)) >= 0 && (idx2 = contents.indexOf(suffix, idx1)) >= 0) {
            int num;
            List<String> toks;
            int endLineIdx;
            idx = idx2 + 1;
            String product = contents.substring(idx1 + 1, idx2 - 1);
            int lineCnt = 0;
            int startLineIdx = 0;
            String stationLine = null;
            boolean seenNonBlankLine = false;
            Date date = null;
            String afosPil = "";
            String wmoID = "";
            while ((endLineIdx = product.indexOf("\n", startLineIdx)) >= 0) {
                String line = product.substring(startLineIdx, endLineIdx);
                startLineIdx = endLineIdx + 1;
                String tline = line.trim();
                if (seenNonBlankLine || tline.length() > 0) {
                    seenNonBlankLine = true;
                    if (++lineCnt == 2) {
                        stationLine = line;
                    } else if (lineCnt == 3) {
                        afosPil = line;
                    }
                }
                if (lineCnt <= 8) continue;
                break;
            }
            if (stationLine == null || (toks = StringUtil.split(stationLine, " ", true, true)).size() < 3) continue;
            wmoID = toks.get(0);
            String stationString = toks.get(1);
            String dateString = toks.get(2);
            date = DateUtil.decodeWMODate(dateString, fileDate);
            if (date == null) {
                date = fileDate;
            }
            if (ids == null || ids.isEmpty()) {
                products.add(new Product(stationString, product, date));
                continue;
            }
            if (ids.get(stationString) == null || (num = ids.get(stationString).intValue()) >= maxCount) continue;
            products.add(new Product(stationString, product, date));
            ids.put(stationString, new Integer(num++));
        }
        return products;
    }

    protected boolean canHandleType(TableInfo ti) {
        return ti.flag.equals("B") || ti.flag.equals("W") || ti.flag.equals("F");
    }

    public void setPaths(Hashtable<String, String> value) {
        this.paths = value;
    }

    public Hashtable<String, String> getPaths() {
        return this.paths;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("need to supply a file name");
            System.exit(1);
        }
        System.out.println(NwxTextProductDataSource.getDateFromFileName(args[0]));
    }

    protected class TableInfo {
        public static final String FLAG_B = "B";
        public static final String FLAG_S = "S";
        public static final String FLAG_W = "W";
        public static final String FLAG_R = "R";
        public static final String FLAG_M = "M";
        public static final String FLAG_F = "F";
        public static final String FLAG_Z = "Z";
        public static final String FLAG_O = "O";
        String type;
        String locationFile;
        String flag;
        String dataDir;
        String fileExtension;

        public TableInfo(String type, String locationFile, String flag, String dataDir, String fileExtension) {
            this.type = type;
            this.locationFile = locationFile;
            this.flag = flag;
            this.dataDir = dataDir;
            this.fileExtension = fileExtension;
        }

        public boolean useStationTable() {
            return !this.flag.equals(FLAG_W);
        }

        public String toString() {
            return this.type + ":" + this.locationFile + ":" + this.flag + ":" + this.dataDir + ":" + this.fileExtension;
        }
    }
}

