/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.text;

import edu.wisc.ssec.mcidas.adde.AddeTextReader;
import java.io.ByteArrayInputStream;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTextField;
import ucar.unidata.data.BadDataException;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DirectDataChoice;
import ucar.unidata.data.FilesDataSource;
import ucar.unidata.util.DateUtil;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.UtcDate;
import visad.Data;
import visad.DateTime;
import visad.Text;
import visad.VisADException;

public class FrontDataSource
extends FilesDataSource {
    private static final String TIME_FORMAT = "yyyy_MM_dd_HH_mm";
    public static final String PROP_TIMEWINDOW = "front.timewindow";
    private static final String TYPE_HIGHS = "HIGHS";
    private static final String TYPE_LOWS = "LOWS";
    private static final String TYPE_STNRY = "STNRY";
    private static final String TYPE_COLD = "COLD";
    private static final String TYPE_WARM = "WARM";
    private static final String TYPE_TROF = "TROF";
    private static final String TYPE_OCFNT = "OCFNT";
    private static final List TYPES = new ArrayList();
    private double timeWindow = 3.0;
    private JTextField timeWindowField;
    private List errors;
    private List warnings;
    private SimpleDateFormat sdf;
    private DateTime baseTime = null;
    private static final GregorianCalendar calendar = new GregorianCalendar();

    public FrontDataSource() {
    }

    public FrontDataSource(DataSourceDescriptor descriptor, String filename, Hashtable properties) {
        this(descriptor, Misc.newList(filename), properties);
    }

    public FrontDataSource(DataSourceDescriptor descriptor, List files, Hashtable properties) {
        super(descriptor, files, (String)files.get(0), "Front data source", properties);
        this.timeWindow = this.getProperty(PROP_TIMEWINDOW, this.timeWindow);
    }

    @Override
    public boolean canSaveDataToLocalDisk() {
        return !this.isFileBased();
    }

    @Override
    protected String getDataFileExtension(String file) {
        return "fcst";
    }

    protected String getDataFilePrefix(String file) {
        return "front";
    }

    @Override
    public void getPropertiesComponents(List comps) {
        super.getPropertiesComponents(comps);
        this.timeWindowField = new JTextField("" + this.timeWindow, 6);
        comps.add(GuiUtils.rLabel("Time Window:"));
        comps.add(GuiUtils.left(GuiUtils.hbox(this.timeWindowField, new JLabel(" hours"))));
    }

    @Override
    public boolean applyProperties() {
        if (!super.applyProperties()) {
            return false;
        }
        this.timeWindow = new Double(this.timeWindowField.getText().trim());
        this.flushCache();
        return true;
    }

    @Override
    protected void doMakeDataChoices() {
        String category = "fronts";
        String docName = this.getName();
        this.addDataChoice(new DirectDataChoice(this, (Object)docName, docName, docName, DataCategory.parseCategories(category, false)));
    }

    @Override
    protected Data getDataInner(DataChoice dataChoice, DataCategory category, DataSelection dataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        try {
            String xml = this.parseContents();
            if (xml == null) {
                return null;
            }
            return new Text(xml);
        }
        catch (Exception exc) {
            this.logException("Could not process front file contents: " + this.sources, exc);
            return null;
        }
    }

    @Override
    protected String processDataFilename(String filename, int index) {
        return FrontDataSource.convertFilename(filename);
    }

    private static String convertFilename(String filename) {
        int index = filename.indexOf("%DAY-");
        if (index >= 0) {
            String tok = filename.substring(index + 1);
            GregorianCalendar now = new GregorianCalendar();
            now.setTime(new Date());
            int year = now.get(1);
            int index2 = tok.indexOf("%");
            tok = tok.substring(0, index2);
            String deltas = tok.substring(4, index2);
            int delta = new Integer(deltas);
            now.add(6, -delta);
            String days = "" + now.get(6);
            days = StringUtil.padLeft(days, 3, "0");
            String yearDay = now.get(1) + "" + days;
            filename = StringUtil.replace(filename, "%DAY-" + delta + "%", yearDay);
        }
        return filename;
    }

    private String parseContents() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("<shapes " + XmlUtil.attrs("title", "Fronts", "usetimesinanimation", "true", "frontdisplay", "true") + ">\n");
        this.errors = new ArrayList();
        this.warnings = new ArrayList();
        ArrayList contentsList = new ArrayList();
        boolean anyOk = false;
        for (int i = 0; i < this.sources.size(); ++i) {
            String filename = (String)this.sources.get(i);
            filename = FrontDataSource.convertFilename(filename);
            LogUtil.message("Reading front data: " + filename);
            String contents = this.getContents(filename);
            if (contents == null) continue;
            try {
                this.parseContents(sb, contents);
                anyOk = true;
                continue;
            }
            catch (BadDataException bde) {
                this.errors.add(bde.getMessage());
            }
        }
        LogUtil.message("");
        if (!anyOk) {
            this.errors.addAll(this.warnings);
        }
        if (this.errors.size() > 0) {
            LogUtil.userErrorMessage("There were errors processing the front file:\n" + StringUtil.join("\n", this.errors));
        }
        if (anyOk && this.warnings.size() > 0) {
            System.err.println("There were warnings processing the front file:\n" + StringUtil.join("\n", this.warnings));
        }
        if (!anyOk) {
            return null;
        }
        sb.append("</shapes>\n");
        return sb.toString();
    }

    @Override
    protected List getInputStreams(List processedSources) throws Exception {
        ArrayList<ByteArrayInputStream> is = new ArrayList<ByteArrayInputStream>();
        for (int i = 0; i < processedSources.size(); ++i) {
            is.add(new ByteArrayInputStream(this.getContents(processedSources.get(i).toString()).getBytes()));
        }
        return is;
    }

    private String getContents(String filename) throws Exception {
        if (filename.startsWith("adde:")) {
            AddeTextReader reader = new AddeTextReader(filename);
            if (!reader.getStatus().equals("OK")) {
                this.errors.add("Unable to read adde url: " + filename);
            }
            return reader.getText();
        }
        return IOUtil.readContents(filename);
    }

    private void parseContents(StringBuffer sb, String c) throws Exception {
        List<String> lines = StringUtil.split(c, "\n", true, true);
        ValidBlock block = null;
        for (int idx = 0; idx < lines.size(); ++idx) {
            String line = lines.get(idx);
            if (block == null && (line.indexOf(" PM ") >= 0 || line.indexOf(" AM ") >= 0)) {
                List<String> timeToks = StringUtil.split(line, " ", true, true);
                String ts = StringUtil.join(" ", timeToks);
                if (timeToks.size() == 7) {
                    try {
                        this.baseTime = UtcDate.createDateTime(ts, "hmm a z EEE MMM dd yyyy");
                    }
                    catch (Exception exc) {
                        this.errors.add("Could not parse base time:" + ts);
                    }
                } else {
                    this.errors.add("Could not parse base time:" + ts);
                }
            }
            if (line.indexOf("$$") >= 0) {
                if (block != null) {
                    this.processBlock(block, sb);
                }
                this.baseTime = null;
                block = null;
                continue;
            }
            if (line.indexOf("VALID") >= 0) {
                if (block != null) {
                    this.processBlock(block, sb);
                }
                block = new ValidBlock(line);
                continue;
            }
            if (block == null) continue;
            List<String> toks = StringUtil.split(line, " ", true, true);
            toks.remove("$$");
            block.toks.addAll(toks);
        }
        if (block != null) {
            this.processBlock(block, sb);
        }
    }

    private void processBlock(ValidBlock block, StringBuffer sb) throws Exception {
        if (TYPES.size() == 0) {
            TYPES.addAll(Misc.newList(TYPE_HIGHS, TYPE_LOWS, TYPE_STNRY, TYPE_COLD));
            TYPES.addAll(Misc.newList(TYPE_WARM, TYPE_TROF, TYPE_OCFNT));
        }
        Date validTime = null;
        List<String> validToks = StringUtil.split(block.validLine, " ", true, true);
        if (validToks.size() == 2 || validToks.size() == 4) {
            String ts;
            String format;
            if (validToks.size() == 2) {
                format = "yyyyMMddHH";
                ts = validToks.get(1);
            } else {
                ts = validToks.get(3);
                format = "yyyyMMddHHmm";
            }
            if (ts.endsWith("Z")) {
                ts = ts.substring(0, ts.length() - 1);
            }
            try {
                if (ts.length() <= 6 && this.baseTime != null) {
                    calendar.setTime(new Date(1000L * (long)this.baseTime.getValue()));
                    if (validToks.size() == 2) {
                        ts = calendar.get(1) + ts;
                    } else {
                        String month = "" + (calendar.get(2) + 1);
                        if (month.length() == 1) {
                            month = "0" + month;
                        }
                        ts = calendar.get(1) + month + ts;
                    }
                }
                DateTime dttm = UtcDate.createDateTime(ts, format);
                validTime = new Date(1000L * (long)dttm.getValue());
            }
            catch (Exception exc) {
                this.errors.add("Could not parse time:" + ts);
            }
        } else {
            this.errors.add("Could not parse time:" + block.validLine);
        }
        List toks = block.toks;
        String currentType = null;
        ArrayList<String> subToks = null;
        for (int i = 0; i < toks.size(); ++i) {
            String tok = (String)toks.get(i);
            if (TYPES.contains(tok)) {
                if (currentType != null && subToks.size() > 0) {
                    try {
                        this.processType(currentType, subToks, sb, validTime);
                    }
                    catch (BadDataException bde) {
                        this.errors.add(bde.getMessage());
                    }
                }
                currentType = tok;
                subToks = new ArrayList<String>();
                continue;
            }
            if (subToks != null && currentType != null) {
                subToks.add(tok);
                continue;
            }
            throw new BadDataException("Unknown token block:" + toks);
        }
        if (currentType != null && subToks.size() > 0) {
            try {
                this.processType(currentType, subToks, sb, validTime);
            }
            catch (BadDataException bde) {
                this.errors.add(bde.getMessage());
            }
        }
    }

    private double[] parse(List toks) {
        toks.remove("$$");
        return Misc.parseDoubles(StringUtil.join(",", toks), ",");
    }

    double[] getLatLon(String s) {
        int splitIndex = 2;
        double divisor = 1.0;
        if (s.length() > 5) {
            splitIndex = 3;
            divisor = 10.0;
        }
        double lat = new Double(s.substring(0, splitIndex)) / divisor;
        double lon = -new Double(s.substring(splitIndex)).doubleValue() / divisor;
        return new double[]{lat, lon};
    }

    private void processType(String type, List toks, StringBuffer sb, Date validTime) throws Exception {
        StringBuffer dttms = new StringBuffer();
        if (validTime != null) {
            if (this.sdf == null) {
                this.sdf = new SimpleDateFormat();
                this.sdf.applyPattern(TIME_FORMAT);
                this.sdf.setTimeZone(DateUtil.TIMEZONE_GMT);
            }
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(validTime);
            dttms.append(" timeformat=\"yyyy_MM_dd_HH_mm\" ");
            dttms.append(" times=\"");
            int delta = (int)(60.0 * this.timeWindow / 2.0);
            cal.add(12, -delta);
            dttms.append(this.sdf.format(cal.getTime()));
            dttms.append(",");
            cal.add(12, 2 * delta);
            dttms.append(this.sdf.format(cal.getTime()));
            dttms.append("\" ");
        }
        if (type.equals(TYPE_HIGHS) || type.equals(TYPE_LOWS)) {
            String color = type.equals(TYPE_HIGHS) ? "0,0,255" : "255,0,0";
            boolean high = type.equals(TYPE_HIGHS);
            for (int i = 0; i < toks.size(); ++i) {
                double lon;
                double lat;
                String pressure;
                block21: {
                    String pos;
                    block20: {
                        if (i == toks.size() - 1) {
                            this.warnings.add("Missing location value in " + type + " list: " + StringUtil.join(" ", toks));
                            continue;
                        }
                        pressure = (String)toks.get(i);
                        try {
                            double pd = new Double(pressure);
                            if (pd < 800.0 || pd > 1100.0) {
                                this.warnings.add("Bad pressure data: " + pressure + " in " + type + " list: " + StringUtil.join(" ", toks));
                            }
                            break block20;
                        }
                        catch (NumberFormatException nfe) {
                            this.errors.add("Bad pressure value: " + pressure + " in " + type + " list: " + StringUtil.join(" ", toks));
                        }
                        continue;
                    }
                    if ((pos = (String)toks.get(++i)).length() < 4 || pos.length() > 7) {
                        this.warnings.add("Bad location value: " + pos + " in " + type + " list: " + StringUtil.join(" ", toks));
                        continue;
                    }
                    lat = 0.0;
                    lon = 0.0;
                    try {
                        double[] ll = this.getLatLon(pos);
                        lat = ll[0];
                        if (Math.abs(lat) > 90.0) {
                            this.warnings.add("Bad latitude value: " + pos + " in " + type + " list: " + StringUtil.join(" ", toks));
                            continue;
                        }
                        lon = ll[1];
                        if (Math.abs(lon) > 180.0) {
                            this.warnings.add("Bad longitude value: " + pos + " in " + type + " list: " + StringUtil.join(" ", toks));
                        }
                        break block21;
                    }
                    catch (Exception exc) {
                        this.warnings.add("Bad location value: " + pos + " in " + type + " list: " + StringUtil.join(" ", toks));
                    }
                    continue;
                }
                sb.append("<" + (high ? "high" : "low") + " " + dttms.toString());
                sb.append(XmlUtil.attr("coordtype", "LATLON"));
                sb.append(XmlUtil.attr("pressure", pressure));
                sb.append(XmlUtil.attr("points", lat + "," + lon));
                sb.append("/>\n");
            }
        } else {
            StringBuffer attrs = new StringBuffer();
            attrs.append(XmlUtil.attr("coordtype", "LATLON"));
            StringBuffer points = new StringBuffer();
            int cnt = 0;
            String subType = null;
            for (int i = 0; i < toks.size(); ++i) {
                String newTok;
                int newSize;
                String tok = (String)toks.get(i);
                int size = tok.length();
                if (size < 4 && i < toks.size() - 1 && (newSize = size + (newTok = (String)toks.get(i + 1)).length()) >= 4 && newSize < 8) {
                    tok = tok + newTok;
                    ++i;
                }
                try {
                    double[] ll = this.getLatLon(tok);
                    if (cnt > 0) {
                        points.append(",");
                    }
                    points.append(ll[0]);
                    points.append(",");
                    points.append(ll[1]);
                    ++cnt;
                    continue;
                }
                catch (NumberFormatException nfe) {
                    if (subType == null) {
                        subType = tok;
                        continue;
                    }
                    throw new BadDataException("Bad front state: " + tok + " " + toks);
                }
            }
            attrs.append(XmlUtil.attr("points", points.toString()));
            String frontType = this.getFrontType(type, subType);
            attrs.append(XmlUtil.attr("fronttype", frontType));
            sb.append("<front " + dttms.toString());
            sb.append(attrs);
            sb.append("/>\n");
        }
    }

    private String getFrontType(String type, String subType) {
        if (type.equals(TYPE_COLD)) {
            return "COLD_FRONT";
        }
        if (type.equals(TYPE_WARM)) {
            return "WARM_FRONT";
        }
        if (type.equals(TYPE_OCFNT)) {
            return "OCCLUDED_FRONT";
        }
        if (type.equals(TYPE_TROF)) {
            return "TROUGH";
        }
        if (type.equals(TYPE_STNRY)) {
            return "STATIONARY_FRONT";
        }
        throw new BadDataException("Unknown front type:" + type);
    }

    public void setTimeWindow(double value) {
        this.timeWindow = value;
    }

    public double getTimeWindow() {
        return this.timeWindow;
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < 20; ++i) {
            FrontDataSource.convertFilename("foo%DAY-" + i + "%");
        }
    }

    private static class ValidBlock {
        String validLine;
        List toks = new ArrayList();

        ValidBlock(String line) {
            this.validLine = line;
        }
    }
}

