/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.text;

import edu.wisc.ssec.mcidas.McIDASUtil;
import edu.wisc.ssec.mcidas.adde.AddeTextReader;
import edu.wisc.ssec.mcidas.adde.WxTextProduct;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.text.NwxTextProductDataSource;
import ucar.unidata.data.text.Product;
import ucar.unidata.metdata.NamedStationImpl;
import ucar.unidata.util.DateSelection;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;

public class AddeTextProductDataSource
extends NwxTextProductDataSource {
    private Properties warningProps;
    private static final String WARN_PROP_FILE = "warnings.search.properties";
    public static final String PROP_TABLE_PATH = "text.table.path";
    public static final String PROP_WARN_PATH = "text.warning.path";

    public AddeTextProductDataSource() {
    }

    public AddeTextProductDataSource(DataSourceDescriptor descriptor, String filename, Hashtable properties) {
        this(descriptor, Misc.newList(filename), properties);
    }

    public AddeTextProductDataSource(DataSourceDescriptor descriptor, List files, Hashtable properties) {
        super(descriptor, files, "ADDE Text Products", "ADDE Text Products", properties);
    }

    @Override
    protected List<Product> readProducts(NwxTextProductDataSource.TableInfo ti, List<NamedStationImpl> stations, DateSelection dateSelection) {
        ArrayList<Product> products = new ArrayList<Product>();
        if (!this.canHandleType(ti)) {
            return products;
        }
        String base = "adde://" + this.getDataContext().getIdv().getProperty("textserver", "adde.ucar.edu") + "/";
        try {
            if (!ti.flag.equals("O")) {
                if (stations == null) {
                    stations = new ArrayList<NamedStationImpl>();
                    stations.add(null);
                }
                for (NamedStationImpl station : stations) {
                    String url = base + this.getWxTextRequest(ti, station, dateSelection);
                    AddeTextReader atr = new AddeTextReader(url);
                    List<WxTextProduct> prods = atr.getWxTextProducts();
                    for (WxTextProduct wtp : prods) {
                        products.add(new Product(wtp.getWstn(), wtp.getText(), wtp.getDate()));
                    }
                }
            } else {
                String url = base + this.getObTextRequest(ti, stations, dateSelection);
                AddeTextReader atr = new AddeTextReader(url);
                String obs = atr.getText();
                products.add(new Product(stations.toString(), atr.getText(), new Date()));
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return products;
    }

    private String getWxTextRequest(NwxTextProductDataSource.TableInfo ti, NamedStationImpl station, DateSelection dateSelection) {
        Date[] dateRange = dateSelection == null || dateSelection.isLatest() || dateSelection.isAll() ? null : dateSelection.getRange();
        Date endTime = dateRange == null ? new Date() : dateRange[1];
        int[] endDT = McIDASUtil.mcSecsToDayTime(endTime.getTime() / 1000L);
        int maxCount = dateSelection == null || dateSelection.isLatest() ? 1 : dateSelection.getCount();
        int dtime = 720;
        if (dateRange != null) {
            int hours = (int)(Math.abs(dateRange[1].getTime() - dateRange[0].getTime()) / 3600000L);
            if (hours < 1) {
                hours = 1;
            }
            dtime = hours;
        }
        StringBuilder buf = new StringBuilder("wxtext?");
        if (ti.flag.equals("W")) {
            if (this.warningProps != null) {
                String search = this.warningProps.getProperty(ti.type);
                if (search != null) {
                    buf.append(search);
                }
                if (station != null) {
                    buf.append("&WSTN=");
                    buf.append(station.getID());
                }
            } else {
                String apro = ti.fileExtension;
                if (apro.length() == 3 && StringUtil.isUpperCase(apro)) {
                    buf.append("APRO=");
                    buf.append(apro);
                    if (station != null) {
                        buf.append("&WSTN=");
                        buf.append(station.getID());
                    }
                }
            }
        } else if (ti.flag.equals("F")) {
            String afos = station.getID();
            if (afos == null || afos.equals("")) {
                return "";
            }
            buf.append("APRO=");
            buf.append(afos.substring(0, 3));
            buf.append("&ASTN=");
            buf.append(afos.substring(3));
        } else {
            buf.append("WMO=");
            buf.append(station.getProperty("bull", "NONE"));
            buf.append("&WSTN=");
            buf.append(station.getID());
            String apro = ti.fileExtension;
            if (apro.length() == 3 && StringUtil.isUpperCase(apro)) {
                buf.append("&APRO=");
                buf.append(apro);
            }
        }
        buf.append("&dtime=");
        buf.append(dtime);
        buf.append("&num=");
        buf.append(maxCount);
        buf.append("&day=");
        buf.append(endDT[0]);
        return buf.toString();
    }

    private String getObTextRequest(NwxTextProductDataSource.TableInfo ti, List<NamedStationImpl> stations, DateSelection dateSelection) {
        Date[] dateRange = dateSelection == null || dateSelection.isLatest() || dateSelection.isAll() ? null : dateSelection.getRange();
        Date start = dateRange == null ? null : dateRange[0];
        Date end = dateRange == null ? null : dateRange[1];
        int maxCount = dateSelection == null || dateSelection.isLatest() ? 1 : dateSelection.getCount();
        StringBuilder buf = new StringBuilder("obtext?");
        buf.append("&ID=");
        for (NamedStationImpl station : stations) {
            String id = station.getID();
            String idn = (String)station.getProperty("idn", "");
            if (!idn.equals("")) {
                idn = idn.substring(0, 5);
            }
            if (ti.type.equals("SND_DATA")) {
                id = idn;
            } else if (ti.type.equals("SYN_DATA")) {
                id = idn;
            } else if (id.length() < 4) {
                id = "K" + id;
            }
            buf.append(id);
            buf.append(" ");
        }
        int hourMod = 1;
        buf.append("&descriptor=");
        if (ti.type.equals("SND_DATA")) {
            buf.append("UPPERAIR");
            hourMod = 3;
        } else if (ti.type.equals("SYN_DATA")) {
            buf.append("SYNOPTIC");
            hourMod = 3;
        } else if (ti.type.equals("TAFS_DEC")) {
            buf.append("TERMFCST");
        } else {
            buf.append("SFCHOURLY");
        }
        if (dateRange != null) {
            int[] endDT = McIDASUtil.mcSecsToDayTime(end.getTime() / 1000L);
            int endHour = endDT[1] / 10000;
            endHour -= endHour % hourMod;
            buf.append("&newest=");
            buf.append(endDT[0]);
            buf.append(" ");
            buf.append(endHour);
            int[] startDT = McIDASUtil.mcSecsToDayTime(start.getTime() / 1000L);
            int startHour = startDT[1] / 10000;
            startHour -= startHour % hourMod;
            buf.append("&oldest=");
            buf.append(startDT[0]);
            buf.append(" ");
            buf.append(startHour);
        }
        buf.append("&num=");
        buf.append(maxCount);
        return buf.toString();
    }

    @Override
    protected String getTablePath() {
        return this.getIdvProperty(PROP_TABLE_PATH, "http://www.unidata.ucar.edu/software/idv/resources");
    }

    @Override
    protected boolean setAdditionalResources() {
        return true;
    }

    @Override
    public String getAdditionalResourcesError() {
        return "";
    }

    @Override
    protected void initAfter() {
        super.initAfter();
        String warningPropFile = null;
        try {
            warningPropFile = this.getIdvProperty(PROP_WARN_PATH, this.getTablePath() + "/nwx/" + WARN_PROP_FILE);
            this.warningProps = Misc.readProperties(warningPropFile, this.warningProps, this.getClass());
        }
        catch (Exception e) {
            System.err.println("Couldn't read warning property file: " + warningPropFile);
        }
    }

    @Override
    protected boolean canHandleType(NwxTextProductDataSource.TableInfo ti) {
        return ti.flag.equals("B") || ti.flag.equals("F") || ti.flag.equals("W") || ti.flag.equals("O");
    }

    private String getIdvProperty(String name, String def) {
        return this.getDataContext().getIdv().getProperty(name, def);
    }
}

