/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.storm;

import java.util.ArrayList;
import java.util.List;
import ucar.unidata.data.storm.StormParam;
import visad.DateTime;
import visad.Real;
import visad.georef.EarthLocation;

public class StormTrackPoint
implements Comparable {
    private int id = -1;
    private boolean edited = false;
    private EarthLocation location;
    private DateTime time;
    private List<Real> attributes;
    private int forecastHour = 0;

    public StormTrackPoint(StormTrackPoint that) {
        this.location = that.location;
        this.time = that.time;
        if (that.attributes != null) {
            this.attributes = new ArrayList<Real>(that.attributes);
        }
        this.forecastHour = that.forecastHour;
        this.id = that.id;
        this.edited = that.edited;
    }

    public StormTrackPoint(EarthLocation pointLocation, DateTime time, int forecastHour, List<Real> attrs) {
        this.location = pointLocation;
        this.time = time;
        this.forecastHour = forecastHour;
        this.attributes = attrs;
    }

    public int compareTo(Object o) {
        if (o instanceof StormTrackPoint) {
            StormTrackPoint that = (StormTrackPoint)o;
            return this.time.compareTo(that.time);
        }
        return this.toString().compareTo(o.toString());
    }

    public void setForecastHour(int value) {
        this.forecastHour = value;
    }

    public int getForecastHour() {
        return this.forecastHour;
    }

    public void setTime(DateTime time) {
        this.time = time;
    }

    public DateTime getTime() {
        return this.time;
    }

    public void setLocation(EarthLocation point) {
        this.location = point;
    }

    public EarthLocation getLocation() {
        return this.location;
    }

    public List<Real> getTrackAttributes() {
        return this.attributes;
    }

    public String toString() {
        return this.location + "";
    }

    public Real getAttribute(StormParam param) {
        return param.getAttribute(this.attributes);
    }

    public void setAttribute(Real real) {
        for (Real attr : this.attributes) {
            if (!attr.getType().equals(real.getType())) continue;
            this.attributes.remove(attr);
            this.attributes.add(real);
        }
    }

    public void addAttribute(Real attr) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<Real>();
        }
        this.attributes.add(attr);
    }

    public void setId(int value) {
        this.id = value;
    }

    public int getId() {
        return this.id;
    }

    public void setEdited(boolean value) {
        this.edited = value;
    }

    public boolean getEdited() {
        return this.edited;
    }
}

