/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.storm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import ucar.unidata.data.storm.StormInfo;
import ucar.unidata.data.storm.StormParam;
import ucar.unidata.data.storm.StormTrack;
import ucar.unidata.data.storm.StormTrackPoint;
import ucar.unidata.data.storm.Way;
import visad.DateTime;

public class StormTrackCollection {
    private HashMap<Way, List> wayToTracksHashMap;
    List<StormTrack> tracks = new ArrayList<StormTrack>();

    public StormTrackCollection() {
        this.wayToTracksHashMap = new HashMap();
    }

    public List<Way> getWayList() {
        Set<Way> ss = this.wayToTracksHashMap.keySet();
        ArrayList<Way> ways = new ArrayList<Way>();
        ways.addAll(ss);
        return ways;
    }

    public void addTrackList(List<StormTrack> tracks) {
        for (StormTrack track : tracks) {
            this.addTrack(track);
        }
    }

    public void addTrack(StormTrack track) {
        ArrayList<StormTrack> list = this.wayToTracksHashMap.get(track.getWay());
        if (list == null) {
            list = new ArrayList<StormTrack>();
            this.wayToTracksHashMap.put(track.getWay(), list);
        }
        list.add(track);
        this.tracks.add(track);
    }

    public List<StormTrack> getTracks() {
        return new ArrayList<StormTrack>(this.tracks);
    }

    public List<StormTrack> getTrackList(Way way) {
        return this.wayToTracksHashMap.get(way);
    }

    public HashMap<Way, List> getWayToTracksHashMap() {
        return this.wayToTracksHashMap;
    }

    public HashMap getWayToStartDatesHashMap() {
        HashMap wayToStartDatesHashMap = new HashMap();
        int size = this.wayToTracksHashMap.size();
        Set<Way> ways = this.wayToTracksHashMap.keySet();
        Iterator<Way> itr = ways.iterator();
        for (int i = 0; i < size; ++i) {
            Way way = itr.next();
            List<StormTrack> tracks = this.getTrackList(way);
            ArrayList<DateTime> startTimes = new ArrayList<DateTime>();
            if (tracks == null) continue;
            for (StormTrack track : tracks) {
                DateTime st = track.getStartTime();
                startTimes.add(st);
            }
            if (startTimes.size() <= 0) continue;
            wayToStartDatesHashMap.put(way, startTimes);
        }
        return wayToStartDatesHashMap;
    }

    public StormTrack getObsTrack() {
        List<StormTrack> tracks = this.getTrackList(Way.OBSERVATION);
        if (tracks == null || tracks.size() == 0) {
            return null;
        }
        return tracks.get(0);
    }

    public void setObsTrack(Way way) {
        List obtracks = this.wayToTracksHashMap.get(Way.OBSERVATION);
        StormTrack obtrack = (StormTrack)obtracks.get(0);
        StormInfo sInfo = obtrack.getStormInfo();
        List<StormParam> obParams = obtrack.getParams();
        int size = obParams.size();
        StormParam[] obParam = new StormParam[size];
        int i = 0;
        Iterator<StormParam> iterator = obParams.iterator();
        while (iterator.hasNext()) {
            StormParam sp;
            obParam[i] = sp = iterator.next();
            ++i;
        }
        this.wayToTracksHashMap.remove(Way.OBSERVATION);
        ArrayList<StormTrackPoint> newObsPoints = new ArrayList<StormTrackPoint>();
        List<StormTrack> tracks = this.getTrackList(way);
        for (StormTrack stk : tracks) {
            List<StormTrackPoint> stkPoints = stk.getTrackPoints();
            newObsPoints.add(stkPoints.get(0));
        }
        StormTrack stk = new StormTrack(sInfo, Way.OBSERVATION, newObsPoints, obParam);
        this.addTrack(stk);
    }
}

