/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.storm;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import ucar.unidata.data.NamedArray;
import ucar.unidata.data.storm.STIStormDataSource;
import ucar.unidata.data.storm.StormInfo;
import ucar.unidata.data.storm.StormParam;
import ucar.unidata.data.storm.StormTrackPoint;
import ucar.unidata.data.storm.Way;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.util.Misc;
import ucar.visad.Util;
import visad.CommonUnit;
import visad.DateTime;
import visad.Real;
import visad.RealType;
import visad.VisADException;
import visad.georef.EarthLocation;

public class StormTrack
implements Comparable {
    private List<StormParam> params = null;
    private LatLonRect bbox;
    private String trackId;
    private StormInfo stormInfo;
    private Way way;
    private NamedArray lats;
    private NamedArray lons;
    private List<StormTrackPoint> trackPoints;
    private Hashtable temporaryProperties = new Hashtable();
    private static final int DIAMOND_MISSING_VALUE = 9999;
    private boolean isEdited = false;

    public StormTrack(StormTrack track) {
        this.stormInfo = track.stormInfo;
        this.way = track.way;
        this.params = track.params;
        this.trackId = track.trackId;
        this.trackPoints = new ArrayList<StormTrackPoint>(track.trackPoints);
    }

    public StormTrack(StormInfo stormInfo, Way way, List<StormTrackPoint> pts, StormParam[] params) {
        this.stormInfo = stormInfo;
        this.way = way;
        if (params != null) {
            this.params = Misc.toList(params);
        }
        this.trackPoints = new ArrayList<StormTrackPoint>(pts);
        StormTrackPoint firstPoint = pts.get(0);
        DateTime trackStartTime = firstPoint.getTime();
        this.trackId = stormInfo.toString() + "_" + way + "_" + trackStartTime.getValue();
    }

    public StormTrack(StormInfo stormInfo, Way way, DateTime startTime, StormParam[] params) {
        this.stormInfo = stormInfo;
        this.way = way;
        if (params != null) {
            this.params = Misc.toList(params);
        }
        this.trackPoints = new ArrayList<StormTrackPoint>();
        this.trackId = stormInfo.toString() + "_" + way + "_" + startTime.getValue();
    }

    public LatLonRect getBoundingBox() {
        if (this.trackPoints.size() == 0) {
            return null;
        }
        if (this.bbox == null) {
            double minLon = Double.POSITIVE_INFINITY;
            double maxLon = Double.NEGATIVE_INFINITY;
            double minLat = Double.POSITIVE_INFINITY;
            double maxLat = Double.NEGATIVE_INFINITY;
            for (StormTrackPoint stp : this.trackPoints) {
                EarthLocation el = stp.getLocation();
                minLat = Math.min(minLat, el.getLatitude().getValue());
                maxLat = Math.max(maxLat, el.getLatitude().getValue());
                minLon = Math.min(minLon, el.getLongitude().getValue());
                maxLon = Math.max(maxLon, el.getLongitude().getValue());
            }
            this.bbox = new LatLonRect(new LatLonPointImpl(maxLat, minLon), new LatLonPointImpl(minLat, maxLon));
        }
        return this.bbox;
    }

    public int compareTo(Object o) {
        if (o instanceof StormTrack) {
            double v2;
            StormTrack that = (StormTrack)o;
            double v1 = this.getStartTime().getValue();
            if (v1 < (v2 = that.getStartTime().getValue())) {
                return -1;
            }
            if (v1 > v2) {
                return 1;
            }
            return 0;
        }
        return this.toString().compareTo(o.toString());
    }

    public StormTrackPoint findPointWithForecastHour(int hour) {
        for (StormTrackPoint stp : this.trackPoints) {
            if (stp.getForecastHour() != hour) continue;
            return stp;
        }
        return null;
    }

    public void addPoint(StormTrackPoint point) {
        this.trackPoints.add(point);
    }

    public boolean isObservation() {
        return this.way.isObservation();
    }

    public boolean isEdited() {
        return this.isEdited;
    }

    public void setIsEdited(boolean isEdited) {
        this.isEdited = isEdited;
    }

    public boolean getIsEdited() {
        return this.isEdited;
    }

    public int hashCode() {
        return this.trackId.hashCode();
    }

    public void setId(String id) {
        this.trackId = id;
    }

    public String getId() {
        return this.trackId;
    }

    public DateTime getStartTime() {
        StormTrackPoint firstPoint = this.trackPoints.get(0);
        return firstPoint.getTime();
    }

    public void setStormInfo(StormInfo stormInfo) {
        this.stormInfo = stormInfo;
    }

    public StormInfo getStormInfo() {
        return this.stormInfo;
    }

    public void setWay(Way way) {
        this.way = way;
    }

    public Way getWay() {
        return this.way;
    }

    public void setTrackPoints(List<StormTrackPoint> pts) {
        this.trackPoints = new ArrayList<StormTrackPoint>(pts);
    }

    public List<StormTrackPoint> getTrackPoints() {
        return this.trackPoints;
    }

    public List<DateTime> getTrackTimes() {
        ArrayList<DateTime> trackTimes = new ArrayList<DateTime>();
        for (StormTrackPoint stp : this.trackPoints) {
            trackTimes.add(stp.getTime());
        }
        return trackTimes;
    }

    public List<StormParam> getParams() {
        if (this.params == null) {
            this.params = new ArrayList<StormParam>();
            Hashtable<RealType, RealType> seenParam = new Hashtable<RealType, RealType>();
            for (StormTrackPoint stp : this.trackPoints) {
                List<Real> reals = stp.getTrackAttributes();
                for (Real r : reals) {
                    RealType type = (RealType)r.getType();
                    if (seenParam.get(type) != null) continue;
                    seenParam.put(type, type);
                    this.params.add(new StormParam(type));
                }
            }
        }
        return this.params;
    }

    public List<EarthLocation> getLocations() {
        ArrayList<EarthLocation> locs = new ArrayList<EarthLocation>();
        for (StormTrackPoint stp : this.trackPoints) {
            locs.add(stp.getLocation());
        }
        return locs;
    }

    public Real[] getTrackAttributeValues(StormParam param) throws VisADException {
        int i;
        if (param == null) {
            return null;
        }
        int size = this.trackPoints.size();
        Real[] trackAttributes = new Real[size];
        Real missing = null;
        for (i = 0; i < size; ++i) {
            Real value = this.trackPoints.get(i).getAttribute(param);
            if (value == null) {
                if (i == 0) {
                    return null;
                }
                trackAttributes[i] = null;
                continue;
            }
            if (missing == null) {
                missing = value.cloneButValue(Double.NaN);
            }
            trackAttributes[i] = value;
        }
        for (i = 0; i < size; ++i) {
            if (trackAttributes[i] != null) continue;
            trackAttributes[i] = missing;
        }
        return trackAttributes;
    }

    public float findClosestAttr(float[] trackAttributes, int i) {
        int up = i;
        int down = i;
        int size = trackAttributes.length;
        float value = Float.NaN;
        while (Float.isNaN(value)) {
            --down;
            if (++up > 0 && up < size) {
                value = trackAttributes[up];
            }
            if (down <= 0 || down >= size) continue;
            value = trackAttributes[down];
        }
        return value;
    }

    public String toString() {
        return this.trackId;
    }

    public int indexOf(StormTrackPoint stp) {
        for (int i = 0; i < this.trackPoints.size(); ++i) {
            if (!this.trackPoints.get(i).getLocation().equals(stp.getLocation())) continue;
            return i;
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof StormTrack)) {
            return false;
        }
        StormTrack other = (StormTrack)o;
        return this.trackId.equals(other.trackId);
    }

    public void putTemporaryProperty(Object key, Object value) {
        this.temporaryProperties.put(key, value);
    }

    public Object getTemporaryProperty(Object key) {
        return this.temporaryProperties.get(key);
    }

    public static StringBuffer toDiamond7(List<StormTrack> sts, String id) throws VisADException {
        StringBuffer sb = new StringBuffer();
        sb.append("diamond 7 " + id + "TropicalCycloneTrack" + "\n");
        for (StormTrack st : sts) {
            st.toDiamond7(sb, id);
        }
        return sb;
    }

    public void toDiamond7(StringBuffer sb, String id) throws VisADException {
        Calendar cal = Calendar.getInstance();
        List<StormTrackPoint> tpoints = this.getTrackPoints();
        sb.append("Name " + id + " " + this.way + " " + tpoints.size() + "\n");
        for (StormTrackPoint stp : tpoints) {
            Date dttm = null;
            try {
                dttm = Util.makeDate(stp.getTime());
            }
            catch (Exception exception) {
                // empty catch block
            }
            cal.setTime(dttm);
            String year = Integer.toString(cal.get(1));
            int mm = cal.get(2);
            String mon = Integer.toString(mm);
            if (mm < 10) {
                mon = "0" + mon;
            }
            int dd = cal.get(5);
            String day = Integer.toString(dd);
            if (dd < 10) {
                day = "0" + day;
            }
            int hour = cal.get(11);
            int fhour = stp.getForecastHour();
            EarthLocation el = stp.getLocation();
            List<Real> attrs = stp.getTrackAttributes();
            sb.append(year.substring(2));
            sb.append(" ");
            sb.append(mon);
            sb.append(" ");
            sb.append(day);
            sb.append(" ");
            sb.append(hour);
            sb.append(" ");
            sb.append(fhour);
            sb.append(" ");
            sb.append(el.getLongitude().getValue(CommonUnit.degree));
            sb.append(" ");
            sb.append(el.getLatitude().getValue(CommonUnit.degree));
            sb.append(" ");
            this.appendDiamondValue(sb, stp.getAttribute(STIStormDataSource.PARAM_MAXWINDSPEED));
            this.appendDiamondValue(sb, stp.getAttribute(STIStormDataSource.PARAM_MINPRESSURE));
            this.appendDiamondValue(sb, stp.getAttribute(STIStormDataSource.PARAM_RADIUSMODERATEGALE));
            this.appendDiamondValue(sb, stp.getAttribute(STIStormDataSource.PARAM_RADIUSWHOLEGALE));
            this.appendDiamondValue(sb, stp.getAttribute(STIStormDataSource.PARAM_MOVESPEED));
            this.appendDiamondValue(sb, stp.getAttribute(STIStormDataSource.PARAM_MOVEDIRECTION));
            sb.append("\n");
        }
    }

    private void appendDiamondValue(StringBuffer sb, Real r) {
        if (r == null || Double.isNaN(r.getValue())) {
            sb.append(9999);
        } else {
            sb.append(r.getValue());
        }
        sb.append(" ");
    }
}

