/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.storm;

import java.util.List;
import ucar.unidata.data.DataChoice;
import ucar.unidata.util.TwoFacedObject;
import ucar.visad.Util;
import visad.Real;
import visad.RealType;
import visad.Unit;
import visad.VisADException;

public class StormParam {
    RealType type;
    private boolean canDoDifference = true;
    private boolean derived = false;
    private boolean isChartParam = true;

    public StormParam() {
    }

    public StormParam(RealType type) {
        this.type = type;
        if (type != null) {
            DataChoice.addCurrentName(new TwoFacedObject((Object)("Storm Track>" + type), Util.cleanTypeName(type)));
        }
    }

    public StormParam(RealType type, boolean derived) {
        this(type);
        this.derived = derived;
    }

    public StormParam(RealType type, boolean derived, boolean canDoDiff) {
        this(type);
        this.derived = derived;
        this.canDoDifference = canDoDiff;
    }

    public StormParam(RealType type, boolean derived, boolean canDoDiff, boolean chartList) {
        this(type);
        this.derived = derived;
        this.canDoDifference = canDoDiff;
        this.isChartParam = chartList;
    }

    public Real getReal(double value) throws VisADException {
        return new Real(this.type, value);
    }

    public Unit getUnit() {
        return this.type.getDefaultUnit();
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public void setCanDoDifference(boolean value) {
        this.canDoDifference = value;
    }

    public boolean getCanDoDifference() {
        return this.canDoDifference;
    }

    public void setIsChartParam(boolean value) {
        this.isChartParam = value;
    }

    public boolean getIsChartParam() {
        return this.isChartParam;
    }

    public Real getAttribute(List<Real> attributes) {
        if (attributes == null) {
            return null;
        }
        for (Real attr : attributes) {
            if (!attr.getType().equals(this.type)) continue;
            return attr;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        StormParam that = (StormParam)o;
        return this.type.equals(that.type);
    }

    public String toString() {
        return Util.cleanTypeName(this.type.getName()).replace("_", " ");
    }

    public String getName() {
        return Util.cleanTypeName(this.type.getName());
    }

    public void setType(RealType value) {
        this.type = value;
    }

    public RealType getType() {
        return this.type;
    }

    public void setDerived(boolean value) {
        this.derived = value;
    }

    public boolean getDerived() {
        return this.derived;
    }
}

