/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.storm;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DataSourceImpl;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.DirectDataChoice;
import ucar.unidata.data.storm.StormInfo;
import ucar.unidata.data.storm.StormParam;
import ucar.unidata.data.storm.StormTrack;
import ucar.unidata.data.storm.StormTrackCollection;
import ucar.unidata.data.storm.StormTrackPoint;
import ucar.unidata.data.storm.Way;
import ucar.unidata.geoloc.Bearing;
import ucar.unidata.util.DateUtil;
import ucar.visad.Util;
import visad.DateTime;
import visad.Real;
import visad.RealType;
import visad.Unit;
import visad.VisADException;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationLite;

public abstract class StormDataSource
extends DataSourceImpl {
    public static final int CATEGORY_DB = 0;
    public static final int CATEGORY_TD = 1;
    public static final int CATEGORY_TS = 2;
    public static final int CATEGORY_TY = 3;
    public static final int CATEGORY_ST = 4;
    public static final int CATEGORY_TC = 5;
    public static final int CATEGORY_HU = 6;
    public static final int CATEGORY_SD = 7;
    public static final int CATEGORY_SS = 8;
    public static final int CATEGORY_EX = 9;
    public static final int CATEGORY_IN = 10;
    public static final int CATEGORY_DS = 11;
    public static final int CATEGORY_LO = 12;
    public static final int CATEGORY_WV = 13;
    public static final int CATEGORY_ET = 14;
    public static final int CATEGORY_XX = 15;
    public static StormParam PARAM_MINPRESSURE;
    public static StormParam PARAM_MAXWINDSPEED_KTS;
    public static final int[] CATEGORY_VALUES;
    public static final String[] CATEGORY_NAMES;
    public static final String ATTR_CATEGORY = "attr.category";
    public static StormParam PARAM_STORMCATEGORY;
    protected StormParam[] obsParams;
    protected StormParam[] forecastParams;
    private Hashtable seenWays = new Hashtable();
    private List<Way> ways = new ArrayList<Way>();
    private Hashtable<String, Way> wayMap = new Hashtable();

    public StormDataSource() throws Exception {
    }

    public StormDataSource(DataSourceDescriptor descriptor, String name, String description, Hashtable properties) {
        super(descriptor, name, description, properties);
    }

    public boolean isEditable() {
        return false;
    }

    @Override
    public boolean canAddCurrentName(DataChoice dataChoice) {
        return false;
    }

    protected static RealType makeRealType(String id, String alias, Unit unit) {
        try {
            alias = alias + "[unit:" + (unit == null ? "null" : DataUtil.cleanName(unit.toString())) + "]";
            return Util.makeRealType(id, alias, unit);
        }
        catch (VisADException exc) {
            throw new RuntimeException(exc);
        }
    }

    @Override
    protected final void initAfter() {
        try {
            StormDataSource.incrOutstandingGetDataCalls();
            this.initializeStormData();
        }
        finally {
            StormDataSource.decrOutstandingGetDataCalls();
        }
    }

    protected void initializeStormData() {
    }

    protected void initParams() throws VisADException {
        if (PARAM_STORMCATEGORY == null) {
            PARAM_STORMCATEGORY = new StormParam(Util.makeRealType("stormcategory", "Storm_Category", null));
            PARAM_MINPRESSURE = new StormParam(StormDataSource.makeRealType("minpressure", "Min_Pressure", DataUtil.parseUnit("mb")));
            PARAM_MAXWINDSPEED_KTS = new StormParam(StormDataSource.makeRealType("maxwindspeedkts", "Max_Windspeed", DataUtil.parseUnit("kts")));
        }
    }

    public int getCategory(String name) {
        if (name == null) {
            return 15;
        }
        for (int i = 0; i < CATEGORY_NAMES.length; ++i) {
            if (!name.equals(CATEGORY_NAMES[i])) continue;
            return CATEGORY_VALUES[i];
        }
        return 15;
    }

    public abstract List<StormInfo> getStormInfos();

    public abstract String getId();

    @Override
    protected void doMakeDataChoices() {
        List cats = DataCategory.parseCategories("stormtrack", false);
        DirectDataChoice choice = new DirectDataChoice((DataSource)this, (Object)"stormtrack", "Storm Track", "Storm Track", cats, (Hashtable)null);
        this.addDataChoice(choice);
    }

    @Override
    public void reloadData() {
        this.initializeStormData();
        super.reloadData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StormTrackCollection getTrackCollection(StormInfo stormInfo, Hashtable<String, Boolean> waysToUse, Way obsWay) throws Exception {
        try {
            StormDataSource.incrOutstandingGetDataCalls();
            StormTrackCollection stormTrackCollection = this.getTrackCollectionInner(stormInfo, waysToUse, obsWay);
            return stormTrackCollection;
        }
        finally {
            StormDataSource.decrOutstandingGetDataCalls();
        }
    }

    public String getWayName() {
        return "Way";
    }

    public String getWaysName() {
        return this.getWayName() + "s";
    }

    public abstract StormTrackCollection getTrackCollectionInner(StormInfo var1, Hashtable<String, Boolean> var2, Way var3) throws Exception;

    protected Way addWay(Way way) {
        if (this.seenWays.get(way) == null) {
            this.seenWays.put(way, way);
            this.ways.add(way);
        }
        return way;
    }

    protected Way getWay(String w, String name) {
        Way way = this.wayMap.get(w);
        if (way == null) {
            way = new Way(w, name);
            this.wayMap.put(w, way);
        }
        this.addWay(way);
        return way;
    }

    public List<Way> getWays() {
        return new ArrayList<Way>(this.ways);
    }

    public StormInfo getStormInfo(String stormId) {
        List<StormInfo> stormInfos = this.getStormInfos();
        for (StormInfo sInfo : stormInfos) {
            if (!sInfo.getStormId().equals(stormId)) continue;
            return sInfo;
        }
        return null;
    }

    public static int getYear(DateTime dttm) throws VisADException {
        GregorianCalendar cal = new GregorianCalendar(DateUtil.TIMEZONE_GMT);
        cal.setTime(Util.makeDate(dttm));
        return cal.get(1);
    }

    public static void addDistanceError(StormTrack obsTrack, StormTrack fctTrack) throws VisADException {
        List<StormTrackPoint> obsTrackPoints = obsTrack.getTrackPoints();
        List<StormTrackPoint> fctTrackPoints = fctTrack.getTrackPoints();
        for (StormTrackPoint stp : fctTrackPoints) {
            DateTime dateTime = stp.getTime();
        }
    }

    public static StormTrack difference(StormTrack obsTrack, StormTrack fctTrack, StormParam param) throws VisADException, RemoteException {
        List<StormTrackPoint> obsTrackPoints = obsTrack.getTrackPoints();
        List<StormTrackPoint> fctTrackPoints = fctTrack.getTrackPoints();
        ArrayList<StormTrackPoint> diffPoints = new ArrayList<StormTrackPoint>();
        for (StormTrackPoint forecastPoint : fctTrackPoints) {
            DateTime forecastDttm;
            StormTrackPoint[] range;
            Real forecastValue = forecastPoint.getAttribute(param);
            if (forecastValue == null || (range = StormDataSource.getClosestPointRange(obsTrackPoints, forecastDttm = forecastPoint.getTime())) == null) continue;
            Real obsValue = null;
            if (range.length == 1) {
                obsValue = range[0].getAttribute(param);
            } else {
                Real v1 = range[0].getAttribute(param);
                Real v2 = range[1].getAttribute(param);
                if (v1 == null || v2 == null) continue;
                DateTime t1 = range[0].getTime();
                DateTime t2 = range[1].getTime();
                double percent = forecastDttm.getValue() - t1.getValue() / (t2.getValue() - t1.getValue());
                double interpolatedValue = v2.getValue() + percent * (v2.getValue() - v1.getValue());
                obsValue = v1.cloneButValue(interpolatedValue);
                System.err.println("interp %:" + percent + " v:" + obsValue + " v1:" + v1 + " v2:" + v2 + "\n\tt1:" + t1 + " t2:" + t2);
            }
            if (obsValue == null) continue;
            Real difference = (Real)forecastValue.__sub__(obsValue);
            StormTrackPoint newStormTrackPoint = new StormTrackPoint(forecastPoint.getLocation(), forecastDttm, forecastPoint.getForecastHour(), new ArrayList<Real>());
            newStormTrackPoint.addAttribute(difference);
            diffPoints.add(newStormTrackPoint);
        }
        if (diffPoints.size() == 0) {
            return null;
        }
        return new StormTrack(fctTrack.getStormInfo(), fctTrack.getWay(), diffPoints, null);
    }

    public static StormTrackPoint[] getClosestPointRange(List<StormTrackPoint> aList, DateTime dt) {
        double timeToLookFor = dt.getValue();
        int numPoints = aList.size();
        double lastTime = -1.0;
        for (int i = 0; i < numPoints; ++i) {
            StormTrackPoint stp = aList.get(i);
            double currentTime = stp.getTime().getValue();
            if (timeToLookFor == currentTime) {
                return new StormTrackPoint[]{stp};
            }
            if (timeToLookFor < currentTime) {
                if (i == 0) {
                    return null;
                }
                if (timeToLookFor > lastTime) {
                    return new StormTrackPoint[]{aList.get(i - 1), stp};
                }
            }
            lastTime = currentTime;
        }
        return null;
    }

    public static StormTrackPoint getClosestPoint(List<StormTrackPoint> aList, DateTime dt) {
        int numPoints = aList.size();
        StormTrackPoint stp1 = aList.get(0);
        StormTrackPoint stp2 = aList.get(numPoints - 1);
        double pValue = dt.getValue();
        double minDiffLeft = 200000.0;
        double minDiffRight = 200000.0;
        for (int i = 0; i < numPoints; ++i) {
            StormTrackPoint stp11 = aList.get(i);
            StormTrackPoint stp21 = aList.get(numPoints - i - 1);
            double p1Value = stp11.getTime().getValue();
            double p2Value = stp21.getTime().getValue();
            double diff1 = Math.abs(p1Value - pValue);
            double diff2 = Math.abs(p2Value - pValue);
            if (pValue >= p1Value && diff1 < minDiffRight) {
                if (pValue == p1Value) {
                    return stp11;
                }
                stp1 = stp11;
                minDiffRight = diff1;
            }
            if (!(pValue <= p2Value) || !(diff2 < minDiffLeft)) continue;
            if (pValue == p2Value) {
                return stp21;
            }
            stp2 = stp21;
            minDiffLeft = diff2;
        }
        double diff = minDiffLeft + minDiffRight;
        EarthLocation el1 = stp1.getLocation();
        EarthLocation el2 = stp1.getLocation();
        double lat = ((diff - minDiffLeft) * el1.getLatitude().getValue() + (diff - minDiffRight) * el2.getLatitude().getValue()) / diff;
        double lon = ((diff - minDiffLeft) * el1.getLongitude().getValue() + (diff - minDiffRight) * el2.getLongitude().getValue()) / diff;
        EarthLocationLite el = new EarthLocationLite(new Real(RealType.Latitude, lat), new Real(RealType.Longitude, lon), null);
        return new StormTrackPoint(el, dt, 0, null);
    }

    public boolean getIsObservationWayChangeable() {
        return false;
    }

    public Way getDefaultObservationWay() {
        return null;
    }

    public static double getDistance(StormTrackPoint p1, StormTrackPoint p2) {
        EarthLocation el1 = p1.getLocation();
        EarthLocation el2 = p2.getLocation();
        Bearing b = Bearing.calculateBearing(el1.getLatitude().getValue(), el1.getLongitude().getValue(), el2.getLatitude().getValue(), el2.getLongitude().getValue(), null);
        return b.getDistance();
    }

    static {
        CATEGORY_VALUES = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        CATEGORY_NAMES = new String[]{"DB", "TD", "TS", "TY", "ST", "TC", "HU", "SD", "SS", "EX", "IN", "DS", "LO", "WV", "ET", "XX"};
    }
}

