/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.storm;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import ucar.unidata.data.BadDataException;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.storm.StormDataSource;
import ucar.unidata.data.storm.StormInfo;
import ucar.unidata.data.storm.StormParam;
import ucar.unidata.data.storm.StormTrack;
import ucar.unidata.data.storm.StormTrackCollection;
import ucar.unidata.data.storm.StormTrackPoint;
import ucar.unidata.data.storm.Way;
import ucar.unidata.sql.SqlUtil;
import ucar.unidata.util.DateUtil;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.Misc;
import ucar.visad.Util;
import visad.CommonUnit;
import visad.DateTime;
import visad.Real;
import visad.RealType;
import visad.VisADException;
import visad.georef.EarthLocationLite;

public class STIStormDataSource
extends StormDataSource {
    private static final Way DEFAULT_OBSERVATION_WAY = new Way("babj");
    private static final String DEFAULT_URL = "jdbc:mysql://localhost:3306/typhoon?zeroDateTimeBehavior=convertToNull&user=yuanho&password=password";
    private static final String DEFAULT_DERBY_URL = "jdbc:derby:test;create=true";
    private static final String COL_DERBY_HOUR = "hh";
    private static final String COL_DERBY_YEAR = "yyyy";
    public static StormParam PARAM_MAXWINDSPEED;
    public static StormParam PARAM_RADIUSMODERATEGALE;
    public static StormParam PARAM_RADIUSWHOLEGALE;
    public static StormParam PARAM_PROBABILITY10RADIUS;
    public static StormParam PARAM_PROBABILITY20RADIUS;
    public static StormParam PARAM_PROBABILITY30RADIUS;
    public static StormParam PARAM_PROBABILITY40RADIUS;
    public static StormParam PARAM_PROBABILITY50RADIUS;
    public static StormParam PARAM_PROBABILITY60RADIUS;
    public static StormParam PARAM_PROBABILITY70RADIUS;
    public static StormParam PARAM_PROBABILITY80RADIUS;
    public static StormParam PARAM_PROBABILITY90RADIUS;
    public static StormParam PARAM_DISTANCE_ERROR;
    public static StormParam PARAM_PROBABILITY100RADIUS;
    public static StormParam PARAM_PROBABILITYRADIUS;
    public static StormParam PARAM_MOVEDIRECTION;
    public static StormParam PARAM_MOVESPEED;
    private static float MISSING;
    private static final String ZEROHOUR = "0";
    private static final String TABLE_TRACK = "typhoon";
    private static final String COL_TYPHOON_YEAR = "year";
    private static final String COL_TYPHOON_HOUR = "hour";
    private static final String COL_TYPHOON_STORMID = "nno";
    private static final String COL_TYPHOON_TIME = "time";
    private static final String COL_TYPHOON_LATITUDE = "lat";
    private static final String COL_TYPHOON_LONGITUDE = "lon";
    private static final String COL_TYPHOON_MONTH = "mon";
    private static final String COL_TYPHOON_DAY = "day";
    private static final String COL_TYPHOON_FHOUR = "fhour";
    private static final String COL_TYPHOON_WAY = "way";
    private static final String COL_TYPHOON_PRESSURE = "pressure";
    private static final String COL_TYPHOON_WINDSPEED = "wind";
    private static final String COL_TYPHOON_RADIUSMG = "xx1";
    private static final String COL_TYPHOON_RADIUSWG = "xx2";
    private static final String COL_TYPHOON_MOVEDIR = "xx3";
    private static final String COL_TYPHOON_MOVESPEED = "xx4";
    private static final String TABLE_PROBILITY = "probility";
    private static final String COL_PROBILITY_WAYNAME = "wayname";
    private static final String COL_PROBILITY_FHOUR = "fhour";
    private static final String COL_PROBILITY_P10 = "p10";
    private static final String COL_PROBILITY_P20 = "p20";
    private static final String COL_PROBILITY_P30 = "p30";
    private static final String COL_PROBILITY_P40 = "p40";
    private static final String COL_PROBILITY_P50 = "p50";
    private static final String COL_PROBILITY_P60 = "p60";
    private static final String COL_PROBILITY_P70 = "p70";
    private static final String COL_PROBILITY_P80 = "p80";
    private static final String COL_PROBILITY_P90 = "p90";
    private static final String COL_PROBILITY_P100 = "p100";
    private static final String COL_DISTANCE_ERROR = "error";
    private static final String COL_PROBILITY_REMARK = "remark";
    private String dbUrl;
    private Connection connection;
    private String fromDate = "-1 year";
    private String toDate = "now";
    private List<StormInfo> stormInfos;
    private HashMap<String, float[]> wayfhourToRadius;

    private boolean useDerby() {
        return this.dbUrl != null && this.dbUrl.indexOf("derby") >= 0;
    }

    @Override
    public String getId() {
        return "sti";
    }

    private String getColHour() {
        if (this.useDerby()) {
            return COL_DERBY_HOUR;
        }
        return COL_TYPHOON_HOUR;
    }

    private String getColYear() {
        if (this.useDerby()) {
            return COL_DERBY_YEAR;
        }
        return COL_TYPHOON_YEAR;
    }

    public STIStormDataSource() throws Exception {
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    protected void initParams() throws VisADException {
        super.initParams();
        this.obsParams = new StormParam[]{PARAM_MAXWINDSPEED, PARAM_MINPRESSURE, PARAM_RADIUSMODERATEGALE, PARAM_RADIUSWHOLEGALE, PARAM_MOVEDIRECTION, PARAM_MOVESPEED};
        this.forecastParams = new StormParam[]{PARAM_MAXWINDSPEED, PARAM_MINPRESSURE, PARAM_RADIUSMODERATEGALE, PARAM_RADIUSWHOLEGALE, PARAM_MOVEDIRECTION, PARAM_MOVESPEED, PARAM_PROBABILITY10RADIUS, PARAM_PROBABILITY20RADIUS, PARAM_PROBABILITY30RADIUS, PARAM_PROBABILITY40RADIUS, PARAM_PROBABILITY50RADIUS, PARAM_PROBABILITY60RADIUS, PARAM_PROBABILITY70RADIUS, PARAM_PROBABILITY80RADIUS, PARAM_PROBABILITY90RADIUS, PARAM_PROBABILITY100RADIUS, PARAM_DISTANCE_ERROR};
    }

    public STIStormDataSource(DataSourceDescriptor descriptor, String url, Hashtable properties) throws Exception {
        super(descriptor, "STI Storm Data", "STI Storm Data", properties);
        if (url != null && url.trim().equals("test")) {
            url = DEFAULT_DERBY_URL;
        }
        if (url == null || url.trim().equalsIgnoreCase("default") || url.trim().length() == 0) {
            url = this.useDerby() ? DEFAULT_DERBY_URL : DEFAULT_URL;
        }
        this.dbUrl = url;
    }

    @Override
    protected void initializeStormData() {
        try {
            this.initParams();
            File userDir = this.getDataContext().getIdv().getObjectStore().getUserDirectory();
            String derbyDir = IOUtil.joinDir(userDir, "derbydb");
            IOUtil.makeDirRecursive(new File(derbyDir));
            System.setProperty("derby.system.home", derbyDir);
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
            Class.forName("com.mysql.jdbc.Driver");
            if (!this.initConnection()) {
                this.setInError(true, true, "Unable to initialize database connection:" + this.dbUrl);
            } else {
                this.stormInfos = this.getAllStormInfos();
            }
        }
        catch (Exception exc) {
            this.logException("Error initializing STI database: " + this.dbUrl, exc);
        }
    }

    @Override
    public List<StormInfo> getStormInfos() {
        ArrayList<StormInfo> sInfos = new ArrayList<StormInfo>();
        sInfos.addAll(this.stormInfos);
        return sInfos;
    }

    @Override
    public StormTrackCollection getTrackCollectionInner(StormInfo stormInfo, Hashtable<String, Boolean> waysToUse, Way observationWay) throws Exception {
        if (observationWay == null) {
            observationWay = DEFAULT_OBSERVATION_WAY;
        }
        long t1 = System.currentTimeMillis();
        StormTrackCollection trackCollection = new StormTrackCollection();
        List<Way> forecastWays = this.getForecastWays(stormInfo);
        this.getWayProbabilityRadius();
        for (Way forecastWay : forecastWays) {
            List<StormTrack> forecastTracks;
            if (waysToUse != null && waysToUse.size() > 0 && waysToUse.get(forecastWay.getId()) == null || (forecastTracks = this.getForecastTracks(stormInfo, forecastWay)).size() <= 0) continue;
            trackCollection.addTrackList(forecastTracks);
        }
        StormTrack obsTrack = this.getObservationTrack(stormInfo, observationWay);
        if (obsTrack != null) {
            List<StormTrack> tracks = trackCollection.getTracks();
            long t2 = System.currentTimeMillis();
            trackCollection.addTrack(obsTrack);
        }
        return trackCollection;
    }

    private List<StormTrack> getForecastTracks(StormInfo stormInfo, Way forecastWay) throws Exception {
        ArrayList<StormTrack> tracks = new ArrayList<StormTrack>();
        List<DateTime> startDates = this.getForecastTrackStartDates(stormInfo, forecastWay);
        int nstarts = startDates.size();
        for (int i = 0; i < nstarts; ++i) {
            int pn;
            DateTime dt = startDates.get(i);
            StormTrack tk = this.getForecastTrack(stormInfo, dt, forecastWay);
            if (tk == null || (pn = tk.getTrackPoints().size()) <= 1) continue;
            tracks.add(tk);
        }
        return tracks;
    }

    public double getValue(double d, String name) {
        if (d == 9999.0 || d == 999.0) {
            return Double.NaN;
        }
        if (name.equalsIgnoreCase(PARAM_MAXWINDSPEED.getName()) ? d < 0.0 || d > 60.0 : (name.equalsIgnoreCase(PARAM_MINPRESSURE.getName()) ? d < 800.0 || d > 1050.0 : (name.equalsIgnoreCase(PARAM_RADIUSMODERATEGALE.getName()) ? d < 0.0 || d > 900.0 : (name.equalsIgnoreCase(PARAM_RADIUSWHOLEGALE.getName()) ? d < 0.0 || d > 500.0 : (name.equalsIgnoreCase(PARAM_MOVESPEED.getName()) ? d < 0.0 || d > 55.0 : name.equalsIgnoreCase(PARAM_MOVEDIRECTION.getName()) && (d < 0.0 || d > 360.0)))))) {
            return Double.NaN;
        }
        return d;
    }

    public double getLatLonValue(double d) {
        if (d == 9999.0 || d == 999.0) {
            return Double.NaN;
        }
        return d;
    }

    private StormTrack getForecastTrack(StormInfo stormInfo, DateTime sTime, Way forecastWay) throws Exception {
        ResultSet results;
        String columns = SqlUtil.comma(new String[]{this.getColYear(), COL_TYPHOON_MONTH, COL_TYPHOON_DAY, this.getColHour(), "fhour", COL_TYPHOON_LATITUDE, COL_TYPHOON_LONGITUDE, COL_TYPHOON_WINDSPEED, COL_TYPHOON_PRESSURE, COL_TYPHOON_RADIUSMG, COL_TYPHOON_RADIUSWG, COL_TYPHOON_MOVEDIR, COL_TYPHOON_MOVESPEED});
        ArrayList<String> whereList = new ArrayList<String>();
        whereList.add(SqlUtil.eq(COL_TYPHOON_STORMID, SqlUtil.quote(stormInfo.getStormId())));
        whereList.add(SqlUtil.eq(COL_TYPHOON_WAY, SqlUtil.quote(forecastWay.getId())));
        this.addDateSelection(sTime, whereList);
        String query = SqlUtil.makeSelect(columns, Misc.newList(TABLE_TRACK), SqlUtil.makeAnd(whereList));
        query = query + " order by  " + SqlUtil.comma(new String[]{this.getColYear(), COL_TYPHOON_MONTH, COL_TYPHOON_DAY, this.getColHour(), "fhour"});
        Statement statement = this.evaluate(query);
        SqlUtil.Iterator iter = SqlUtil.getIterator(statement);
        double radius = 0.0;
        ArrayList<StormTrackPoint> pts = new ArrayList<StormTrackPoint>();
        Real altReal = new Real(RealType.Altitude, 0.0);
        while ((results = iter.getNext()) != null) {
            double longitude;
            double latitude;
            ArrayList<Real> attrs = new ArrayList<Real>();
            int col = 1;
            int year = results.getInt(col++);
            int month = results.getInt(col++);
            int day = results.getInt(col++);
            int hour = results.getInt(col++);
            int fhour = results.getInt(col++);
            if ((latitude = this.getLatLonValue(results.getDouble(col++))) > 90.0 || latitude < -90.0 || (longitude = this.getLatLonValue(results.getDouble(col++))) > 360.0 || longitude < -180.0) continue;
            attrs.add(PARAM_MAXWINDSPEED.getReal(this.getValue(results.getDouble(col++), PARAM_MAXWINDSPEED.getName())));
            attrs.add(PARAM_MINPRESSURE.getReal(this.getValue(results.getDouble(col++), PARAM_MINPRESSURE.getName())));
            attrs.add(PARAM_RADIUSMODERATEGALE.getReal(this.getValue(results.getDouble(col++), PARAM_RADIUSMODERATEGALE.getName())));
            attrs.add(PARAM_RADIUSWHOLEGALE.getReal(this.getValue(results.getDouble(col++), PARAM_RADIUSWHOLEGALE.getName())));
            attrs.add(PARAM_MOVEDIRECTION.getReal(this.getValue(results.getDouble(col++), PARAM_MOVEDIRECTION.getName())));
            attrs.add(PARAM_MOVESPEED.getReal(this.getValue(results.getDouble(col++), PARAM_MOVESPEED.getName())));
            float[] radiuses = this.getProbabilityRadius(forecastWay, fhour);
            DateTime dttm = this.getDateTime(year, month, day, hour + fhour);
            EarthLocationLite elt = new EarthLocationLite(new Real(RealType.Latitude, latitude), new Real(RealType.Longitude, longitude), altReal);
            this.addProbabilityRadiusAttrs(attrs, radiuses);
            StormTrackPoint stp = new StormTrackPoint(elt, dttm, fhour, attrs);
            if (elt.isMissing()) continue;
            pts.add(stp);
        }
        if (pts.size() == 0) {
            System.err.println("found no track data time=" + sTime + " from query:" + SqlUtil.makeAnd(whereList));
        }
        if (pts.size() > 0) {
            return new StormTrack(stormInfo, forecastWay, pts, this.forecastParams);
        }
        return null;
    }

    private float[] getProbabilityRadius(Way way, int forecastHour) {
        String key = way.getId().toUpperCase() + forecastHour;
        return this.wayfhourToRadius.get(key);
    }

    private void putProbabilityRadius(Way way, int forecastHour, float[] radiuses) {
        String key = way.getId().toUpperCase() + forecastHour;
        this.wayfhourToRadius.put(key, radiuses);
    }

    private void addProbabilityRadiusAttrs(List<Real> attrs, float[] radiuses) throws Exception {
        if (radiuses != null) {
            attrs.add(PARAM_PROBABILITY10RADIUS.getReal(radiuses[0]));
            attrs.add(PARAM_PROBABILITY20RADIUS.getReal(radiuses[1]));
            attrs.add(PARAM_PROBABILITY30RADIUS.getReal(radiuses[2]));
            attrs.add(PARAM_PROBABILITY40RADIUS.getReal(radiuses[3]));
            attrs.add(PARAM_PROBABILITY50RADIUS.getReal(radiuses[4]));
            attrs.add(PARAM_PROBABILITY60RADIUS.getReal(radiuses[5]));
            attrs.add(PARAM_PROBABILITY70RADIUS.getReal(radiuses[6]));
            attrs.add(PARAM_PROBABILITY80RADIUS.getReal(radiuses[7]));
            attrs.add(PARAM_PROBABILITY90RADIUS.getReal(radiuses[8]));
            attrs.add(PARAM_PROBABILITY100RADIUS.getReal(radiuses[9]));
            attrs.add(PARAM_DISTANCE_ERROR.getReal(this.getLatLonValue(radiuses[10])));
        } else {
            attrs.add(PARAM_PROBABILITY10RADIUS.getReal(Double.NaN));
            attrs.add(PARAM_PROBABILITY20RADIUS.getReal(Double.NaN));
            attrs.add(PARAM_PROBABILITY30RADIUS.getReal(Double.NaN));
            attrs.add(PARAM_PROBABILITY40RADIUS.getReal(Double.NaN));
            attrs.add(PARAM_PROBABILITY50RADIUS.getReal(Double.NaN));
            attrs.add(PARAM_PROBABILITY60RADIUS.getReal(Double.NaN));
            attrs.add(PARAM_PROBABILITY70RADIUS.getReal(Double.NaN));
            attrs.add(PARAM_PROBABILITY80RADIUS.getReal(Double.NaN));
            attrs.add(PARAM_PROBABILITY90RADIUS.getReal(Double.NaN));
            attrs.add(PARAM_PROBABILITY100RADIUS.getReal(Double.NaN));
            attrs.add(PARAM_DISTANCE_ERROR.getReal(Double.NaN));
        }
    }

    private void addDateSelection(DateTime sTime, List whereList) throws VisADException {
        GregorianCalendar cal = new GregorianCalendar(DateUtil.TIMEZONE_GMT);
        cal.setTime(Util.makeDate(sTime));
        int yy = cal.get(1);
        int mm = cal.get(2) + 1;
        int dd = cal.get(5);
        int hh = cal.get(11);
        whereList.add(SqlUtil.eq(this.getColYear(), Integer.toString(yy)));
        whereList.add(SqlUtil.eq(COL_TYPHOON_MONTH, Integer.toString(mm)));
        whereList.add(SqlUtil.eq(COL_TYPHOON_DAY, Integer.toString(dd)));
        whereList.add(SqlUtil.eq(this.getColHour(), Integer.toString(hh)));
    }

    private DateTime getDateTime(int year, int month, int day, int hour) throws Exception {
        GregorianCalendar convertCal = new GregorianCalendar(DateUtil.TIMEZONE_GMT);
        convertCal.clear();
        convertCal.set(1, year);
        convertCal.set(2, month - 1);
        convertCal.set(5, day);
        convertCal.set(11, hour);
        return new DateTime(convertCal.getTime());
    }

    protected List<DateTime> getForecastTrackStartDates(StormInfo stormInfo, Way way) throws Exception {
        ResultSet results;
        String columns = SqlUtil.comma(new String[]{this.getColYear(), COL_TYPHOON_MONTH, COL_TYPHOON_DAY, this.getColHour()});
        ArrayList<String> whereList = new ArrayList<String>();
        whereList.add(SqlUtil.eq(COL_TYPHOON_STORMID, SqlUtil.quote(stormInfo.getStormId())));
        whereList.add(SqlUtil.eq("fhour", ZEROHOUR));
        whereList.add(SqlUtil.eq(COL_TYPHOON_WAY, SqlUtil.quote(way.getId())));
        String query = SqlUtil.makeSelect(columns, Misc.newList(TABLE_TRACK), SqlUtil.makeAnd(whereList));
        query = query + " order by  " + SqlUtil.comma(new String[]{this.getColYear(), COL_TYPHOON_MONTH, COL_TYPHOON_DAY, this.getColHour()});
        Statement statement = this.evaluate(query);
        SqlUtil.Iterator iter = SqlUtil.getIterator(statement);
        ArrayList<DateTime> startDates = new ArrayList<DateTime>();
        while ((results = iter.getNext()) != null) {
            int col = 1;
            int year = results.getInt(col++);
            int month = results.getInt(col++);
            int day = results.getInt(col++);
            int hour = results.getInt(col++);
            startDates.add(this.getDateTime(year, month, day, hour));
        }
        return startDates;
    }

    protected void getWayProbabilityRadius() throws Exception {
        ResultSet results;
        String columns = SqlUtil.comma(new String[]{COL_PROBILITY_WAYNAME, "fhour", COL_PROBILITY_P10, COL_PROBILITY_P20, COL_PROBILITY_P30, COL_PROBILITY_P40, COL_PROBILITY_P50, COL_PROBILITY_P60, COL_PROBILITY_P70, COL_PROBILITY_P80, COL_PROBILITY_P90, COL_PROBILITY_P100, COL_DISTANCE_ERROR});
        ArrayList whereList = new ArrayList();
        String query = SqlUtil.makeSelect(columns, Misc.newList(TABLE_PROBILITY), SqlUtil.makeAnd(whereList));
        Statement statement = this.evaluate(query);
        SqlUtil.Iterator iter = SqlUtil.getIterator(statement);
        this.wayfhourToRadius = new HashMap();
        while ((results = iter.getNext()) != null) {
            float[] wp = new float[11];
            int col = 1;
            String wayName = results.getString(col++);
            int fhour = results.getInt(col++);
            wp[0] = results.getFloat(col++);
            wp[1] = results.getFloat(col++);
            wp[2] = results.getFloat(col++);
            wp[3] = results.getFloat(col++);
            wp[4] = results.getFloat(col++);
            wp[5] = results.getFloat(col++);
            wp[6] = results.getFloat(col++);
            wp[7] = results.getFloat(col++);
            wp[8] = results.getFloat(col++);
            wp[9] = results.getFloat(col++);
            wp[10] = results.getFloat(col++);
            this.putProbabilityRadius(new Way(wayName), fhour, wp);
        }
    }

    protected StormTrack getObservationTrack(StormInfo stormInfo, Way observationWay) throws Exception {
        this.addWay(observationWay);
        List<StormTrackPoint> obsTrackPoints = this.getObservationTrackPoints(stormInfo, observationWay);
        if (obsTrackPoints.size() == 0) {
            return null;
        }
        return new StormTrack(stormInfo, this.addWay(Way.OBSERVATION), obsTrackPoints, this.obsParams);
    }

    @Override
    public boolean getIsObservationWayChangeable() {
        return true;
    }

    @Override
    public Way getDefaultObservationWay() {
        return DEFAULT_OBSERVATION_WAY;
    }

    protected List<StormTrackPoint> getObservationTrackPoints(StormInfo stormInfo, Way wy) throws Exception {
        ResultSet results;
        String columns = SqlUtil.comma(new String[]{this.getColYear(), COL_TYPHOON_MONTH, COL_TYPHOON_DAY, this.getColHour(), COL_TYPHOON_LATITUDE, COL_TYPHOON_LONGITUDE, COL_TYPHOON_WINDSPEED, COL_TYPHOON_PRESSURE, COL_TYPHOON_RADIUSMG, COL_TYPHOON_RADIUSWG, COL_TYPHOON_MOVEDIR, COL_TYPHOON_MOVESPEED, COL_TYPHOON_WAY});
        ArrayList<String> whereList = new ArrayList<String>();
        whereList.add(SqlUtil.eq(COL_TYPHOON_STORMID, SqlUtil.quote(stormInfo.getStormId())));
        whereList.add(SqlUtil.eq("fhour", ZEROHOUR));
        whereList.add(SqlUtil.eq(COL_TYPHOON_WAY, SqlUtil.quote(wy.getId())));
        String query = SqlUtil.makeSelect(columns, Misc.newList(TABLE_TRACK), SqlUtil.makeAnd(whereList));
        query = query + " order by  " + SqlUtil.comma(new String[]{this.getColYear(), COL_TYPHOON_MONTH, COL_TYPHOON_DAY, this.getColHour()});
        Statement statement = this.evaluate(query);
        SqlUtil.Iterator iter = SqlUtil.getIterator(statement);
        ArrayList<StormTrackPoint> obsPts = new ArrayList<StormTrackPoint>();
        Real altReal = new Real(RealType.Altitude, 0.0);
        while ((results = iter.getNext()) != null) {
            double longitude;
            double latitude;
            ArrayList<Real> attrs = new ArrayList<Real>();
            int col = 1;
            int year = results.getInt(col++);
            int month = results.getInt(col++);
            int day = results.getInt(col++);
            int hour = results.getInt(col++);
            if ((latitude = this.getLatLonValue(results.getDouble(col++))) > 90.0 || latitude < -90.0 || (longitude = this.getLatLonValue(results.getDouble(col++))) > 360.0 || longitude < -180.0) continue;
            attrs.add(PARAM_MAXWINDSPEED.getReal(this.getValue(results.getDouble(col++), PARAM_MAXWINDSPEED.getName())));
            attrs.add(PARAM_MINPRESSURE.getReal(this.getValue(results.getDouble(col++), PARAM_MINPRESSURE.getName())));
            attrs.add(PARAM_RADIUSMODERATEGALE.getReal(this.getValue(results.getDouble(col++), PARAM_RADIUSMODERATEGALE.getName())));
            attrs.add(PARAM_RADIUSWHOLEGALE.getReal(this.getValue(results.getDouble(col++), PARAM_RADIUSWHOLEGALE.getName())));
            attrs.add(PARAM_MOVEDIRECTION.getReal(this.getValue(results.getDouble(col++), PARAM_MOVEDIRECTION.getName())));
            attrs.add(PARAM_MOVESPEED.getReal(this.getValue(results.getDouble(col++), PARAM_MOVESPEED.getName())));
            EarthLocationLite elt = new EarthLocationLite(new Real(RealType.Latitude, latitude), new Real(RealType.Longitude, longitude), altReal);
            DateTime date = this.getDateTime(year, month, day, hour);
            String key = "" + latitude + " " + longitude;
            StormTrackPoint stp = new StormTrackPoint(elt, date, 0, attrs);
            obsPts.add(stp);
        }
        return obsPts;
    }

    protected List<StormTrackPoint> getObservationTrack(StormInfo stormInfo, Way wy, DateTime before, DateTime after, List pts) throws Exception {
        ResultSet results;
        String columns = SqlUtil.comma(new String[]{this.getColYear(), COL_TYPHOON_MONTH, COL_TYPHOON_DAY, this.getColHour(), COL_TYPHOON_LATITUDE, COL_TYPHOON_LONGITUDE, COL_TYPHOON_WINDSPEED, COL_TYPHOON_PRESSURE, COL_TYPHOON_RADIUSMG, COL_TYPHOON_RADIUSWG, COL_TYPHOON_MOVEDIR, COL_TYPHOON_MOVESPEED, COL_TYPHOON_WAY});
        ArrayList<String> whereList = new ArrayList<String>();
        whereList.add(SqlUtil.eq(COL_TYPHOON_STORMID, SqlUtil.quote(stormInfo.getStormId())));
        whereList.add(SqlUtil.eq("fhour", ZEROHOUR));
        whereList.add(SqlUtil.eq(COL_TYPHOON_WAY, SqlUtil.quote(wy.getId())));
        String query = SqlUtil.makeSelect(columns, Misc.newList(TABLE_TRACK), SqlUtil.makeAnd(whereList));
        query = query + " order by  " + SqlUtil.comma(new String[]{this.getColYear(), COL_TYPHOON_MONTH, COL_TYPHOON_DAY, this.getColHour()});
        Statement statement = this.evaluate(query);
        SqlUtil.Iterator iter = SqlUtil.getIterator(statement);
        ArrayList<StormTrackPoint> obsPts = new ArrayList<StormTrackPoint>();
        ArrayList<StormTrackPoint> obsPts1 = new ArrayList<StormTrackPoint>();
        ArrayList<StormTrackPoint> obsPts2 = new ArrayList<StormTrackPoint>();
        Real altReal = new Real(RealType.Altitude, 0.0);
        while ((results = iter.getNext()) != null) {
            StormTrackPoint stp;
            double longitude;
            double latitude;
            ArrayList<Real> attrs = new ArrayList<Real>();
            int col = 1;
            int year = results.getInt(col++);
            int month = results.getInt(col++);
            int day = results.getInt(col++);
            int hour = results.getInt(col++);
            if ((latitude = this.getLatLonValue(results.getDouble(col++))) > 90.0 || latitude < -90.0 || (longitude = this.getLatLonValue(results.getDouble(col++))) > 360.0 || longitude < -180.0) continue;
            attrs.add(PARAM_MAXWINDSPEED.getReal(this.getValue(results.getDouble(col++), PARAM_MAXWINDSPEED.getName())));
            attrs.add(PARAM_MINPRESSURE.getReal(this.getValue(results.getDouble(col++), PARAM_MINPRESSURE.getName())));
            attrs.add(PARAM_RADIUSMODERATEGALE.getReal(this.getValue(results.getDouble(col++), PARAM_RADIUSMODERATEGALE.getName())));
            attrs.add(PARAM_RADIUSWHOLEGALE.getReal(this.getValue(results.getDouble(col++), PARAM_RADIUSWHOLEGALE.getName())));
            attrs.add(PARAM_MOVEDIRECTION.getReal(this.getValue(results.getDouble(col++), PARAM_MOVEDIRECTION.getName())));
            attrs.add(PARAM_MOVESPEED.getReal(this.getValue(results.getDouble(col++), PARAM_MOVESPEED.getName())));
            EarthLocationLite elt = new EarthLocationLite(new Real(RealType.Latitude, latitude), new Real(RealType.Longitude, longitude), altReal);
            DateTime date = this.getDateTime(year, month, day, hour);
            if (date.getValue() < before.getValue()) {
                stp = new StormTrackPoint(elt, date, 0, attrs);
                obsPts1.add(stp);
            }
            if (!(date.getValue() > after.getValue())) continue;
            stp = new StormTrackPoint(elt, date, 0, attrs);
            obsPts2.add(stp);
        }
        if (obsPts1.size() > 0) {
            obsPts.addAll(obsPts1);
        }
        obsPts.addAll(pts);
        if (obsPts2.size() > 0) {
            obsPts.addAll(obsPts2);
        }
        return obsPts;
    }

    protected DateTime getStartTime(List times) {
        int size = times.size();
        DateTime dt = (DateTime)times.get(0);
        int idx = 0;
        double value = dt.getValue();
        for (int i = 1; i < size; ++i) {
            dt = (DateTime)times.get(i);
            double dtValue = dt.getValue();
            if (!(dtValue < value)) continue;
            value = dtValue;
            idx = i;
        }
        return (DateTime)times.get(idx);
    }

    private List<StormInfo> getAllStormInfos() throws Exception {
        ResultSet results;
        String columns = SqlUtil.distinct(COL_TYPHOON_STORMID);
        String query = SqlUtil.makeSelect(columns, Misc.newList(TABLE_TRACK));
        SqlUtil.Iterator iter = SqlUtil.getIterator(this.evaluate(query));
        ArrayList<StormInfo> stormInfos = new ArrayList<StormInfo>();
        while ((results = iter.getNext()) != null) {
            String id = results.getString(1);
            DateTime startTime = this.getStormStartTime(id);
            StormInfo sinfo = new StormInfo(id, startTime);
            stormInfos.add(sinfo);
        }
        return stormInfos;
    }

    protected DateTime getStormStartTime(String id) throws Exception {
        String columns = SqlUtil.comma(new String[]{this.getColYear(), COL_TYPHOON_MONTH, COL_TYPHOON_DAY, this.getColHour()});
        ArrayList<String> whereList = new ArrayList<String>();
        whereList.add(SqlUtil.eq(COL_TYPHOON_STORMID, SqlUtil.quote(id)));
        whereList.add(SqlUtil.eq("fhour", ZEROHOUR));
        String query = SqlUtil.makeSelect(columns, Misc.newList(TABLE_TRACK), SqlUtil.makeAnd(whereList));
        query = query + " order by  " + columns;
        Statement statement = this.evaluate(query);
        SqlUtil.Iterator iter = SqlUtil.getIterator(statement);
        ResultSet results = iter.getNext();
        if (results != null) {
            int col = 1;
            int year = results.getInt(col++);
            int month = results.getInt(col++);
            int day = results.getInt(col++);
            int hour = results.getInt(col++);
            statement.close();
            return this.getDateTime(year, month, day, hour);
        }
        return null;
    }

    protected List<Way> getForecastWays(StormInfo stormInfo) throws Exception {
        ResultSet results;
        String columns = SqlUtil.distinct(COL_TYPHOON_WAY);
        ArrayList<String> whereList = new ArrayList<String>();
        whereList.add(SqlUtil.eq(COL_TYPHOON_STORMID, SqlUtil.quote(stormInfo.getStormId())));
        String query = SqlUtil.makeSelect(columns, Misc.newList(TABLE_TRACK), SqlUtil.makeAnd(whereList));
        Statement statement = this.evaluate(query);
        SqlUtil.Iterator iter = SqlUtil.getIterator(statement);
        ArrayList<Way> forecastWays = new ArrayList<Way>();
        while ((results = iter.getNext()) != null) {
            Way way = new Way(results.getString(1));
            this.addWay(way);
            forecastWays.add(way);
        }
        return forecastWays;
    }

    private Statement evaluate(String sql) throws SQLException {
        Statement stmt = this.getConnection().createStatement();
        stmt.execute(sql);
        return stmt;
    }

    public Connection getConnection() {
        if (this.connection != null) {
            return this.connection;
        }
        String url = this.dbUrl;
        int cnt = 0;
        while (true) {
            String userName = this.getUserName();
            String password = this.getPassword();
            if (userName == null) {
                userName = "";
            }
            if (password == null) {
                password = "";
            }
            try {
                this.connection = this.useDerby() ? DriverManager.getConnection(url) : (url.indexOf("user") > 0 && url.indexOf("password") > 0 ? DriverManager.getConnection(url) : DriverManager.getConnection(url, userName, password));
                return this.connection;
            }
            catch (Exception sqe) {
                String msg = sqe.toString();
                if (msg.indexOf("Access denied") >= 0 || msg.indexOf("role \"" + userName + "\" does not exist") >= 0 || msg.indexOf("user name specified") >= 0) {
                    String label = cnt == 0 ? "<html>The database requires a login.<br>Please enter a user name and password:</html>" : "<html>Incorrect username/password. Please try again.</html>";
                    if (!this.showPasswordDialog("Database Login", label)) {
                        return null;
                    }
                    ++cnt;
                    continue;
                }
                throw new BadDataException("Unable to connect to database", sqe);
            }
            break;
        }
    }

    private boolean initConnection() throws Exception {
        if (this.getConnection() == null) {
            return false;
        }
        try {
            Connection connection = this.getConnection();
            Statement stmt = connection.createStatement();
            if (this.useDerby()) {
                try {
                    stmt.execute("select count(*) from typhoon");
                    System.err.println("Derby DB OK");
                }
                catch (Exception exc) {
                    System.err.println("exc;" + exc);
                    System.err.println("Creating test database");
                    String initSql = IOUtil.readContents("/ucar/unidata/data/storm/testdb.sql", this.getClass());
                    connection.setAutoCommit(false);
                    SqlUtil.loadSql(initSql, stmt, false);
                    connection.commit();
                    connection.setAutoCommit(true);
                }
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        String sid = "0623";
        STIStormDataSource s = null;
        try {
            s = new STIStormDataSource();
        }
        catch (Exception exc) {
            System.err.println("err:" + exc);
            exc.printStackTrace();
        }
        s.initAfter();
        List<StormInfo> sInfoList = s.getStormInfos();
        StormInfo sInfo = sInfoList.get(0);
        sInfo = s.getStormInfo(sid);
        String sd = sInfo.getStormId();
        StormTrackCollection cls = s.getTrackCollection(sInfo, null, null);
        StormTrack obsTrack = cls.getObsTrack();
        List<StormTrackPoint> trackPointList = obsTrack.getTrackPoints();
        List<DateTime> trackPointTime = obsTrack.getTrackTimes();
        List<Way> ways = cls.getWayList();
        HashMap mp = cls.getWayToStartDatesHashMap();
        HashMap<Way, List> mp1 = cls.getWayToTracksHashMap();
        System.err.println("test:");
    }

    public void setDbUrl(String value) {
        this.dbUrl = value;
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    static {
        MISSING = 9999.0f;
        try {
            PARAM_MAXWINDSPEED = new StormParam(STIStormDataSource.makeRealType("maxwindspeed", "Max_Windspeed", Util.parseUnit("m/s")));
            PARAM_RADIUSMODERATEGALE = new StormParam(STIStormDataSource.makeRealType("radiusmoderategale", "Radius_of_Beaufort_Scale7", DataUtil.parseUnit("km")));
            PARAM_RADIUSWHOLEGALE = new StormParam(STIStormDataSource.makeRealType("radiuswholegale", "Radius_of_Beaufort_Scale10", DataUtil.parseUnit("km")));
            PARAM_MOVEDIRECTION = new StormParam(STIStormDataSource.makeRealType("movedirection", "Storm_Direction", CommonUnit.degree));
            PARAM_MOVESPEED = new StormParam(STIStormDataSource.makeRealType("movespeed", "Storm_Speed", Util.parseUnit("m/s")));
            PARAM_PROBABILITY10RADIUS = new StormParam(STIStormDataSource.makeRealType("probabilityradius10", "Probability_10%_Radius", DataUtil.parseUnit("km")), true, false, false);
            PARAM_PROBABILITY20RADIUS = new StormParam(STIStormDataSource.makeRealType("probabilityradius20", "Probability_20%_Radius", DataUtil.parseUnit("km")), true, false, false);
            PARAM_PROBABILITY30RADIUS = new StormParam(STIStormDataSource.makeRealType("probabilityradius30", "Probability_30%_Radius", DataUtil.parseUnit("km")), true, false, false);
            PARAM_PROBABILITY40RADIUS = new StormParam(STIStormDataSource.makeRealType("probabilityradius40", "Probability_40%_Radius", DataUtil.parseUnit("km")), true, false, false);
            PARAM_PROBABILITY50RADIUS = new StormParam(STIStormDataSource.makeRealType("probabilityradius50", "Probability_50%_Radius", DataUtil.parseUnit("km")), true, false, false);
            PARAM_PROBABILITY60RADIUS = new StormParam(STIStormDataSource.makeRealType("probabilityradius60", "Probability_60%_Radius", DataUtil.parseUnit("km")), true, false, false);
            PARAM_PROBABILITY70RADIUS = new StormParam(STIStormDataSource.makeRealType("probabilityradius70", "Probability_70%_Radius", DataUtil.parseUnit("km")), true, false, false);
            PARAM_PROBABILITY80RADIUS = new StormParam(STIStormDataSource.makeRealType("probabilityradius80", "Probability_80%_Radius", DataUtil.parseUnit("km")), true, false, false);
            PARAM_PROBABILITY90RADIUS = new StormParam(STIStormDataSource.makeRealType("probabilityradius90", "Probability_90%_Radius", DataUtil.parseUnit("km")), true, false, false);
            PARAM_PROBABILITY100RADIUS = new StormParam(STIStormDataSource.makeRealType("probabilityradius100", "Probability_100%_Radius", DataUtil.parseUnit("km")), true, false, false);
            PARAM_DISTANCE_ERROR = new StormParam(STIStormDataSource.makeRealType("meanDistanceError", "Mean_Distance_Error", DataUtil.parseUnit("km")), true, false, false);
        }
        catch (Exception exc) {
            System.err.println("Error creating storm params:" + exc);
            exc.printStackTrace();
        }
    }
}

