/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.storm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.storm.STIStormDataSource;
import ucar.unidata.data.storm.StormDataSource;
import ucar.unidata.data.storm.StormInfo;
import ucar.unidata.data.storm.StormParam;
import ucar.unidata.data.storm.StormTrack;
import ucar.unidata.data.storm.StormTrackCollection;
import ucar.unidata.data.storm.StormTrackPoint;
import ucar.unidata.data.storm.Way;
import ucar.unidata.util.DateUtil;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.StringUtil;
import ucar.visad.Util;
import visad.CommonUnit;
import visad.DateTime;
import visad.Real;
import visad.RealType;
import visad.VisADException;
import visad.georef.EarthLocationLite;

public class Diamond7StormDataSource
extends StormDataSource {
    public static StormParam PARAM_MAXWINDSPEED;
    public static StormParam PARAM_RADIUSMODERATEGALE;
    public static StormParam PARAM_RADIUSWHOLEGALE;
    public static StormParam PARAM_DISTANCE_ERROR;
    public static StormParam PARAM_PROBABILITY100RADIUS;
    public static StormParam PARAM_PROBABILITYRADIUS;
    public static StormParam PARAM_MOVEDIRECTION;
    public static StormParam PARAM_MOVESPEED;
    private static float MISSING;
    private String fileName;
    private List<StormInfo> stormInfos;
    private List<StormTrack> stormTracks;
    private HashMap<String, Way> stormWays;
    private static final Way DEFAULT_OBSERVATION_WAY;
    private boolean hasObservation = false;

    @Override
    public String getId() {
        return "stiDiamond";
    }

    public Diamond7StormDataSource(DataSourceDescriptor descriptor, String fileName, Hashtable properties) throws Exception {
        super(descriptor, fileName, "Diamond7 Storm Data", properties);
        if (fileName == null || fileName.trim().length() == 0 || fileName.trim().equalsIgnoreCase("default")) {
            System.err.println("No input file");
        }
        this.fileName = fileName;
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    protected void initParams() throws VisADException {
        super.initParams();
        this.obsParams = new StormParam[]{PARAM_MAXWINDSPEED, PARAM_MINPRESSURE, PARAM_RADIUSMODERATEGALE, PARAM_RADIUSWHOLEGALE, PARAM_MOVESPEED, PARAM_MOVEDIRECTION};
        this.forecastParams = new StormParam[]{PARAM_MAXWINDSPEED, PARAM_MINPRESSURE, PARAM_RADIUSMODERATEGALE, PARAM_RADIUSWHOLEGALE, PARAM_MOVESPEED, PARAM_MOVEDIRECTION};
    }

    public Diamond7StormDataSource() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initializeStormData() {
        try {
            this.stormInfos = new ArrayList<StormInfo>();
            this.stormTracks = new ArrayList<StormTrack>();
            this.stormWays = new HashMap();
            String s = IOUtil.readContents(this.fileName);
            boolean lcn = false;
            String sid = null;
            String sway = null;
            boolean nextTrack = false;
            Way trackWay = null;
            StormInfo sInfo = null;
            ArrayList<StormTrackPoint> pts = null;
            ArrayList<StormTrackPoint> obsPts = new ArrayList<StormTrackPoint>();
            StormTrack sTrack = null;
            List<String> lines = StringUtil.split(s, "\n", true, true);
            int currentIndex = 0;
            String headerLine1 = lines.get(currentIndex++);
            double minTime = Double.MAX_VALUE;
            DateTime minDate = null;
            while (currentIndex < lines.size()) {
                DateTime trackStartTime;
                String headerLine2 = lines.get(currentIndex++);
                List<String> toks = StringUtil.split(headerLine2, " ", true, true);
                sid = toks.get(1);
                sway = toks.get(2);
                int numberPts = Integer.parseInt(toks.get(3));
                trackWay = new Way(sway);
                this.stormWays.put(sway, trackWay);
                if (trackWay.isObservation()) {
                    this.hasObservation = true;
                }
                if (sInfo == null) {
                    sInfo = new StormInfo(sid, new DateTime(new Date()));
                    this.stormInfos.add(sInfo);
                }
                pts = new ArrayList<StormTrackPoint>();
                int endPtsIndex = currentIndex + numberPts;
                while (currentIndex < endPtsIndex) {
                    String line = lines.get(currentIndex++);
                    toks = StringUtil.split(line, " ", true, true);
                    String year = toks.get(0);
                    String mon = toks.get(1);
                    String day = toks.get(2);
                    String hr = toks.get(3);
                    String fhr = toks.get(4);
                    String lon = toks.get(5);
                    String lat = toks.get(6);
                    String maxwindsp = toks.get(7);
                    String minpress = toks.get(8);
                    String radiusmgale = toks.get(9);
                    String radiuswgale = toks.get(10);
                    String mspd = toks.get(11);
                    String mdir = toks.get(12);
                    int yy = Integer.parseInt(year);
                    if (yy < 20) {
                        yy = 2000 + yy;
                    } else if (yy > 50 && yy < 99) {
                        yy = 1900 + yy;
                    }
                    DateTime dtt = this.getDateTime(yy, Integer.parseInt(mon), Integer.parseInt(day), Integer.parseInt(hr));
                    double latitude = Double.parseDouble(lat);
                    double longitude = Double.parseDouble(lon);
                    Real altReal = new Real(RealType.Altitude, 0.0);
                    int fhour = Integer.parseInt(fhr);
                    EarthLocationLite elt = new EarthLocationLite(new Real(RealType.Latitude, latitude), new Real(RealType.Longitude, longitude), altReal);
                    ArrayList<Real> attributes = new ArrayList<Real>();
                    double windspeed = this.getDouble(maxwindsp);
                    double pressure = this.getDouble(minpress);
                    attributes.add(PARAM_MINPRESSURE.getReal(pressure));
                    attributes.add(PARAM_MAXWINDSPEED.getReal(windspeed));
                    attributes.add(PARAM_RADIUSMODERATEGALE.getReal(this.getDouble(radiusmgale)));
                    attributes.add(PARAM_RADIUSWHOLEGALE.getReal(this.getDouble(radiuswgale)));
                    attributes.add(PARAM_MOVEDIRECTION.getReal(this.getDouble(mdir)));
                    attributes.add(PARAM_MOVESPEED.getReal(this.getDouble(mspd)));
                    StormTrackPoint stp = new StormTrackPoint(elt, dtt, fhour, attributes);
                    if (fhour == 0 && !trackWay.isObservation()) {
                        obsPts.add(stp);
                    }
                    if (fhour == 0 && pts.size() > 0 && !trackWay.isObservation()) {
                        DateTime trackStartTime2 = ((StormTrackPoint)pts.get(0)).getTime();
                        if (trackStartTime2.getValue() < minTime) {
                            minTime = trackStartTime2.getValue();
                            minDate = trackStartTime2;
                        }
                        sTrack = new StormTrack(sInfo, trackWay, pts, this.forecastParams);
                        this.stormTracks.add(sTrack);
                        pts = new ArrayList();
                    }
                    pts.add(stp);
                }
                if (trackWay.isObservation()) {
                    trackStartTime = ((StormTrackPoint)pts.get(0)).getTime();
                    if (trackStartTime.getValue() < minTime) {
                        minTime = trackStartTime.getValue();
                        minDate = trackStartTime;
                    }
                    sTrack = new StormTrack(sInfo, trackWay, pts, this.obsParams);
                    this.stormTracks.add(sTrack);
                    pts = new ArrayList();
                }
                if (pts.size() <= 0 || trackWay.isObservation()) continue;
                trackStartTime = ((StormTrackPoint)pts.get(0)).getTime();
                if (trackStartTime.getValue() < minTime) {
                    minTime = trackStartTime.getValue();
                    minDate = trackStartTime;
                }
                sTrack = new StormTrack(sInfo, trackWay, pts, this.forecastParams);
                this.stormTracks.add(sTrack);
                pts = new ArrayList();
            }
            if (sInfo != null && minDate != null) {
                sInfo.setStartTime(minDate);
            }
            if (!this.hasObservation && obsPts.size() > 0) {
                sTrack = new StormTrack(sInfo, DEFAULT_OBSERVATION_WAY, obsPts, this.obsParams);
                this.stormTracks.add(sTrack);
                this.stormWays.put("Observation", DEFAULT_OBSERVATION_WAY);
            }
        }
        catch (Exception exc) {
            this.logException("Error initializing ATCF data", exc);
        }
        finally {
            Diamond7StormDataSource.decrOutstandingGetDataCalls();
        }
    }

    public double getDouble(String dstring) {
        if (dstring.equalsIgnoreCase("NaN") || dstring.equalsIgnoreCase("9999")) {
            return Double.NaN;
        }
        return Double.parseDouble(dstring);
    }

    @Override
    public List<StormInfo> getStormInfos() {
        ArrayList<StormInfo> sInfos = new ArrayList<StormInfo>();
        sInfos.addAll(this.stormInfos);
        return sInfos;
    }

    @Override
    public StormTrackCollection getTrackCollectionInner(StormInfo stormInfo, Hashtable<String, Boolean> waysToUse, Way observationWay) throws Exception {
        if (observationWay == null) {
            observationWay = DEFAULT_OBSERVATION_WAY;
        }
        StormTrackCollection trackCollection = new StormTrackCollection();
        List<Way> forecastWays = this.getForecastWays(stormInfo);
        for (Way forecastWay : forecastWays) {
            List<StormTrack> forecastTracks;
            if (waysToUse != null && waysToUse.size() > 0 && waysToUse.get(forecastWay.getId()) == null || (forecastTracks = this.getForecastTracks(stormInfo, forecastWay)).size() <= 0) continue;
            trackCollection.addTrackList(forecastTracks);
        }
        StormTrack obsTrack = this.getObservationTrack(stormInfo, observationWay);
        if (obsTrack != null) {
            List<StormTrack> tracks = trackCollection.getTracks();
            trackCollection.addTrack(obsTrack);
        }
        return trackCollection;
    }

    private List<StormTrack> getForecastTracks(StormInfo stormInfo, Way forecastWay) throws Exception {
        ArrayList<StormTrack> tracks = new ArrayList<StormTrack>();
        List<DateTime> startDates = this.getForecastTrackStartDates(stormInfo, forecastWay);
        int nstarts = startDates.size();
        for (int i = 0; i < nstarts; ++i) {
            int pn;
            DateTime dt = startDates.get(i);
            StormTrack tk = this.getForecastTrack(stormInfo, dt, forecastWay);
            if (tk == null || (pn = tk.getTrackPoints().size()) <= 1) continue;
            tracks.add(tk);
        }
        return tracks;
    }

    public double getValue(double d, String name) {
        if (d == 9999.0 || d == 999.0) {
            return Double.NaN;
        }
        if (name.equalsIgnoreCase(PARAM_MAXWINDSPEED.getName()) ? d < 0.0 || d > 60.0 : (name.equalsIgnoreCase(PARAM_MINPRESSURE.getName()) ? d < 800.0 || d > 1050.0 : (name.equalsIgnoreCase(PARAM_RADIUSMODERATEGALE.getName()) ? d < 0.0 || d > 900.0 : (name.equalsIgnoreCase(PARAM_RADIUSWHOLEGALE.getName()) ? d < 0.0 || d > 500.0 : (name.equalsIgnoreCase(PARAM_MOVESPEED.getName()) ? d < 0.0 || d > 55.0 : name.equalsIgnoreCase(PARAM_MOVEDIRECTION.getName()) && (d < 0.0 || d > 360.0)))))) {
            return Double.NaN;
        }
        return d;
    }

    public double getLatLonValue(double d) {
        if (d == 9999.0 || d == 999.0) {
            return Double.NaN;
        }
        return d;
    }

    private StormTrack getForecastTrack(StormInfo stormInfo, DateTime sTime, Way forecastWay) throws Exception {
        StormTrack track = null;
        Iterator<StormTrack> iter = this.stormTracks.iterator();
        String sid = stormInfo.getStormId();
        String sway = forecastWay.getId();
        while (iter.hasNext()) {
            track = iter.next();
            String away = track.getWay().getId();
            String id = track.getStormInfo().getStormId();
            DateTime dt = track.getStartTime();
            if (!id.equalsIgnoreCase(sid) || dt != sTime || !sway.equalsIgnoreCase(away)) continue;
            return track;
        }
        return null;
    }

    private DateTime getDateTime(int year, int month, int day, int hour) throws Exception {
        GregorianCalendar convertCal = new GregorianCalendar(DateUtil.TIMEZONE_GMT);
        convertCal.clear();
        convertCal.set(1, year);
        convertCal.set(2, month - 1);
        convertCal.set(5, day);
        convertCal.set(11, hour);
        return new DateTime(convertCal.getTime());
    }

    protected List<DateTime> getForecastTrackStartDates(StormInfo stormInfo, Way way) throws Exception {
        Iterator<StormTrack> iter = this.stormTracks.iterator();
        ArrayList<DateTime> startDates = new ArrayList<DateTime>();
        while (iter.hasNext()) {
            StormTrack track = iter.next();
            if (track.getWay().isObservation()) continue;
            DateTime dt = track.getStartTime();
            startDates.add(dt);
        }
        return startDates;
    }

    protected StormTrack getObservationTrack(StormInfo stormInfo, Way observationWay) throws Exception {
        this.addWay(observationWay);
        List<StormTrackPoint> obsTrackPoints = this.getObservationTrackPoints(stormInfo, observationWay);
        if (obsTrackPoints == null || obsTrackPoints.size() == 0) {
            return null;
        }
        return new StormTrack(stormInfo, this.addWay(Way.OBSERVATION), obsTrackPoints, this.obsParams);
    }

    @Override
    public boolean getIsObservationWayChangeable() {
        return true;
    }

    protected List<StormTrackPoint> getObservationTrackPoints(StormInfo stormInfo, Way wy) throws Exception {
        Iterator<StormTrack> iter = this.stormTracks.iterator();
        String sway = wy.getId();
        String sid = stormInfo.getStormId();
        while (iter.hasNext()) {
            StormTrack strack = iter.next();
            String away = strack.getWay().getId();
            String aid = strack.getStormInfo().getStormId();
            if (!away.equalsIgnoreCase(sway) || !aid.equalsIgnoreCase(sid)) continue;
            return strack.getTrackPoints();
        }
        return null;
    }

    protected List<StormTrackPoint> getObservationTrack(StormInfo stormInfo, Way wy, DateTime before, DateTime after, List pts) throws Exception {
        return null;
    }

    protected DateTime getStartTime(List times) {
        int size = times.size();
        DateTime dt = (DateTime)times.get(0);
        int idx = 0;
        double value = dt.getValue();
        for (int i = 1; i < size; ++i) {
            dt = (DateTime)times.get(i);
            double dtValue = dt.getValue();
            if (!(dtValue < value)) continue;
            value = dtValue;
            idx = i;
        }
        return (DateTime)times.get(idx);
    }

    protected DateTime getStormStartTime(String sid) throws Exception {
        for (StormTrack strack : this.stormTracks) {
            String aid = strack.getStormInfo().getStormId();
            if (!aid.equalsIgnoreCase(sid)) continue;
            return strack.getStartTime();
        }
        return null;
    }

    protected List<Way> getForecastWays(StormInfo stormInfo) throws Exception {
        ArrayList<Way> ways = new ArrayList<Way>();
        Collection<Way> wc = this.stormWays.values();
        for (Way way : wc) {
            if (way.isObservation()) continue;
            ways.add(way);
        }
        return ways;
    }

    public static void main(String[] args) throws Exception {
        String sid = "0623";
        STIStormDataSource s = null;
        try {
            s = new STIStormDataSource();
        }
        catch (Exception exc) {
            System.err.println("err:" + exc);
            exc.printStackTrace();
        }
        s.initAfter();
        List<StormInfo> sInfoList = s.getStormInfos();
        StormInfo sInfo = sInfoList.get(0);
        sInfo = s.getStormInfo(sid);
        String sd = sInfo.getStormId();
        StormTrackCollection cls = s.getTrackCollection(sInfo, null, null);
        StormTrack obsTrack = cls.getObsTrack();
        List<StormTrackPoint> trackPointList = obsTrack.getTrackPoints();
        List<DateTime> trackPointTime = obsTrack.getTrackTimes();
        List<Way> ways = cls.getWayList();
        HashMap mp = cls.getWayToStartDatesHashMap();
        HashMap<Way, List> mp1 = cls.getWayToTracksHashMap();
        System.err.println("test:");
    }

    static {
        MISSING = 9999.0f;
        try {
            PARAM_MINPRESSURE = new StormParam(Diamond7StormDataSource.makeRealType("minpressure", "Min_Pressure", DataUtil.parseUnit("mb")));
            PARAM_MAXWINDSPEED = new StormParam(Diamond7StormDataSource.makeRealType("maxwindspeed", "Max_Windspeed", Util.parseUnit("m/s")));
            PARAM_RADIUSMODERATEGALE = new StormParam(Diamond7StormDataSource.makeRealType("radiusmoderategale", "Radius_of_Beaufort_Scale7", DataUtil.parseUnit("km")));
            PARAM_RADIUSWHOLEGALE = new StormParam(Diamond7StormDataSource.makeRealType("radiuswholegale", "Radius_of_Beaufort_Scale10", DataUtil.parseUnit("km")));
            PARAM_MOVEDIRECTION = new StormParam(Diamond7StormDataSource.makeRealType("movedirection", "Storm_Direction", CommonUnit.degree));
            PARAM_MOVESPEED = new StormParam(Diamond7StormDataSource.makeRealType("movespeed", "Storm_Speed", Util.parseUnit("m/s")));
        }
        catch (Exception exc) {
            System.err.println("Error creating storm params:" + exc);
            exc.printStackTrace();
        }
        DEFAULT_OBSERVATION_WAY = new Way("Observation");
    }
}

