/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.storm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import java.util.TimeZone;
import java.util.zip.GZIPInputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import ucar.unidata.data.BadDataException;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.storm.StormDataSource;
import ucar.unidata.data.storm.StormInfo;
import ucar.unidata.data.storm.StormParam;
import ucar.unidata.data.storm.StormTrack;
import ucar.unidata.data.storm.StormTrackCollection;
import ucar.unidata.data.storm.StormTrackPoint;
import ucar.unidata.data.storm.Way;
import ucar.unidata.util.DateUtil;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.StringUtil;
import visad.DateTime;
import visad.Real;
import visad.RealType;
import visad.VisADException;
import visad.georef.EarthLocationLite;

public class AtcfStormDataSource
extends StormDataSource {
    private int BASEIDX = 0;
    private int IDX_BASIN = this.BASEIDX++;
    private int IDX_CY = this.BASEIDX++;
    private int IDX_YYYYMMDDHH = this.BASEIDX++;
    private int IDX_TECHNUM = this.BASEIDX++;
    private int IDX_TECH = this.BASEIDX++;
    private int IDX_TAU = this.BASEIDX++;
    private int IDX_LAT = this.BASEIDX++;
    private int IDX_LON = this.BASEIDX++;
    private int IDX_VMAX = this.BASEIDX++;
    private int IDX_MSLP = this.BASEIDX++;
    private int IDX_TY = this.BASEIDX++;
    private int IDX_RAD = this.BASEIDX++;
    private int IDX_WINDCODE = this.BASEIDX++;
    private int IDX_RAD1 = this.BASEIDX++;
    private int IDX_RAD2 = this.BASEIDX++;
    private int IDX_RAD3 = this.BASEIDX++;
    private int IDX_RAD4 = this.BASEIDX++;
    private int IDX_RADP = this.BASEIDX++;
    private int IDX_RRP = this.BASEIDX++;
    private int IDX_MRD = this.BASEIDX++;
    private int IDX_GUSTS = this.BASEIDX++;
    private int IDX_EYE = this.BASEIDX++;
    private int IDX_SUBREGION = this.BASEIDX++;
    private int IDX_MAXSEAS = this.BASEIDX++;
    private int IDX_INITIALS = this.BASEIDX++;
    private int IDX_DIR = this.BASEIDX++;
    private int IDX_SPEED = this.BASEIDX++;
    private int IDX_STORMNAME = this.BASEIDX++;
    private int IDX_DEPTH = this.BASEIDX++;
    private int IDX_SEAS = this.BASEIDX++;
    private int IDX_SEASCODE = this.BASEIDX++;
    private int IDX_SEAS1 = this.BASEIDX++;
    private int IDX_SEAS2 = this.BASEIDX++;
    private int IDX_SEAS3 = this.BASEIDX++;
    private int IDX_SEAS4 = this.BASEIDX++;
    private static final String PREFIX_ANALYSIS = "a";
    private static final String PREFIX_BEST = "b";
    private static final String WAY_BEST = "BEST";
    private static final String WAY_CARQ = "CARQ";
    private static final String WAY_WRNG = "WRNG";
    private static String DEFAULT_PATH = "ftp://anonymous:password@ftp.nhc.noaa.gov/atcf";
    private String path;
    private List<StormInfo> stormInfos;
    private StormTrackCollection localTracks;

    public AtcfStormDataSource() throws Exception {
    }

    @Override
    public String getFullDescription() {
        return "ATCF Data Source<br>Path:" + this.path;
    }

    public AtcfStormDataSource(DataSourceDescriptor descriptor, String url, Hashtable properties) {
        super(descriptor, "ATCF Storm Data", "ATCF Storm Data", properties);
        if (url == null || url.trim().length() == 0 || url.trim().equalsIgnoreCase("default")) {
            url = DEFAULT_PATH;
        }
        this.path = url;
    }

    @Override
    public String getId() {
        return "atcf";
    }

    private String getFullPath(String suffix) {
        return this.path + "/" + suffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initializeStormData() {
        try {
            AtcfStormDataSource.incrOutstandingGetDataCalls();
            this.stormInfos = new ArrayList<StormInfo>();
            if (this.path.toLowerCase().endsWith(".atcf") || IOUtil.getFileTail(this.path.toLowerCase()).startsWith("track") || this.path.toLowerCase().endsWith(".gz") || this.path.toLowerCase().endsWith(".dat")) {
                String name = IOUtil.stripExtension(IOUtil.getFileTail(this.path));
                StormInfo si = new StormInfo(name, new DateTime(new Date()));
                this.stormInfos.add(si);
                this.localTracks = new StormTrackCollection();
                this.readTracks(si, this.localTracks, this.path, null, true);
                List<StormTrack> trackList = this.localTracks.getTracks();
                if (trackList.size() > 0) {
                    si.setStartTime(trackList.get(0).getStartTime());
                }
                return;
            }
            byte[] techs = this.readFile(this.getFullPath("nhc_techlist.dat"), true);
            if (techs != null) {
                int cnt = 0;
                for (String line : StringUtil.split(new String(techs), "\n", true, true)) {
                    if (cnt++ == 0 || line.length() <= 67) continue;
                    String id = line.substring(3, 10).trim();
                    String name = line.substring(67).trim();
                    this.getWay(id, name);
                }
            }
            byte[] bytes = this.readFile(this.getFullPath("index/storm_list.txt"), false);
            String stormTable = new String(bytes);
            List<String> lines = StringUtil.split(stormTable, "\n", true, true);
            SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMddHH");
            fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
            for (int i = 0; i < lines.size(); ++i) {
                String line = lines.get(i);
                List<String> toks = StringUtil.split((Object)line, ",", true);
                String name = toks.get(0);
                String basin = toks.get(1);
                String number = toks.get(7);
                String year = toks.get(8);
                int y = new Integer(year);
                String id = basin + "_" + number + "_" + year;
                if (name.equals("UNNAMED")) {
                    name = id;
                }
                String dttm = toks.get(11);
                Date date = fmt.parse(dttm);
                StormInfo si = new StormInfo(id, name, basin, number, new DateTime(date));
                this.stormInfos.add(si);
            }
        }
        catch (Exception exc) {
            this.logException("Error initializing ATCF data", exc);
        }
        finally {
            AtcfStormDataSource.decrOutstandingGetDataCalls();
        }
    }

    @Override
    public List<StormInfo> getStormInfos() {
        return this.stormInfos;
    }

    private double getDouble(String s) {
        if (s == null) {
            return Double.NaN;
        }
        if (s.length() == 0) {
            return Double.NaN;
        }
        return new Double(s);
    }

    @Override
    protected void initParams() throws VisADException {
        super.initParams();
        if (this.obsParams == null) {
            this.obsParams = new StormParam[]{PARAM_STORMCATEGORY, PARAM_MINPRESSURE, PARAM_MAXWINDSPEED_KTS};
        }
    }

    private boolean readTracks(StormInfo stormInfo, StormTrackCollection tracks, String trackFile, Hashtable<String, Boolean> waysToUse, boolean throwError) throws Exception {
        long t1 = System.currentTimeMillis();
        byte[] bytes = this.readFile(trackFile, true);
        long t2 = System.currentTimeMillis();
        boolean isZip = trackFile.endsWith(".gz");
        if (bytes == null && isZip) {
            String withoutGZ = trackFile.substring(0, trackFile.length() - 3);
            bytes = this.readFile(withoutGZ, true);
            isZip = false;
        }
        if (bytes == null) {
            if (throwError) {
                throw new BadDataException("Unable to read track file:" + trackFile);
            }
            return false;
        }
        if (isZip) {
            GZIPInputStream zin = new GZIPInputStream(new ByteArrayInputStream(bytes));
            bytes = IOUtil.readBytes(zin);
            zin.close();
        }
        GregorianCalendar convertCal = new GregorianCalendar(DateUtil.TIMEZONE_GMT);
        convertCal.clear();
        String trackData = new String(bytes);
        List<String> lines = StringUtil.split(trackData, "\n", true, true);
        SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMddHH");
        fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        Hashtable<String, StormTrack> trackMap = new Hashtable<String, StormTrack>();
        Real altReal = new Real(RealType.Altitude, 0.0);
        Hashtable<String, String> seenDate = new Hashtable<String, String>();
        this.initParams();
        boolean xcnt = false;
        List<String> toks1 = StringUtil.split((Object)lines.get(1), ",", true);
        String techNum = toks1.get(this.IDX_TECHNUM);
        if (techNum.length() > 0 && !techNum.matches("\\d+")) {
            --this.IDX_TECH;
            --this.IDX_TAU;
            --this.IDX_LAT;
            --this.IDX_LON;
            --this.IDX_VMAX;
            --this.IDX_MSLP;
            --this.IDX_TY;
        }
        for (int i = 0; i < lines.size(); ++i) {
            String key;
            String dttmkey;
            int category;
            String line = lines.get(i);
            if (i == 0) {
                // empty if block
            }
            List<String> toks = StringUtil.split((Object)line, ",", true);
            String dateString = toks.get(this.IDX_YYYYMMDDHH);
            String wayString = toks.get(this.IDX_TECH);
            boolean isBest = wayString.equals(WAY_BEST);
            boolean isWarning = wayString.equals(WAY_WRNG);
            boolean isCarq = wayString.equals(WAY_CARQ);
            int n = category = this.IDX_TY < toks.size() ? this.getCategory(toks.get(this.IDX_TY)) : 15;
            if (category != 15) {
                // empty if block
            }
            String fhour = toks.get(this.IDX_TAU);
            int forecastHour = new Integer(fhour);
            if (fhour.length() == 5 && forecastHour > 100) {
                forecastHour /= 100;
            }
            if (isWarning || isCarq) {
                forecastHour = -forecastHour;
            }
            if (seenDate.get(dttmkey = wayString + "_" + dateString + "_" + forecastHour) != null) continue;
            seenDate.put(dttmkey, dttmkey);
            Date dttm = fmt.parse(dateString);
            convertCal.setTime(dttm);
            Way way = this.getWay(wayString, null);
            if (!isBest && waysToUse != null && waysToUse.size() > 0 && waysToUse.get(wayString) == null) continue;
            if (isBest) {
                key = wayString;
            } else {
                key = wayString + "_" + dateString;
                convertCal.add(11, forecastHour);
            }
            dttm = convertCal.getTime();
            StormTrack track = (StormTrack)trackMap.get(key);
            if (track == null) {
                way = isBest ? Way.OBSERVATION : way;
                track = new StormTrack(stormInfo, this.addWay(way), new DateTime(dttm), this.obsParams);
                trackMap.put(key, track);
                tracks.addTrack(track);
            }
            String latString = toks.get(this.IDX_LAT);
            String lonString = toks.get(this.IDX_LON);
            String t = latString + " " + lonString;
            boolean south = latString.endsWith("S");
            boolean west = lonString.endsWith("W");
            double latitude = Double.parseDouble(latString.substring(0, latString.length() - 1)) / 10.0;
            double longitude = Double.parseDouble(lonString.substring(0, lonString.length() - 1)) / 10.0;
            if (south) {
                latitude = -latitude;
            }
            if (west) {
                longitude = -longitude;
            }
            EarthLocationLite elt = new EarthLocationLite(new Real(RealType.Latitude, latitude), new Real(RealType.Longitude, longitude), altReal);
            ArrayList<Real> attributes = new ArrayList<Real>();
            double windspeed = this.IDX_VMAX < toks.size() ? this.getDouble(toks.get(this.IDX_VMAX)) : Double.NaN;
            double pressure = this.IDX_MSLP < toks.size() ? this.getDouble(toks.get(this.IDX_MSLP)) : Double.NaN;
            attributes.add(PARAM_STORMCATEGORY.getReal(category));
            attributes.add(PARAM_MINPRESSURE.getReal(pressure));
            attributes.add(PARAM_MAXWINDSPEED_KTS.getReal(windspeed));
            StormTrackPoint stp = new StormTrackPoint(elt, new DateTime(dttm), forecastHour, attributes);
            track.addPoint(stp);
        }
        return true;
    }

    @Override
    public String getWayName() {
        return "Tech";
    }

    @Override
    public StormTrackCollection getTrackCollectionInner(StormInfo stormInfo, Hashtable<String, Boolean> waysToUse, Way observationWay) throws Exception {
        StormTrackCollection tracks;
        block11: {
            String trackFile;
            String bSubDir;
            int stormYear;
            block10: {
                if (this.localTracks != null) {
                    return this.localTracks;
                }
                long t1 = System.currentTimeMillis();
                tracks = new StormTrackCollection();
                boolean justObs = waysToUse != null && waysToUse.size() == 1 && waysToUse.get(Way.OBSERVATION.toString()) != null;
                int nowYear = new GregorianCalendar(DateUtil.TIMEZONE_GMT).get(1);
                stormYear = AtcfStormDataSource.getYear(stormInfo.getStartTime());
                String aSubDir = stormYear == nowYear ? "aid_public" : "archive/" + stormYear;
                String string = bSubDir = stormYear == nowYear ? "btk" : "archive/" + stormYear;
                if (!justObs) {
                    trackFile = this.getFullPath(aSubDir + "/" + PREFIX_ANALYSIS + stormInfo.getBasin().toLowerCase() + stormInfo.getNumber() + stormYear + ".dat.gz");
                    try {
                        this.readTracks(stormInfo, tracks, trackFile, waysToUse, true);
                    }
                    catch (BadDataException bde) {
                        if (aSubDir.equals("aid_public")) break block10;
                        try {
                            trackFile = this.getFullPath("aid_public/a" + stormInfo.getBasin().toLowerCase() + stormInfo.getNumber() + stormYear + ".dat.gz");
                            this.readTracks(stormInfo, tracks, trackFile, waysToUse, true);
                        }
                        catch (BadDataException bde2) {
                            System.err.println("Failed reading 'A' file for storm:" + stormInfo + " file:" + trackFile);
                        }
                    }
                }
            }
            trackFile = this.getFullPath(bSubDir + "/" + PREFIX_BEST + stormInfo.getBasin().toLowerCase() + stormInfo.getNumber() + stormYear + ".dat.gz");
            try {
                this.readTracks(stormInfo, tracks, trackFile, null, true);
            }
            catch (BadDataException bde) {
                if (bSubDir.equals("btk")) break block11;
                try {
                    trackFile = this.getFullPath("btk/b" + stormInfo.getBasin().toLowerCase() + stormInfo.getNumber() + stormYear + ".dat.gz");
                    this.readTracks(stormInfo, tracks, trackFile, null, true);
                }
                catch (BadDataException bde2) {
                    System.err.println("Failed reading 'B' file for storm:" + stormInfo + " file:" + trackFile);
                }
            }
        }
        long t2 = System.currentTimeMillis();
        return tracks;
    }

    public void setPath(String value) {
        this.path = value;
    }

    public String getPath() {
        return this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFile(String file, boolean ignoreErrors) throws Exception {
        if (new File(file).exists()) {
            return IOUtil.readBytes(IOUtil.getInputStream(file, this.getClass()));
        }
        if (!file.startsWith("ftp:")) {
            if (ignoreErrors) {
                return null;
            }
            throw new FileNotFoundException("Could not read file: " + file);
        }
        URL url = new URL(file);
        FTPClient ftp = new FTPClient();
        try {
            ftp.connect(url.getHost());
            ftp.login("anonymous", "password");
            ftp.setFileType(2);
            ftp.enterLocalPassiveMode();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            if (ftp.retrieveFile(url.getPath(), (OutputStream)bos)) {
                byte[] byArray = bos.toByteArray();
                return byArray;
            }
            try {
                throw new IOException("Unable to retrieve file:" + url);
            }
            catch (FTPConnectionClosedException fcce) {
                System.err.println("ftp error:" + (Object)((Object)fcce));
                System.err.println(ftp.getReplyString());
                if (!ignoreErrors) {
                    throw fcce;
                }
                byte[] byArray = null;
                return byArray;
            }
            catch (Exception exc) {
                if (!ignoreErrors) {
                    throw exc;
                }
                byte[] byArray = null;
                return byArray;
            }
        }
        finally {
            try {
                ftp.logout();
            }
            catch (Exception exception) {}
            try {
                ftp.disconnect();
            }
            catch (Exception exception) {}
        }
    }
}

