/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.sounding;

import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import ucar.ma2.Range;
import ucar.unidata.data.CompositeDataChoice;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DirectDataChoice;
import ucar.unidata.data.VarInfo;
import ucar.unidata.data.sounding.CDMTrajectoryFeatureTypeInfo;
import ucar.unidata.data.sounding.CosmicTrajectoryFeatureTypeInfo;
import ucar.unidata.data.sounding.TrackAdapter;
import ucar.unidata.data.sounding.TrackDataSource;
import ucar.unidata.data.sounding.TrackInfo;
import ucar.unidata.data.sounding.TrajectoryFeatureTypeAdapter;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.data.CalendarDateTime;
import visad.Data;
import visad.DateTime;
import visad.FieldImpl;
import visad.FunctionType;
import visad.RealType;
import visad.Text;
import visad.VisADException;

public class TrajectoryFeatureTypeDataSource
extends TrackDataSource {
    public static final String ID_SONDELOCATIONS = "id.sondelocations";
    public static final String ID_SONDESTARTLOCATIONS = "id.sondestartlocations";
    private static final String ID_SONDEENDLOCATIONS = "id.sondeendlocations";
    private List pointCats = Misc.newList(DataCategory.POINT_PLOT_CATEGORY);
    private List selectTimes;
    private boolean isCosmic = false;

    public TrajectoryFeatureTypeDataSource() {
    }

    public TrajectoryFeatureTypeDataSource(DataSourceDescriptor descriptor, String source, Hashtable properties) throws VisADException {
        this(descriptor, Misc.newList(source), properties);
    }

    public TrajectoryFeatureTypeDataSource(DataSourceDescriptor descriptor, List sources, Hashtable properties) throws VisADException {
        super(descriptor, sources, "Trajectory Soundings", properties);
    }

    @Override
    protected void initCategories() {
        if (this.traceCats == null) {
            super.initCategories();
            this.soundingCats = Misc.newList(DataCategory.TRAJECTORY_SOUNDING_CATEGORY);
        }
    }

    @Override
    protected DateTime getBaseTime() {
        DateTime[] minMax = this.getMinMaxTime();
        if (minMax == null) {
            return null;
        }
        return minMax[0];
    }

    protected DateTime[] getTimeList() {
        List adapters = this.getAdapters();
        if (adapters == null) {
            try {
                return new DateTime[]{new DateTime(), new DateTime()};
            }
            catch (Exception exc) {
                this.logException("Create null datetimes", exc);
                return null;
            }
        }
        DateTime[] timeList = new DateTime[adapters.size()];
        for (int i = 0; i < adapters.size(); ++i) {
            DateTime theTime;
            TrackAdapter adapter = (TrackAdapter)this.getAdapters().get(i);
            timeList[i] = theTime = adapter.getEndTime();
        }
        return timeList;
    }

    @Override
    protected List doMakeDateTimes() {
        Object[] timeList = this.getTimeList();
        if (timeList == null) {
            return new ArrayList();
        }
        return Misc.newList(timeList);
    }

    @Override
    protected FieldImpl aggregateTracks(List tracks, Object id0) throws VisADException, RemoteException {
        List adapters = this.getAdapters();
        FunctionType fiType = null;
        DateTime[] times = new DateTime[tracks.size()];
        if (this.selectTimes == null) {
            for (int i = 0; i < tracks.size(); ++i) {
                TrackAdapter adapter = (TrackAdapter)adapters.get(i);
                DateTime time = adapter.getEndTime();
                if (fiType == null) {
                    FieldImpl data = (FieldImpl)tracks.get(i);
                    fiType = new FunctionType(RealType.Time, data.getType());
                }
                times[i] = time;
            }
        } else {
            int len = this.selectTimes.size();
            times = new DateTime[len];
            for (int i = 0; i < len; ++i) {
                Integer ii = (Integer)this.selectTimes.get(i);
                int j = ii;
                TrackAdapter adapter = (TrackAdapter)adapters.get(j);
                DateTime time = adapter.getEndTime();
                if (fiType == null) {
                    FieldImpl data = (FieldImpl)tracks.get(j);
                    fiType = new FunctionType(RealType.Time, data.getType());
                }
                times[i] = time;
            }
        }
        FieldImpl fi = new FieldImpl(fiType, CalendarDateTime.makeTimeSet(times));
        for (int i = 0; i < tracks.size(); ++i) {
            FieldImpl data = (FieldImpl)tracks.get(i);
            fi.setSample(i, (Data)data, false);
        }
        return fi;
    }

    @Override
    protected void doMakeDataChoices() {
        List sources = this.getSources();
        if (sources.size() == 0) {
            return;
        }
        String source = sources.get(0).toString();
        File f = new File(source);
        if (f.isDirectory()) {
            return;
        }
        List adapters = this.getAdapters();
        if (adapters == null) {
            return;
        }
        this.initCategories();
        List<TrackInfo> trackInfos = null;
        try {
            trackInfos = this.getTraceAdapter().getTrackInfos();
        }
        catch (Exception exception) {
            // empty catch block
        }
        List categories = this.traceCats;
        for (int trackIdx = 0; trackIdx < trackInfos.size(); ++trackIdx) {
            TrackInfo trackInfo = trackInfos.get(trackIdx);
            List<VarInfo> vars = trackInfo.getVariables();
            String trackName = trackInfo.getTrackName();
            Object basicCat = null;
            if (trackInfos.size() > 1) {
                categories = DataCategory.parseCategories(trackName + "-Tracks" + ";trace", true);
            }
            Hashtable props = Misc.newHashtable("prop.icon", "/auxdata/ui/icons/TrajectoryData16.gif");
            for (VarInfo varInfo : vars) {
                List cats = categories;
                if (varInfo.getCategory() != null) {
                    String cat = StringUtil.replace(varInfo.getCategory(), "-", " ");
                    cats = DataCategory.parseCategories("Track-" + cat + ";trace", true);
                }
                DirectDataChoice ddc = new DirectDataChoice((DataSource)this, (Object)new String[]{trackName, varInfo.getName()}, varInfo.getName(), varInfo.getDescription(), cats, props);
                this.addDataChoice(ddc);
            }
            List pointCatList = this.pointCats;
            if (trackInfos.size() > 1) {
                pointCatList = DataCategory.parseCategories(trackName + ";" + DataCategory.POINT_PLOT_CATEGORY, true);
            }
            props = Misc.newHashtable("prop.icon", "/auxdata/ui/icons/Placemark16.gif");
            String pointLabel = this.getDataChoiceLabel("id.pointtrace");
            this.addDataChoice(new DirectDataChoice((DataSource)this, (Object)new String[]{trackName, "id.pointtrace"}, pointLabel, pointLabel, pointCatList, props));
        }
        if (f.getPath().contains("ionPrf") || f.getPath().contains("atmPhs")) {
            return;
        }
        if (this.isCosmic) {
            DirectDataChoice soundingChoice = null;
            if (adapters != null && adapters.size() > 1) {
                List category;
                String id;
                TrackAdapter adapter = (TrackAdapter)adapters.get(0);
                String sName = adapter.toString();
                List<TrackInfo> tinfo = adapter.getTrackInfos();
                String tName = tinfo.get((int)0).trackName;
                if (sName.contains("wetPrf") || sName.contains("atmPrf")) {
                    id = "id.soundingtrace";
                    category = this.getSoundingCategories();
                } else {
                    id = "id.soundingob";
                    category = this.getRaobCategories();
                }
                soundingChoice = new CompositeDataChoice(this, (Object)id, this.getDataChoiceLabel(id), this.getDataChoiceLabel(id), category);
                for (int i = 0; i < adapters.size(); ++i) {
                    TrackAdapter ta = (TrackAdapter)adapters.get(i);
                    TrackInfo trackInfo = ta.getTrackInfos().get(0);
                    String trackName = trackInfo.getTrackName() + i;
                    ((CompositeDataChoice)soundingChoice).addDataChoice(new DirectDataChoice(this, (Object)id, trackName, "Sonde " + i, category));
                }
            } else {
                soundingChoice = new DirectDataChoice(this, (Object)"id.soundingtrace", this.getDataChoiceLabel("id.soundingtrace"), this.getDataChoiceLabel("id.soundingtrace"), this.getSoundingCategories());
            }
            this.addDataChoice(soundingChoice);
            List locCats = DataCategory.parseCategories("locations", false);
            this.addDataChoice(new DirectDataChoice(this, (Object)ID_SONDEENDLOCATIONS, "Sonde End Locations", "Sonde End Locations", locCats));
        }
    }

    @Override
    protected TrackAdapter doMakeAdapter(String file, Hashtable pointDataFilter, int stride, int lastNMinutes) throws Exception {
        TrajectoryFeatureTypeAdapter td = new TrajectoryFeatureTypeAdapter(this, file, pointDataFilter, stride, lastNMinutes);
        this.isCosmic = td.isCosmic();
        return td;
    }

    @Override
    protected Data getDataInner(DataChoice dataChoice, DataCategory category, DataSelection dataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        String id = this.getChoiceId(dataChoice);
        this.selectTimes = dataSelection.getTimes();
        if (id.equals(ID_SONDESTARTLOCATIONS) || id.equals(ID_SONDEENDLOCATIONS)) {
            List adapters = this.getAdapters();
            String name = id.equals(ID_SONDEENDLOCATIONS) ? "Sonde End Locations" : "Sonde Start Locations";
            StringBuffer xml = new StringBuffer("<stationtable name=\"" + name + "\">\n");
            if (adapters != null) {
                for (int i = 0; i < adapters.size(); ++i) {
                    TrajectoryFeatureTypeAdapter cta = (TrajectoryFeatureTypeAdapter)adapters.get(i);
                    List<TrackInfo> infos = cta.getTrackInfos();
                    if (infos.size() == 0) continue;
                    TrackInfo cfti = this.isCosmic ? (CosmicTrajectoryFeatureTypeInfo)infos.get(0) : (CDMTrajectoryFeatureTypeInfo)infos.get(0);
                    int numObs = 0;
                    try {
                        boolean ascendingTimes;
                        numObs = cfti.getNumberPoints();
                        Range range = cfti.getFullRange();
                        double[] times = cfti.getTimeVals(range);
                        boolean bl = ascendingTimes = times[0] < times[times.length - 1];
                        int rVal = id.equals(ID_SONDEENDLOCATIONS) ? (ascendingTimes ? times.length - 1 : 0) : (ascendingTimes ? 0 : times.length - 1);
                        Range r = new Range(rVal, rVal);
                        String trueStartDate = cfti.getStartTime().getValue() > cfti.getEndTime().getValue() ? cfti.getEndTime().formattedString("HH:mm", DateTime.DEFAULT_TIMEZONE) : cfti.getStartTime().formattedString("HH:mm", DateTime.DEFAULT_TIMEZONE);
                        xml.append("<station " + XmlUtil.attr("id", trueStartDate) + XmlUtil.attr("name", IOUtil.getFileTail(cta.getFilename())) + XmlUtil.attr("lat", "" + cfti.getLatitude(r)[0]) + XmlUtil.attr("lon", "" + cfti.getLongitude(r)[0]) + XmlUtil.attr("elev", "" + cfti.getAltitude(r)[0]) + XmlUtil.attr("time", trueStartDate) + "/>");
                        continue;
                    }
                    catch (Exception exc) {
                        throw new IllegalStateException("Got error creating sonde positions " + exc);
                    }
                }
            }
            xml.append("</stationtable>");
            return new Text(xml.toString());
        }
        return super.getDataInner(dataChoice, category, dataSelection, requestProperties);
    }

    public void setTraceAdapter(String traceAdapter) throws Exception {
    }
}

