/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.sounding;

import java.util.Formatter;
import java.util.Hashtable;
import java.util.List;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dods.DODSNetcdfFile;
import ucar.nc2.ft.DsgFeatureCollection;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.ProfileFeature;
import ucar.nc2.ft.ProfileFeatureCollection;
import ucar.nc2.ft.TrajectoryFeature;
import ucar.nc2.ft.TrajectoryFeatureCollection;
import ucar.unidata.data.BadDataException;
import ucar.unidata.data.sounding.CDMProfileFeatureTypeInfo;
import ucar.unidata.data.sounding.CDMTrajectoryFeatureTypeInfo;
import ucar.unidata.data.sounding.CosmicTrajectoryFeatureTypeInfo;
import ucar.unidata.data.sounding.TrackAdapter;
import ucar.unidata.data.sounding.TrackDataSource;
import visad.Data;

public class TrajectoryFeatureTypeAdapter
extends TrackAdapter {
    private boolean isCosmic = false;
    private boolean isProfile = false;

    public TrajectoryFeatureTypeAdapter() throws Exception {
    }

    public TrajectoryFeatureTypeAdapter(TrackDataSource dataSource, String filename, Hashtable pointDataFilter, int stride, int lastNMinutes) throws Exception {
        super(dataSource, filename, pointDataFilter, stride, lastNMinutes);
        Formatter log = new Formatter();
        FeatureDatasetPoint dataset = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open(FeatureType.TRAJECTORY, DODSNetcdfFile.canonicalURL(filename), null, log);
        if (dataset == null && (dataset = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open(FeatureType.PROFILE, filename, null, log)) != null) {
            this.isProfile = true;
        }
        String imp = dataset.getImplementationName();
        if (dataset == null) {
            throw new BadDataException("Could not open trajectory file:" + filename);
        }
        List<DsgFeatureCollection> fcList = dataset.getPointFeatureCollectionList();
        DsgFeatureCollection fc = fcList.get(0);
        TrajectoryFeatureCollection tfc = null;
        ProfileFeatureCollection pfc = null;
        if (!this.isProfile) {
            tfc = (TrajectoryFeatureCollection)fc;
            tfc.resetIteration();
        } else {
            pfc = (ProfileFeatureCollection)fc;
            pfc.resetIteration();
        }
        if (imp.equalsIgnoreCase("cosmic")) {
            this.isCosmic = true;
            this.addTrackInfo(new CosmicTrajectoryFeatureTypeInfo(this, dataset, tfc));
        } else if (this.isProfile) {
            for (ProfileFeature pf : pfc) {
                this.addTrackInfo(new CDMProfileFeatureTypeInfo((TrackAdapter)this, dataset, pf));
            }
        } else if (dataset.getFeatureType().equals((Object)FeatureType.TRAJECTORY)) {
            for (TrajectoryFeature traj : tfc) {
                this.addTrackInfo(new CDMTrajectoryFeatureTypeInfo.PointFeatureTypeInfo(this, dataset, traj));
            }
        } else {
            this.addTrackInfo(new CDMTrajectoryFeatureTypeInfo.TrajectoryFeatureTypeInfo(this, dataset, tfc));
        }
    }

    public void setIsCosmic(boolean isC) {
        this.isCosmic = isC;
    }

    public boolean getIsCosmic() {
        return this.isCosmic;
    }

    public boolean isCosmic() {
        return this.isCosmic;
    }

    @Override
    public Data getAerologicalDiagramData(String trackId) throws Exception {
        CosmicTrajectoryFeatureTypeInfo ctfi = (CosmicTrajectoryFeatureTypeInfo)this.getTrackInfo(trackId);
        return ctfi.getAerologicalDiagramData();
    }
}

