/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.sounding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import ucar.ma2.Range;
import ucar.unidata.data.DataAlias;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.VarInfo;
import ucar.unidata.data.point.PointObTuple;
import ucar.unidata.data.sounding.RAOB;
import ucar.unidata.data.sounding.TrackAdapter;
import ucar.unidata.util.JobManager;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Trace;
import ucar.visad.Util;
import ucar.visad.quantities.AirPressure;
import ucar.visad.quantities.AirTemperature;
import ucar.visad.quantities.CommonUnits;
import ucar.visad.quantities.DewPoint;
import ucar.visad.quantities.Direction;
import ucar.visad.quantities.PolarHorizontalWind;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.Data;
import visad.DateTime;
import visad.DoubleSet;
import visad.ErrorEstimate;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DDoubleSet;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.SetType;
import visad.Text;
import visad.Tuple;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationTuple;
import visad.util.DataUtility;

public abstract class TrackInfo {
    protected String varTime;
    protected String varLatitude;
    protected String varLongitude;
    protected String varAltitude;
    public static final String TIME_TYPE = "track_time";
    public static final String LAT_TYPE = "track_lat";
    public static final String LON_TYPE = "track_lon";
    public static final String ALT_TYPE = "track_alt";
    protected Hashtable cachedTimeVals = new Hashtable();
    protected TrackAdapter adapter;
    protected GriddedSet llaSet = null;
    protected Range lastSpatialSetRange = null;
    DateTime startTime;
    DateTime endTime;
    protected List variables = new ArrayList();
    protected String trackName;
    Map<String, Object> dataTable = new HashMap<String, Object>();

    public TrackInfo(TrackAdapter adapter, String name) throws Exception {
        this.adapter = adapter;
        this.trackName = name;
    }

    protected void addVariable(VarInfo variable) {
        this.variables.add(variable);
    }

    protected void addVariableData(String vname, Object dataArray) {
        this.dataTable.put(vname, dataArray);
    }

    protected Object getVariableData(String vname) {
        return this.dataTable.get(vname);
    }

    public List<VarInfo> getVariables() {
        return this.variables;
    }

    public DateTime getStartTime() {
        return this.startTime;
    }

    public DateTime getEndTime() {
        return this.endTime;
    }

    public int getNumberPoints() throws Exception {
        float[] lats = this.getLatitude(null);
        if (lats == null) {
            return 0;
        }
        return lats.length;
    }

    protected GriddedSet makeEarthDomainSet(Range range) throws Exception {
        return Util.makeEarthDomainSet(this.getLatitude(range), this.getLongitude(range), this.getAltitude(range));
    }

    public synchronized FlatField getTrackWithTime(String variable, Range range) throws Exception {
        FlatField trace;
        Trace.call1("TrackAdapter.getTrackWithTime");
        if (range == null) {
            range = this.getFullRange();
        }
        if ((trace = this.getTrack(variable, range)) == null) {
            return null;
        }
        double[][] vals = trace.getValues(false);
        RealType varType = (RealType)DataUtility.getFlatRangeType(trace).getComponent(0);
        Unit timeUnit = this.getTimeUnit();
        double[][] newRangeVals = new double[2][vals[0].length];
        double[] timeVals = this.getTimeVals(range);
        newRangeVals[0] = vals[0];
        RealType timeType = this.getVarType(RealType.Time, timeUnit, timeVals[0]);
        RealTupleType rangeType = new RealTupleType(this.getVarType(varType), timeType);
        if (!this.getTimeUnit().equals(timeType.getDefaultUnit())) {
            Unit tmpUnit = timeType.getDefaultUnit();
            timeVals = tmpUnit.toThis(timeVals, timeUnit);
            timeUnit = tmpUnit;
        }
        newRangeVals[1] = timeVals;
        Set[] rangeSets = new Set[]{new DoubleSet(new SetType(rangeType.getComponent(0))), new DoubleSet(new SetType(rangeType.getComponent(1)))};
        GriddedSet llaSet = this.getSpatialSet(range);
        FunctionType newType = new FunctionType(((SetType)llaSet.getType()).getDomain(), rangeType);
        FlatField timeTrack = new FlatField(newType, (Set)llaSet, (CoordinateSystem)null, rangeSets, new Unit[]{varType.getDefaultUnit(), timeUnit});
        timeTrack.setSamples(newRangeVals, false);
        Trace.call2("TrackAdapter.getTrackWithTime");
        return timeTrack;
    }

    public double[] getTimeVals(Range range) throws Exception {
        double[] timeVals = (double[])this.cachedTimeVals.get(range);
        if (timeVals == null) {
            timeVals = this.getTime(range);
            this.cachedTimeVals.put(range, timeVals);
        }
        return timeVals;
    }

    protected Unit getTimeUnit() throws Exception {
        return CommonUnit.secondsSinceTheEpoch;
    }

    protected double[] getTime(Range range) throws Exception {
        return this.getDoubleData(range, this.varTime);
    }

    protected float[] getLatitude(Range range) throws Exception {
        return this.getFloatData(range, this.varLatitude);
    }

    protected float[] getLongitude(Range range) throws Exception {
        return this.getFloatData(range, this.varLongitude);
    }

    protected float[] getAltitude(Range range) throws Exception {
        return this.getFloatData(range, this.varAltitude);
    }

    protected float[] getFloatData(Range range, VarInfo var) throws Exception {
        return this.getFloatData(range, var.getShortName());
    }

    protected String[] getStringData(Range range, VarInfo var) throws Exception {
        return this.getStringData(range, var.getShortName());
    }

    protected abstract float[] getFloatData(Range var1, String var2) throws Exception;

    protected double[] getDoubleData(Range range, String var) throws Exception {
        return Misc.arrayToDouble(this.getFloatData(range, var));
    }

    protected abstract String[] getStringData(Range var1, String var2) throws Exception;

    public synchronized FieldImpl getPointObTrack(Range range) throws Exception {
        Trace.call1("TrackAdapter.getPointObTrack");
        Object loadId = JobManager.getManager().startLoad("TrackAdapter");
        if (range == null) {
            range = this.getFullRange();
        }
        float[] lats = this.getLatitude(range);
        float[] lons = this.getLongitude(range);
        float[] alts = this.getAltitude(range);
        double[] timeVals = this.getTimeVals(range);
        int numObs = lats.length;
        timeVals = CommonUnit.secondsSinceTheEpoch.toThis(timeVals, this.getTimeUnit());
        List<VarInfo> varsToUse = this.getVarsToUse();
        int numReals = this.countReals(varsToUse);
        int numStrings = varsToUse.size() - numReals;
        boolean allReals = numStrings == 0;
        int numVars = varsToUse.size();
        Unit[] units = new Unit[numVars];
        for (int varIdx = 0; varIdx < numVars; ++varIdx) {
            VarInfo var = varsToUse.get(varIdx);
            units[varIdx] = var.getUnit();
        }
        Trace.msg("TrackAdapter #obs: " + this.getNumberPoints() + " vars:" + numVars);
        RealType dirType = Direction.getRealType();
        EarthLocationTuple lastEL = null;
        ArrayList<EarthLocationTuple> locations = new ArrayList<EarthLocationTuple>();
        ArrayList<DateTime> times = new ArrayList<DateTime>();
        ArrayList<Data[]> tuples = new ArrayList<Data[]>();
        ArrayList<double[]> reals = new ArrayList<double[]>();
        ArrayList<String[]> strings = new ArrayList<String[]>();
        ArrayList<Real> bearings = new ArrayList<Real>();
        ArrayList stringTypeList = new ArrayList();
        for (int obIdx = 0; obIdx < numObs; ++obIdx) {
            EarthLocationTuple location = new EarthLocationTuple(new Real(RealType.Latitude, (double)lats[obIdx]), new Real(RealType.Longitude, (double)lons[obIdx]), new Real(RealType.Altitude, (double)alts[obIdx]));
            if (obIdx == 0) {
                lastEL = location;
            }
            locations.add(location);
            double dirVal = Util.calculateBearing(lastEL, location).getAngle();
            lastEL = location;
            Real bearing = new Real(dirType, dirVal);
            bearings.add(bearing);
            times.add(new DateTime(timeVals[obIdx]));
            Data[] tupleArray = allReals ? new Real[numVars + 1] : new Data[numVars + 1];
            tuples.add(tupleArray);
            double[] realArray = new double[numReals + 1];
            reals.add(realArray);
            realArray[realArray.length - 1] = dirVal;
            strings.add(new String[numStrings]);
        }
        Trace.call1("TrackAdapter.reading data");
        boolean doColumnOriented = true;
        if (doColumnOriented) {
            int realCnt = 0;
            int stringCnt = 0;
            for (int varIdx = 0; varIdx < numVars; ++varIdx) {
                if (!JobManager.getManager().canContinue(loadId)) {
                    return null;
                }
                VarInfo var = varsToUse.get(varIdx);
                if (var.getIsNumeric()) {
                    float[] fvalues = this.getFloatData(range, var.getShortName());
                    if (var.getRealType() == null) {
                        // empty if block
                    }
                    Data[] firstTuple = null;
                    for (int obIdx = 0; obIdx < numObs; ++obIdx) {
                        Data[] tupleArray = (Data[])tuples.get(obIdx);
                        ((double[])reals.get((int)obIdx))[realCnt] = fvalues[obIdx];
                        if (firstTuple != null) {
                            tupleArray[varIdx] = ((Real)firstTuple[varIdx]).cloneButValue(fvalues[obIdx]);
                            continue;
                        }
                        firstTuple = tupleArray;
                        tupleArray[varIdx] = var.getUnit() == null ? new Real(var.getRealType(), (double)fvalues[obIdx]) : new Real(var.getRealType(), fvalues[obIdx], var.getUnit());
                    }
                    ++realCnt;
                    continue;
                }
                String[] svalues = this.getStringData(range, var.getShortName());
                for (int obIdx = 0; obIdx < numObs; ++obIdx) {
                    Data[] tupleArray = (Data[])tuples.get(obIdx);
                    tupleArray[varIdx] = new Text(svalues[obIdx]);
                    ((String[])strings.get((int)obIdx))[stringCnt] = svalues[obIdx];
                }
                ++stringCnt;
            }
        }
        Trace.call2("TrackAdapter.reading data");
        Trace.call1("TrackAdapter.processing data", " all reals?" + allReals);
        Data[] obs = new PointObTuple[locations.size()];
        TupleType tt = null;
        RealTupleType rtt = null;
        TupleType finalTT = null;
        for (int obIdx = 0; obIdx < obs.length; ++obIdx) {
            Data[] tupleArray = (Data[])tuples.get(obIdx);
            double[] realArray = (double[])reals.get(obIdx);
            String[] stringArray = (String[])strings.get(obIdx);
            tupleArray[tupleArray.length - 1] = (Data)bearings.get(obIdx);
            if (tt == null) {
                tt = Tuple.buildTupleType(tupleArray);
                if (allReals) {
                    rtt = (RealTupleType)tt;
                }
            }
            Tuple rest = allReals ? new RealTuple(rtt, (Real[])tupleArray, null, units, false) : new Tuple(tt, tupleArray, false, false);
            PointObTuple pot = null;
            if (finalTT == null) {
                pot = new PointObTuple((EarthLocation)locations.get(obIdx), (DateTime)times.get(obIdx), rest);
                finalTT = Tuple.buildTupleType(pot.getComponents());
            } else {
                pot = new PointObTuple((EarthLocation)locations.get(obIdx), (DateTime)times.get(obIdx), rest, finalTT, false);
            }
            obs[obIdx] = pot;
        }
        Trace.call2("TrackAdapter.processing data");
        Integer1DSet indexSet = new Integer1DSet((MathType)RealType.getRealType("index"), numObs);
        FieldImpl retField = new FieldImpl(new FunctionType(((SetType)indexSet.getType()).getDomain(), obs[0].getType()), indexSet);
        retField.setSamples(obs, false, false);
        Trace.call2("TrackAdapter.getPointObTrack");
        return retField;
    }

    protected VarInfo getDataVariable(String variableName) {
        String[] vars = new String[]{variableName, variableName.toLowerCase()};
        for (int dummyIdx = 0; dummyIdx < vars.length; ++dummyIdx) {
            VarInfo theVar;
            int varIdx;
            for (varIdx = 0; varIdx < this.variables.size(); ++varIdx) {
                theVar = (VarInfo)this.variables.get(varIdx);
                if (!vars[dummyIdx].equals(theVar.getName())) continue;
                return theVar;
            }
            for (varIdx = 0; varIdx < this.variables.size(); ++varIdx) {
                theVar = (VarInfo)this.variables.get(varIdx);
                if (!vars[dummyIdx].equals(theVar.getDescription())) continue;
                return theVar;
            }
        }
        throw new IllegalArgumentException("Unknown variable: " + variableName);
    }

    protected RealType getVarType(RealType varToCheck) {
        return this.getVarType(varToCheck, null, Double.NaN);
    }

    public String getTrackName() {
        return this.trackName;
    }

    public void setCoordinateVars(String lon, String lat, String alt, String time) {
        this.varLongitude = lon;
        this.varLatitude = lat;
        this.varAltitude = alt;
        this.varTime = time;
    }

    protected RealType getVarType(RealType varToCheck, Unit unit, double sampleValue) {
        RealType varType = null;
        if (varToCheck.equals(RealType.Altitude)) {
            varType = RealType.getRealType(ALT_TYPE, CommonUnit.meter);
        } else if (varToCheck.equals(RealType.Latitude)) {
            varType = RealType.getRealType(LAT_TYPE, CommonUnits.DEGREE);
        } else if (varToCheck.equals(RealType.Longitude)) {
            varType = RealType.getRealType(LON_TYPE, CommonUnits.DEGREE);
        } else if (varToCheck.equals(RealType.Time)) {
            try {
                Real value = new Real(RealType.Time, sampleValue, unit);
                double sinceEpoch = value.getValue(CommonUnit.secondsSinceTheEpoch);
                int years = (int)(sinceEpoch / 3.1536E7);
                int year = 1970 + years;
                Unit timeUnit = DataUtil.parseUnit("seconds since " + year + "-1-1 0:00:00 0:00");
                varType = RealType.getRealType(DataUtil.cleanName("track_time_" + timeUnit), timeUnit);
            }
            catch (Exception excp) {
                varType = RealType.getRealType(TIME_TYPE, CommonUnit.secondsSinceTheEpoch);
            }
        } else {
            varType = varToCheck;
        }
        return varType;
    }

    protected Range getDataRange() throws Exception {
        return new Range(0, this.getNumberPoints() - 1, 1);
    }

    protected Range getFullRange() throws Exception {
        Range range = this.getDataRange();
        if (this.adapter.getLastNMinutes() > 0) {
            int beginIndex;
            long endTime = (long)this.getStartTime().getValue(CommonUnit.secondsSinceTheEpoch);
            long startTime = endTime - (long)(this.adapter.getLastNMinutes() * 60);
            double[] timeVals = this.getTimeVals(range);
            timeVals = CommonUnit.secondsSinceTheEpoch.toThis(timeVals, this.getTimeUnit());
            for (beginIndex = timeVals.length - 1; beginIndex >= 0 && !((double)startTime > timeVals[beginIndex]); --beginIndex) {
            }
            range = new Range(beginIndex, range.last(), range.stride());
        }
        if (this.adapter.getStride() > 1) {
            range = new Range(range.first(), range.last(), this.adapter.getStride());
        }
        return range;
    }

    protected List<VarInfo> getVarsToUse() {
        ArrayList<VarInfo> varsToUse = new ArrayList<VarInfo>();
        for (int varIdx = 0; varIdx < this.variables.size(); ++varIdx) {
            VarInfo var = (VarInfo)this.variables.get(varIdx);
            if (!this.includeInPointData(var.getShortName())) continue;
            varsToUse.add(var);
        }
        return varsToUse;
    }

    protected int countReals(List vars) {
        int numReals = 0;
        for (int varIdx = 0; varIdx < vars.size(); ++varIdx) {
            VarInfo var = (VarInfo)vars.get(varIdx);
            if (!var.getIsNumeric()) continue;
            ++numReals;
        }
        return numReals;
    }

    public synchronized FlatField getTrack(String variableName, Range range) throws Exception {
        if (range == null) {
            range = this.getFullRange();
        }
        Unit unit = null;
        float[] value = null;
        double[] dvalue = null;
        if (Misc.equals(variableName, this.varTime)) {
            unit = this.getTimeUnit();
            dvalue = this.getTime(range);
        } else {
            VarInfo var = VarInfo.getVarInfo(variableName, this.variables);
            unit = var.getUnit();
            value = this.getFloatData(range, var.getShortName());
        }
        float[][] values = new float[1][];
        double[][] valuesD = new double[1][];
        Set[] rangeSets = null;
        RealType type = DataUtil.makeRealType(variableName, unit);
        if (type == null) {
            throw new VisADException(variableName + " not available");
        }
        if (dvalue == null) {
            values[0] = value;
            rangeSets = null;
        } else {
            valuesD[0] = dvalue;
            rangeSets = new Set[]{new DoubleSet(new SetType(type))};
        }
        FunctionType ftype = new FunctionType(RealTupleType.LatitudeLongitudeAltitude, this.getVarType(type));
        FlatField field = new FlatField(ftype, (Set)this.getSpatialSet(range), (CoordinateSystem)null, rangeSets, new Unit[]{unit});
        if (dvalue == null) {
            field.setSamples(values, false);
        } else {
            field.setSamples(valuesD, false);
        }
        return field;
    }

    protected GriddedSet getSpatialSet(Range range) throws Exception {
        if (this.llaSet == null || range == null || this.lastSpatialSetRange == null || !Misc.equals(this.lastSpatialSetRange, range)) {
            this.llaSet = this.makeEarthDomainSet(range);
        }
        this.lastSpatialSetRange = range;
        return this.llaSet;
    }

    public boolean includeInPointData(String varName) {
        return this.adapter.includeInPointData(varName);
    }

    public Data getAerologicalDiagramData() throws Exception {
        VarInfo pressureVar = null;
        VarInfo tempVar = null;
        VarInfo dewpointVar = null;
        VarInfo wspdVar = null;
        VarInfo wdirVar = null;
        for (int varIdx = 0; varIdx < this.variables.size(); ++varIdx) {
            VarInfo var = (VarInfo)this.variables.get(varIdx);
            String name = var.getShortName();
            String canonical = DataAlias.aliasToCanonical(name);
            if (canonical == null) continue;
            if (canonical.equals("PRESSURE")) {
                pressureVar = var;
                continue;
            }
            if (canonical.equals("TEMP")) {
                tempVar = var;
                continue;
            }
            if (canonical.equals("DEWPOINT")) {
                dewpointVar = var;
                continue;
            }
            if (canonical.equals("SPEED")) {
                wspdVar = var;
                continue;
            }
            if (!canonical.equals("DIR")) continue;
            wdirVar = var;
        }
        String missing = "";
        if (pressureVar == null) {
            missing = missing + "\nPressure";
        }
        if (dewpointVar == null) {
            missing = missing + "\nDewpoint";
        }
        if (wspdVar == null) {
            missing = missing + "\nWind speed";
        }
        if (wdirVar == null) {
            missing = missing + "\nWind direction";
        }
        if (missing.length() > 0) {
            throw new VisADException("Couldn't find all needed variables for aerological diagram:" + missing);
        }
        TupleType addType = new TupleType(new MathType[]{AirPressure.getRealType(), AirTemperature.getRealType(), DewPoint.getRealType(), PolarHorizontalWind.getRealTupleType(), RealTupleType.LatitudeLongitudeAltitude});
        Range range = this.getFullRange();
        FunctionType addFType = new FunctionType(RealType.Time, addType);
        GriddedSet llaSet = this.getSpatialSet(this.getFullRange());
        Unit[] llaUnits = llaSet.getSetUnits();
        Unit tempUnit = tempVar.getUnit();
        Unit dewpointUnit = dewpointVar.getUnit();
        Unit[] addUnits = new Unit[]{pressureVar.getUnit(), Unit.canConvert(tempUnit, CommonUnits.CELSIUS) ? tempUnit : CommonUnits.CELSIUS, Unit.canConvert(dewpointUnit, CommonUnits.CELSIUS) ? dewpointUnit : CommonUnits.CELSIUS, wspdVar.getUnit(), wdirVar.getUnit(), llaUnits[0], llaUnits[1], llaUnits[2]};
        float[][] llaSamples = llaSet.getSamples();
        double[] timeVals = this.getTimeVals(range);
        Gridded1DDoubleSet timeSet = new Gridded1DDoubleSet((MathType)RealType.Time, new double[][]{timeVals}, timeVals.length, (CoordinateSystem)null, new Unit[]{this.getTimeUnit()}, (ErrorEstimate[])null);
        FlatField addField = new FlatField(addFType, (Set)timeSet, (CoordinateSystem[])null, (Set[])null, addUnits);
        addField.setSamples(new float[][]{this.getFloatData(range, pressureVar), this.getFloatData(range, tempVar), this.getFloatData(range, dewpointVar), this.getFloatData(range, wspdVar), this.getFloatData(range, wdirVar), llaSamples[0], llaSamples[1], llaSamples[2]});
        return addField;
    }

    protected RAOB makeRAOB() throws Exception {
        RAOB raob = new RAOB();
        FlatField ff = (FlatField)this.getAerologicalDiagramData();
        float[][] samples = ff.getFloats(true);
        int presIndex = 0;
        int tempIndex = 1;
        int dewpointIndex = 2;
        int wspdIndex = 3;
        int wdirIndex = 4;
        int altIndex = 7;
        RAOB.MandatoryPressureProfile mpp = RAOB.newMandatoryPressureProfile(AirPressure.getRealType().getDefaultUnit(), samples[presIndex], AirTemperature.getRealType().getDefaultUnit(), samples[tempIndex], DewPoint.getRealType().getDefaultUnit(), samples[dewpointIndex], PolarHorizontalWind.getSpeedRealType().getDefaultUnit(), samples[wspdIndex], PolarHorizontalWind.getDirectionRealType().getDefaultUnit(), samples[wdirIndex], DataUtil.parseUnit("gpm"), samples[altIndex]);
        raob.setMandatoryPressureProfile(mpp);
        return raob;
    }
}

