/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.sounding;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import ucar.ma2.Range;
import ucar.unidata.data.CompositeDataChoice;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DirectDataChoice;
import ucar.unidata.data.FilesDataSource;
import ucar.unidata.data.VarInfo;
import ucar.unidata.data.point.PointObFactory;
import ucar.unidata.data.sounding.CdmTrackAdapter;
import ucar.unidata.data.sounding.EolDbTrackAdapter;
import ucar.unidata.data.sounding.RAOB;
import ucar.unidata.data.sounding.SoundingAdapter;
import ucar.unidata.data.sounding.SoundingOb;
import ucar.unidata.data.sounding.SoundingStation;
import ucar.unidata.data.sounding.TrackAdapter;
import ucar.unidata.data.sounding.TrackInfo;
import ucar.unidata.ui.SqlShell;
import ucar.unidata.ui.TwoListPanel;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.util.WrapperException;
import visad.Data;
import visad.DataImpl;
import visad.DateTime;
import visad.FieldImpl;
import visad.FlatField;
import visad.Function;
import visad.FunctionType;
import visad.Gridded1DDoubleSet;
import visad.GriddedSet;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.SingletonSet;
import visad.Tuple;
import visad.VisADException;
import visad.georef.EarthLocationTuple;
import visad.util.DataUtility;

public class TrackDataSource
extends FilesDataSource {
    private static final Object MUTEX = new Object();
    protected List traceCats;
    protected List soundingCats;
    private List raobCats;
    private List pointCats;
    private TrackAdapter traceAdapter;
    private Hashtable pointDataFilter = new Hashtable();
    public static final String ID_SOUNDINGOB = "id.soundingob";
    public static final String ID_SOUNDINGTRACE = "id.soundingtrace";
    public static final String ID_TIMETRACE = "id.timetrace";
    public static final String ID_WHOLETRACE = "id.wholetrace";
    public static final String ID_POINTTRACE = "id.pointtrace";
    public static final String ID_LASTOB = "id.lastob";
    private static String[] DATA_IDS = new String[]{"id.soundingob", "id.soundingtrace", "id.timetrace", "id.pointtrace", "id.lastob"};
    private static String[] DATA_LABELS = new String[]{"Sounding Data", "Skew-T data", "Time Trace", "Point Data", "Last Point"};
    public static final String PROP_TRACKTYPE = "track type";
    private int stride = 1;
    private int lastNMinutes = -1;
    private boolean usingDataBase = false;
    private JTextField strideFld;
    private JTextField lastNMinutesFld;
    private TwoListPanel twoListPanel;
    private boolean haveAskedToSubset = false;
    private SqlShell sqlShell;

    public TrackDataSource() {
    }

    public TrackDataSource(DataSourceDescriptor descriptor, String source, Hashtable properties) throws VisADException {
        this(descriptor, Misc.newList(source), properties);
    }

    public TrackDataSource(DataSourceDescriptor descriptor, List sources, Hashtable properties) throws VisADException {
        this(descriptor, sources, "Track Files", properties);
    }

    public TrackDataSource(DataSourceDescriptor descriptor, List sources, String description, Hashtable properties) throws VisADException {
        super(descriptor, sources, sources.size() > 1 ? description : sources.get(0).toString(), description, properties);
    }

    @Override
    public void doRemove() {
        super.doRemove();
        if (this.sqlShell != null) {
            this.sqlShell.close();
        }
    }

    @Override
    protected void addActions(List actions) {
        super.addActions(actions);
        if (this.traceAdapter != null) {
            this.traceAdapter.addActions(actions);
        }
    }

    public void showSqlShell() {
        if (this.sqlShell == null) {
            this.sqlShell = new SqlShell("Sql Shell - " + this.getName(), ((EolDbTrackAdapter)this.traceAdapter).getConnection());
        }
        this.sqlShell.show();
    }

    @Override
    protected void initAfter() {
        super.initAfter();
        this.getAdapters();
        if (this.getInError()) {
            return;
        }
        if (this.traceAdapter != null && this.traceAdapter.getDataSourceDescription() != null) {
            this.setDescription(this.traceAdapter.getDataSourceDescription());
        }
    }

    @Override
    public void initAfterCreation() {
        super.initAfterCreation();
        if (this.getInError()) {
            return;
        }
        if (this.traceAdapter != null && this.traceAdapter.getDataSourceName() != null) {
            this.setName(this.traceAdapter.getDataSourceName());
        }
    }

    protected void initCategories() {
        if (this.traceCats == null) {
            this.traceCats = DataCategory.parseCategories("Track;trace", true);
            this.soundingCats = Misc.newList(DataCategory.TRACK_SOUNDING_CATEGORY);
            this.raobCats = Misc.newList(DataCategory.RAOB_SOUNDING_CATEGORY);
            this.pointCats = Misc.newList(DataCategory.POINT_PLOT_CATEGORY);
        }
    }

    @Override
    public boolean canSaveDataToLocalDisk() {
        return !this.isFileBased();
    }

    @Override
    public String getFullDescription() {
        List adapters;
        StringBuffer desc = new StringBuffer("Track Data Source<p>");
        this.getAdapters();
        if (this.traceAdapter != null && this.traceAdapter.getDataSourceDescription() != null) {
            desc.append(this.traceAdapter.getDataSourceDescription());
            desc.append("<hr>");
        }
        desc.append("Stride: " + this.stride + "<p>");
        if (this.lastNMinutes > 0) {
            desc.append("Last N Minutes: " + this.lastNMinutes + "<p>");
        }
        if ((adapters = this.getAdapters()) == null) {
            desc.append("No track files<p>\n");
        } else {
            desc.append("Track files:<table><tr><td><b>File</b></td><td><b>Time</b></td></td></tr>\n");
            for (int i = 0; i < adapters.size(); ++i) {
                TrackAdapter adapter = (TrackAdapter)adapters.get(i);
                desc.append("<tr><td>" + adapter.getFilename() + "</td><td>" + adapter.getStartTime() + " -- <br>" + adapter.getEndTime() + "</td></tr>\n");
            }
            desc.append("</table>\n");
        }
        if (this.traceAdapter == null) {
            return desc.toString();
        }
        List<TrackInfo> trackInfos = this.traceAdapter.getTrackInfos();
        for (int trackIdx = 0; trackIdx < trackInfos.size(); ++trackIdx) {
            int total = 0;
            int hidden = 0;
            StringBuffer extra = null;
            TrackInfo trackInfo = trackInfos.get(trackIdx);
            desc.append("<p>");
            if (trackInfos.size() > 1) {
                desc.append(trackInfo.getTrackName() + "<p>");
            }
            try {
                desc.append(" Total observations:" + trackInfo.getNumberPoints() + "<p>\n");
            }
            catch (Exception exception) {
                // empty catch block
            }
            StringBuffer params = new StringBuffer();
            List<VarInfo> vars = trackInfo.getVariables();
            for (VarInfo varInfo : vars) {
                ++total;
                String name = varInfo.getName();
                if (!trackInfo.includeInPointData(name)) {
                    ++hidden;
                    if (extra == null) {
                        extra = new StringBuffer("");
                    }
                    extra.append("<li>" + varInfo.getDescription() + " (" + name + ")\n");
                    continue;
                }
                params.append("<li>" + varInfo.getDescription() + " (" + name + ")\n");
            }
            desc.append("Parameters: ");
            if (hidden != 0) {
                desc.append(total - hidden + "/" + total);
            } else {
                desc.append(total + "");
            }
            desc.append(" <ul>\n");
            desc.append(params.toString());
            desc.append("</ul>\n");
            if (extra == null) continue;
            desc.append("Hidden Parameters: " + hidden + "/" + total + " <ul>\n");
            desc.append(extra.toString());
            desc.append("</ul>");
        }
        return desc.toString();
    }

    protected List getTraceCategories() {
        this.initCategories();
        return this.traceCats;
    }

    protected List getSoundingCategories() {
        this.initCategories();
        return this.soundingCats;
    }

    protected List getRaobCategories() {
        this.initCategories();
        return this.raobCats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initTrack() {
        Object object = MUTEX;
        synchronized (object) {
            if (this.adapters != null && this.adapters.size() > 0) {
                return;
            }
            ArrayList tmp = new ArrayList(this.sources);
            this.sources = new ArrayList();
            for (int i = 0; i < tmp.size(); ++i) {
                String fileOrUrl = tmp.get(i).toString();
                if (fileOrUrl.startsWith("jdbc:")) {
                    this.usingDataBase = true;
                    this.sources.add(fileOrUrl);
                    continue;
                }
                if (new File(fileOrUrl).exists()) {
                    this.sources.add(fileOrUrl);
                    continue;
                }
                try {
                    new URL(fileOrUrl);
                    this.sources.add(fileOrUrl);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.traceAdapter = null;
            this.adapters = new ArrayList();
            if (this.sources.size() == 0) {
                this.sources = tmp;
                return;
            }
            String file = "";
            this.flushCache();
            ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
            ArrayList<String> messages = new ArrayList<String>();
            for (int i = 0; i < this.sources.size(); ++i) {
                try {
                    file = (String)this.sources.get(i);
                    TrackAdapter adapter = this.doMakeAdapter(file, this.pointDataFilter, this.stride, this.lastNMinutes);
                    if (this.traceAdapter == null) {
                        this.traceAdapter = adapter;
                    }
                    this.adapters.add(adapter);
                    continue;
                }
                catch (Throwable e) {
                    exceptions.add(e);
                    messages.add("Problem opening file:" + file + " " + e);
                }
            }
            if (exceptions.size() > 0) {
                LogUtil.printExceptions(messages, exceptions);
                if (this.sources.size() == exceptions.size()) {
                    this.setInError(true, false, null);
                }
            }
        }
    }

    protected TrackAdapter doMakeAdapter(String file, Hashtable pointDataFilter, int stride, int lastNMinutes) throws Exception {
        if (file.startsWith("jdbc:")) {
            this.usingDataBase = true;
            return new EolDbTrackAdapter(this, file, pointDataFilter, stride, lastNMinutes);
        }
        return new CdmTrackAdapter(this, file, pointDataFilter, stride, lastNMinutes);
    }

    public List getAdapters() {
        if (this.adapters == null || this.adapters.size() == 0) {
            this.initTrack();
        }
        if (this.adapters.size() == 0) {
            this.adapters = null;
        }
        return this.adapters;
    }

    @Override
    protected void doMakeDataChoices() {
        List adapters = this.getAdapters();
        if (adapters == null) {
            return;
        }
        this.initCategories();
        List<TrackInfo> trackInfos = this.traceAdapter.getTrackInfos();
        List categories = this.traceCats;
        for (int trackIdx = 0; trackIdx < trackInfos.size(); ++trackIdx) {
            TrackInfo trackInfo = trackInfos.get(trackIdx);
            List<VarInfo> vars = trackInfo.getVariables();
            String trackName = trackInfo.getTrackName();
            Object basicCat = null;
            if (trackInfos.size() > 1) {
                categories = DataCategory.parseCategories(trackName + "-Tracks" + ";trace", true);
            }
            Hashtable props = Misc.newHashtable("prop.icon", "/auxdata/ui/icons/TrajectoryData16.gif");
            for (VarInfo varInfo : vars) {
                List cats = categories;
                if (varInfo.getCategory() != null) {
                    String cat = StringUtil.replace(varInfo.getCategory(), "-", " ");
                    cats = DataCategory.parseCategories("Track-" + cat + ";trace", true);
                }
                DirectDataChoice ddc = new DirectDataChoice((DataSource)this, (Object)new String[]{trackName, varInfo.getName()}, varInfo.getName(), varInfo.getDescription(), cats, props);
                this.addDataChoice(ddc);
            }
            List pointCatList = this.pointCats;
            if (trackInfos.size() > 1) {
                pointCatList = DataCategory.parseCategories(trackName + ";" + DataCategory.POINT_PLOT_CATEGORY, true);
            }
            props = Misc.newHashtable("prop.icon", "/auxdata/ui/icons/Placemark16.gif");
            String pointLabel = this.getDataChoiceLabel(ID_POINTTRACE);
            this.addDataChoice(new DirectDataChoice((DataSource)this, (Object)new String[]{trackName, ID_POINTTRACE}, pointLabel, pointLabel, pointCatList, props));
        }
    }

    protected boolean canDoView() {
        return true;
    }

    private String getDataChoiceId(Object id) {
        for (int i = 0; i < DATA_IDS.length; ++i) {
            if (!Misc.equals(id, DATA_IDS[i]) && !Misc.equals(id, DATA_LABELS[i])) continue;
            return DATA_IDS[i];
        }
        return id.toString();
    }

    protected String getDataChoiceLabel(Object id) {
        for (int i = 0; i < DATA_IDS.length; ++i) {
            if (!Misc.equals(id, DATA_IDS[i])) continue;
            return DATA_LABELS[i];
        }
        return id.toString();
    }

    @Override
    protected Data getDataInner(DataChoice dataChoice, DataCategory category, DataSelection dataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        Data retData = null;
        try {
            String id = this.getChoiceId(dataChoice);
            if (id.equals(ID_SOUNDINGTRACE)) {
                retData = this.getSoundingTrace(dataChoice, dataSelection);
            } else if (id.equals(ID_SOUNDINGOB)) {
                retData = this.getSoundingObs(dataChoice, dataSelection);
            } else if (id.equals(ID_POINTTRACE)) {
                if (!this.getHaveAskedToSubset()) {
                    if ((this.pointDataFilter == null || this.pointDataFilter.isEmpty()) && GuiUtils.askYesNo("Subset Data", "<html>It is recommended that you subset the point data.<br>Do you want to subset the point data?</html>") && !this.showPropertiesDialog("Subset Point Data", true)) {
                        return null;
                    }
                    this.setHaveAskedToSubset(true);
                }
                retData = this.getPointObTrack(dataChoice, dataSelection, null);
            } else if (id.equals(ID_LASTOB)) {
                retData = this.getLastPointOb(dataChoice, dataSelection);
            } else {
                String id0 = this.getChoiceId0(dataChoice);
                List tracks = this.getTracks(dataChoice, dataSelection, requestProperties);
                if (tracks != null && tracks.size() > 0) {
                    retData = this.aggregateTracks(tracks, id0);
                }
            }
        }
        catch (Exception exc) {
            throw new WrapperException(exc);
        }
        if (retData == null) {
            // empty if block
        }
        return retData;
    }

    protected DateTime getBaseTime() {
        DateTime[] minMax = this.getMinMaxTime();
        if (minMax == null) {
            return null;
        }
        return minMax[1];
    }

    protected DateTime[] getMinMaxTime() {
        List adapters = this.getAdapters();
        if (adapters == null) {
            try {
                return new DateTime[]{new DateTime(), new DateTime()};
            }
            catch (Exception exc) {
                this.logException("Create null datetimes", exc);
                return null;
            }
        }
        DateTime startTime = null;
        DateTime endTime = null;
        for (int i = 0; i < adapters.size(); ++i) {
            TrackAdapter adapter = (TrackAdapter)this.getAdapters().get(i);
            DateTime theTime = adapter.getEndTime();
            if (endTime == null || theTime.getValue() > endTime.getValue()) {
                endTime = theTime;
            }
            if (startTime != null && !(theTime.getValue() > startTime.getValue())) continue;
            startTime = theTime;
        }
        return new DateTime[]{startTime, endTime};
    }

    protected FieldImpl aggregateTracks(List tracks, Object id) throws VisADException, RemoteException {
        FlatField mergedTracks = this.mergeTracks(tracks);
        FunctionType fiType = new FunctionType(RealType.Time, mergedTracks.getType());
        DateTime endTime = this.getBaseTime();
        FieldImpl fi = new FieldImpl(fiType, new SingletonSet(new RealTuple(new Real[]{endTime})));
        fi.setSample(0, (Data)mergedTracks, false);
        return fi;
    }

    @Override
    protected List doMakeDateTimes() {
        DateTime baseTime = this.getBaseTime();
        if (baseTime == null) {
            return new ArrayList();
        }
        return Misc.newList(baseTime);
    }

    private String[] getIdArray(DataChoice dc) {
        String[] id = dc.getId();
        if (id instanceof String) {
            id = new String[]{null, id.toString()};
        }
        return id;
    }

    protected List getTracks(DataChoice dc, DataSelection dataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        try {
            boolean withTimes = false;
            if (requestProperties != null) {
                withTimes = ID_TIMETRACE.equals(requestProperties.get(PROP_TRACKTYPE));
            }
            ArrayList<FlatField> tracks = new ArrayList<FlatField>();
            List adapters = this.getAdapters();
            if (adapters == null) {
                return tracks;
            }
            String[] idArray = this.getIdArray(dc);
            for (int i = 0; i < adapters.size(); ++i) {
                FlatField data = null;
                data = withTimes ? ((TrackAdapter)adapters.get(i)).getTrackWithTime(idArray[0], idArray[1], null) : ((TrackAdapter)adapters.get(i)).getTrack(idArray[0], idArray[1], null);
                if (data == null) {
                    return null;
                }
                tracks.add(data);
            }
            return tracks;
        }
        catch (Exception exc) {
            LogUtil.logException("Could not read data", exc);
            return null;
        }
    }

    protected FlatField getTrack(DataChoice dc, DataSelection dataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        List datas = this.getTracks(dc, dataSelection, requestProperties);
        if (datas == null) {
            return null;
        }
        return this.mergeTracks(datas);
    }

    protected FieldImpl getLastPointOb(DataChoice dc, DataSelection dataSelection) throws Exception {
        List adapters = this.getAdapters();
        if (adapters == null) {
            return null;
        }
        Range lastRange = ((TrackAdapter)adapters.get(0)).getLastPointRange(this.getTrackId(dc));
        return this.getPointObTrack(dc, dataSelection, lastRange);
    }

    protected FieldImpl getPointObTrack(DataChoice dc, DataSelection dataSelection, Range range) throws VisADException, RemoteException {
        List adapters = this.getAdapters();
        if (adapters == null) {
            return null;
        }
        FieldImpl retField = null;
        try {
            ArrayList<FieldImpl> datas = new ArrayList<FieldImpl>(adapters.size());
            for (int i = 0; i < adapters.size(); ++i) {
                TrackAdapter adapter = (TrackAdapter)adapters.get(i);
                FieldImpl data = adapter.getPointObTrack(this.getTrackId(dc), range);
                if (data == null) {
                    return null;
                }
                datas.add(data);
            }
            retField = PointObFactory.mergeData(datas);
        }
        catch (Exception exc) {
            this.logException("Creating track obs", exc);
        }
        return retField;
    }

    protected Data getSoundingTrace(DataChoice dc, DataSelection dataSelection) throws Exception {
        if (this.traceAdapter == null && this.adapters != null) {
            if (this.adapters.size() > 0) {
                this.traceAdapter = (TrackAdapter)this.adapters.get(0);
            }
        } else if (this.adapters == null) {
            this.initTrack();
            this.traceAdapter = (TrackAdapter)this.adapters.get(0);
        }
        return this.traceAdapter.getAerologicalDiagramData(this.getTrackId(dc));
    }

    public TrackAdapter getTraceAdapter() throws Exception {
        return this.traceAdapter;
    }

    public void setTraceAdapter(TrackAdapter traceAdapter) throws Exception {
        this.traceAdapter = traceAdapter;
    }

    protected String getChoiceId(DataChoice dc) {
        String[] idArray = this.getIdArray(dc);
        return idArray[1];
    }

    protected String getChoiceId0(DataChoice dc) {
        String[] idArray = this.getIdArray(dc);
        return idArray[0];
    }

    protected String getTrackId(DataChoice dc) {
        String[] idArray = this.getIdArray(dc);
        return idArray[0];
    }

    private Data getSoundingObs(DataChoice dataChoice, DataSelection subset) throws VisADException, RemoteException {
        Vector<Data> v = new Vector<Data>();
        List<DataChoice> choices = dataChoice instanceof CompositeDataChoice ? ((CompositeDataChoice)dataChoice).getDataChoices() : Arrays.asList(dataChoice);
        Iterator iter = choices.iterator();
        while (iter.hasNext()) {
            Data ob = this.getSoundingOb((DataChoice)iter.next(), subset);
            if (ob == null) continue;
            v.add(ob);
        }
        return v.isEmpty() ? null : new Tuple(v.toArray(new Data[v.size()]), false);
    }

    protected Data getSoundingOb(DataChoice dc, DataSelection dataSelection) throws VisADException, RemoteException {
        SoundingOb so = ((SoundingAdapter)((Object)this.traceAdapter)).getSoundingObs()[0];
        RAOB raob = so.getRAOB();
        SoundingStation ss = so.getStation();
        Tuple data = new Tuple(new Data[]{so.getTimestamp(), new EarthLocationTuple(ss.getLatitude(), ss.getLongitude(), ss.getAltitude().getValue()), raob.getTemperatureProfile(), raob.getDewPointProfile()});
        return data;
    }

    @Override
    public void setName(String value) {
        super.setName(value);
        if (this.sources == null) {
            this.sources = Misc.newList(this.getName());
        }
    }

    public static void main(String[] args) throws Exception {
    }

    public FlatField mergeTracks(List datas) throws VisADException {
        if (datas.isEmpty()) {
            return null;
        }
        if (datas.size() == 1) {
            return (FlatField)datas.get(0);
        }
        FlatField retField = null;
        try {
            int numObs = 0;
            GriddedSet domainSet = null;
            DataImpl ff = null;
            for (int i = 0; i < datas.size(); ++i) {
                ff = (FlatField)datas.get(i);
                domainSet = (GriddedSet)((FieldImpl)ff).getDomainSet();
                numObs += domainSet.getLength();
            }
            FunctionType retType = (FunctionType)ff.getType();
            RealTupleType rtt = DataUtility.getFlatRangeType((Function)((Object)ff));
            double[][] domainVals = new double[domainSet.getDimension()][numObs];
            float[][] values = new float[rtt.getDimension()][numObs];
            int curPos = 0;
            for (int i = 0; i < datas.size(); ++i) {
                int j;
                FlatField data = (FlatField)datas.get(i);
                GriddedSet dset = (GriddedSet)data.getDomainSet();
                double[][] samples = dset.getDoubles(false);
                int length = dset.getLength();
                float[][] vals = data.getFloats(false);
                for (j = 0; j < samples.length; ++j) {
                    System.arraycopy(samples[j], 0, domainVals[j], curPos, length);
                }
                for (j = 0; j < vals.length; ++j) {
                    System.arraycopy(vals[j], 0, values[j], curPos, length);
                }
                curPos += length;
            }
            GriddedSet newDomain = null;
            newDomain = domainSet instanceof Gridded1DDoubleSet ? new Gridded1DDoubleSet(domainSet.getType(), domainVals, numObs, domainSet.getCoordinateSystem(), domainSet.getSetUnits(), domainSet.getSetErrors()) : GriddedSet.create(domainSet.getType(), Set.doubleToFloat(domainVals), new int[]{numObs}, domainSet.getCoordinateSystem(), domainSet.getSetUnits(), domainSet.getSetErrors());
            retField = new FlatField(retType, newDomain);
            retField.setSamples(values, false);
        }
        catch (RemoteException re) {
            throw new VisADException("got RemoteException " + re);
        }
        return retField;
    }

    public void setPointDataFilter(Hashtable value) {
        this.pointDataFilter = value;
    }

    public Hashtable getPointDataFilter() {
        return this.pointDataFilter;
    }

    @Override
    public void getPropertiesComponents(List comps) {
        super.getPropertiesComponents(comps);
        if (this.usingDataBase) {
            comps.add(GuiUtils.filler());
            comps.add(this.getPropertiesHeader("Database"));
        }
        this.strideFld = new JTextField("" + this.stride, 5);
        this.lastNMinutesFld = new JTextField("" + (this.lastNMinutes > 0 ? "" + this.lastNMinutes : "all"), 5);
        comps.add(GuiUtils.filler());
        comps.add(this.getPropertiesHeader("Time Subsetting"));
        comps.add(GuiUtils.rLabel("Use Every: "));
        comps.add(GuiUtils.left(GuiUtils.hbox((Component)this.strideFld, (Component)GuiUtils.lLabel(" Time Steps  "), GuiUtils.makeButton("Reset", this, "resetStrideFld"))));
        comps.add(GuiUtils.rLabel("Use Last: "));
        comps.add(GuiUtils.left(GuiUtils.hbox((Component)this.lastNMinutesFld, (Component)GuiUtils.lLabel(" Minutes  "), GuiUtils.makeButton("Reset", this, "resetLastNMinutesFld"))));
    }

    public void resetLastNMinutesFld() {
        if (this.lastNMinutesFld != null) {
            this.lastNMinutesFld.setText("all");
        }
    }

    public void resetStrideFld() {
        if (this.strideFld != null) {
            this.strideFld.setText("1");
        }
    }

    @Override
    public boolean applyProperties() {
        int i;
        if (!super.applyProperties()) {
            return false;
        }
        if (this.traceAdapter == null) {
            return true;
        }
        String what = "stride";
        String text = "";
        try {
            text = this.strideFld.getText().trim();
            this.setStride(new Integer(text));
            List adapters = this.getAdapters();
            if (adapters != null) {
                for (i = 0; i < adapters.size(); ++i) {
                    ((TrackAdapter)adapters.get(i)).setStride(this.stride);
                }
            }
            what = "last n minutes";
            text = this.lastNMinutesFld.getText().trim();
            if (text.equals("all") || text.length() == 0) {
                this.setLastNMinutes(-1);
            } else {
                this.setLastNMinutes(new Integer(text));
            }
        }
        catch (NumberFormatException nfe) {
            LogUtil.userErrorMessage("Bad " + what + " value:" + text);
            return false;
        }
        this.flushCache();
        if (this.twoListPanel != null) {
            List current = TwoFacedObject.getIdStrings(this.twoListPanel.getCurrentEntries());
            this.pointDataFilter.clear();
            for (i = 0; i < current.size(); ++i) {
                this.pointDataFilter.put(current.get(i), current.get(i));
            }
        }
        return true;
    }

    @Override
    public void addPropertiesTabs(JTabbedPane tabbedPane) {
        super.addPropertiesTabs(tabbedPane);
        if (this.traceAdapter == null) {
            return;
        }
        List<TrackInfo> trackInfos = this.traceAdapter.getTrackInfos();
        if (trackInfos.size() == 0) {
            return;
        }
        this.twoListPanel = new TwoListPanel(new ArrayList(), "All Fields", new ArrayList(), "Current Fields", null);
        TrackInfo trackInfo = trackInfos.get(0);
        List<VarInfo> vars = trackInfo.getVariables();
        HashSet<String> skipVars = new HashSet<String>();
        skipVars.add("time");
        skipVars.add("latitude");
        skipVars.add("longitude");
        skipVars.add("altitude");
        ArrayList<String> labels = new ArrayList<String>();
        ArrayList<String> ids = new ArrayList<String>();
        Hashtable<String, String> currentMap = new Hashtable<String, String>();
        for (VarInfo varInfo : vars) {
            String name = varInfo.getName();
            if (skipVars.contains(name.toLowerCase())) continue;
            labels.add(varInfo.getDescription() + "  (" + varInfo.getName() + ")");
            ids.add(varInfo.getName());
            if (!this.traceAdapter.includeInPointData(varInfo.getName())) continue;
            currentMap.put(varInfo.getName(), varInfo.getName());
        }
        JComponent contents = this.twoListPanel.getContents("Select fields to show", labels, ids, currentMap);
        tabbedPane.add("Subset Point Data", contents);
    }

    public void setStride(int value) {
        this.stride = value;
    }

    public int getStride() {
        return this.stride;
    }

    public void setHaveAskedToSubset(boolean value) {
        this.haveAskedToSubset = value;
    }

    public boolean getHaveAskedToSubset() {
        return this.haveAskedToSubset;
    }

    public void setLastNMinutes(int value) {
        this.lastNMinutes = value;
        List adapters = this.getAdapters();
        if (adapters != null) {
            for (int i = 0; i < adapters.size(); ++i) {
                ((TrackAdapter)adapters.get(i)).setLastNMinutes(value);
            }
        }
    }

    public int getLastNMinutes() {
        return this.lastNMinutes;
    }
}

