/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.sounding;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import ucar.ma2.Range;
import ucar.unidata.data.sounding.RAOB;
import ucar.unidata.data.sounding.SoundingOb;
import ucar.unidata.data.sounding.TrackDataSource;
import ucar.unidata.data.sounding.TrackInfo;
import visad.CommonUnit;
import visad.Data;
import visad.DateTime;
import visad.FieldImpl;
import visad.FlatField;

public abstract class TrackAdapter {
    DateTime startTime;
    DateTime endTime;
    SoundingOb soundingOb = null;
    TrackDataSource dataSource;
    private List<TrackInfo> trackInfos = new ArrayList<TrackInfo>();
    private Hashtable pointDataFilter;
    int stride = 1;
    int lastNMinutes = -1;
    private String filename;

    public TrackAdapter() throws Exception {
    }

    public TrackAdapter(TrackDataSource dataSource, String filename) throws Exception {
        this(dataSource, filename, null, 1, -1);
    }

    public TrackAdapter(TrackDataSource dataSource, String filename, Hashtable pointDataFilter, int stride, int lastNMinutes) throws Exception {
        this.dataSource = dataSource;
        this.filename = filename;
        this.stride = stride;
        this.lastNMinutes = lastNMinutes;
        this.pointDataFilter = pointDataFilter;
    }

    protected void addActions(List actions) {
    }

    protected void addTrackInfo(TrackInfo trackInfo) throws Exception {
        this.trackInfos.add(trackInfo);
        if (this.startTime == null || trackInfo.getStartTime().getValue(CommonUnit.secondsSinceTheEpoch) < this.startTime.getValue(CommonUnit.secondsSinceTheEpoch)) {
            this.startTime = trackInfo.getStartTime();
        }
        if (this.endTime == null || trackInfo.getEndTime().getValue(CommonUnit.secondsSinceTheEpoch) > this.endTime.getValue(CommonUnit.secondsSinceTheEpoch)) {
            this.endTime = trackInfo.getEndTime();
        }
    }

    public List<TrackInfo> getTrackInfos() {
        return this.trackInfos;
    }

    public TrackInfo getTrackInfo(String name) {
        for (TrackInfo trackInfo : this.trackInfos) {
            if (name != null && !name.equals(trackInfo.getTrackName())) continue;
            return trackInfo;
        }
        for (TrackInfo trackInfo : this.trackInfos) {
            int i = Math.min(trackInfo.getTrackName().length(), 20);
            if (!name.startsWith(trackInfo.getTrackName().substring(0, i))) continue;
            return trackInfo;
        }
        throw new IllegalArgumentException("Unknown track:" + name);
    }

    public FlatField getTrackWithTime(String trackId, String variable, Range range) throws Exception {
        return this.getTrackInfo(trackId).getTrackWithTime(variable, range);
    }

    public Range getLastPointRange(String trackId) throws Exception {
        int cnt = this.getNumObservations(trackId);
        return new Range(cnt - 1, cnt - 1);
    }

    public int getNumObservations(String trackId) throws Exception {
        return this.getTrackInfo(trackId).getNumberPoints();
    }

    public FieldImpl getPointObTrack(String trackId, Range range) throws Exception {
        return this.getTrackInfo(trackId).getPointObTrack(range);
    }

    public FlatField getTrack(String trackId, String variable, Range range) throws Exception {
        return this.getTrackInfo(trackId).getTrack(variable, range);
    }

    public Data getAerologicalDiagramData(String trackId) throws Exception {
        return this.getTrackInfo(trackId).getAerologicalDiagramData();
    }

    private RAOB makeRAOB(String trackId) throws Exception {
        return this.getTrackInfo(trackId).makeRAOB();
    }

    private SoundingOb getSoundingOb() {
        return null;
    }

    public DateTime getBaseTime() {
        return this.getStartTime();
    }

    public DateTime getStartTime() {
        return this.startTime;
    }

    public DateTime getEndTime() {
        return this.endTime;
    }

    public void setStride(int value) {
        this.stride = value;
    }

    public int getStride() {
        return this.stride;
    }

    public void setLastNMinutes(int value) {
        this.lastNMinutes = value;
    }

    public int getLastNMinutes() {
        return this.lastNMinutes;
    }

    public boolean includeInPointData(String varName) {
        if (this.pointDataFilter == null || this.pointDataFilter.size() == 0) {
            return true;
        }
        return this.pointDataFilter.get(varName) != null;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getDataSourceName() {
        return null;
    }

    public String getDataSourceDescription() {
        return null;
    }

    public String toString() {
        return this.filename;
    }
}

