/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.sounding;

import ucar.unidata.data.sounding.RAOB;
import ucar.unidata.data.sounding.SoundingStation;
import ucar.unidata.util.Misc;
import visad.DateTime;

public class SoundingOb {
    private String mandatoryFile;
    private String sigFile;
    private SoundingStation station_;
    private DateTime timestamp_;
    private RAOB raob_;

    public SoundingOb() {
    }

    public SoundingOb(SoundingStation station, DateTime timestamp) {
        this(station, timestamp, null);
    }

    public SoundingOb(SoundingStation station, DateTime timestamp, RAOB raob) {
        this.station_ = station;
        this.timestamp_ = timestamp;
        this.raob_ = raob;
    }

    public SoundingStation getStation() {
        return this.station_;
    }

    public void setStation(SoundingStation s) {
        this.station_ = s;
    }

    public String getStationIdentifier() {
        return this.station_.getIdentifier();
    }

    public boolean hasData() {
        return !this.getRAOB().getTemperatureProfile().isMissing() || !this.getRAOB().getDewPointProfile().isMissing() || !this.getRAOB().getWindProfile().isMissing();
    }

    public RAOB getRAOB() {
        if (this.raob_ == null) {
            try {
                this.raob_ = new RAOB();
            }
            catch (Exception ve) {
                throw new IllegalStateException("Error creating RAOB:" + ve);
            }
        }
        return this.raob_;
    }

    protected void setRAOB(RAOB r) {
        this.raob_ = r;
    }

    public DateTime getTimestamp() {
        return this.timestamp_;
    }

    public void setTimestamp(DateTime d) {
        this.timestamp_ = d;
    }

    public String toString() {
        return this.station_.toString() + " " + this.timestamp_.toString() + " " + (this.raob_ != null ? this.raob_.toString() : "");
    }

    public String getLabel() {
        return this.station_.toString() + " " + this.timestamp_.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof SoundingOb)) {
            return false;
        }
        SoundingOb that = (SoundingOb)other;
        return Misc.equals(this.station_, that.station_) && Misc.equals(this.timestamp_, that.timestamp_);
    }

    public void setMandatoryFile(String value) {
        this.mandatoryFile = value;
    }

    public String getMandatoryFile() {
        return this.mandatoryFile;
    }

    public void setSigFile(String value) {
        this.sigFile = value;
    }

    public String getSigFile() {
        return this.sigFile;
    }
}

