/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.sounding;

import java.util.ArrayList;
import java.util.List;
import ucar.unidata.beans.InvisiblePropertiedBean;
import ucar.unidata.data.sounding.SoundingAdapter;
import ucar.unidata.data.sounding.SoundingOb;
import ucar.unidata.data.sounding.SoundingStation;
import ucar.unidata.util.Defaults;
import visad.DateTime;

public abstract class SoundingAdapterImpl
extends InvisiblePropertiedBean {
    protected boolean haveInitialized = false;
    protected boolean debug = false;
    protected Defaults defaults = null;
    protected List<SoundingStation> stations;
    protected List<SoundingOb> soundings;
    protected List<DateTime> times;

    public SoundingAdapterImpl(String name) {
        super(name);
    }

    protected void init() throws Exception {
        this.haveInitialized = true;
    }

    protected void checkInit() {
        try {
            this.init();
        }
        catch (Exception exc) {
            throw new IllegalStateException("Error initializing: " + exc);
        }
    }

    protected String getDflt(String prefix, String name, String dflt) {
        String key;
        String sysProp;
        if (this.defaults == null) {
            this.defaults = Defaults.initialize(SoundingAdapter.class.getResource("Soundings.defaults"));
        }
        if (!(sysProp = System.getProperty(key = prefix + name, dflt)).equals(dflt)) {
            return sysProp;
        }
        return Defaults.getDefault(prefix + name, dflt);
    }

    protected void dbPrint(String s) {
        if (this.debug) {
            System.err.println(s);
        }
    }

    public List<SoundingStation> getStations() {
        this.checkInit();
        ArrayList<SoundingStation> stnList = new ArrayList();
        if (this.stations != null) {
            stnList = new ArrayList<SoundingStation>(this.stations);
        }
        this.dbPrint(stnList.size() + " stations");
        return stnList;
    }

    public List<SoundingStation> getStations(DateTime time) {
        this.checkInit();
        ArrayList<SoundingStation> stnList = new ArrayList<SoundingStation>();
        if (this.stations != null) {
            for (SoundingOb snd : this.soundings) {
                DateTime e = snd.getTimestamp();
                if (!time.equals(e)) continue;
                stnList.add(snd.getStation());
            }
        }
        this.dbPrint(stnList.size() + " stations at " + time);
        return stnList;
    }

    public abstract SoundingOb initSoundingOb(SoundingOb var1);

    public SoundingOb getSoundingOb(SoundingStation station) {
        this.checkInit();
        if (this.soundings != null) {
            for (int i = 0; i < this.soundings.size(); ++i) {
                SoundingOb snd = this.soundings.get(i);
                SoundingStation sta = snd.getStation();
                if (!sta.equals(station)) continue;
                return this.initSoundingOb(snd);
            }
        }
        return null;
    }

    public SoundingOb[] getSoundingObs() {
        this.checkInit();
        if (this.soundings != null && !this.soundings.isEmpty()) {
            SoundingOb[] returns = new SoundingOb[this.soundings.size()];
            for (int i = 0; i < this.soundings.size(); ++i) {
                returns[i] = this.initSoundingOb(this.soundings.get(i));
            }
            return returns;
        }
        return null;
    }

    public DateTime[] getSoundingTimes() {
        this.checkInit();
        return this.times == null ? (DateTime[])null : this.times.toArray(new DateTime[this.times.size()]);
    }

    public List<DateTime> getSoundingTimes(SoundingStation station) {
        this.checkInit();
        ArrayList<DateTime> timesList = new ArrayList<DateTime>();
        if (this.soundings != null) {
            for (SoundingOb snd : this.soundings) {
                SoundingStation sta = snd.getStation();
                if (!sta.equals(station)) continue;
                timesList.add(snd.getTimestamp());
            }
        }
        this.dbPrint(timesList.size() + " times for " + station);
        return timesList;
    }
}

