/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.sounding;

import java.io.File;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import ucar.ma2.Range;
import ucar.nc2.ft.TrajectoryFeature;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DirectDataChoice;
import ucar.unidata.data.sounding.CdmTrackInfo;
import ucar.unidata.data.sounding.TrackAdapter;
import ucar.unidata.data.sounding.TrackDataSource;
import ucar.unidata.data.sounding.TrackInfo;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.Util;
import ucar.visad.data.CalendarDateTime;
import visad.Data;
import visad.DateTime;
import visad.FieldImpl;
import visad.FunctionType;
import visad.RealType;
import visad.Text;
import visad.VisADException;

public class SondeDataSource
extends TrackDataSource {
    public static final String ID_SONDELOCATIONS = "id.sondelocations";
    public static final String ID_SONDESTARTLOCATIONS = "id.sondestartlocations";
    private static final String ID_SONDEENDLOCATIONS = "id.sondeendlocations";

    public SondeDataSource() {
    }

    public SondeDataSource(DataSourceDescriptor descriptor, String source, Hashtable properties) throws VisADException {
        this(descriptor, Misc.newList(source), properties);
    }

    public SondeDataSource(DataSourceDescriptor descriptor, List sources, Hashtable properties) throws VisADException {
        super(descriptor, sources, properties);
        this.setDescription("Sonde Data Source");
    }

    @Override
    protected DateTime getBaseTime() {
        DateTime[] minMax = this.getMinMaxTime();
        if (minMax == null) {
            return null;
        }
        return minMax[0];
    }

    protected FieldImpl HIDEaggregateTracks(List tracks) throws VisADException, RemoteException {
        List adapters = this.getAdapters();
        FunctionType fiType = null;
        DateTime[] times = new DateTime[tracks.size()];
        for (int i = 0; i < tracks.size(); ++i) {
            TrackAdapter adapter = (TrackAdapter)adapters.get(i);
            DateTime time = adapter.getEndTime();
            if (fiType == null) {
                FieldImpl data = (FieldImpl)tracks.get(i);
                fiType = new FunctionType(RealType.Time, data.getType());
            }
            times[i] = adapter.getStartTime();
        }
        FieldImpl fi = new FieldImpl(fiType, CalendarDateTime.makeTimeSet(times));
        for (int i = 0; i < tracks.size(); ++i) {
            FieldImpl data = (FieldImpl)tracks.get(i);
            fi.setSample(i, (Data)data, false);
        }
        return fi;
    }

    @Override
    protected void doMakeDataChoices() {
        List sources = this.getSources();
        if (sources.size() == 0) {
            return;
        }
        String source = sources.get(0).toString();
        File f = new File(source);
        if (f.isDirectory()) {
            return;
        }
        super.doMakeDataChoices();
        this.addDataChoice(new DirectDataChoice(this, (Object)"id.soundingtrace", this.getDataChoiceLabel("id.soundingtrace"), this.getDataChoiceLabel("id.soundingtrace"), this.getSoundingCategories()));
        List locCats = DataCategory.parseCategories("locations", false);
        this.addDataChoice(new DirectDataChoice(this, (Object)ID_SONDESTARTLOCATIONS, "Sonde Start Locations", "Sonde Start Locations", locCats));
    }

    @Override
    protected Data getDataInner(DataChoice dataChoice, DataCategory category, DataSelection dataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        String id = this.getChoiceId(dataChoice);
        if (id.equals(ID_SONDELOCATIONS) || id.equals(ID_SONDESTARTLOCATIONS) || id.equals(ID_SONDEENDLOCATIONS)) {
            List adapters = this.getAdapters();
            String name = id.equals(ID_SONDEENDLOCATIONS) ? "Sonde End Locations" : "Sonde Start Locations";
            StringBuffer xml = new StringBuffer("<stationtable name=\"" + name + "\">\n");
            if (adapters != null) {
                for (int i = 0; i < adapters.size(); ++i) {
                    TrackAdapter adapter = (TrackAdapter)adapters.get(i);
                    List<TrackInfo> infos = adapter.getTrackInfos();
                    if (infos.size() == 0) continue;
                    TrackInfo trackInfo = infos.get(0);
                    TrajectoryFeature todt = ((CdmTrackInfo)trackInfo).getTodt();
                    int numObs = 0;
                    try {
                        boolean ascendingTimes;
                        numObs = trackInfo.getNumberPoints();
                        double[] times = trackInfo.getTimeVals(trackInfo.getFullRange());
                        boolean bl = ascendingTimes = times[0] < times[times.length - 1];
                        int rVal = id.equals(ID_SONDEENDLOCATIONS) ? (ascendingTimes ? times.length - 1 : 0) : (ascendingTimes ? 0 : times.length - 1);
                        Range r = new Range(rVal, rVal);
                        Date trueStartDate = trackInfo.startTime.getValue() > trackInfo.endTime.getValue() ? Util.makeDate(trackInfo.endTime) : Util.makeDate(trackInfo.startTime);
                        String time = new DateTime(trueStartDate).formattedString("HH:mm", DateTime.DEFAULT_TIMEZONE);
                        xml.append("<station " + XmlUtil.attr("id", time) + XmlUtil.attr("name", IOUtil.getFileTail(adapter.getFilename())) + XmlUtil.attr("lat", "" + trackInfo.getLatitude(r)[0]) + XmlUtil.attr("lon", "" + trackInfo.getLongitude(r)[0]) + XmlUtil.attr("elev", "" + trackInfo.getAltitude(r)[0]) + XmlUtil.attr("time", time) + "/>");
                        continue;
                    }
                    catch (Exception exc) {
                        throw new IllegalStateException("Got error creating sonde positions " + exc);
                    }
                }
            }
            xml.append("</stationtable>");
            return new Text(xml.toString());
        }
        return super.getDataInner(dataChoice, category, dataSelection, requestProperties);
    }
}

