/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.sounding;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import ucar.unidata.data.AddeUtil;
import ucar.unidata.data.CompositeDataChoice;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DataSourceImpl;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.DirectDataChoice;
import ucar.unidata.data.sounding.AddeSoundingAdapter;
import ucar.unidata.data.sounding.CMASoundingAdapter;
import ucar.unidata.data.sounding.NetcdfSoundingAdapter;
import ucar.unidata.data.sounding.RAOB;
import ucar.unidata.data.sounding.RaobDataSet;
import ucar.unidata.data.sounding.SoundingAdapter;
import ucar.unidata.data.sounding.SoundingAdapterImpl;
import ucar.unidata.data.sounding.SoundingOb;
import ucar.unidata.data.sounding.SoundingStation;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import visad.Data;
import visad.DateTime;
import visad.FlatField;
import visad.Tuple;
import visad.VisADException;

public final class RaobDataSource
extends DataSourceImpl {
    private RaobDataSet raobDataSet;
    private String file;
    public boolean useDriverTime = false;
    List<DateTime> initTimes = null;

    public RaobDataSource() {
    }

    public RaobDataSource(DataSourceDescriptor descriptor, RaobDataSet rds, Hashtable properties) throws VisADException {
        super(descriptor, "RAOB data: " + rds.getAdapterSource(), "RAOB data source", properties);
        this.raobDataSet = rds;
    }

    public RaobDataSource(DataSourceDescriptor descriptor, String file, Hashtable properties) throws VisADException {
        super(descriptor, "RAOB data: " + file, "RAOB data source", properties);
        this.file = file;
        this.raobDataSet = this.doMakeRaobDataSet();
    }

    private RaobDataSet doMakeRaobDataSet() {
        SoundingAdapterImpl adapter = null;
        try {
            adapter = new NetcdfSoundingAdapter(this.file);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (adapter == null) {
            try {
                adapter = new CMASoundingAdapter(this.file);
            }
            catch (Exception exc) {
                LogUtil.logException("Reading sounding:" + this.file, exc);
                return null;
            }
        }
        if (adapter == null) {
            throw new IllegalArgumentException("Could not open sounding file:" + this.file);
        }
        Object[] obs = adapter.getSoundingObs();
        return new RaobDataSet((SoundingAdapter)((Object)adapter), Misc.toList(obs));
    }

    @Override
    public boolean equals(Object object) {
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        RaobDataSource that = (RaobDataSource)object;
        if (this.file != null) {
            return Misc.equals(this.file, that.file);
        }
        return Misc.equals(this.raobDataSet, that.raobDataSet);
    }

    @Override
    public List getDataPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        AddeSoundingAdapter asa = (AddeSoundingAdapter)this.getRDS().getSoundingAdapter();
        List obs = this.getRDS().getSoundingObs();
        for (int i = 0; i < obs.size(); ++i) {
            SoundingOb ob = (SoundingOb)obs.get(i);
            if (ob.getMandatoryFile() != null) {
                paths.add(ob.getMandatoryFile());
                paths.add(ob.getSigFile());
                continue;
            }
            paths.add(asa.getMandatoryURL(ob));
            paths.add(asa.getSigURL(ob));
        }
        return paths;
    }

    @Override
    public void initAfterUnpersistence() {
        super.initAfterUnpersistence();
        List tmp = this.getTmpPaths();
        if (tmp != null) {
            List obs = this.getRDS().getSoundingObs();
            AddeSoundingAdapter asa = (AddeSoundingAdapter)this.getRDS().getSoundingAdapter();
            for (int i = 0; i < tmp.size(); i += 2) {
                SoundingOb ob = (SoundingOb)obs.get(i / 2);
                ob.setMandatoryFile(tmp.get(i).toString());
                ob.setMandatoryFile(tmp.get(i + 1).toString());
            }
        }
    }

    @Override
    protected List saveDataToLocalDisk(String prefix, Object loadId, boolean changeLinks) throws Exception {
        ArrayList<String> urls = new ArrayList<String>();
        List obs = this.getRDS().getSoundingObs();
        AddeSoundingAdapter asa = (AddeSoundingAdapter)this.getRDS().getSoundingAdapter();
        for (int i = 0; i < obs.size(); ++i) {
            SoundingOb ob = (SoundingOb)obs.get(i);
            urls.add(asa.getMandatoryURL(ob) + "&rawstream=true");
            urls.add(asa.getSigURL(ob) + "&rawstream=true");
        }
        List newFiles = IOUtil.writeTo(urls, prefix, "raob", loadId);
        if (newFiles == null) {
            return null;
        }
        if (changeLinks) {
            for (int i = 0; i < newFiles.size(); i += 2) {
                SoundingOb ob = (SoundingOb)obs.get(i / 2);
                ob.setMandatoryFile(newFiles.get(i).toString());
                ob.setSigFile(newFiles.get(i + 1).toString());
            }
        }
        return newFiles;
    }

    @Override
    public boolean canSaveDataToLocalDisk() {
        return this.getRDS().getSoundingAdapter() instanceof AddeSoundingAdapter && ((SoundingOb)this.getRDS().getSoundingObs().get(0)).getMandatoryFile() == null;
    }

    @Override
    protected void doMakeDataChoices() {
        boolean i = false;
        List soundingObs = this.getRDS().getSoundingObs();
        ArrayList<DataCategory> categories = new ArrayList<DataCategory>();
        DataCategory cat = new DataCategory("RAOB_SOUNDING");
        cat.setForDisplay(false);
        categories.add(cat);
        ArrayList<DataCategory> compCategories = new ArrayList<DataCategory>();
        DataCategory compCat = new DataCategory("None");
        compCat.setForDisplay(false);
        compCategories.add(compCat);
        CompositeDataChoice composite = new CompositeDataChoice(this, soundingObs, this.getName(), "RAOB Data", categories);
        Hashtable props = Misc.newHashtable("prop.icon", "/auxdata/ui/icons/Balloon.gif");
        for (SoundingOb ob : soundingObs) {
            String name = ob.getLabel();
            DateTime obTime = ob.getTimestamp();
            DataSelection timeSelect = null;
            if (obTime != null) {
                ArrayList<DateTime> times = new ArrayList<DateTime>(1);
                times.add(obTime);
                timeSelect = new DataSelection(times);
            }
            DirectDataChoice choice = new DirectDataChoice(this, ob, composite.getName(), name, categories, timeSelect, props);
            composite.addDataChoice(choice);
        }
        this.addDataChoice(composite);
    }

    @Override
    protected Data getDataInner(DataChoice dataChoice, DataCategory category, DataSelection dataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        List times = null;
        if (dataSelection != null) {
            times = this.getTimesFromDataSelection(dataSelection, dataChoice);
        }
        return this.getSoundingObs(dataChoice, dataSelection);
    }

    @Override
    protected List doMakeDateTimes() {
        ArrayList timesList = new ArrayList();
        if (this.getProperty(AddeUtil.ABSOLUTE_TIMES, (Object)null) != null) {
            timesList.addAll((List)this.getProperty(AddeUtil.ABSOLUTE_TIMES));
        }
        return timesList;
    }

    private Data makeSoundingOb(DataChoice dc, DataSelection dataSelection) throws VisADException, RemoteException {
        SoundingOb so = this.getRDS().initSoundingOb((SoundingOb)dc.getId());
        if (so == null) {
            return null;
        }
        RAOB raob = so.getRAOB();
        SoundingStation ss = so.getStation();
        FlatField t = raob.getTemperatureProfile();
        if (t.getDomainSet().getLength() == 1) {
            return null;
        }
        return new Tuple(new Data[]{so.getTimestamp(), so.getStation().getNamedLocation(), raob.getTemperatureProfile(), raob.getDewPointProfile(), raob.getWindProfile()});
    }

    private Data getSoundingObs(DataChoice dataChoice, DataSelection subset) throws VisADException, RemoteException {
        Vector<Data> v = new Vector<Data>();
        List<DataChoice> choices = dataChoice instanceof CompositeDataChoice ? ((CompositeDataChoice)dataChoice).getDataChoices() : Arrays.asList(dataChoice);
        Object t = subset.getProperty("Use_Display_Driver_Times");
        if (t instanceof Boolean && !this.useDriverTime) {
            this.useDriverTime = (Boolean)t;
        }
        if (this.useDriverTime) {
            if (this.initTimes == null) {
                this.initTimes = subset.getTimeDriverTimes();
            }
            if (this.initTimes != null) {
                List<SoundingOb> soundingObs = this.getTimeMatchingSoundingObs(this.initTimes);
                choices = this.getTimeMatchingDataChoices(soundingObs);
            }
        }
        for (DataChoice dc : choices) {
            Data ob = this.makeSoundingOb(dc, subset);
            if (ob == null) continue;
            v.add(ob);
        }
        return v.isEmpty() ? null : new Tuple(v.toArray(new Data[v.size()]), false);
    }

    protected List<SoundingOb> getTimeMatchingSoundingObs(List<DateTime> dTimes) {
        List soundingObs = this.getRDS().getSoundingObs();
        ArrayList<SoundingOb> newSoundingObs = new ArrayList<SoundingOb>();
        SoundingAdapter adapter = this.getRDS().adapter;
        for (SoundingOb ob : soundingObs) {
            for (DateTime obTime : dTimes) {
                SoundingOb ob1 = null;
                try {
                    ob1 = new SoundingOb(ob.getStation(), obTime);
                    newSoundingObs.add(ob1);
                }
                catch (Exception exception) {}
            }
        }
        this.raobDataSet = new RaobDataSet(adapter, newSoundingObs);
        return newSoundingObs;
    }

    protected List<DataChoice> getTimeMatchingDataChoices(List<SoundingOb> soundingObs) {
        ArrayList<DataChoice> newChoices = new ArrayList<DataChoice>();
        ArrayList<DataCategory> categories = new ArrayList<DataCategory>();
        DataCategory cat = new DataCategory("RAOB_SOUNDING");
        cat.setForDisplay(false);
        categories.add(cat);
        ArrayList<DataCategory> compCategories = new ArrayList<DataCategory>();
        DataCategory compCat = new DataCategory("None");
        compCat.setForDisplay(false);
        compCategories.add(compCat);
        Hashtable props = Misc.newHashtable("prop.icon", "/auxdata/ui/icons/Balloon.gif");
        for (SoundingOb ob : soundingObs) {
            String name = ob.getLabel();
            DateTime obTime = ob.getTimestamp();
            DataSelection timeSelect = null;
            if (obTime != null) {
                ArrayList<DateTime> times = new ArrayList<DateTime>(1);
                times.add(obTime);
                timeSelect = new DataSelection(times);
            }
            DirectDataChoice choice = new DirectDataChoice(this, ob, this.getName(), name, categories, timeSelect, props);
            newChoices.add(choice);
        }
        return newChoices;
    }

    public List getAllTimesForTimeDriver(DataChoice dataChoice, DataSelection selection, List<DateTime> timeDriverTimes) {
        List<DateTime> results = null;
        ArrayList<DateTime> collectionTimes = new ArrayList<DateTime>();
        DateTime[] soundingTimes = this.raobDataSet.getSoundingAdapter().getSoundingTimes();
        for (int i = 0; i < soundingTimes.length; ++i) {
            collectionTimes.add(soundingTimes[i]);
        }
        try {
            results = DataUtil.selectTimesFromList(collectionTimes, timeDriverTimes);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initTimes = results;
        return results;
    }

    public RaobDataSet getRDS() {
        if (this.raobDataSet == null && this.file != null) {
            this.raobDataSet = this.doMakeRaobDataSet();
        }
        return this.raobDataSet;
    }

    public RaobDataSet getRaobDataSet() {
        if (this.file == null) {
            return this.raobDataSet;
        }
        return null;
    }

    public void setRaobDataSet(RaobDataSet newRds) {
        this.raobDataSet = newRds;
    }

    public void setFile(String value) {
        this.file = value;
    }

    public String getFile() {
        return this.file;
    }
}

