/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.sounding;

import java.beans.PropertyVetoException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import ucar.unidata.beans.InvisiblePropertiedBean;
import ucar.unidata.beans.NonVetoableProperty;
import ucar.unidata.beans.Property;
import ucar.unidata.beans.VetoableProperty;
import ucar.unidata.data.sounding.Link;
import ucar.unidata.data.sounding.LinkSet;
import ucar.unidata.util.LogUtil;
import ucar.visad.Segment;
import ucar.visad.SegmentSet;
import ucar.visad.Util;
import ucar.visad.functiontypes.DewPointProfile;
import ucar.visad.functiontypes.InSituAirTemperatureProfile;
import ucar.visad.functiontypes.PolarHorizontalWindOfGeopotentialAltitude;
import ucar.visad.quantities.AirPressure;
import ucar.visad.quantities.CommonUnits;
import ucar.visad.quantities.DewPoint;
import ucar.visad.quantities.GeopotentialAltitude;
import ucar.visad.quantities.Gravity;
import ucar.visad.quantities.InSituAirTemperature;
import ucar.visad.quantities.PolarHorizontalWind;
import visad.CoordinateSystem;
import visad.EmpiricalCoordinateSystem;
import visad.ErrorEstimate;
import visad.Field;
import visad.FieldException;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.SingletonSet;
import visad.TupleType;
import visad.UnimplementedException;
import visad.Unit;
import visad.VisADException;
import visad.util.DataUtility;

public final class RAOB
extends InvisiblePropertiedBean {
    private static MandatoryPressureProfile emptyMandatoryPressureProfile;
    private static SignificantTemperatureProfile emptySignificantTemperatureProfile;
    private static TropopauseProfile emptyTropopauseProfile;
    private static MaximumWindProfile emptyMaximumWindProfile;
    private static MandatoryWindProfile emptyMandatoryWindProfile;
    private static SignificantWindProfile emptySignificantWindProfile;
    private static FlatField emptyTemperatureProfile;
    private static FlatField emptyDewPointProfile;
    private static FlatField emptyWindProfile;
    private GravityProperty gravityProperty = new GravityProperty();
    private OutputProfileProperty temperatureProfileProperty;
    private OutputProfileProperty dewPointProfileProperty;
    private OutputProfileProperty windProfileProperty;
    private MandatoryPressureProperty mandatoryPressureProperty;
    private SignificantTemperatureProperty significantTemperatureProperty;
    private TropopauseProperty tropopauseProperty;
    private MaximumWindProperty maximumWindProperty;
    private MandatoryWindProperty mandatoryWindProperty;
    private SignificantWindProperty significantWindProperty;
    private PressureCoordinateSystem pressureCoordinateSystem;
    private GeopotentialAltitudeCoordinateSystem geopotentialAltitudeCoordinateSystem;
    private MandatoryPressureCSHelper mandatoryPressureCSHelper;
    private OutputProfileContributors temperatureProfileContributors;
    private OutputProfileContributors dewPointProfileContributors;
    private OutputProfileContributors windProfileContributors;
    private LinkSet possibleLinks;
    private LinkSet activeLinks;

    public RAOB() throws VisADException {
        super("Radiosonde Observation");
        this.addProperty(this.gravityProperty);
        this.mandatoryPressureProperty = new MandatoryPressureProperty();
        this.addProperty(this.mandatoryPressureProperty);
        this.significantTemperatureProperty = new SignificantTemperatureProperty();
        this.addProperty(this.significantTemperatureProperty);
        this.tropopauseProperty = new TropopauseProperty();
        this.addProperty(this.tropopauseProperty);
        this.maximumWindProperty = new MaximumWindProperty();
        this.addProperty(this.maximumWindProperty);
        this.mandatoryWindProperty = new MandatoryWindProperty();
        this.addProperty(this.mandatoryWindProperty);
        this.significantWindProperty = new SignificantWindProperty();
        this.addProperty(this.significantWindProperty);
        this.temperatureProfileContributors = new OutputProfileContributors(new InputProfileProperty[]{this.mandatoryPressureProperty, this.significantTemperatureProperty, this.tropopauseProperty});
        this.dewPointProfileContributors = new OutputProfileContributors(new InputProfileProperty[]{this.mandatoryPressureProperty, this.significantTemperatureProperty, this.tropopauseProperty});
        this.windProfileContributors = new OutputProfileContributors(new InputProfileProperty[]{this.mandatoryPressureProperty, this.tropopauseProperty, this.maximumWindProperty, this.mandatoryWindProperty, this.significantWindProperty});
        try {
            this.mandatoryPressureCSHelper = new MandatoryPressureCSHelper();
            this.pressureCoordinateSystem = new PressureCoordinateSystem(this.mandatoryPressureCSHelper);
            this.addProperty(this.pressureCoordinateSystem);
            this.geopotentialAltitudeCoordinateSystem = new GeopotentialAltitudeCoordinateSystem();
            this.addProperty(this.geopotentialAltitudeCoordinateSystem);
            this.temperatureProfileProperty = new OutputProfileProperty("temperatureProfile", emptyTemperatureProfile, this.pressureCoordinateSystem.getCoordinateSystem(), this.temperatureProfileContributors);
            this.addProperty(this.temperatureProfileProperty);
            this.dewPointProfileProperty = new OutputProfileProperty("dewPointProfile", emptyDewPointProfile, this.pressureCoordinateSystem.getCoordinateSystem(), this.dewPointProfileContributors);
            this.addProperty(this.dewPointProfileProperty);
            this.windProfileProperty = new OutputProfileProperty("windProfile", emptyWindProfile, this.geopotentialAltitudeCoordinateSystem.getCoordinateSystem(), this.windProfileContributors);
            this.addProperty(this.windProfileProperty);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.possibleLinks = new LinkSet(new Link[]{new Contribution(this.mandatoryPressureProperty, this.temperatureProfileProperty), new Contribution(this.mandatoryPressureProperty, this.dewPointProfileProperty), new Contribution(this.mandatoryPressureProperty, this.windProfileProperty), new Contribution(this.significantTemperatureProperty, this.temperatureProfileProperty), new Contribution(this.significantTemperatureProperty, this.dewPointProfileProperty), new Contribution(this.tropopauseProperty, this.temperatureProfileProperty), new Contribution(this.tropopauseProperty, this.dewPointProfileProperty), new Contribution(this.tropopauseProperty, this.windProfileProperty), new Contribution(this.maximumWindProperty, this.windProfileProperty), new Contribution(this.mandatoryWindProperty, this.windProfileProperty), new Contribution(this.significantWindProperty, this.windProfileProperty)});
    }

    public void setMandatoryPressureProfile(Field field) throws VisADException, RemoteException, PropertyVetoException {
        this.mandatoryPressureProperty.setField(field);
    }

    public void setMandatoryPressureProfile(Unit pressureUnit, float[] pressures, Unit temperatureUnit, float[] temperatures, Unit dewPointUnit, float[] dewPoints, Unit speedUnit, float[] speeds, Unit directionUnit, float[] directions, Unit geopotentialAltitudeUnit, float[] geopotentialAltitudes) throws SetException, RemoteException, VisADException, PropertyVetoException {
        this.setMandatoryPressureProfile(RAOB.newMandatoryPressureProfile(pressureUnit, pressures, temperatureUnit, temperatures, dewPointUnit, dewPoints, speedUnit, speeds, directionUnit, directions, geopotentialAltitudeUnit, geopotentialAltitudes));
    }

    public Field getMandatoryPressureProfile() {
        return this.mandatoryPressureProperty.getField();
    }

    public void setSignificantTemperatureProfile(Field field) throws VisADException, RemoteException, PropertyVetoException {
        this.significantTemperatureProperty.setField(field);
    }

    public void setSignificantTemperatureProfile(Unit pressureUnit, float[] pressures, Unit temperatureUnit, float[] temperatures, Unit dewPointUnit, float[] dewPoints) throws VisADException, RemoteException, PropertyVetoException {
        this.setSignificantTemperatureProfile(RAOB.newSignificantTemperatureProfile(pressureUnit, pressures, temperatureUnit, temperatures, dewPointUnit, dewPoints));
    }

    public Field getSignificantTemperatureProfile() {
        return this.significantTemperatureProperty.getField();
    }

    public void setTropopauseProfile(Field field) throws VisADException, RemoteException, PropertyVetoException {
        this.tropopauseProperty.setField(field);
    }

    public Field getTropopauseProfile() {
        return this.tropopauseProperty.getField();
    }

    public void setMaximumWindProfile(Field field) throws VisADException, RemoteException, PropertyVetoException {
        this.maximumWindProperty.setField(field);
    }

    public void setMaximumWindProfile(Unit pressureUnit, float[] pressures, Unit speedUnit, float[] speeds, Unit directionUnit, float[] directions) throws VisADException, RemoteException, PropertyVetoException {
        this.setMaximumWindProfile(RAOB.newMaximumWindProfile(pressureUnit, pressures, speedUnit, speeds, directionUnit, directions));
    }

    public Field getMaximumWindProfile() {
        return this.maximumWindProperty.getField();
    }

    public void setMandatoryWindProfile(Field field) throws VisADException, RemoteException, PropertyVetoException {
        this.mandatoryWindProperty.setField(field);
    }

    public void setMandatoryWindProfile(Unit geopotentialAltitudeUnit, float[] geopotentialAltitudes, Unit speedUnit, float[] speeds, Unit directionUnit, float[] directions) throws VisADException, RemoteException, PropertyVetoException {
        this.setMandatoryWindProfile(RAOB.newMandatoryWindProfile(geopotentialAltitudeUnit, geopotentialAltitudes, speedUnit, speeds, directionUnit, directions));
    }

    public Field getMandatoryWindProfile() {
        return this.mandatoryWindProperty.getField();
    }

    public void setSignificantWindProfile(Field field) throws VisADException, RemoteException, PropertyVetoException {
        this.significantWindProperty.setField(field);
    }

    public void setSignificantWindProfile(Unit geopotentialAltitudeUnit, float[] geopotentialAltitudes, Unit speedUnit, float[] speeds, Unit directionUnit, float[] directions) throws VisADException, RemoteException, PropertyVetoException {
        this.setSignificantWindProfile(RAOB.newSignificantWindProfile(geopotentialAltitudeUnit, geopotentialAltitudes, speedUnit, speeds, directionUnit, directions));
    }

    public Field getSignificantWindProfile() {
        return this.significantWindProperty.getField();
    }

    public void setGravity(Real gravity) throws VisADException, RemoteException, PropertyVetoException {
        this.gravityProperty.set(gravity);
    }

    public Real getGravity() {
        return this.gravityProperty.get();
    }

    public CoordinateSystem getPressureCoordinateSystem() {
        return this.pressureCoordinateSystem.getCoordinateSystem();
    }

    public CoordinateSystem getGeopotentialAltitudeCoordinateSystem() {
        return this.geopotentialAltitudeCoordinateSystem.getCoordinateSystem();
    }

    public FlatField getTemperatureProfile() {
        return this.temperatureProfileProperty.getFlatField();
    }

    public FlatField getDewPointProfile() {
        return this.dewPointProfileProperty.getFlatField();
    }

    public FlatField getWindProfile() {
        return this.windProfileProperty.getFlatField();
    }

    public LinkSet getPossibleLinks() {
        return this.possibleLinks;
    }

    public LinkSet getActiveLinks() {
        return this.activeLinks;
    }

    public void setActiveLinks(LinkSet links) throws VisADException, RemoteException, PropertyVetoException {
        Iterator iter = links.SecondEndIterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            ((OutputProfileProperty)entry.getKey()).setContributors((java.util.Set)entry.getValue());
        }
    }

    protected static void adjustData(float[][] domainValues, float[][] rangeValues, boolean increasing) {
        float[] values = domainValues[0];
        int[] tmpIndexes = new int[values.length];
        int n = 0;
        int i = values.length;
        while (--i >= 0) {
            float value = values[i];
            if (Float.isNaN(value) || Float.isInfinite(value)) continue;
            tmpIndexes[n++] = i;
        }
        int[] indexes = new int[n];
        System.arraycopy(tmpIndexes, 0, indexes, 0, n);
        if (indexes.length < values.length) {
            values = Util.take(values, indexes);
            int i2 = rangeValues.length;
            while (--i2 >= 0) {
                rangeValues[i2] = Util.take(rangeValues[i2], indexes);
            }
        }
        if (!Util.isStrictlySorted(values)) {
            indexes = Util.strictlySortedIndexes(values, increasing);
            values = Util.take(values, indexes);
            int i3 = rangeValues.length;
            while (--i3 >= 0) {
                rangeValues[i3] = Util.take(rangeValues[i3], indexes);
            }
        }
        domainValues[0] = values;
    }

    public static MandatoryPressureProfile newMandatoryPressureProfile(Unit pressureUnit, float[] pressures, Unit temperatureUnit, float[] temperatures, Unit dewPointUnit, float[] dewPoints, Unit speedUnit, float[] speeds, Unit directionUnit, float[] directions, Unit geopotentialAltitudeUnit, float[] geopotentialAltitudes) throws SetException, RemoteException, VisADException {
        float[][] domainValues = new float[][]{pressures};
        float[][] rangeValues = new float[][]{temperatures, dewPoints, speeds, directions, geopotentialAltitudes};
        RAOB.adjustData(domainValues, rangeValues, false);
        return new MandatoryPressureProfile(pressureUnit, domainValues[0], temperatureUnit, rangeValues[0], dewPointUnit, rangeValues[1], speedUnit, rangeValues[2], directionUnit, rangeValues[3], geopotentialAltitudeUnit, rangeValues[4]);
    }

    public static SignificantTemperatureProfile newSignificantTemperatureProfile(Unit pressureUnit, float[] pressures, Unit temperatureUnit, float[] temperatures, Unit dewPointUnit, float[] dewPoints) throws VisADException, RemoteException {
        float[][] domainValues = new float[][]{pressures};
        float[][] rangeValues = new float[][]{temperatures, dewPoints};
        RAOB.adjustData(domainValues, rangeValues, false);
        return new SignificantTemperatureProfile(pressureUnit, domainValues[0], temperatureUnit, rangeValues[0], dewPointUnit, rangeValues[1]);
    }

    public static TropopauseProfile newTropopauseProfile(Unit pressureUnit, float[] pressures, Unit temperatureUnit, float[] temperatures, Unit dewPointUnit, float[] dewPoints, Unit speedUnit, float[] speeds, Unit directionUnit, float[] directions) throws VisADException, RemoteException {
        float[][] domainValues = new float[][]{pressures};
        float[][] rangeValues = new float[][]{temperatures, dewPoints, speeds, directions};
        RAOB.adjustData(domainValues, rangeValues, false);
        return new TropopauseProfile(pressureUnit, domainValues[0], temperatureUnit, rangeValues[0], dewPointUnit, rangeValues[1], speedUnit, rangeValues[2], directionUnit, rangeValues[3]);
    }

    public static MaximumWindProfile newMaximumWindProfile(Unit pressureUnit, float[] pressures, Unit speedUnit, float[] speeds, Unit directionUnit, float[] directions) throws VisADException, RemoteException {
        float[][] domainValues = new float[][]{pressures};
        float[][] rangeValues = new float[][]{speeds, directions};
        RAOB.adjustData(domainValues, rangeValues, false);
        return new MaximumWindProfile(pressureUnit, domainValues[0], speedUnit, rangeValues[0], directionUnit, rangeValues[1]);
    }

    public static MandatoryWindProfile newMandatoryWindProfile(Unit geopotentialAltitudeUnit, float[] geopotentialAltitudes, Unit speedUnit, float[] speeds, Unit directionUnit, float[] directions) throws VisADException, RemoteException {
        float[][] domainValues = new float[][]{geopotentialAltitudes};
        float[][] rangeValues = new float[][]{speeds, directions};
        RAOB.adjustData(domainValues, rangeValues, true);
        return new MandatoryWindProfile(geopotentialAltitudeUnit, domainValues[0], speedUnit, rangeValues[0], directionUnit, rangeValues[1]);
    }

    public static SignificantWindProfile newSignificantWindProfile(Unit geopotentialAltitudeUnit, float[] geopotentialAltitudes, Unit speedUnit, float[] speeds, Unit directionUnit, float[] directions) throws VisADException, RemoteException {
        float[][] domainValues = new float[][]{geopotentialAltitudes};
        float[][] rangeValues = new float[][]{speeds, directions};
        RAOB.adjustData(domainValues, rangeValues, true);
        return new SignificantWindProfile(geopotentialAltitudeUnit, domainValues[0], speedUnit, rangeValues[0], directionUnit, rangeValues[1]);
    }

    protected static Set newSet(RealTupleType type, float[] values, Unit unit) throws SetException, RemoteException, VisADException {
        if (values.length <= 0) {
            throw new SetException("RAOB.newSet(): Non-positive-length value-array");
        }
        SampledSet set = values.length == 1 ? new SingletonSet(new RealTuple(type, new Real[]{new Real((RealType)type.getComponent(0), values[0], unit)}, null), (CoordinateSystem)null, new Unit[]{unit}, (ErrorEstimate[])null) : new Gridded1DSet((MathType)type, (float[][])new float[][]{values}, values.length, (CoordinateSystem)null, new Unit[]{unit}, (ErrorEstimate[])null);
        return set;
    }

    protected boolean adjustCoordinateSystem(CoordinateSystem cs, Field oldField, Property property) throws VisADException, RemoteException {
        boolean change;
        if (cs.equals(oldField.getDomainCoordinateSystem())) {
            change = false;
        } else {
            try {
                FlatField newField = (FlatField)Util.clone((FlatField)oldField.local(), Util.clone(oldField.getDomainSet(), cs));
                property.setValueAndNotifyListeners(newField);
            }
            catch (Exception e) {
                throw new VisADException(this.getClass().getName() + ": Couldn't set property " + property.getName() + ": " + e);
            }
            change = true;
        }
        return change;
    }

    protected static FlatField ensureDomain1D(FlatField field, RealTupleType newDomainType, CoordinateSystem coordinateSystem) throws VisADException, RemoteException {
        FlatField newField;
        if (DataUtility.getDomainType(field).equals(newDomainType)) {
            newField = coordinateSystem.equals(field.getDomainSet().getCoordinateSystem()) ? field : (FlatField)Util.clone(field, Util.clone(field.getDomainSet(), coordinateSystem));
        } else {
            CoordinateSystem rangeCoordinateSystem = Util.getRangeCoordinateSystem(field);
            CoordinateSystem[] rangeCoordinateSystems = Util.getRangeCoordinateSystems(field);
            Set[] rangeSets = field.getRangeSets();
            Unit[] rangeUnits = Util.getRangeUnits(field);
            SampledSet oldDomain = (SampledSet)field.getDomainSet();
            RealTupleType oldDomainType = ((SetType)oldDomain.getType()).getDomain();
            ErrorEstimate[] oldErrors = oldDomain.getSetErrors();
            ErrorEstimate[] newErrors = new ErrorEstimate[oldErrors.length];
            Unit[] newUnits = coordinateSystem == null ? newDomainType.getDefaultUnits() : coordinateSystem.getCoordinateSystemUnits();
            double[][] newDomainValues = CoordinateSystem.transformCoordinates(newDomainType, coordinateSystem, newUnits, newErrors, oldDomainType, oldDomain.getCoordinateSystem(), oldDomain.getSetUnits(), oldErrors, oldDomain.getDoubles());
            ValidSegmentSet goodSegments = new ValidSegmentSet(newDomainValues);
            newField = new FlatField(new FunctionType(newDomainType, DataUtility.getRangeType(field)), Util.newSampledSet(new int[]{goodSegments.getTotalCount()}, newDomainType, goodSegments.take(newDomainValues), coordinateSystem, newUnits, newErrors), rangeCoordinateSystem, rangeCoordinateSystems, field.getRangeSets(), null);
            if (!field.isMissing()) {
                newField.setSamples(goodSegments.take(field.getValues(true)), false);
            }
        }
        return newField;
    }

    protected static FlatField ensureValidRange(FlatField flatField) throws FieldException, SetException, VisADException, RemoteException {
        FlatField result;
        if (flatField.getDomainDimension() != 1) {
            throw new FieldException("Domain not 1-D");
        }
        if (flatField.isMissing()) {
            result = flatField;
        } else {
            double[][] rangeValues = flatField.getValues(false);
            ValidSegmentSet goodSegments = new ValidSegmentSet(rangeValues);
            int goodCount = goodSegments.getTotalCount();
            if (goodCount == 0) {
                result = null;
            } else if (goodCount == flatField.getLength()) {
                result = flatField;
            } else {
                SampledSet oldDomainSet = (SampledSet)flatField.getDomainSet();
                result = Util.clone(flatField, (Set)Util.newSampledSet(oldDomainSet, goodSegments.take(oldDomainSet.getSamples(false)), new int[]{goodCount}), false);
                if (goodCount > 0) {
                    result.setSamples(goodSegments.take(rangeValues), true);
                }
            }
        }
        return result;
    }

    static {
        try {
            emptyMandatoryPressureProfile = new MandatoryPressureProfile();
            emptySignificantTemperatureProfile = new SignificantTemperatureProfile();
            emptyTropopauseProfile = new TropopauseProfile();
            emptyMaximumWindProfile = new MaximumWindProfile();
            emptyMandatoryWindProfile = new MandatoryWindProfile();
            emptySignificantWindProfile = new SignificantWindProfile();
            emptyTemperatureProfile = new FlatField(InSituAirTemperatureProfile.instance());
            emptyDewPointProfile = new FlatField(DewPointProfile.instance());
            emptyWindProfile = new FlatField(PolarHorizontalWindOfGeopotentialAltitude.instance());
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't initialize class: " + e.toString());
        }
    }

    protected static class Contribution
    extends Link {
        public Contribution(InputProfileProperty input, OutputProfileProperty output) {
            super(new End(input), new End(output));
        }

        public InputProfileProperty getInputProfileProperty() {
            return (InputProfileProperty)((End)this.getFirstEnd()).getProperty();
        }

        public OutputProfileProperty getOutputProfileProperty() {
            return (OutputProfileProperty)((End)this.getSecondEnd()).getProperty();
        }

        protected static class End
        extends Link.End {
            private final Property property;

            public End(Property property) {
                super(property.getName());
                this.property = property;
            }

            public Property getProperty() {
                return this.property;
            }
        }
    }

    protected static final class ValidSegmentSet
    extends SegmentSet {
        public ValidSegmentSet(double[][] values) {
            if (values.length > 0) {
                int pointCount = values[0].length;
                int i = values.length;
                while (--i > 0) {
                    if (values[i].length == pointCount) continue;
                    throw new IllegalArgumentException("Subarrays have different lengths");
                }
                int pointIndex = -1;
                while (pointIndex < pointCount) {
                    while (++pointIndex < pointCount) {
                        double value;
                        int componentIndex;
                        for (componentIndex = 0; componentIndex < values.length && (value = values[componentIndex][pointIndex]) == value && !Double.isInfinite(value); ++componentIndex) {
                        }
                        if (componentIndex != values.length) continue;
                        break;
                    }
                    if (pointIndex >= pointCount) continue;
                    int startIndex = pointIndex;
                    while (++pointIndex < pointCount) {
                        double value;
                        int componentIndex;
                        for (componentIndex = 0; componentIndex < values.length && (value = values[componentIndex][pointIndex]) == value && !Double.isInfinite(value); ++componentIndex) {
                        }
                        if (componentIndex >= values.length) continue;
                        break;
                    }
                    this.add(new Segment(startIndex, pointIndex - startIndex));
                }
            }
        }
    }

    private final class OutputProfileProperty
    extends NonVetoableProperty {
        private CoordinateSystem domainCoordinateSystem;
        private final FunctionType functionType;
        private final OutputProfileContributors contributors;
        private boolean recomputationNeeded;
        private boolean recomputationEnabled;

        public OutputProfileProperty(String name, FlatField defaultFlatField, CoordinateSystem domainCoordinateSystem, OutputProfileContributors contributors) throws VisADException, RemoteException {
            super(RAOB.this, name);
            this.recomputationNeeded = false;
            this.recomputationEnabled = true;
            this.setValue(defaultFlatField);
            this.domainCoordinateSystem = domainCoordinateSystem;
            this.contributors = contributors;
            this.functionType = (FunctionType)defaultFlatField.getType();
        }

        public final FlatField getFlatField() {
            return (FlatField)this.getValue();
        }

        public void setFlatField(FlatField newFlatField) throws PropertyVetoException {
            this.setValueAndNotifyListeners(newFlatField);
        }

        public void setContributors(java.util.Set contributors) throws VisADException, RemoteException, PropertyVetoException {
            this.contributors.clear();
            this.contributors.addAll(contributors);
            this.recomputationNeeded = true;
            this.recompute();
        }

        public final InputProfileProperty[] getContributors() {
            return this.contributors.getContributors();
        }

        public void disableRecomputation() {
            this.recomputationEnabled = false;
        }

        public void enableRecomputation() throws VisADException, RemoteException, PropertyVetoException {
            this.recomputationEnabled = true;
            this.recompute();
        }

        public void contributorChanged(InputProfileProperty input) throws VisADException, RemoteException, PropertyVetoException {
            this.recomputationNeeded = this.contributors.isContributor(input);
            this.recompute();
        }

        private void recompute() throws VisADException, RemoteException, PropertyVetoException {
            if (this.recomputationNeeded && this.recomputationEnabled) {
                this.recomputationNeeded = false;
                InputProfileProperty[] inputProperties = this.contributors.getContributors();
                if (inputProperties.length == 0) {
                    this.setFlatField(null);
                } else {
                    FlatField[] flatFields = new FlatField[inputProperties.length];
                    int i = inputProperties.length;
                    while (--i >= 0) {
                        flatFields[i] = inputProperties[i].getFlatField();
                    }
                    this.setFlatField(this.consolidate(this.functionType, flatFields, this.domainCoordinateSystem));
                }
            }
        }

        private FlatField consolidate(FunctionType outputFuncType, FlatField[] fields, CoordinateSystem coordinateSystem) throws VisADException, RemoteException {
            ArrayList<FlatField> fieldList = new ArrayList<FlatField>(fields.length);
            MathType outputRangeType = outputFuncType.getRange();
            RealTupleType outputDomainType = outputFuncType.getDomain();
            for (int i = 0; i < fields.length; ++i) {
                if (fields[i].isMissing()) continue;
                try {
                    FlatField validFlatField = RAOB.ensureValidRange(RAOB.ensureDomain1D((FlatField)DataUtility.ensureRange(fields[i], outputRangeType), outputDomainType, coordinateSystem));
                    if (validFlatField == null) {
                        LogUtil.consoleMessage("Warning: Field has no valid " + outputRangeType + " data");
                        continue;
                    }
                    fieldList.add(validFlatField);
                    continue;
                }
                catch (SetException e) {
                    System.err.println("Warning: Couldn't use " + fields[i].getType());
                }
            }
            int fieldCount = fieldList.size();
            FlatField result = fieldCount == 0 ? (FlatField)null : (FlatField)DataUtility.consolidate(fieldList.toArray(new FlatField[fieldCount]));
            result = (FlatField)Util.clone(result, Util.clone(result.getDomainSet(), coordinateSystem));
            return result;
        }

        public void coordinateSystemChanged(CoordinateSystem cs) throws VisADException, RemoteException, UnimplementedException, PropertyVetoException {
            if (RAOB.this.adjustCoordinateSystem(cs, this.getFlatField(), this)) {
                this.domainCoordinateSystem = cs;
                this.notifyListeners();
            }
        }
    }

    private final class MaximumWindProperty
    extends InputProfileProperty {
        public MaximumWindProperty() {
            super("maximumWindProfile", emptyMaximumWindProfile);
        }

        @Override
        protected void setOutputProfiles() throws VisADException, RemoteException {
            try {
                RAOB.this.windProfileProperty.contributorChanged(this);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private final class SignificantWindProperty
    extends InputProfileProperty {
        public SignificantWindProperty() {
            super("significantWindProfile", emptySignificantWindProfile);
        }

        @Override
        protected void setOutputProfiles() throws VisADException, RemoteException {
            try {
                RAOB.this.windProfileProperty.contributorChanged(this);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private final class MandatoryWindProperty
    extends InputProfileProperty {
        public MandatoryWindProperty() {
            super("mandatoryWindProfile", emptyMandatoryWindProfile);
        }

        @Override
        protected void setOutputProfiles() throws VisADException, RemoteException {
            try {
                RAOB.this.windProfileProperty.contributorChanged(this);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private final class TropopauseProperty
    extends InputProfileProperty {
        public TropopauseProperty() {
            super("tropopauseProfile", emptyTropopauseProfile);
        }

        @Override
        protected void setOutputProfiles() throws VisADException, RemoteException {
            try {
                RAOB.this.temperatureProfileProperty.contributorChanged(this);
                RAOB.this.dewPointProfileProperty.contributorChanged(this);
                RAOB.this.windProfileProperty.contributorChanged(this);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private final class SignificantTemperatureProperty
    extends InputProfileProperty {
        public SignificantTemperatureProperty() {
            super("significantTemperatureProfile", emptySignificantTemperatureProfile);
        }

        @Override
        protected void setOutputProfiles() throws VisADException, RemoteException {
            try {
                RAOB.this.temperatureProfileProperty.contributorChanged(this);
                RAOB.this.dewPointProfileProperty.contributorChanged(this);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private final class MandatoryPressureProperty
    extends InputProfileProperty {
        public MandatoryPressureProperty() {
            super("mandatoryPressureProfile", emptyMandatoryPressureProfile);
        }

        @Override
        public synchronized void setField(Field newField) throws VisADException, RemoteException {
            Field original = this.getField();
            this.setReporting(false);
            RAOB.this.temperatureProfileProperty.disableRecomputation();
            RAOB.this.dewPointProfileProperty.disableRecomputation();
            RAOB.this.windProfileProperty.disableRecomputation();
            try {
                this.setValue(newField);
                RAOB.this.pressureCoordinateSystem.mandatoryPressureProfileChanged();
                this.setOutputProfiles();
            }
            catch (Exception e) {
                try {
                    this.setReporting(true);
                    RAOB.this.temperatureProfileProperty.enableRecomputation();
                    RAOB.this.dewPointProfileProperty.enableRecomputation();
                    RAOB.this.windProfileProperty.enableRecomputation();
                    this.setValueAndNotifyListeners(original);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            this.setReporting(true);
            try {
                RAOB.this.temperatureProfileProperty.enableRecomputation();
                RAOB.this.dewPointProfileProperty.enableRecomputation();
                RAOB.this.windProfileProperty.enableRecomputation();
            }
            catch (PropertyVetoException propertyVetoException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        @Override
        protected void setOutputProfiles() throws VisADException, RemoteException {
            try {
                RAOB.this.temperatureProfileProperty.contributorChanged(this);
                RAOB.this.dewPointProfileProperty.contributorChanged(this);
                RAOB.this.windProfileProperty.contributorChanged(this);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private abstract class InputProfileProperty
    extends VetoableProperty {
        public InputProfileProperty(String name, FlatField defaultFlatField) {
            super(RAOB.this, name);
            try {
                this.setValue(defaultFlatField);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        public final Field getField() {
            return (Field)this.getValue();
        }

        public final FlatField getFlatField() {
            return (FlatField)((FlatField)this.getValue()).local();
        }

        public void setField(Field newField) throws VisADException, RemoteException, PropertyVetoException {
            this.setValueAndNotifyListeners(newField);
            this.setOutputProfiles();
        }

        public void coordinateSystemChanged(CoordinateSystem cs) throws VisADException, RemoteException, UnimplementedException {
            if (RAOB.this.adjustCoordinateSystem(cs, this.getField(), this)) {
                this.notifyListeners();
                this.setOutputProfiles();
            }
        }

        protected abstract void setOutputProfiles() throws VisADException, RemoteException;
    }

    private final class OutputProfileContributors
    extends TreeSet {
        public OutputProfileContributors(InputProfileProperty[] inputProfileProperties) {
            super(new Comparator(){

                public int compare(Object obj1, Object obj2) {
                    return ((InputProfileProperty)obj1).getName().compareTo(((InputProfileProperty)obj2).getName());
                }

                public boolean equals(Object obj1, Object obj2) {
                    return this.compare(obj1, obj2) == 0;
                }
            });
            int i = inputProfileProperties.length;
            while (--i >= 0) {
                this.add(inputProfileProperties[i]);
            }
        }

        public InputProfileProperty[] getContributors() {
            return this.toArray(new InputProfileProperty[this.size()]);
        }

        public boolean isContributor(InputProfileProperty property) {
            return this.contains(property);
        }
    }

    private class GravityProperty
    extends VetoableProperty {
        public GravityProperty() throws VisADException {
            super(RAOB.this, "gravity");
            try {
                this.setValue(Gravity.newReal());
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        protected final Real get() {
            return (Real)this.getValue();
        }

        protected final void set(Real gravity) throws PropertyVetoException, VisADException, RemoteException {
            this.setValue(gravity);
            try {
                RAOB.this.pressureCoordinateSystem.gravityChanged();
                RAOB.this.geopotentialAltitudeCoordinateSystem.gravityChanged();
            }
            finally {
                this.notifyListeners();
            }
        }
    }

    private final class GeopotentialAltitudeCoordinateSystem
    extends CoordinateSystemProperty {
        public GeopotentialAltitudeCoordinateSystem() throws VisADException {
            super("geopotentialAltitudeCoordinateSystem", GeopotentialAltitude.getRealTupleType().getCoordinateSystem());
        }

        @Override
        public void gravityChanged() throws VisADException, RemoteException, PropertyVetoException {
            CoordinateSystem cs = GeopotentialAltitude.getRealTupleType().getCoordinateSystem();
            this.setValueAndNotifyListeners(cs);
            RAOB.this.mandatoryWindProperty.coordinateSystemChanged(cs);
            RAOB.this.significantWindProperty.coordinateSystemChanged(cs);
            RAOB.this.windProfileProperty.coordinateSystemChanged(cs);
        }
    }

    private final class MandatoryPressureCSHelper
    extends PressureCSHelper {
        private CoordinateSystem cs;
        private boolean recomputationNeeded = false;

        private MandatoryPressureCSHelper() {
        }

        @Override
        public void gravityChanged() throws VisADException, RemoteException, PropertyVetoException {
            this.contributorChanged();
        }

        @Override
        public void mandatoryPressureProfileChanged() throws VisADException, RemoteException, PropertyVetoException {
            this.contributorChanged();
        }

        private void contributorChanged() throws VisADException, RemoteException, PropertyVetoException {
            if (!this.isActive) {
                this.recomputationNeeded = true;
            } else {
                this.recomputationNeeded = true;
                this.recompute();
                this.propagateChange();
            }
        }

        private void propagateChange() throws VisADException, RemoteException, PropertyVetoException {
            RAOB.this.pressureCoordinateSystem.setValue(this.cs);
            RAOB.this.pressureCoordinateSystem.notifyListeners();
            RAOB.this.pressureCoordinateSystem.notifyAffectedProfiles();
        }

        private void recompute() throws VisADException, RemoteException {
            if (this.recomputationNeeded) {
                this.recomputationNeeded = false;
                FlatField geopotentialField = RAOB.ensureValidRange((FlatField)DataUtility.ensureRange(RAOB.this.mandatoryPressureProperty.getFlatField(), GeopotentialAltitude.getRealType()));
                try {
                    this.cs = geopotentialField == null || geopotentialField.isMissing() || geopotentialField.getLength() <= 1 ? (CoordinateSystem)null : EmpiricalCoordinateSystem.create((FlatField)GeopotentialAltitude.toAltitude(geopotentialField, RAOB.this.gravityProperty.get()));
                }
                catch (SetException e) {
                    this.cs = AirPressure.getRealTupleType().getCoordinateSystem();
                }
            }
        }

        @Override
        public CoordinateSystem getCoordinateSystem() throws VisADException, RemoteException {
            this.recompute();
            return this.cs;
        }
    }

    private static abstract class PressureCSHelper {
        protected boolean isActive = false;

        protected PressureCSHelper() {
        }

        public abstract void gravityChanged() throws VisADException, RemoteException, PropertyVetoException;

        public abstract void mandatoryPressureProfileChanged() throws VisADException, RemoteException, PropertyVetoException;

        public abstract CoordinateSystem getCoordinateSystem() throws VisADException, RemoteException;

        public void setActive(boolean isActive) {
            this.isActive = isActive;
        }
    }

    private final class PressureCoordinateSystem
    extends CoordinateSystemProperty {
        private PressureCSHelper pressureCSHelper;

        public PressureCoordinateSystem(PressureCSHelper pressureCSHelper) throws VisADException {
            super("pressureCoordinateSystem", AirPressure.getRealTupleType().getCoordinateSystem());
            this.pressureCSHelper = null;
            this.pressureCSHelper = pressureCSHelper;
            pressureCSHelper.setActive(true);
        }

        public void setPressureCSHelper(PressureCSHelper pressureCSHelper) throws VisADException, RemoteException, PropertyVetoException {
            this.pressureCSHelper.setActive(false);
            this.pressureCSHelper = pressureCSHelper;
            pressureCSHelper.setActive(true);
            this.setValue(pressureCSHelper.getCoordinateSystem());
            this.notifyListeners();
            this.notifyAffectedProfiles();
        }

        public void notifyAffectedProfiles() throws VisADException, RemoteException, UnimplementedException, PropertyVetoException {
            CoordinateSystem cs = this.getCoordinateSystem();
            RAOB.this.mandatoryPressureProperty.coordinateSystemChanged(cs);
            RAOB.this.significantTemperatureProperty.coordinateSystemChanged(cs);
            RAOB.this.tropopauseProperty.coordinateSystemChanged(cs);
            RAOB.this.maximumWindProperty.coordinateSystemChanged(cs);
            RAOB.this.temperatureProfileProperty.coordinateSystemChanged(cs);
            RAOB.this.dewPointProfileProperty.coordinateSystemChanged(cs);
        }

        @Override
        public void gravityChanged() throws VisADException, RemoteException, PropertyVetoException {
            this.pressureCSHelper.gravityChanged();
        }

        public void mandatoryPressureProfileChanged() throws VisADException, RemoteException, PropertyVetoException {
            this.pressureCSHelper.mandatoryPressureProfileChanged();
        }
    }

    private abstract class CoordinateSystemProperty
    extends NonVetoableProperty {
        protected CoordinateSystemProperty(String name, CoordinateSystem defaultCS) {
            super(RAOB.this, name);
            this.setValue(defaultCS);
        }

        public abstract void gravityChanged() throws VisADException, RemoteException, PropertyVetoException;

        public CoordinateSystem getCoordinateSystem() {
            return (CoordinateSystem)this.getValue();
        }
    }

    public static final class SignificantWindProfile
    extends GeopotentialWindProfile {
        public SignificantWindProfile() throws VisADException, RemoteException {
        }

        public SignificantWindProfile(Unit geopotentialAltitudeUnit, float[] geopotentialAltitudes, Unit speedUnit, float[] speeds, Unit directionUnit, float[] directions) throws VisADException, RemoteException {
            super(geopotentialAltitudeUnit, geopotentialAltitudes, speedUnit, speeds, directionUnit, directions);
        }
    }

    public static final class MandatoryWindProfile
    extends GeopotentialWindProfile {
        public MandatoryWindProfile() throws VisADException, RemoteException {
        }

        public MandatoryWindProfile(Unit geopotentialAltitudeUnit, float[] geopotentialAltitudes, Unit speedUnit, float[] speeds, Unit directionUnit, float[] directions) throws VisADException, RemoteException {
            super(geopotentialAltitudeUnit, geopotentialAltitudes, speedUnit, speeds, directionUnit, directions);
        }
    }

    private static abstract class GeopotentialWindProfile
    extends FlatField {
        private static FunctionType functionType;

        private GeopotentialWindProfile() throws VisADException, RemoteException {
            super(functionType, new SingletonSet(new RealTuple(new Real[]{new Real(GeopotentialAltitude.getRealType(), 0.0)})));
        }

        private GeopotentialWindProfile(Unit geopotentialAltitudeUnit, float[] geopotentialAltitudes, Unit speedUnit, float[] speeds, Unit directionUnit, float[] directions) throws VisADException, RemoteException {
            super(functionType, RAOB.newSet(GeopotentialAltitude.getRealTupleType(), geopotentialAltitudes, geopotentialAltitudeUnit), (CoordinateSystem[])null, (Set[])null, new Unit[]{speedUnit, directionUnit});
            this.setSamples(new float[][]{speeds, directions});
        }

        static {
            try {
                functionType = new FunctionType(GeopotentialAltitude.getRealTupleType(), PolarHorizontalWind.getRealTupleType());
            }
            catch (Exception e) {
                System.err.println("Couldn't initialize class RAOB.GeopotentialWindProfile: " + e);
            }
        }
    }

    public static final class MaximumWindProfile
    extends PressureProfile {
        private static MathType rangeType;

        public MaximumWindProfile() throws VisADException, RemoteException {
            super(rangeType);
        }

        public MaximumWindProfile(Unit pressureUnit, float[] pressures, Unit speedUnit, float[] speeds, Unit directionUnit, float[] directions) throws VisADException, RemoteException {
            super(rangeType, pressureUnit, pressures, new Unit[]{speedUnit, directionUnit}, new float[][]{speeds, directions});
        }

        static {
            try {
                rangeType = PolarHorizontalWind.getRealTupleType();
            }
            catch (Exception e) {
                System.err.println("Couldn't initialize class RAOB.MaximumWindProfile: " + e);
            }
        }
    }

    public static final class TropopauseProfile
    extends PressureProfile {
        private static MathType rangeType;

        public TropopauseProfile() throws VisADException, RemoteException {
            super(rangeType);
        }

        public TropopauseProfile(Unit pressureUnit, float[] pressures, Unit temperatureUnit, float[] temperatures, Unit dewPointUnit, float[] dewPoints, Unit speedUnit, float[] speeds, Unit directionUnit, float[] directions) throws VisADException, RemoteException {
            super(rangeType, pressureUnit, pressures, new Unit[]{temperatureUnit, dewPointUnit, speedUnit, directionUnit}, new float[][]{temperatures, dewPoints, speeds, directions});
        }

        static {
            try {
                rangeType = new TupleType(new MathType[]{InSituAirTemperature.getRealType(), DewPoint.getRealType(), PolarHorizontalWind.getRealTupleType()});
            }
            catch (Exception e) {
                System.err.println("Couldn't initialize class RAOB.TropopauseProfile" + e);
            }
        }
    }

    public static final class SignificantTemperatureProfile
    extends PressureProfile {
        private static MathType rangeType;

        public SignificantTemperatureProfile() throws VisADException, RemoteException {
            super(rangeType);
        }

        public SignificantTemperatureProfile(Unit pressureUnit, float[] pressures, Unit temperatureUnit, float[] temperatures, Unit dewPointUnit, float[] dewPoints) throws VisADException, RemoteException {
            super(rangeType, pressureUnit, pressures, new Unit[]{temperatureUnit, dewPointUnit}, new float[][]{temperatures, dewPoints});
        }

        static {
            try {
                rangeType = new RealTupleType(InSituAirTemperature.getRealType(), DewPoint.getRealType());
            }
            catch (Exception e) {
                System.err.println("Couldn't initialize class RAOB.SignificantTemperatureProfile: " + e);
            }
        }
    }

    public static final class MandatoryPressureProfile
    extends PressureProfile {
        private static MathType rangeType;

        public MandatoryPressureProfile() throws VisADException, RemoteException {
            super(rangeType);
        }

        public MandatoryPressureProfile(Unit pressureUnit, float[] pressures, Unit temperatureUnit, float[] temperatures, Unit dewPointUnit, float[] dewPoints, Unit speedUnit, float[] speeds, Unit directionUnit, float[] directions, Unit geopotentialAltitudeUnit, float[] geopotentialAltitudes) throws SetException, RemoteException, VisADException {
            super(rangeType, pressureUnit, pressures, new Unit[]{temperatureUnit, dewPointUnit, speedUnit, directionUnit, geopotentialAltitudeUnit}, new float[][]{temperatures, dewPoints, speeds, directions, geopotentialAltitudes});
        }

        static {
            try {
                rangeType = new TupleType(new MathType[]{InSituAirTemperature.getRealType(), DewPoint.getRealType(), PolarHorizontalWind.getRealTupleType(), GeopotentialAltitude.getRealType()});
            }
            catch (Exception e) {
                System.err.println("Couldn't initialize class RAOB.MandatoryPressureProfile: " + e);
            }
        }
    }

    private static abstract class PressureProfile
    extends FlatField {
        private PressureProfile(MathType rangeType) throws VisADException, RemoteException {
            super(new FunctionType(AirPressure.getRealTupleType(), rangeType), new SingletonSet(new RealTuple(AirPressure.getRealTupleType(), new Real[]{new Real(AirPressure.getRealType(), 500.0, CommonUnits.HECTOPASCAL)}, null)));
        }

        public PressureProfile(MathType rangeType, Unit pressureUnit, float[] pressures, Unit[] rangeUnits, float[][] rangeValues) throws SetException, RemoteException, VisADException {
            super(new FunctionType(AirPressure.getRealTupleType(), rangeType), RAOB.newSet(AirPressure.getRealTupleType(), pressures, pressureUnit), (CoordinateSystem[])null, (Set[])null, rangeUnits);
            this.setSamples(rangeValues);
        }
    }
}

