/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.sounding;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import ucar.netcdf.Attribute;
import ucar.netcdf.NetcdfFile;
import ucar.netcdf.Variable;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.sounding.RAOB;
import ucar.unidata.data.sounding.SoundingAdapter;
import ucar.unidata.data.sounding.SoundingAdapterImpl;
import ucar.unidata.data.sounding.SoundingOb;
import ucar.unidata.data.sounding.SoundingStation;
import ucar.unidata.util.LogUtil;
import ucar.visad.quantities.CommonUnits;
import ucar.visad.quantities.GeopotentialAltitude;
import visad.DateTime;
import visad.Real;
import visad.RealType;
import visad.Unit;

public class NetcdfSoundingAdapter
extends SoundingAdapterImpl
implements SoundingAdapter {
    private String filename;
    private NetcdfFile nc = null;
    private int numStations;
    private String prMandPVar;
    private String htMandPVar;
    private String tpMandPVar;
    private String tdMandPVar;
    private String spdMandPVar;
    private String dirMandPVar;
    private String htMandWVar;
    private String spdMandWVar;
    private String dirMandWVar;
    private String prSigTVar;
    private String tpSigTVar;
    private String tdSigTVar;
    private String htSigWVar;
    private String spdSigWVar;
    private String dirSigWVar;
    private String prMaxWVar;
    private String spdMaxWVar;
    private String dirMaxWVar;
    private String prTropVar;
    private String tpTropVar;
    private String tdTropVar;
    private String spdTropVar;
    private String dirTropVar;
    private Variable stid;
    private Variable lat;
    private Variable lon;
    private Variable elev;
    private Variable time;
    private Variable numMandP;
    private Variable numMandW;
    private Variable numSigT;
    private Variable numSigW;
    private Variable numMaxW;
    private Variable numTrop;
    private boolean hasMandP = false;
    private boolean hasMandW = false;
    private boolean hasSigT = false;
    private boolean hasSigW = false;
    private boolean hasMaxW = false;
    private boolean hasTrop = false;
    private boolean oneTrop = false;
    private boolean dewpointIsDepression = true;
    private float missingValue = 99999.0f;
    private Unit timeUnit = null;
    private double timeFill = Double.NaN;
    private SoundingStation s;

    public NetcdfSoundingAdapter() {
        super("NetcdfSoundingAdapter");
    }

    public NetcdfSoundingAdapter(String filename) throws Exception {
        super("NetcdfSoundingAdapter");
        this.filename = filename;
        this.init();
    }

    public NetcdfSoundingAdapter(File file) throws Exception {
        this(file.getAbsolutePath());
    }

    @Override
    public void update() {
        try {
            this.haveInitialized = false;
            this.init();
        }
        catch (Exception exc) {
            LogUtil.logException("Doing update", exc);
        }
    }

    @Override
    protected void init() throws Exception {
        if (this.haveInitialized) {
            return;
        }
        super.init();
        try {
            URL url = new URL(this.filename);
            this.nc = new NetcdfFile(url);
        }
        catch (MalformedURLException e) {
            this.nc = new NetcdfFile(this.filename, true);
        }
        this.getVariables();
        this.numStations = this.stid.getLengths()[0];
        this.stations = new ArrayList(this.numStations);
        this.soundings = new ArrayList(this.numStations);
        this.times = new ArrayList(10);
        int[] index = new int[1];
        for (int i = 0; i < this.numStations; ++i) {
            DateTime sndTime;
            index[0] = i;
            try {
                this.makeSoundingStation(index);
                sndTime = this.getObsTime(index);
            }
            catch (Exception e) {
                continue;
            }
            if (sndTime == null) continue;
            this.makeSoundingOb(index, this.s, sndTime);
        }
        Collections.sort(this.times);
    }

    @Override
    public String getSource() {
        return this.filename;
    }

    @Override
    public void setSource(String s) {
        this.filename = s;
    }

    @Override
    public SoundingOb initSoundingOb(SoundingOb sound) {
        this.checkInit();
        if (!sound.hasData()) {
            int idx = this.soundings.indexOf(sound);
            if (idx < 0) {
                throw new IllegalArgumentException("SoundingAdapter does not contain sounding:" + sound);
            }
            this.setRAOBData(new int[]{idx}, sound);
        }
        return sound;
    }

    private void makeSoundingStation(int[] index) throws Exception {
        double elevvalue;
        double lonvalue;
        double latvalue;
        String wmoID;
        try {
            wmoID = Integer.toString(this.stid.getInt(index));
            latvalue = this.lat.getDouble(index);
            lonvalue = this.lon.getDouble(index);
            elevvalue = this.elev.getDouble(index);
        }
        catch (Exception ne) {
            throw new Exception(ne.toString());
        }
        this.s = new SoundingStation(wmoID, latvalue, lonvalue, elevvalue);
        this.stations.add(this.s);
    }

    private void makeSoundingOb(int[] index, SoundingStation station, DateTime sndTime) {
        this.soundings.add(new SoundingOb(station, sndTime));
        if (!this.times.contains(sndTime)) {
            this.times.add(sndTime);
        }
    }

    private void setRAOBData(int[] index, SoundingOb sound) {
        int i;
        float[] dir;
        float[] spd;
        float[] td;
        float[] t;
        float[] z;
        float[] p;
        float dirFill;
        Variable direct;
        float spdFill;
        Variable speed;
        float tdFill;
        Variable dewpt;
        float tpFill;
        Variable temp;
        float zFill;
        Variable height;
        float pFill;
        Variable press;
        int levFill;
        int numLevels;
        Unit pUnit = null;
        Unit tUnit = null;
        Unit tdUnit = null;
        Unit spdUnit = null;
        Unit dirUnit = null;
        Unit zUnit = null;
        int[] j = new int[2];
        j[0] = index[0];
        this.dbPrint("\nNew Station:\n\t" + sound.getStation());
        if (this.hasMandP) {
            try {
                numLevels = this.numMandP.getInt(index);
                levFill = (int)this.getFillValue(this.numMandP, this.missingValue);
                if (numLevels > 0 && numLevels != levFill) {
                    this.dbPrint("Num mand pressure levels = " + numLevels);
                    press = this.nc.get(this.prMandPVar);
                    pUnit = this.getUnit(press);
                    if (pUnit == null) {
                        pUnit = CommonUnits.MILLIBAR;
                    }
                    pFill = this.getFillValue(press, this.missingValue);
                    height = this.nc.get(this.htMandPVar);
                    zUnit = GeopotentialAltitude.getGeopotentialUnit(this.getUnit(height));
                    zFill = this.getFillValue(height, this.missingValue);
                    temp = this.nc.get(this.tpMandPVar);
                    tUnit = this.getUnit(temp);
                    tpFill = this.getFillValue(temp, this.missingValue);
                    dewpt = this.nc.get(this.tdMandPVar);
                    tdUnit = this.getUnit(dewpt);
                    tdFill = this.getFillValue(dewpt, this.missingValue);
                    speed = this.nc.get(this.spdMandPVar);
                    spdUnit = this.getUnit(speed);
                    spdFill = this.getFillValue(speed, this.missingValue);
                    direct = this.nc.get(this.dirMandPVar);
                    dirUnit = this.getUnit(direct);
                    dirFill = this.getFillValue(direct, this.missingValue);
                    p = new float[numLevels];
                    z = new float[numLevels];
                    t = new float[numLevels];
                    td = new float[numLevels];
                    spd = new float[numLevels];
                    dir = new float[numLevels];
                    for (i = 0; i < numLevels; ++i) {
                        j[1] = i;
                        p[i] = press.getFloat(j) == pFill ? Float.NaN : press.getFloat(j);
                        z[i] = height.getFloat(j) == zFill ? Float.NaN : height.getFloat(j);
                        float f = t[i] = temp.getFloat(j) == tpFill ? Float.NaN : temp.getFloat(j);
                        td[i] = dewpt.getFloat(j) == tdFill ? Float.NaN : (this.dewpointIsDepression ? t[i] - dewpt.getFloat(j) : dewpt.getFloat(j));
                        spd[i] = speed.getFloat(j) == spdFill ? Float.NaN : speed.getFloat(j);
                        dir[i] = direct.getFloat(j) == dirFill ? Float.NaN : direct.getFloat(j);
                    }
                    sound.getRAOB().setMandatoryPressureProfile(pUnit, p, tUnit, t, tdUnit, td, spdUnit, spd, dirUnit, dir, zUnit, z);
                } else if (this.debug) {
                    System.err.println("No mandatory pressure data found for this station");
                }
            }
            catch (Exception e) {
                LogUtil.logException("Unable to set mandatory pressure  data for station " + sound.getStation(), e);
            }
        }
        if (this.hasMandW) {
            try {
                numLevels = this.numMandW.getInt(index);
                levFill = (int)this.getFillValue(this.numMandW, this.missingValue);
                if (numLevels > 0 && numLevels != levFill) {
                    if (this.debug) {
                        System.err.println("Num mand wind levels = " + numLevels);
                    }
                    height = this.nc.get(this.htMandWVar);
                    zUnit = GeopotentialAltitude.getGeopotentialUnit(this.getUnit(height));
                    zFill = this.getFillValue(height, this.missingValue);
                    speed = this.nc.get(this.spdMandWVar);
                    spdUnit = this.getUnit(speed);
                    spdFill = this.getFillValue(speed, this.missingValue);
                    direct = this.nc.get(this.dirMandWVar);
                    dirUnit = this.getUnit(direct);
                    dirFill = this.getFillValue(direct, this.missingValue);
                    z = new float[numLevels];
                    spd = new float[numLevels];
                    dir = new float[numLevels];
                    for (i = 0; i < numLevels; ++i) {
                        j[1] = i;
                        z[i] = height.getFloat(j) == zFill ? Float.NaN : height.getFloat(j);
                        spd[i] = speed.getFloat(j) == spdFill ? Float.NaN : speed.getFloat(j);
                        dir[i] = direct.getFloat(j) == dirFill ? Float.NaN : direct.getFloat(j);
                    }
                    if (!this.allNaNs(z)) {
                        sound.getRAOB().setMandatoryWindProfile(zUnit, z, spdUnit, spd, dirUnit, dir);
                    }
                } else if (this.debug) {
                    System.err.println("No mandatory wind data found for this station");
                }
            }
            catch (Exception e) {
                LogUtil.logException("Unable to set mandatory wind data for station " + sound.getStation(), e);
            }
        }
        if (this.hasSigT) {
            try {
                numLevels = this.numSigT.getInt(index);
                levFill = (int)this.getFillValue(this.numSigT, this.missingValue);
                if (numLevels > 0 && numLevels != levFill) {
                    if (this.debug) {
                        System.err.println("Num sig temperature levels = " + numLevels);
                    }
                    if ((pUnit = this.getUnit(press = this.nc.get(this.prSigTVar))) == null) {
                        pUnit = CommonUnits.MILLIBAR;
                    }
                    pFill = this.getFillValue(press, this.missingValue);
                    temp = this.nc.get(this.tpSigTVar);
                    tUnit = this.getUnit(temp);
                    tpFill = this.getFillValue(temp, this.missingValue);
                    dewpt = this.nc.get(this.tdSigTVar);
                    tdUnit = this.getUnit(dewpt);
                    tdFill = this.getFillValue(dewpt, this.missingValue);
                    p = new float[numLevels];
                    t = new float[numLevels];
                    td = new float[numLevels];
                    for (i = 0; i < numLevels; ++i) {
                        j[1] = i;
                        p[i] = press.getFloat(j) == pFill ? Float.NaN : press.getFloat(j);
                        float f = t[i] = temp.getFloat(j) == tpFill ? Float.NaN : temp.getFloat(j);
                        td[i] = dewpt.getFloat(j) == tdFill ? Float.NaN : (this.dewpointIsDepression ? t[i] - dewpt.getFloat(j) : dewpt.getFloat(j));
                    }
                    if (!this.allNaNs(p)) {
                        sound.getRAOB().setSignificantTemperatureProfile(pUnit, p, tUnit, t, tdUnit, td);
                    }
                } else if (this.debug) {
                    System.err.println("No sig temperature data found for this station");
                }
            }
            catch (Exception e) {
                LogUtil.logException("Unable to set significant temperature data for station " + sound.getStation(), e);
            }
        }
        if (this.hasSigW) {
            try {
                numLevels = this.numSigW.getInt(index);
                levFill = (int)this.getFillValue(this.numSigW, this.missingValue);
                if (numLevels > 0 && numLevels != levFill) {
                    if (this.debug) {
                        System.err.println("Num significant wind levels = " + numLevels);
                    }
                    height = this.nc.get(this.htSigWVar);
                    zUnit = GeopotentialAltitude.getGeopotentialUnit(this.getUnit(height));
                    zFill = this.getFillValue(height, this.missingValue);
                    speed = this.nc.get(this.spdSigWVar);
                    spdUnit = this.getUnit(speed);
                    spdFill = this.getFillValue(speed, this.missingValue);
                    direct = this.nc.get(this.dirSigWVar);
                    dirUnit = this.getUnit(direct);
                    dirFill = this.getFillValue(direct, this.missingValue);
                    z = new float[numLevels];
                    spd = new float[numLevels];
                    dir = new float[numLevels];
                    for (i = 0; i < numLevels; ++i) {
                        j[1] = i;
                        z[i] = height.getFloat(j) == zFill ? Float.NaN : height.getFloat(j);
                        spd[i] = speed.getFloat(j) == spdFill ? Float.NaN : speed.getFloat(j);
                        dir[i] = direct.getFloat(j) == dirFill ? Float.NaN : direct.getFloat(j);
                    }
                    if (!this.allNaNs(z)) {
                        sound.getRAOB().setSignificantWindProfile(zUnit, z, spdUnit, spd, dirUnit, dir);
                    }
                } else {
                    this.dbPrint("No significant wind data found for this station");
                }
            }
            catch (Exception e) {
                LogUtil.logException("Unable to set significant wind data for station " + sound.getStation(), e);
            }
        }
        if (this.hasMaxW) {
            boolean multiLevel = false;
            try {
                numLevels = this.numMaxW.getInt(index);
                levFill = (int)this.getFillValue(this.numMaxW, this.missingValue);
                if (numLevels > 0 && numLevels != levFill) {
                    if (this.debug) {
                        System.err.println("Num max wind levels = " + numLevels);
                    }
                    if ((press = this.nc.get(this.prMaxWVar)).getRank() > 1) {
                        multiLevel = true;
                    }
                    if ((pUnit = this.getUnit(press)) == null) {
                        pUnit = CommonUnits.MILLIBAR;
                    }
                    pFill = this.getFillValue(press, this.missingValue);
                    speed = this.nc.get(this.spdMaxWVar);
                    spdUnit = this.getUnit(speed);
                    spdFill = this.getFillValue(speed, this.missingValue);
                    direct = this.nc.get(this.dirMaxWVar);
                    dirUnit = this.getUnit(direct);
                    dirFill = this.getFillValue(direct, this.missingValue);
                    p = new float[numLevels];
                    spd = new float[numLevels];
                    dir = new float[numLevels];
                    if (!multiLevel) {
                        j = new int[]{index[0]};
                    }
                    for (i = 0; i < numLevels; ++i) {
                        if (multiLevel) {
                            j[1] = i;
                        }
                        p[i] = press.getFloat(j) == pFill ? Float.NaN : press.getFloat(j);
                        spd[i] = speed.getFloat(j) == spdFill ? Float.NaN : speed.getFloat(j);
                        dir[i] = direct.getFloat(j) == dirFill ? Float.NaN : direct.getFloat(j);
                    }
                    if (!this.allNaNs(p)) {
                        sound.getRAOB().setMaximumWindProfile(pUnit, p, spdUnit, spd, dirUnit, dir);
                    }
                } else if (this.debug) {
                    System.err.println("No maximum wind data found for this station");
                }
            }
            catch (Exception e) {
                LogUtil.logException("Unable to set maximum wind data for station " + sound.getStation(), e);
            }
        }
        if (this.hasTrop) {
            try {
                numLevels = this.oneTrop ? 1 : this.numTrop.getInt(index);
                int n = levFill = this.oneTrop ? (int)this.missingValue : (int)this.getFillValue(this.numTrop, this.missingValue);
                if (numLevels > 0 && numLevels != levFill) {
                    if (this.debug) {
                        System.err.println("Num tropopause levels = " + numLevels);
                    }
                    if ((pUnit = this.getUnit(press = this.nc.get(this.prTropVar))) == null) {
                        pUnit = CommonUnits.MILLIBAR;
                    }
                    pFill = this.getFillValue(press, this.missingValue);
                    temp = this.nc.get(this.tpTropVar);
                    tUnit = this.getUnit(temp);
                    tpFill = this.getFillValue(temp, this.missingValue);
                    dewpt = this.nc.get(this.tdTropVar);
                    tdUnit = this.getUnit(dewpt);
                    tdFill = this.getFillValue(dewpt, this.missingValue);
                    speed = this.nc.get(this.spdTropVar);
                    spdUnit = this.getUnit(speed);
                    spdFill = this.getFillValue(speed, this.missingValue);
                    direct = this.nc.get(this.dirTropVar);
                    dirUnit = this.getUnit(direct);
                    dirFill = this.getFillValue(direct, this.missingValue);
                    p = new float[numLevels];
                    t = new float[numLevels];
                    td = new float[numLevels];
                    spd = new float[numLevels];
                    dir = new float[numLevels];
                    if (this.oneTrop) {
                        j = new int[]{index[0]};
                    }
                    if (!this.oneTrop || this.oneTrop && press.getFloat(j) != pFill) {
                        for (i = 0; i < numLevels; ++i) {
                            if (!this.oneTrop) {
                                j[1] = i;
                            }
                            p[i] = press.getFloat(j) == pFill ? Float.NaN : press.getFloat(j);
                            float f = t[i] = temp.getFloat(j) == tpFill ? Float.NaN : temp.getFloat(j);
                            td[i] = dewpt.getFloat(j) == tdFill ? Float.NaN : (this.dewpointIsDepression ? t[i] - dewpt.getFloat(j) : dewpt.getFloat(j));
                            spd[i] = speed.getFloat(j) == spdFill ? Float.NaN : speed.getFloat(j);
                            dir[i] = direct.getFloat(j) == dirFill ? Float.NaN : direct.getFloat(j);
                        }
                        if (!this.allNaNs(p)) {
                            sound.getRAOB().setTropopauseProfile(RAOB.newTropopauseProfile(pUnit, p, tUnit, t, tdUnit, td, spdUnit, spd, dirUnit, dir));
                        }
                    }
                } else if (this.debug) {
                    System.err.println("No tropopause data found for this station");
                }
            }
            catch (Exception e) {
                LogUtil.logException("Unable to set tropopause data for station " + sound.getStation(), e);
            }
        }
    }

    private DateTime getObsTime(int[] index) {
        try {
            if (this.timeUnit == null) {
                Attribute a;
                this.timeUnit = this.getUnit(this.time);
                if (this.timeUnit == null) {
                    this.timeUnit = RealType.Time.getDefaultUnit();
                }
                if ((a = this.time.getAttribute("_FillValue")) != null) {
                    this.timeFill = a.getNumericValue().doubleValue();
                }
            }
        }
        catch (Exception ve) {
            this.timeUnit = RealType.Time.getDefaultUnit();
            this.timeFill = Double.NaN;
        }
        try {
            double val = this.time.getDouble(index);
            return Double.doubleToLongBits(val) == Double.doubleToLongBits(this.timeFill) ? (DateTime)null : (this.timeUnit == null ? new DateTime(val) : new DateTime(new Real(RealType.Time, val, this.timeUnit)));
        }
        catch (Exception ne) {
            LogUtil.logException("getObsTime", ne);
            return null;
        }
    }

    protected String getDflt(String name, String dflt) {
        return this.getDflt("NetcdfSoundingAdapter.", name, dflt);
    }

    private void getVariables() throws Exception {
        String idVar = this.getDflt("stationIDVariable", "wmoStaNum");
        Attribute a = this.nc.getAttribute("timeVariables");
        String timeVar = a != null ? a.getStringValue() : this.getDflt("soundingTimeVariable", "relTime");
        Attribute version = this.nc.getAttribute("version");
        if (version != null && version.getStringValue().indexOf("Forecast Systems Lab 1.3") >= 0) {
            idVar = "wmoStat";
            timeVar = "synTime";
        }
        this.stid = this.nc.get(idVar);
        if (this.stid == null) {
            throw new Exception("Unable to find station id variable");
        }
        this.lat = this.nc.get(this.getDflt("latitudeVariable", "staLat"));
        if (this.lat == null) {
            throw new Exception("Unable to find latitude variable");
        }
        this.lon = this.nc.get(this.getDflt("longitudeVariable", "staLon"));
        if (this.lon == null) {
            throw new Exception("Unable to find longitude variable");
        }
        this.elev = this.nc.get(this.getDflt("stationElevVariable", "staElev"));
        if (this.elev == null) {
            throw new Exception("Unable to find station elevation variable");
        }
        this.time = this.nc.get(timeVar);
        if (this.time == null) {
            throw new Exception("Unable to find sounding time variable");
        }
        this.numMandP = this.nc.get(this.getDflt("numMandPresLevels", "numMand"));
        if (this.numMandP != null) {
            this.hasMandP = true;
            this.prMandPVar = this.getDflt("mandPPressureVariable", "prMan");
            this.htMandPVar = this.getDflt("mandPHeightVariable", "htMan");
            this.tpMandPVar = this.getDflt("mandPTempVariable", "tpMan");
            this.tdMandPVar = this.getDflt("mandPDewptVariable", "tdMan");
            this.spdMandPVar = this.getDflt("mandPWindSpeedVariable", "wsMan");
            this.dirMandPVar = this.getDflt("mandPWindDirVariable", "wdMan");
        }
        this.numMandW = this.nc.get(this.getDflt("numMandWindLevels", "numMandW"));
        if (this.numMandW != null) {
            this.hasMandW = true;
            this.htMandWVar = this.getDflt("mandWHeightVariable", "htMandW");
            this.spdMandWVar = this.getDflt("mandWWindSpeedVariable", "wsMandW");
            this.dirMandWVar = this.getDflt("mandWWindDirVariable", "wdMandW");
        }
        this.numSigT = this.nc.get(this.getDflt("numSigTempLevels", "numSigT"));
        if (this.numSigT != null) {
            this.hasSigT = true;
            this.prSigTVar = this.getDflt("sigTPressureVariable", "prSigT");
            this.tpSigTVar = this.getDflt("sigTTempVariable", "tpSigT");
            this.tdSigTVar = this.getDflt("sigTDewptVariable", "tdSigT");
        }
        this.numSigW = this.nc.get(this.getDflt("numSigWindLevels", "numSigW"));
        if (this.numSigW != null) {
            this.hasSigW = true;
            this.htSigWVar = this.getDflt("sigWHeightVariable", "htSigW");
            this.spdSigWVar = this.getDflt("sigWWindSpeedVariable", "wsSigW");
            this.dirSigWVar = this.getDflt("sigWWindDirVariable", "wdSigW");
        }
        this.numMaxW = this.nc.get(this.getDflt("numMaxWindLevels", "numMwnd"));
        if (this.numMaxW != null) {
            this.hasMaxW = true;
            this.prMaxWVar = this.getDflt("maxWPressureVariable", "prMaxW");
            this.spdMaxWVar = this.getDflt("maxWWindSpeedVariable", "wsMaxW");
            this.dirMaxWVar = this.getDflt("maxWWindDirVariable", "wdMaxW");
        }
        this.numTrop = this.nc.get(this.getDflt("numTropLevels", "numTrop"));
        if (this.numTrop == null) {
            if (this.nc.contains(this.getDflt("prTropName", "prTrop"))) {
                this.hasTrop = true;
                this.oneTrop = true;
            }
        } else {
            this.hasTrop = true;
        }
        if (this.hasTrop) {
            this.prTropVar = this.getDflt("tropPressureVariable", "prTrop");
            this.tpTropVar = this.getDflt("tropTempVariable", "tpTrop");
            this.tdTropVar = this.getDflt("tropDewptVariable", "tdTrop");
            this.spdTropVar = this.getDflt("tropWindSpeedVariable", "wsTrop");
            this.dirTropVar = this.getDflt("tropWindDirVariable", "wdTrop");
        }
        this.dewpointIsDepression = Boolean.valueOf(this.getDflt("dewpointIsDepression", "true"));
        try {
            this.missingValue = Float.parseFloat(this.getDflt("missingValue", "99999"));
        }
        catch (NumberFormatException excp) {
            this.missingValue = 99999.0f;
        }
    }

    private Unit getUnit(Variable v) {
        Unit u = null;
        Attribute a = v.getAttribute("units");
        if (a != null) {
            u = DataUtil.parseUnit(a.getStringValue());
        }
        return u;
    }

    private float getFillValue(Variable v, float defaultValue) {
        Attribute a = v.getAttribute("_FillValue");
        return a == null ? defaultValue : a.getNumericValue().floatValue();
    }

    private boolean allNaNs(float[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (Float.isNaN(values[i])) continue;
            return false;
        }
        return true;
    }
}

