/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.sounding;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import ucar.unidata.data.sounding.Link;

public class LinkSet {
    private final Map end1Map = new TreeMap();
    private final Map end2Map = new TreeMap();

    public LinkSet(Link[] links) {
        for (int i = 0; i < links.length; ++i) {
            Link link = links[i];
            Link.End end1 = link.getFirstEnd();
            Link.End end2 = link.getSecondEnd();
            LinkSet.add(this.end1Map, end1, end2);
            LinkSet.add(this.end2Map, end2, end1);
        }
    }

    protected static void add(Map map, Link.End key, Link.End other) {
        TreeSet<Link.End> endSet = (TreeSet<Link.End>)map.get(key);
        if (endSet == null) {
            endSet = new TreeSet<Link.End>();
        }
        endSet.add(other);
        map.put(key, endSet);
    }

    public Iterator FirstEndIterator() {
        return new EndIterator(this.end1Map);
    }

    public Iterator SecondEndIterator() {
        return new EndIterator(this.end2Map);
    }

    protected static class EndIterator
    implements Iterator {
        private final Iterator iter;

        public EndIterator(Map map) {
            this.iter = map.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            return (Map.Entry)this.iter.next();
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Can't remove");
        }
    }
}

