/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.sounding;

import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.List;
import javax.swing.AbstractAction;
import ucar.ma2.Range;
import ucar.unidata.data.BadDataException;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.VarInfo;
import ucar.unidata.data.sounding.TrackAdapter;
import ucar.unidata.data.sounding.TrackDataSource;
import ucar.unidata.data.sounding.TrackInfo;
import ucar.unidata.sql.SqlUtil;
import ucar.unidata.util.DateUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import visad.DateTime;
import visad.Unit;

public class EolDbTrackAdapter
extends TrackAdapter {
    public static final String TABLE_GLOBALS = "global_attributes";
    public static final String TABLE_VARIABLE_LIST = "variable_list";
    public static final String TABLE_CATEGORIES = "categories";
    public static final String TABLE_DATA = "raf_lrt";
    public static final String COL_VARIABLE = "variable";
    public static final String COL_CATEGORY = "category";
    public static final String COL_NAME = "name";
    public static final String COL_LONG_NAME = "long_name";
    public static final String COL_UNITS = "units";
    public static final String COL_MISSING_VALUE = "missing_value";
    public static final String GLOBAL_PROJECTNAME = "ProjectName";
    public static final String GLOBAL_FLIGHTNUMBER = "FlightNumber";
    public static final String GLOBAL_COORDINATES = "coordinates";
    public static final String GLOBAL_STARTTIME = "StartTime";
    public static final String GLOBAL_ENDTIME = "EndTime";
    private Connection connection;
    private String url;
    private String name;
    private String description;
    private Hashtable globals;
    private Hashtable missingMap;

    public EolDbTrackAdapter(TrackDataSource dataSource, String filename, Hashtable pointDataFilter, int stride, int lastNMinutes) throws Exception {
        super(dataSource, filename, pointDataFilter, stride, lastNMinutes);
        Class.forName("org.postgresql.Driver");
        if (!this.initConnection()) {
            dataSource.setInError(true, false, "");
        }
    }

    @Override
    protected void addActions(List actions) {
        AbstractAction a = new AbstractAction("Show Sql Shell"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                EolDbTrackAdapter.this.dataSource.showSqlShell();
            }
        };
        actions.add(a);
    }

    @Override
    public String getDataSourceName() {
        return this.name;
    }

    @Override
    public String getDataSourceDescription() {
        return this.description;
    }

    public Connection getConnection() {
        if (this.connection != null) {
            return this.connection;
        }
        String url = this.getFilename();
        if ((this.dataSource.getUserName() == null || this.dataSource.getUserName().trim().length() == 0) && url.indexOf("?") >= 0) {
            int idx = url.indexOf("?");
            List<String> args = StringUtil.split(url.substring(idx + 1), "&", true, true);
            url = url.substring(0, idx);
            for (String tok : args) {
                List<String> subtoks = StringUtil.split(tok, "=", true, true);
                if (subtoks.size() != 2) continue;
                String name = subtoks.get(0);
                String value = subtoks.get(1);
                if (name.equals("user")) {
                    this.dataSource.setUserName(value);
                    continue;
                }
                if (!name.equals("password")) continue;
                this.dataSource.setPassword(value);
            }
        }
        int cnt = 0;
        while (true) {
            String userName = this.dataSource.getUserName();
            String password = this.dataSource.getPassword();
            if (userName == null) {
                userName = "";
            }
            if (password == null) {
                password = "";
            }
            try {
                this.connection = DriverManager.getConnection(url, userName, password);
                return this.connection;
            }
            catch (SQLException sqe) {
                if (sqe.toString().indexOf("role \"" + userName + "\" does not exist") >= 0 || sqe.toString().indexOf("user name specified") >= 0) {
                    String label = cnt == 0 ? "<html>The database requires a login.<br>Please enter a user name and password:</html>" : "<html>Incorrect username/password. Please try again.</html>";
                    if (!this.dataSource.showPasswordDialog("Database Login", label)) {
                        return null;
                    }
                    ++cnt;
                    continue;
                }
                throw new BadDataException("Unable to connect to database", sqe);
            }
            break;
        }
    }

    private Statement select(String what, String where, String extra) throws SQLException {
        return this.evaluate(SqlUtil.makeSelect(what, Misc.newList(where), extra));
    }

    private Statement select(String what, String where) throws SQLException {
        return this.evaluate(SqlUtil.makeSelect(what, Misc.newList(where)));
    }

    private Statement evaluate(String sql) throws SQLException {
        System.err.println("EVAL: " + sql);
        Statement stmt = this.getConnection().createStatement();
        stmt.execute(sql);
        return stmt;
    }

    private boolean initConnection() throws Exception {
        ResultSet results;
        SqlUtil.Iterator iter;
        Statement stmt;
        if (this.getConnection() == null) {
            return false;
        }
        EolDbTrackInfo trackInfo = new EolDbTrackInfo(this, "TRACK");
        Hashtable<String, String> cats = new Hashtable<String, String>();
        try {
            stmt = this.select("*", TABLE_CATEGORIES);
            iter = SqlUtil.getIterator(stmt);
            while ((results = iter.getNext()) != null) {
                cats.put(results.getString(COL_VARIABLE), results.getString(COL_CATEGORY));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.missingMap = new Hashtable();
        stmt = this.select("*", TABLE_GLOBALS);
        this.globals = new Hashtable();
        boolean gotCoords = false;
        this.description = "<b>Globals</b><br>";
        iter = SqlUtil.getIterator(stmt);
        while ((results = iter.getNext()) != null) {
            String globalName = results.getString(1).trim();
            String globalValue = results.getString(2).trim();
            this.globals.put(globalName, globalValue);
            this.description = this.description + "<tr valign=\"top\"><td>" + globalName + "</td><td>" + globalValue + "</td></tr>";
            if (globalName.equals(GLOBAL_STARTTIME)) {
                this.startTime = new DateTime(DateUtil.parse(globalValue));
                continue;
            }
            if (globalName.equals(GLOBAL_ENDTIME)) {
                this.endTime = new DateTime(DateUtil.parse(globalValue));
                continue;
            }
            if (!globalName.equals(GLOBAL_COORDINATES)) continue;
            List<String> toks = StringUtil.split(globalValue, " ", true, true);
            if (toks.size() != 4) {
                throw new BadDataException("Incorrect coordinates value in database:" + globalValue);
            }
            gotCoords = true;
            System.err.println("coords:" + toks);
            trackInfo.setCoordinateVars(toks.get(0), toks.get(1), toks.get(2), toks.get(3));
            trackInfo.setCoordinateVars("GGLON", "GGLAT", "GGALT", "datetime");
        }
        this.description = this.description + "</table>";
        if (!gotCoords) {
            throw new BadDataException("No coordinates found in database");
        }
        this.name = (String)this.globals.get(GLOBAL_PROJECTNAME);
        String flight = (String)this.globals.get(GLOBAL_FLIGHTNUMBER);
        if (this.name != null && flight != null && flight.length() != 0) {
            this.name = this.name + " - " + flight;
        }
        stmt = this.select("*", TABLE_VARIABLE_LIST);
        iter = SqlUtil.getIterator(stmt);
        while ((results = iter.getNext()) != null) {
            String name = results.getString(COL_NAME).trim();
            String desc = results.getString(COL_LONG_NAME).trim();
            Unit unit = DataUtil.parseUnit(results.getString(COL_UNITS).trim());
            String cat = (String)cats.get(name);
            double missing = results.getDouble(COL_MISSING_VALUE);
            VarInfo variable = new VarInfo(name, desc, cat, unit, missing);
            trackInfo.addVariable(variable);
        }
        this.addTrackInfo(trackInfo);
        return true;
    }

    protected double getMissingValue(String var) {
        Double d = (Double)this.missingMap.get(var);
        if (d != null) {
            return d;
        }
        return Double.NaN;
    }

    public class EolDbTrackInfo
    extends TrackInfo {
        private int numberOfPoints;

        public EolDbTrackInfo(EolDbTrackAdapter adapter, String trackName) throws Exception {
            super(adapter, trackName);
            this.numberOfPoints = -1;
        }

        @Override
        public int getNumberPoints() throws Exception {
            if (this.numberOfPoints < 0) {
                ResultSet results;
                Statement stmt = EolDbTrackAdapter.this.select("COUNT(" + this.varTime + ")", EolDbTrackAdapter.TABLE_DATA);
                int cnt = 0;
                SqlUtil.Iterator iter = SqlUtil.getIterator(stmt);
                while ((results = iter.getNext()) != null) {
                    ++cnt;
                }
                this.numberOfPoints = cnt;
            }
            return this.numberOfPoints;
        }

        @Override
        public DateTime getStartTime() {
            return EolDbTrackAdapter.this.getStartTime();
        }

        @Override
        public DateTime getEndTime() {
            return EolDbTrackAdapter.this.getEndTime();
        }

        @Override
        protected double[] getDoubleData(Range range, String var) throws Exception {
            double[] d = SqlUtil.readDouble(SqlUtil.getIterator(EolDbTrackAdapter.this.select(var, EolDbTrackAdapter.TABLE_DATA, "order by " + this.varTime)), 1, EolDbTrackAdapter.this.getMissingValue(var));
            if (d.length == 0) {
                throw new BadDataException("No observations found in data base");
            }
            return d;
        }

        @Override
        protected double[] getTime(Range range) throws Exception {
            String[] s = this.getStringData(range, this.varTime);
            if (s.length == 0) {
                throw new BadDataException("No times found in data base");
            }
            return DateUtil.toSeconds(s);
        }

        @Override
        protected float[] getFloatData(Range range, String var) throws Exception {
            long t1 = System.currentTimeMillis();
            float[] f = SqlUtil.readFloat(SqlUtil.getIterator(EolDbTrackAdapter.this.select("(" + var + ")", EolDbTrackAdapter.TABLE_DATA, "order by " + this.varTime)), 1, (float)EolDbTrackAdapter.this.getMissingValue(var));
            long t2 = System.currentTimeMillis();
            if (f.length == 0) {
                throw new BadDataException("No observations found in data base");
            }
            return f;
        }

        @Override
        protected String[] getStringData(Range range, String var) throws Exception {
            return SqlUtil.readString(SqlUtil.getIterator(EolDbTrackAdapter.this.select(var, EolDbTrackAdapter.TABLE_DATA, "order by " + this.varTime)), 1);
        }
    }
}

