/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.sounding;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import ucar.unidata.data.BadDataException;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.point.PointDataSource;
import ucar.unidata.data.point.PointObTuple;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.sql.SqlUtil;
import ucar.unidata.util.DateUtil;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import visad.Data;
import visad.DateTime;
import visad.DoubleStringTuple;
import visad.FieldImpl;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.MathType;
import visad.Real;
import visad.RealType;
import visad.SetType;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;
import visad.georef.EarthLocationLite;

public class DbTrajectoryDataSource
extends PointDataSource {
    public static final GregorianCalendar calendar = new GregorianCalendar(DateUtil.TIMEZONE_GMT);
    private String tableName = "typhoon";
    private String timeColumn = "time";
    private String latitudeColumn = "lat";
    private String longitudeColumn = "lon";
    private String altitudeColumn = "altitude";
    private String yearColumn = "yyyy";
    private String monthColumn = "mm";
    private String dayColumn = "day";
    private String hourColumn = "hh";
    private String dbUrl = "jdbc:derby:test;create=true";
    private Connection connection;
    private String fromDate = "-1 year";
    private String toDate = "now";

    public DbTrajectoryDataSource() throws VisADException {
        this.init();
    }

    public DbTrajectoryDataSource(DataSourceDescriptor descriptor, String source, Hashtable properties) throws Exception {
        super(descriptor, source, "Db Point Data", properties);
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
        if (!this.initConnection()) {
            this.setInError(true, false, "");
        }
    }

    public Connection getConnection() {
        if (this.connection != null) {
            return this.connection;
        }
        String url = this.dbUrl;
        if ((this.getUserName() == null || this.getUserName().trim().length() == 0) && url.indexOf("?") >= 0) {
            int idx = url.indexOf("?");
            List<String> args = StringUtil.split(url.substring(idx + 1), "&", true, true);
            url = url.substring(0, idx);
            for (String tok : args) {
                List<String> subtoks = StringUtil.split(tok, "=", true, true);
                if (subtoks.size() != 2) continue;
                String name = subtoks.get(0);
                String value = subtoks.get(1);
                if (name.equals("user")) {
                    this.setUserName(value);
                    continue;
                }
                if (!name.equals("password")) continue;
                this.setPassword(value);
            }
        }
        int cnt = 0;
        while (true) {
            String userName = this.getUserName();
            String password = this.getPassword();
            if (userName == null) {
                userName = "";
            }
            if (password == null) {
                password = "";
            }
            try {
                this.connection = DriverManager.getConnection(url, userName, password);
                return this.connection;
            }
            catch (SQLException sqe) {
                if (sqe.toString().indexOf("role \"" + userName + "\" does not exist") >= 0 || sqe.toString().indexOf("user name specified") >= 0) {
                    String label = cnt == 0 ? "<html>The database requires a login.<br>Please enter a user name and password:</html>" : "<html>Incorrect username/password. Please try again.</html>";
                    if (!this.showPasswordDialog("Database Login", label)) {
                        return null;
                    }
                    ++cnt;
                    continue;
                }
                throw new BadDataException("Unable to connect to database", sqe);
            }
            break;
        }
    }

    private boolean initConnection() throws Exception {
        if (this.getConnection() == null) {
            return false;
        }
        try {
            Connection connection = this.getConnection();
            Statement stmt = connection.createStatement();
            SqlUtil.loadSql("drop table " + this.tableName, stmt, true);
            System.err.println("Creating test database");
            String initSql = IOUtil.readContents("/ucar/unidata/data/sounding/typhoon.sql", this.getClass());
            connection.setAutoCommit(false);
            SqlUtil.loadSql(initSql, stmt, false);
            connection.commit();
            connection.setAutoCommit(true);
            System.err.println("OK");
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    protected FieldImpl makeObs(DataChoice dataChoice, DataSelection subset, LatLonRect bbox) throws Exception {
        ResultSet results;
        String columns = this.yearColumn + "," + this.monthColumn + "," + this.dayColumn + "," + this.hourColumn + "," + this.latitudeColumn + "," + this.longitudeColumn + "," + "wind,pressure,way";
        Date[] dateRange = DateUtil.getDateRange(this.fromDate, this.toDate, new Date());
        ArrayList whereList = new ArrayList();
        if (dateRange[0] != null) {
            // empty if block
        }
        if (dateRange[1] != null) {
            // empty if block
        }
        String query = SqlUtil.makeSelect(columns, Misc.newList(this.tableName), SqlUtil.makeAnd(whereList));
        Statement statement = this.evaluate(query);
        SqlUtil.Iterator iter = SqlUtil.getIterator(statement);
        String[] units = new String[]{"m/s", "hpa"};
        String[] numericNames = new String[]{"windspeed", "pressure"};
        ArrayList<RealType> numericTypes = new ArrayList<RealType>();
        ArrayList<Unit> numericUnits = new ArrayList<Unit>();
        for (int i = 0; i < numericNames.length; ++i) {
            Unit unit = DataUtil.parseUnit(units[i]);
            numericTypes.add(DataUtil.makeRealType(numericNames[i], unit));
            numericUnits.add(unit);
        }
        Unit[] allUnits = numericUnits.toArray(new Unit[numericUnits.size()]);
        ArrayList<TextType> stringTypes = new ArrayList<TextType>();
        stringTypes.add(TextType.getTextType("Station"));
        TupleType allTupleType = DoubleStringTuple.makeTupleType(numericTypes, stringTypes);
        TupleType finalTT = null;
        ArrayList<PointObTuple> obs = new ArrayList<PointObTuple>();
        int cnt = 0;
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.setTimeZone(DateUtil.TIMEZONE_GMT);
        sdf.applyPattern("yyyy/MM/dd HH");
        while ((results = iter.getNext()) != null) {
            PointObTuple pot;
            ++cnt;
            int col = 1;
            int year = results.getInt(col++);
            int month = results.getInt(col++);
            int day = results.getInt(col++);
            int hour = results.getInt(col++);
            double latitude = results.getDouble(col++);
            double longitude = results.getDouble(col++);
            double altitude = 0.0;
            EarthLocationLite elt = new EarthLocationLite(new Real(RealType.Latitude, latitude), new Real(RealType.Longitude, longitude), new Real(RealType.Altitude, altitude));
            Date date = sdf.parse(year + "/" + month + "/" + day + " " + hour);
            DateTime dttm = new DateTime(date);
            double windSpeed = results.getDouble(col++);
            double pressure = results.getDouble(col++);
            String way = results.getString(col++);
            double[] realArray = new double[]{windSpeed, pressure};
            String[] stringArray = new String[]{way};
            DoubleStringTuple tuple = new DoubleStringTuple(allTupleType, realArray, stringArray, allUnits);
            if (finalTT == null) {
                pot = new PointObTuple(elt, dttm, tuple);
                finalTT = Tuple.buildTupleType(pot.getComponents());
            } else {
                pot = new PointObTuple(elt, dttm, tuple, finalTT, false);
            }
            obs.add(pot);
        }
        Integer1DSet indexSet = new Integer1DSet((MathType)RealType.getRealType("index"), obs.size());
        FieldImpl retField = new FieldImpl(new FunctionType(((SetType)indexSet.getType()).getDomain(), ((PointObTuple)obs.get(0)).getType()), indexSet);
        Data[] obsArray = obs.toArray(new Data[obs.size()]);
        retField.setSamples(obsArray, false, false);
        return retField;
    }

    @Override
    public void getPropertiesComponents(List comps) {
        super.getPropertiesComponents(comps);
        comps.add(GuiUtils.filler());
        comps.add(this.getPropertiesHeader("Database"));
    }

    @Override
    public boolean applyProperties() {
        return super.applyProperties();
    }

    private Statement evaluate(String sql) throws SQLException {
        Statement stmt = this.getConnection().createStatement();
        stmt.execute(sql);
        return stmt;
    }
}

