/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.sounding;

import java.io.IOException;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dt.TypedDataset;
import ucar.nc2.dt.TypedDatasetFactoryIF;
import ucar.nc2.dt.trajectory.SingleTrajectoryObsDataset;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.util.CancelTask;

public class CosmicTrajectoryObsDataset
extends SingleTrajectoryObsDataset
implements TypedDatasetFactoryIF {
    private static String timeDimName = "MSL_alt";
    private static String timeVarName = "Time";
    private static String latVarName = "Lat";
    private static String lonVarName = "Lon";
    private static String elevVarName = "MSL_alt";
    private static String trajId = "COSMIC sounding";

    public static boolean isValidFile(NetcdfDataset ncd) {
        Attribute attrib = ncd.findGlobalAttributeIgnoreCase("center");
        if (attrib == null) {
            return false;
        }
        if (!attrib.isString()) {
            return false;
        }
        return attrib.getStringValue().equals("UCAR/CDAAC");
    }

    private static SingleTrajectoryObsDataset.Config buildConfig(NetcdfDataset ncd) {
        Attribute attrib = ncd.findGlobalAttributeIgnoreCase("center");
        if (attrib == null) {
            return null;
        }
        if (!attrib.isString()) {
            return null;
        }
        if (!attrib.getStringValue().equals("UCAR/CDAAC")) {
            return null;
        }
        attrib = ncd.findGlobalAttributeIgnoreCase("start_time");
        if (attrib == null) {
            return null;
        }
        if (attrib.isString()) {
            return null;
        }
        double startTime = attrib.getNumericValue().doubleValue();
        attrib = ncd.findGlobalAttributeIgnoreCase("stop_time");
        if (attrib == null) {
            return null;
        }
        if (attrib.isString()) {
            return null;
        }
        double endTime = attrib.getNumericValue().doubleValue();
        List list = ncd.getRootGroup().getDimensions();
        if (list.size() != 1) {
            return null;
        }
        Dimension d = list.get(0);
        if (!d.getName().equals(timeDimName)) {
            return null;
        }
        SingleTrajectoryObsDataset.Config trajConfig = new SingleTrajectoryObsDataset.Config();
        trajConfig.setTimeDim(d);
        Variable var = ncd.getRootGroup().findVariable(latVarName);
        if (var == null) {
            return null;
        }
        list = var.getDimensions();
        if (list.size() != 1) {
            return null;
        }
        d = (Dimension)list.get(0);
        if (!d.getName().equals(timeDimName)) {
            return null;
        }
        String units = var.findAttribute("units").getStringValue();
        if (!SimpleUnit.isCompatible(units, "degrees_north")) {
            return null;
        }
        trajConfig.setLatVar(var);
        int numTimes = d.getLength();
        double[] times = new double[numTimes];
        VariableDS timeVar = new VariableDS(ncd, ncd.getRootGroup(), null, timeVarName, DataType.DOUBLE, timeDimName, "seconds since 1980-01-06 00:00:00", "Time coordinate");
        timeVar.setCachedData(Array.makeArray(DataType.DOUBLE, numTimes, endTime, (startTime - endTime) / (double)numTimes), true);
        ncd.addVariable(ncd.getRootGroup(), timeVar);
        trajConfig.setTimeVar(timeVar);
        var = ncd.getRootGroup().findVariable(lonVarName);
        if (var == null) {
            return null;
        }
        list = var.getDimensions();
        if (list.size() != 1) {
            return null;
        }
        d = (Dimension)list.get(0);
        if (!d.getName().equals(timeDimName)) {
            return null;
        }
        units = var.findAttribute("units").getStringValue();
        if (!SimpleUnit.isCompatible(units, "degrees_east")) {
            return null;
        }
        trajConfig.setLonVar(var);
        var = ncd.getRootGroup().findVariable(elevVarName);
        if (var == null) {
            return null;
        }
        list = var.getDimensions();
        if (list.size() != 1) {
            return null;
        }
        d = (Dimension)list.get(0);
        if (!d.getName().equals(timeDimName)) {
            return null;
        }
        units = var.findAttribute("units").getStringValue();
        if (!SimpleUnit.isCompatible(units, "meters")) {
            return null;
        }
        trajConfig.setElevVar(var);
        trajConfig.setTrajectoryId(trajId);
        return trajConfig;
    }

    @Override
    public boolean isMine(NetcdfDataset ds) {
        return CosmicTrajectoryObsDataset.isValidFile(ds);
    }

    @Override
    public TypedDataset open(NetcdfDataset ncd, CancelTask task, StringBuilder errlog) throws IOException {
        return new CosmicTrajectoryObsDataset(ncd);
    }

    @Override
    public FeatureType getScientificDataType() {
        return FeatureType.TRAJECTORY;
    }

    public CosmicTrajectoryObsDataset() {
    }

    public CosmicTrajectoryObsDataset(NetcdfDataset ncd) throws IOException {
        super(ncd);
        SingleTrajectoryObsDataset.Config trajConfig = CosmicTrajectoryObsDataset.buildConfig(ncd);
        this.setTrajectoryInfo(trajConfig);
    }
}

