/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.sounding;

import java.util.ArrayList;
import java.util.List;
import ucar.ma2.DataType;
import ucar.ma2.Index0D;
import ucar.ma2.Range;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.TrajectoryFeature;
import ucar.nc2.ft.TrajectoryFeatureCollection;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.VarInfo;
import ucar.unidata.data.point.PointObTuple;
import ucar.unidata.data.sounding.TrackAdapter;
import ucar.unidata.data.sounding.TrackInfo;
import ucar.unidata.util.JobManager;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Trace;
import ucar.visad.Util;
import ucar.visad.functiontypes.DewPointProfile;
import ucar.visad.functiontypes.InSituAirTemperatureProfile;
import ucar.visad.quantities.AirPressure;
import ucar.visad.quantities.AirTemperature;
import ucar.visad.quantities.CommonUnits;
import ucar.visad.quantities.DewPoint;
import ucar.visad.quantities.Direction;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.Data;
import visad.DateTime;
import visad.ErrorEstimate;
import visad.Field;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DDoubleSet;
import visad.Gridded1DSet;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.SetType;
import visad.Text;
import visad.Tuple;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationTuple;
import visad.georef.NamedLocationTuple;

public class CosmicTrajectoryFeatureTypeInfo
extends TrackInfo {
    public static final String VAR_LATITUDE = "Latitude";
    public static final String VAR_LONGITUDE = "Longitude";
    public static final String VAR_ALTITUDE = "Altitude";
    public static final String VAR_TIME = "Time";
    private static final String temperature = "Temp";
    private static final String vaporPressure = "Vp";
    private static final String analyzedReflectivity = "Ref";
    private static final String observedReflectivity = "Ref_obs";
    private static final String height = "MSL_alt";
    private static final String latitude = "Lat";
    private static final String longitude = "Lon";
    private static final String pressure = "Pres";
    private static final String time = "time";
    private TrajectoryFeatureCollection tfc;
    FeatureDatasetPoint fd;
    List<PointFeature> obsList;
    private static String[] categoryAttributes = new String[]{"category", "group"};

    public CosmicTrajectoryFeatureTypeInfo(TrackAdapter adapter, FeatureDatasetPoint fd, TrajectoryFeatureCollection tfc) throws Exception {
        super(adapter, tfc.getName());
        this.tfc = tfc;
        this.fd = fd;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws Exception {
        this.varTime = time;
        this.varLatitude = latitude;
        this.varLongitude = longitude;
        this.varAltitude = height;
        Attribute stimeStr = this.fd.findGlobalAttributeIgnoreCase("start_time");
        Attribute etimeStr = this.fd.findGlobalAttributeIgnoreCase("stop_time");
        if (stimeStr == null) {
            stimeStr = this.fd.findGlobalAttributeIgnoreCase("startTime");
            etimeStr = this.fd.findGlobalAttributeIgnoreCase("stopTime");
        }
        if (stimeStr == null) {
            stimeStr = this.fd.findGlobalAttributeIgnoreCase("bottime");
            etimeStr = this.fd.findGlobalAttributeIgnoreCase("toptime");
            if (stimeStr != null) {
                if (stimeStr.getNumericValue().doubleValue() > etimeStr.getNumericValue().doubleValue()) {
                    Attribute t = etimeStr;
                    etimeStr = stimeStr;
                    stimeStr = t;
                }
                this.varLatitude = "GEO_lat";
                this.varLongitude = "GEO_lon";
            }
        }
        this.startTime = new DateTime(stimeStr.getNumericValue().doubleValue(), this.getTimeUnit());
        this.endTime = new DateTime(etimeStr.getNumericValue().doubleValue(), this.getTimeUnit());
        this.tfc.resetIteration();
        this.obsList = new ArrayList<PointFeature>();
        while (this.tfc.hasNext()) {
            TrajectoryFeature pob = this.tfc.next();
            pob.resetIteration();
            try {
                while (pob.hasNext()) {
                    this.obsList.add(pob.next());
                }
            }
            finally {
                pob.finish();
            }
        }
        PointFeature pf = this.obsList.get(0);
        StructureData pfsd = pf.getFeatureData();
        List<StructureMembers.Member> members = pfsd.getMembers();
        for (int i = 0; i < members.size(); ++i) {
            StructureMembers.Member mb = members.get(i);
            String ustr = mb.getUnitsString();
            Unit unit = null;
            if (!ustr.equalsIgnoreCase("none")) {
                try {
                    unit = Util.parseUnit(ustr);
                }
                catch (VisADException e) {
                    unit = null;
                }
            }
            if (unit != null && (unit.isConvertible(CommonUnits.DEGREE) || unit.isConvertible(CommonUnits.KILOMETER) || unit.isConvertible(CommonUnit.secondsSinceTheEpoch))) {
                this.addVariable(new VarInfo(mb.getName(), mb.getDescription(), "Basic", unit));
                continue;
            }
            this.addVariable(new VarInfo(mb.getName(), mb.getDescription(), unit));
        }
    }

    @Override
    public int getNumberPoints() {
        return this.obsList.size();
    }

    public NamedLocationTuple getLatLonPoint() throws Exception {
        float[] lats = this.getLatitude(this.getDataRange());
        float[] lons = this.getLongitude(this.getDataRange());
        float[] alts = this.getAltitude(this.getDataRange());
        String stName = "Lat:" + Misc.format(lats[0]) + " Lon:" + Misc.format(lons[0]);
        NamedLocationTuple s = new NamedLocationTuple(stName, lats[0], lons[0], alts[0]);
        return s;
    }

    @Override
    protected Range getDataRange() throws Exception {
        Range range = new Range(0, this.obsList.size() - 1);
        return range;
    }

    @Override
    protected Unit getTimeUnit() throws Exception {
        return DataUtil.parseUnit("seconds since 1980-01-06 00:00:00");
    }

    @Override
    protected double[] getTime(Range range) throws Exception {
        return this.getDoubleData(range, time);
    }

    public static float[] qcLatLon(float[] v) {
        int i;
        if (v == null || v.length == 0) {
            return v;
        }
        float lastValue = v[0];
        for (i = 0; i < v.length; ++i) {
            if (v[i] != v[i] || v[i] == 0.0f) continue;
            lastValue = v[i];
            break;
        }
        for (i = 0; i < v.length; ++i) {
            if (v[i] != v[i]) continue;
            if (Math.abs(v[i] - lastValue) > 10.0f) {
                v[i] = lastValue;
            }
            lastValue = v[i];
        }
        return v;
    }

    @Override
    public float[] getFloatData(Range range, String var) throws Exception {
        float[] fdata = new float[range.length()];
        int first = range.first();
        int stride = range.stride();
        int last = range.last();
        int scale = 1;
        if (var.equals(height)) {
            scale = 1000;
        }
        int i = first;
        int j = 0;
        if (this.obsList.size() <= last) {
            i = this.obsList.size() - 1;
        }
        while (i <= this.obsList.size() && j < range.length()) {
            PointFeature pf = this.obsList.get(i);
            StructureData pfsd = pf.getFeatureData();
            fdata[j++] = pfsd.getScalarFloat(var) * (float)scale;
            i += stride;
        }
        if (this.obsList.size() < last && j < range.length()) {
            for (int ii = i; ii < last; ii += stride) {
                fdata[ii] = fdata[i];
            }
        }
        return fdata;
    }

    @Override
    public double[] getDoubleData(Range range, String var) throws Exception {
        double[] fdata = new double[range.length()];
        int first = range.first();
        int stride = range.stride();
        int last = range.last();
        int i = first;
        int j = 0;
        if (this.obsList.size() <= last) {
            i = this.obsList.size() - 1;
        }
        while (i <= this.obsList.size() && j < range.length()) {
            PointFeature pf = this.obsList.get(i);
            StructureData pfsd = pf.getFeatureData();
            fdata[j++] = pfsd.getScalarDouble(var);
            i += stride;
        }
        if (this.obsList.size() < last && j < range.length()) {
            for (int ii = i; ii < last; ii += stride) {
                fdata[ii] = fdata[i];
            }
        }
        return fdata;
    }

    @Override
    public String[] getStringData(Range range, String var) throws Exception {
        String[] sdata = new String[range.length()];
        int first = range.first();
        int stride = range.stride();
        int last = range.last();
        int j = 0;
        for (int i = first; i < last; i += stride) {
            PointFeature pf = this.obsList.get(i);
            StructureData pfsd = pf.getFeatureData();
            sdata[j++] = pfsd.getScalarString(var);
        }
        return sdata;
    }

    @Override
    public synchronized FieldImpl getPointObTrack(Range range) throws Exception {
        double[] realArray;
        Trace.call1("TrackAdapter.getPointObTrack");
        Object loadId = JobManager.getManager().startLoad("TrackAdapter");
        if (range == null) {
            range = this.getFullRange();
        }
        float[] lats = this.getLatitude(range);
        float[] lons = this.getLongitude(range);
        float[] alts = this.getAltitude(range);
        double[] timeVals = this.getTimeVals(range);
        int numObs = lats.length;
        timeVals = CommonUnit.secondsSinceTheEpoch.toThis(timeVals, this.getTimeUnit());
        List<VarInfo> varsToUse = this.getVarsToUse();
        int numReals = this.countReals(varsToUse);
        int numStrings = varsToUse.size() - numReals;
        boolean allReals = numStrings == 0;
        int numVars = varsToUse.size();
        Unit[] units = new Unit[numVars];
        for (int varIdx = 0; varIdx < numVars; ++varIdx) {
            VarInfo var = varsToUse.get(varIdx);
            units[varIdx] = var.getUnit();
        }
        Trace.msg("TrackAdapter #obs: " + this.getNumberPoints() + " vars:" + numVars);
        RealType dirType = Direction.getRealType();
        EarthLocationTuple lastEL = null;
        ArrayList<EarthLocationTuple> locations = new ArrayList<EarthLocationTuple>();
        ArrayList<DateTime> times = new ArrayList<DateTime>();
        ArrayList<Data[]> tuples = new ArrayList<Data[]>();
        ArrayList<double[]> reals = new ArrayList<double[]>();
        ArrayList<String[]> strings = new ArrayList<String[]>();
        ArrayList<Real> bearings = new ArrayList<Real>();
        ArrayList stringTypeList = new ArrayList();
        for (int obIdx = 0; obIdx < numObs; ++obIdx) {
            EarthLocationTuple location = new EarthLocationTuple(new Real(RealType.Latitude, (double)lats[obIdx]), new Real(RealType.Longitude, (double)lons[obIdx]), new Real(RealType.Altitude, (double)alts[obIdx]));
            if (obIdx == 0) {
                lastEL = location;
            }
            locations.add(location);
            double dirVal = Util.calculateBearing(lastEL, location).getAngle();
            lastEL = location;
            Real bearing = new Real(dirType, dirVal);
            bearings.add(bearing);
            times.add(new DateTime(timeVals[obIdx]));
            Data[] tupleArray = allReals ? new Real[numVars + 1] : new Data[numVars + 1];
            tuples.add(tupleArray);
            double[] realArray2 = new double[numReals + 1];
            reals.add(realArray2);
            realArray2[realArray2.length - 1] = dirVal;
            strings.add(new String[numStrings]);
        }
        Trace.call1("TrackAdapter.reading data");
        boolean doColumnOriented = true;
        if (doColumnOriented) {
            int realCnt = 0;
            int stringCnt = 0;
            for (int varIdx = 0; varIdx < numVars; ++varIdx) {
                if (!JobManager.getManager().canContinue(loadId)) {
                    return null;
                }
                VarInfo var = varsToUse.get(varIdx);
                if (var.getIsNumeric()) {
                    float[] fvalues;
                    String sn = var.getShortName();
                    if (sn.equals(time)) {
                        double[] dvalues = this.getDoubleData(range, var.getShortName());
                        fvalues = new float[dvalues.length];
                        int i = 0;
                        for (double d : dvalues) {
                            fvalues[i++] = (float)d;
                        }
                    } else {
                        fvalues = this.getFloatData(range, var.getShortName());
                    }
                    Data[] firstTuple = null;
                    for (int obIdx = 0; obIdx < numObs; ++obIdx) {
                        Data[] tupleArray = (Data[])tuples.get(obIdx);
                        ((double[])reals.get((int)obIdx))[realCnt] = fvalues[obIdx];
                        if (firstTuple != null) {
                            tupleArray[varIdx] = ((Real)firstTuple[varIdx]).cloneButValue(fvalues[obIdx]);
                            continue;
                        }
                        firstTuple = tupleArray;
                        tupleArray[varIdx] = var.getUnit() == null ? new Real(var.getRealType(), (double)fvalues[obIdx]) : new Real(var.getRealType(), fvalues[obIdx], var.getUnit());
                    }
                    ++realCnt;
                    continue;
                }
                String[] svalues = this.getStringData(range, var.getShortName());
                for (int obIdx = 0; obIdx < numObs; ++obIdx) {
                    Data[] tupleArray = (Data[])tuples.get(obIdx);
                    tupleArray[varIdx] = new Text(svalues[obIdx]);
                    ((String[])strings.get((int)obIdx))[stringCnt] = svalues[obIdx];
                }
                ++stringCnt;
            }
        } else {
            Index0D scalarIndex = new Index0D(new int[0]);
            for (int obIdx = 0; obIdx < numObs; ++obIdx) {
                if (!JobManager.getManager().canContinue(loadId)) {
                    return null;
                }
                PointFeature pf = this.obsList.get(obIdx);
                StructureData structure = pf.getFeatureData();
                List<StructureMembers.Member> members = structure.getMembers();
                Data[] tupleArray = (Data[])tuples.get(obIdx);
                realArray = (double[])reals.get(obIdx);
                String[] stringArray = (String[])strings.get(obIdx);
                int numMembers = members.size();
                int varCnt = 0;
                int realCnt = 0;
                int stringCnt = 0;
                for (int varIdx = 0; varIdx < numVars; ++varIdx) {
                    VarInfo var = varsToUse.get(varIdx);
                    StructureMembers.Member member = structure.findMember(var.getShortName());
                    if (!var.getIsNumeric()) {
                        String value = new String(DataUtil.toCharArray(structure.getArray(member)));
                        stringArray[stringCnt++] = value;
                        tupleArray[varCnt] = new Text(value);
                    } else {
                        DataType dt = member.getDataType();
                        String dn = dt.getPrimitiveClassType().getSimpleName();
                        if (dt.equals((Object)DataType.DOUBLE)) {
                            double value = structure.getScalarDouble(member);
                            realArray[realCnt++] = value;
                            tupleArray[varCnt] = var.getUnit() == null ? new Real(var.getRealType(), value) : new Real(var.getRealType(), value, var.getUnit());
                        } else if (dt.equals((Object)DataType.FLOAT)) {
                            float value = structure.getScalarFloat(member);
                            realArray[realCnt++] = value;
                            tupleArray[varCnt] = var.getUnit() == null ? new Real(var.getRealType(), (double)value) : new Real(var.getRealType(), value, var.getUnit());
                        }
                    }
                    ++varCnt;
                }
            }
        }
        Trace.call2("TrackAdapter.reading data");
        Trace.call1("TrackAdapter.processing data", " all reals?" + allReals);
        Data[] obs = new PointObTuple[locations.size()];
        TupleType tt = null;
        RealTupleType rtt = null;
        TupleType finalTT = null;
        for (int obIdx = 0; obIdx < obs.length; ++obIdx) {
            Data[] tupleArray = (Data[])tuples.get(obIdx);
            realArray = (double[])reals.get(obIdx);
            String[] stringArray = (String[])strings.get(obIdx);
            tupleArray[tupleArray.length - 1] = (Data)bearings.get(obIdx);
            if (tt == null) {
                tt = Tuple.buildTupleType(tupleArray);
                if (allReals) {
                    rtt = (RealTupleType)tt;
                }
            }
            Tuple rest = allReals ? new RealTuple(rtt, (Real[])tupleArray, null, units, false) : new Tuple(tt, tupleArray, false, false);
            PointObTuple pot = null;
            if (finalTT == null) {
                pot = new PointObTuple((EarthLocation)locations.get(obIdx), (DateTime)times.get(obIdx), rest);
                finalTT = Tuple.buildTupleType(pot.getComponents());
            } else {
                pot = new PointObTuple((EarthLocation)locations.get(obIdx), (DateTime)times.get(obIdx), rest, finalTT, false);
            }
            obs[obIdx] = pot;
        }
        Trace.call2("TrackAdapter.processing data");
        Integer1DSet indexSet = new Integer1DSet((MathType)RealType.getRealType("index"), numObs);
        FieldImpl retField = new FieldImpl(new FunctionType(((SetType)indexSet.getType()).getDomain(), obs[0].getType()), indexSet);
        retField.setSamples(obs, false, false);
        Trace.call2("TrackAdapter.getPointObTrack");
        return retField;
    }

    @Override
    public Data getAerologicalDiagramData() throws Exception {
        VarInfo pressureVar = null;
        VarInfo tempVar = null;
        VarInfo vaprVar = null;
        for (int varIdx = 0; varIdx < this.variables.size(); ++varIdx) {
            VarInfo var = (VarInfo)this.variables.get(varIdx);
            String name = var.getShortName();
            if (name.equals(pressure)) {
                pressureVar = var;
                continue;
            }
            if (name.equals(temperature)) {
                tempVar = var;
                continue;
            }
            if (!name.equals(vaporPressure)) continue;
            vaprVar = var;
        }
        TupleType addType = new TupleType(new MathType[]{AirPressure.getRealType(), AirTemperature.getRealType(), DewPoint.getRealType(), RealTupleType.LatitudeLongitudeAltitude});
        Range range = this.getFullRange();
        FunctionType addFType = new FunctionType(RealType.Time, addType);
        GriddedSet llaSet = this.getSpatialSet(this.getFullRange());
        Unit[] llaUnits = llaSet.getSetUnits();
        Unit tempUnit = tempVar.getUnit();
        Unit dewpointUnit = tempVar.getUnit();
        Unit[] addUnits = new Unit[]{pressureVar.getUnit(), Unit.canConvert(tempUnit, CommonUnits.CELSIUS) ? tempUnit : CommonUnits.CELSIUS, Unit.canConvert(dewpointUnit, CommonUnits.CELSIUS) ? dewpointUnit : CommonUnits.CELSIUS, llaUnits[0], llaUnits[1], llaUnits[2]};
        double[] timeVals = this.getTimeVals(range);
        Gridded1DDoubleSet timeSet = new Gridded1DDoubleSet((MathType)RealType.Time, new double[][]{timeVals}, timeVals.length, (CoordinateSystem)null, new Unit[]{this.getTimeUnit()}, (ErrorEstimate[])null);
        FlatField addField = new FlatField(addFType, (Set)timeSet, (CoordinateSystem[])null, (Set[])null, addUnits);
        return addField;
    }

    public Data[] getAerologicalDiagramDataArray() throws Exception {
        VarInfo pressureVar = null;
        VarInfo tempVar = null;
        VarInfo vaprVar = null;
        for (int varIdx = 0; varIdx < this.variables.size(); ++varIdx) {
            VarInfo var = (VarInfo)this.variables.get(varIdx);
            String name = var.getShortName();
            if (name.equals(pressure)) {
                pressureVar = var;
                continue;
            }
            if (name.equals(temperature)) {
                tempVar = var;
                continue;
            }
            if (!name.equals(vaporPressure)) continue;
            vaprVar = var;
        }
        TupleType tempType = new TupleType(new MathType[]{AirPressure.getRealType(), AirTemperature.getRealType(), RealTupleType.LatitudeLongitudeAltitude});
        TupleType dewType = new TupleType(new MathType[]{AirPressure.getRealType(), DewPoint.getRealType(), RealTupleType.LatitudeLongitudeAltitude});
        Range range = this.getFullRange();
        FunctionType tempFType = new FunctionType(RealType.Time, tempType);
        FunctionType dewFType = new FunctionType(RealType.Time, dewType);
        GriddedSet llaSet = this.getSpatialSet(this.getFullRange());
        Unit[] llaUnits = llaSet.getSetUnits();
        Unit tempUnit = tempVar.getUnit();
        Unit dewpointUnit = tempVar.getUnit();
        Unit[] tempUnits = new Unit[]{pressureVar.getUnit(), Unit.canConvert(tempUnit, CommonUnits.CELSIUS) ? tempUnit : CommonUnits.CELSIUS, llaUnits[0], llaUnits[1], llaUnits[2]};
        Unit[] dewUnits = new Unit[]{pressureVar.getUnit(), Unit.canConvert(dewpointUnit, CommonUnits.CELSIUS) ? dewpointUnit : CommonUnits.CELSIUS, llaUnits[0], llaUnits[1], llaUnits[2]};
        float[][] llaSamples = llaSet.getSamples();
        double[] timeVals = this.getTimeVals(range);
        Gridded1DDoubleSet timeSet = new Gridded1DDoubleSet((MathType)RealType.Time, new double[][]{timeVals}, timeVals.length, (CoordinateSystem)null, new Unit[]{this.getTimeUnit()}, (ErrorEstimate[])null);
        FlatField tempField = new FlatField(tempFType, (Set)timeSet, (CoordinateSystem[])null, (Set[])null, tempUnits);
        tempField.setSamples(new float[][]{this.getFloatData(range, pressureVar), this.getFloatData(range, tempVar), llaSamples[0], llaSamples[1], llaSamples[2]});
        float[] press = this.getFloatData(range, pressureVar);
        float[] temps = this.getFloatData(range, tempVar);
        int[] indexes = Util.strictlySortedIndexes(press, false);
        press = Util.take(press, indexes);
        temps = Util.take(temps, indexes);
        Gridded1DSet presDomain = new Gridded1DSet((MathType)AirPressure.getRealTupleType(), (float[][])new float[][]{press}, press.length, (CoordinateSystem)null, new Unit[]{pressureVar.getUnit()}, (ErrorEstimate[])null);
        FlatField tempPro = new FlatField(InSituAirTemperatureProfile.instance(), presDomain);
        FlatField dewField = new FlatField(dewFType, (Set)timeSet, (CoordinateSystem[])null, (Set[])null, dewUnits);
        tempPro.setSamples(new float[][]{temps});
        if (vaprVar == null) {
            return new Field[]{tempPro, null};
        }
        dewField.setSamples(new float[][]{this.getFloatData(range, pressureVar), this.getDewPointFloatData(range), llaSamples[0], llaSamples[1], llaSamples[2]});
        float[] dews = this.getDewPointFloatData(range);
        dews = Util.take(dews, indexes);
        FlatField dewPro = new FlatField(DewPointProfile.instance(), presDomain);
        dewPro.setSamples(new float[][]{dews});
        return new Field[]{tempPro, dewPro};
    }

    protected float[] getDewPointFloatData(Range range) throws Exception {
        float[] temp = this.getFloatData(range, temperature);
        float[] vapor = this.getFloatData(range, vaporPressure);
        float[] dpoint = new float[temp.length];
        for (int i = 0; i < temp.length; ++i) {
            dpoint[i] = this.getDewpoint(temp[i], vapor[i]);
        }
        return dpoint;
    }

    public float getDewpoint(float temp, float vp) {
        float pa = 7.5f;
        float pb = 237.3f;
        float pc = 6.1078f;
        float p = (float)Math.log10(vp / pc);
        return pb * p / (pa - p);
    }
}

