/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.sounding;

import java.util.ArrayList;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.Index0D;
import ucar.ma2.Range;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.TrajectoryFeature;
import ucar.nc2.time.CalendarDateRange;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.VarInfo;
import ucar.unidata.data.point.PointObTuple;
import ucar.unidata.data.sounding.CDMTrajectoryFeatureTypeInfo;
import ucar.unidata.data.sounding.TrackAdapter;
import ucar.unidata.data.sounding.TrackInfo;
import ucar.unidata.util.JobManager;
import ucar.unidata.util.Trace;
import ucar.visad.Util;
import ucar.visad.quantities.CommonUnits;
import ucar.visad.quantities.Direction;
import visad.CommonUnit;
import visad.Data;
import visad.DateTime;
import visad.DerivedUnit;
import visad.FieldImpl;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.MathType;
import visad.OffsetUnit;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SetType;
import visad.Text;
import visad.Tuple;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationTuple;

public class CdmTrackInfo
extends TrackInfo {
    public static final String VAR_LATITUDE = "Latitude";
    public static final String VAR_LONGITUDE = "Longitude";
    public static final String VAR_ALTITUDE = "Altitude";
    public static final String VAR_TIME = "Time";
    List<PointFeature> obsList = new ArrayList<PointFeature>();
    double[] times;
    private FeatureDatasetPoint tod;
    TrajectoryFeature todt;
    CDMTrajectoryFeatureTypeInfo.TrajectoryFeatureBean trajBean;
    private static String[] categoryAttributes = new String[]{"category", "group"};

    public CdmTrackInfo(TrackAdapter adapter, FeatureDatasetPoint tod, TrajectoryFeature todt) throws Exception {
        super(adapter, tod.getTitle());
        this.tod = tod;
        this.todt = todt;
        this.init();
    }

    private void init() throws Exception {
        this.varTime = VAR_TIME;
        this.varLatitude = VAR_LATITUDE;
        this.varLongitude = VAR_LONGITUDE;
        this.varAltitude = VAR_ALTITUDE;
        this.trajBean = new CDMTrajectoryFeatureTypeInfo.TrajectoryFeatureBean(this.todt);
        List<PointFeature> pfs = this.trajBean.pfs;
        TrajectoryFeature tf = this.trajBean.pfc;
        int psize = pfs.size();
        for (int i = 0; i < psize; ++i) {
            this.obsList.add(pfs.get(i));
        }
        CalendarDateRange cdr = tf.getCalendarDateRange();
        Range rg = this.getDataRange();
        List<VariableSimpleIF> allVariables = this.tod.getDataVariables();
        this.addVariable(new VarInfo(VAR_TIME, VAR_TIME, "Basic", this.getTimeUnit()));
        this.addVariable(new VarInfo(VAR_LATITUDE, VAR_LATITUDE, "Basic", CommonUnits.DEGREE));
        this.addVariable(new VarInfo(VAR_LONGITUDE, VAR_LONGITUDE, "Basic", CommonUnits.DEGREE));
        this.addVariable(new VarInfo(VAR_ALTITUDE, VAR_ALTITUDE, "Basic", DataUtil.parseUnit("m")));
        for (int varIdx = 0; varIdx < allVariables.size(); ++varIdx) {
            String ustr = null;
            Unit unit = null;
            VariableSimpleIF var = allVariables.get(varIdx);
            if (var.getRank() != 0) continue;
            ustr = var.getUnitsString();
            if (ustr != null && !ustr.equalsIgnoreCase("none")) {
                try {
                    unit = Util.parseUnit(ustr);
                }
                catch (VisADException e) {
                    unit = null;
                }
            }
            VarInfo variable = new VarInfo(var.getShortName(), var.getDescription(), var.getUnitsString());
            Attribute attr = null;
            for (int i = 0; i < categoryAttributes.length && attr == null; ++i) {
                attr = var.findAttributeIgnoreCase(categoryAttributes[i]);
            }
            if (attr != null) {
                variable.setCategory(attr.getStringValue());
            }
            if (unit != null) {
                if (unit.isConvertible(CommonUnit.secondsSinceTheEpoch) && !(unit instanceof DerivedUnit) && unit instanceof OffsetUnit) {
                    this.varTime = variable.getName();
                } else if (Double.isNaN(this.trajBean.getAltitude()) && unit.isConvertible(CommonUnit.meter) && (var.getShortName().equalsIgnoreCase("alt") || var.getShortName().equalsIgnoreCase("altitude") || var.getShortName().toLowerCase().startsWith("alt"))) {
                    this.varAltitude = variable.getName();
                    System.out.println(variable.getName());
                }
            }
            this.addVariable(variable);
        }
        this.times = this.getTime(rg);
        if (cdr != null) {
            this.startTime = new DateTime(cdr.getStart().toDate());
            this.endTime = new DateTime(cdr.getEnd().toDate());
        } else {
            this.startTime = this.getStartTime();
            this.endTime = this.getEndTime();
        }
    }

    @Override
    public DateTime getStartTime() {
        if (this.startTime == null) {
            try {
                this.startTime = new DateTime(this.times[0], this.getTimeUnit());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.startTime;
    }

    @Override
    public DateTime getEndTime() {
        if (this.endTime == null) {
            try {
                this.endTime = new DateTime(this.times[this.times.length - 1], this.getTimeUnit());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.endTime;
    }

    public TrajectoryFeature getTodt() {
        return this.todt;
    }

    @Override
    public int getNumberPoints() {
        return this.getTodt().size();
    }

    private void testit() {
        try {
            Trace.call1("TrackInfo.rowRead-new");
            this.test2();
            Trace.call2("TrackInfo.rowRead-new");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void test1() throws Exception {
        Range range = this.getFullRange();
        int numVars = this.variables.size();
        int varCnt = 0;
        for (int varIdx = 0; varIdx < numVars; ++varIdx) {
            VarInfo var = (VarInfo)this.variables.get(varIdx);
            this.getFloatData(range, var.getShortName());
            ++varCnt;
        }
        Trace.msg("Column read #vars:" + varCnt);
    }

    private void test2() throws Exception {
        int numObs = this.getNumberPoints();
        Index0D scalarIndex = new Index0D(new int[0]);
        StructureData structure = this.todt.getFeatureData();
        List<StructureMembers.Member> members = structure.getMembers();
        int numMembers = members.size();
        Trace.msg("test2-numMembers:" + numMembers);
        for (int varIdx = 0; varIdx < numMembers; ++varIdx) {
            StructureMembers.Member member = members.get(varIdx);
            Array array = structure.getArray(member);
        }
    }

    @Override
    protected Range getDataRange() throws Exception {
        return new Range(0, this.getNumberPoints() - 1, 1);
    }

    @Override
    protected Unit getTimeUnit() throws Exception {
        return DataUtil.parseUnit(this.todt.getTimeUnit().toString());
    }

    @Override
    protected double[] getTime(Range range) throws Exception {
        List<PointFeature> pfs = this.trajBean.pfs;
        double[] time = null;
        time = this.trajBean.getTimes(range);
        if (time == null || time.length > 1 && time[0] == time[time.length - 1]) {
            if (this.varTime != null) {
                time = this.trajBean.getDoubleData(range, this.varTime);
            } else {
                time = this.trajBean.getDoubleData(range, VAR_TIME);
                if (time == null) {
                    time = this.trajBean.getDoubleData(range, "time");
                    if (time == null) {
                        time = this.trajBean.getDoubleData(range, "TIME");
                    }
                    if (time == null) {
                        return null;
                    }
                }
            }
        }
        return time;
    }

    public static float[] qcLatLon(float[] v) {
        int i;
        if (v == null || v.length == 0) {
            return v;
        }
        float lastValue = v[0];
        for (i = 0; i < v.length; ++i) {
            if (v[i] != v[i] || v[i] == 0.0f) continue;
            lastValue = v[i];
            break;
        }
        for (i = 0; i < v.length; ++i) {
            if (v[i] != v[i]) continue;
            if (Math.abs(v[i] - lastValue) > 10.0f) {
                v[i] = lastValue;
            }
            lastValue = v[i];
        }
        return v;
    }

    @Override
    protected float[] getFloatData(Range range, String var) throws Exception {
        if (var.equals(VAR_TIME)) {
            return this.trajBean.getFloatData(range, this.varTime);
        }
        if (var.equals(VAR_LATITUDE)) {
            return this.trajBean.getLatitudes(range);
        }
        if (var.equals(VAR_LONGITUDE)) {
            return this.trajBean.getLongitudes(range);
        }
        if (var.equals(VAR_ALTITUDE)) {
            return this.trajBean.getAltitudes(range);
        }
        return this.trajBean.getFloatData(range, var);
    }

    @Override
    protected double[] getDoubleData(Range range, String var) throws Exception {
        if (var.equals(VAR_TIME)) {
            return this.trajBean.getDoubleData(range, this.varTime);
        }
        if (var.equals(VAR_LATITUDE)) {
            return this.trajBean.getDoubleData(range, VAR_LATITUDE);
        }
        if (var.equals(VAR_LONGITUDE)) {
            return this.trajBean.getDoubleData(range, VAR_LONGITUDE);
        }
        if (var.equals(VAR_ALTITUDE)) {
            return this.trajBean.getDoubleData(range, VAR_ALTITUDE);
        }
        return this.trajBean.getDoubleData(range, var);
    }

    @Override
    protected String[] getStringData(Range range, String var) throws Exception {
        return DataUtil.toStringArray(null);
    }

    @Override
    protected float[] getAltitude(Range range) throws Exception {
        if (Double.isNaN(this.trajBean.getAltitude()) && this.varAltitude != null) {
            return this.getFloatData(range, this.varAltitude);
        }
        return this.getFloatData(range, VAR_ALTITUDE);
    }

    @Override
    public synchronized FieldImpl getPointObTrack(Range range) throws Exception {
        double[] realArray;
        Data[] tupleArray;
        Trace.call1("TrackAdapter.getPointObTrack");
        Object loadId = JobManager.getManager().startLoad("TrackAdapter");
        if (range == null) {
            range = this.getFullRange();
        }
        float[] lats = this.getLatitude(range);
        float[] lons = this.getLongitude(range);
        float[] alts = this.getAltitude(range);
        double[] timeVals = this.getTimeVals(range);
        int numObs = lats.length;
        timeVals = CommonUnit.secondsSinceTheEpoch.toThis(timeVals, this.getTimeUnit());
        List<VarInfo> varsToUse = this.getVarsToUse();
        int numReals = this.countReals(varsToUse);
        int numStrings = varsToUse.size() - numReals;
        boolean allReals = numStrings == 0;
        int numVars = varsToUse.size();
        Unit[] units = new Unit[numVars];
        for (int varIdx = 0; varIdx < numVars; ++varIdx) {
            VarInfo var = varsToUse.get(varIdx);
            units[varIdx] = var.getUnit();
        }
        Trace.msg("TrackAdapter #obs: " + this.getNumberPoints() + " vars:" + numVars);
        RealType dirType = Direction.getRealType();
        EarthLocationTuple lastEL = null;
        ArrayList<EarthLocationTuple> locations = new ArrayList<EarthLocationTuple>();
        ArrayList<DateTime> times = new ArrayList<DateTime>();
        ArrayList<Data[]> tuples = new ArrayList<Data[]>();
        ArrayList<double[]> reals = new ArrayList<double[]>();
        ArrayList<String[]> strings = new ArrayList<String[]>();
        ArrayList<Real> bearings = new ArrayList<Real>();
        ArrayList stringTypeList = new ArrayList();
        for (int obIdx = 0; obIdx < numObs; ++obIdx) {
            EarthLocationTuple location = new EarthLocationTuple(new Real(RealType.Latitude, (double)lats[obIdx]), new Real(RealType.Longitude, (double)lons[obIdx]), new Real(RealType.Altitude, (double)alts[obIdx]));
            if (obIdx == 0) {
                lastEL = location;
            }
            locations.add(location);
            double dirVal = Util.calculateBearing(lastEL, location).getAngle();
            lastEL = location;
            Real bearing = new Real(dirType, dirVal);
            bearings.add(bearing);
            times.add(new DateTime(timeVals[obIdx]));
            tupleArray = allReals ? new Real[numVars + 1] : new Data[numVars + 1];
            tuples.add(tupleArray);
            realArray = new double[numReals + 1];
            reals.add(realArray);
            realArray[realArray.length - 1] = dirVal;
            strings.add(new String[numStrings]);
        }
        Trace.call1("TrackAdapter.reading data");
        boolean doColumnOriented = true;
        if (doColumnOriented) {
            int realCnt = 0;
            int stringCnt = 0;
            for (int varIdx = 0; varIdx < numVars; ++varIdx) {
                if (!JobManager.getManager().canContinue(loadId)) {
                    return null;
                }
                VarInfo var = varsToUse.get(varIdx);
                if (var.getIsNumeric()) {
                    float[] fvalues = this.getFloatData(range, var.getShortName());
                    if (var.getRealType() == null) {
                        // empty if block
                    }
                    Data[] firstTuple = null;
                    for (int obIdx = 0; obIdx < numObs; ++obIdx) {
                        Data[] tupleArray2 = (Data[])tuples.get(obIdx);
                        ((double[])reals.get((int)obIdx))[realCnt] = fvalues[obIdx];
                        if (firstTuple != null) {
                            tupleArray2[varIdx] = ((Real)firstTuple[varIdx]).cloneButValue(fvalues[obIdx]);
                            continue;
                        }
                        firstTuple = tupleArray2;
                        tupleArray2[varIdx] = var.getUnit() == null ? new Real(var.getRealType(), (double)fvalues[obIdx]) : new Real(var.getRealType(), fvalues[obIdx], var.getUnit());
                    }
                    ++realCnt;
                    continue;
                }
                String[] svalues = this.getStringData(range, var.getShortName());
                for (int obIdx = 0; obIdx < numObs; ++obIdx) {
                    Data[] tupleArray3 = (Data[])tuples.get(obIdx);
                    tupleArray3[varIdx] = new Text(svalues[obIdx]);
                    ((String[])strings.get((int)obIdx))[stringCnt] = svalues[obIdx];
                }
                ++stringCnt;
            }
        } else {
            Index0D scalarIndex = new Index0D(new int[0]);
            for (int obIdx = 0; obIdx < numObs; ++obIdx) {
                if (!JobManager.getManager().canContinue(loadId)) {
                    return null;
                }
                StructureData structure = this.todt.getFeatureData();
                List<StructureMembers.Member> members = structure.getMembers();
                tupleArray = (Data[])tuples.get(0);
                realArray = (double[])reals.get(0);
                String[] stringArray = (String[])strings.get(0);
                int numMembers = members.size();
                int varCnt = 0;
                int realCnt = 0;
                int stringCnt = 0;
                for (int varIdx = 0; varIdx < numVars; ++varIdx) {
                    VarInfo var = varsToUse.get(varIdx);
                    StructureMembers.Member member = structure.findMember(var.getShortName());
                    if (!var.getIsNumeric()) {
                        String value = new String(DataUtil.toCharArray(structure.getArray(member)));
                        stringArray[stringCnt++] = value;
                        tupleArray[varCnt] = new Text(value);
                    } else {
                        float value = structure.convertScalarFloat(member);
                        realArray[realCnt++] = value;
                        tupleArray[varCnt] = var.getUnit() == null ? new Real(var.getRealType(), (double)value) : new Real(var.getRealType(), value, var.getUnit());
                    }
                    ++varCnt;
                }
            }
        }
        Trace.call2("TrackAdapter.reading data");
        Trace.call1("TrackAdapter.processing data", " all reals?" + allReals);
        Data[] obs = new PointObTuple[locations.size()];
        TupleType tt = null;
        RealTupleType rtt = null;
        TupleType finalTT = null;
        for (int obIdx = 0; obIdx < obs.length; ++obIdx) {
            Data[] tupleArray4 = (Data[])tuples.get(obIdx);
            double[] realArray2 = (double[])reals.get(obIdx);
            String[] stringArray = (String[])strings.get(obIdx);
            tupleArray4[tupleArray4.length - 1] = (Data)bearings.get(obIdx);
            if (tt == null) {
                tt = Tuple.buildTupleType(tupleArray4);
                if (allReals) {
                    rtt = (RealTupleType)tt;
                }
            }
            Tuple rest = allReals ? new RealTuple(rtt, (Real[])tupleArray4, null, units, false) : new Tuple(tt, tupleArray4, false, false);
            PointObTuple pot = null;
            if (finalTT == null) {
                pot = new PointObTuple((EarthLocation)locations.get(obIdx), (DateTime)times.get(obIdx), rest);
                finalTT = Tuple.buildTupleType(pot.getComponents());
            } else {
                pot = new PointObTuple((EarthLocation)locations.get(obIdx), (DateTime)times.get(obIdx), rest, finalTT, false);
            }
            obs[obIdx] = pot;
        }
        Trace.call2("TrackAdapter.processing data");
        Integer1DSet indexSet = new Integer1DSet((MathType)RealType.getRealType("index"), numObs);
        FieldImpl retField = new FieldImpl(new FunctionType(((SetType)indexSet.getType()).getDomain(), obs[0].getType()), indexSet);
        retField.setSamples(obs, false, false);
        Trace.call2("TrackAdapter.getPointObTrack");
        return retField;
    }
}

